/* -*-C++-*-
 * ############################################################################
 *	Cpptcl - Integrating C++ with Tcl							  
 *	
 *	FILE: "cpptcl_metaobject.h"
 *										   created:	19/7/96 {7:22:29 pm}
 *									   last update: 19/11/97 {1:57:55 pm}
 *	  by: Vince	Darley
 *			 E-mail: darley@fas.harvard.edu
 *			   mail:   Divison of Applied Sciences,	Harvard	University
 *					Cambridge MA 02138
 * 
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *	DESCRIPTION: Mediates flow of interesting information between
 *				 the user and the different	Cpptcl objects 
 *				 
 *	HISTORY
 *					 
 *	modified who rev reason
 *	-------- --- --- ------	
 *	12/14/93 VMD 1.0 Original
 *	1/12/94	 VMD 1.1 Created internal hierarchy	of analysis-nodes as planned
 *	16/7/94	 VMD 1.2 Now allows for multiple inheritance
 * ############################################################################
 */

#ifndef _Cpptcl_cpptcl_metaobject_
#define _Cpptcl_cpptcl_metaobject_

#include "tcl_object.h"
#include "cpptcl_type.h"
#include "cpptcl_init.h"
#include "list.h"

class meta_object;

tcl_args& operator >> (tcl_args& arg, const meta_object* & into);

//@Section: Cpptcl library
///
/** 
 * -------------------------------------------------------------------------
 *   
 * "cpptcl_metaobject"  --
 *  
 *  Important control meta_object of which a single instance 'cppmeta'
 *  exists in the Tcl interpreter.  It is created automatically by the
 *  package init procedure.
 *         
 * Command Summary:
 *     
 *     % cpp::documentObject cppmeta
 *     cppmeta attach : add all object commands to the interpreter
 *     cppmeta commandFor : the creation command for an object of the given type
 *     cppmeta create : create an object of the given type
 *     cppmeta detach : remove all object commands from the interpreter
 *     cppmeta ensemble : configure subcommands of a given object type
 *     cppmeta getClass : gets class of the objet
 *     cppmeta getType : gets type of the object or one of its members
 *     cppmeta hasDescendants : test if this type has further derived types
 *     cppmeta isa : tests whether one type descends from another
 *     cppmeta listAncestry : list all ancestral types
 *     cppmeta listDescendants : list all descendant types
 *     cppmeta listParents : list parent types
 *     cppmeta listTypes : list of direct descendants
 *     cppmeta rename : changes the Tcl command name of the object
 * 
 * This object handles the object hierarchy.  It also allows you to create
 * objects of any known instantiable type, and to attach/detach all object
 * command into/from a Tcl interpreter.  This means you can always create
 * an instance of a given class type like this:
 * 
 * 		cppmeta create 'type' name ?args?
 * 	
 * but if 'cppmeta attach' has been called at some point (which it is by
 * default), then each type is also a registered Tcl command, so you can
 * do this:
 * 
 * 		type name ?args?
 * 		
 * which has the same effect.  The 'type' command can also be queried
 * using 'type mconfig ...' etc about it and its members.
 * 
 * --Version--Author------------------Changes-------------------------------  
 *    1.0     <darley@fas.harvard.edu> original
 * -------------------------------------------------------------------------
 */
DLL_IMPORT_EXPORT
class cpptcl_metaobject: public tcl_object {
	friend class tcl_base;
	friend tcl_args& operator >> (tcl_args& arg, const meta_object* & into);

  public:

	/// you really shouldn't call this with zero, but:
    bool is_of_type(const char* t1, const char* type) const {
    	return (t1 ? is_of_type(find_meta_info(t1),type) : false);
    }
	///
    cpx_type find_type(const char* type_name) const;
	///
    int parse_tcl_command(tcl_args& arg);
	///
    const char* command_for(const char*) const;
	///
    
    static DLL_IMPORT_EXPORT const char* _type;
	
  protected:
	///
    cpptcl_metaobject(tcl_args&);
	/// Makes a copy and DELETES the old version
    cpptcl_metaobject(tcl_args&, cpptcl_metaobject*);
   ~cpptcl_metaobject(void);

  protected:	  
	///
    meta_object* base_object;
	///
	void initialise_meta_hierarchy(void);
	///
	bool attaching;
  public:
	///
    const meta_object& new_object_type(const meta_object& type, 
		const meta_object& parent);

	/// if we don't know about the base meta_object yet, then return zero
    const meta_object* find_meta_info(const char* parent_name, 
										const meta_object* from=0) const;
	/// 
    bool is_of_type(const meta_object * o, const char* t) const;
	///
	tcl_obj list_descendants(const meta_object* o) const;
	///
	void list_members(const meta_object *o, tcl_obj& t, const char* member_type=0) const;
	///
	void attach_all_objects(bool attach, const meta_object* o=0) const;
	
};

#include "meta_type.h"

#endif





