/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "meta_type.h"
 *                                    created: 28/10/97 {9:10:18 am} 
 *                                last update: 18/12/97 {3:46:20 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  28/10/97 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_meta_type_
#define _Cpptcl_meta_type_

#include "cpptclInt.h"
#include "list.h"
#include "cpptcl_private.h"
class cpp_member_info;
class tcl_object;
class cpp_mem;
class tcl_obj;
class meta_object;

//@Section: Cpptcl library
///
DLL_EXPORT
class meta_members_base {
  public:
	///
	virtual int member_info_size(void) const {return 0;}
	///
	virtual const cpp_member_info* member_info(void) const {return 0;}
	meta_members_base(void) {}
	virtual ~meta_members_base(void) {}
};

DLL_EXPORT
class cpp_wrapped_member {
  public:
	const cpp_mem* member;
	const meta_object* of;
	cpp_wrapped_member(const cpp_mem* m, const meta_object* o):member(m),of(o) {}
	cpp_wrapped_member(const cpp_wrapped_member& c):member(c.member),of(c.of) {}
	~cpp_wrapped_member(void) {}
};

DLL_EXPORT
class cpp_wrapped_objmember {
  public:
	mutable tcl_object* in;
	const cpp_mem* member;
	const meta_object* of;
	cpp_wrapped_objmember(tcl_object *i, const cpp_mem* m, const meta_object* o)
	:in(i),member(m),of(o) {}
	cpp_wrapped_objmember(tcl_object *i, const cpp_wrapped_member& wm)
	:in(i),member(wm.member),of(wm.of) {}
	cpp_wrapped_objmember(tcl_object *i, const cpp_wrapped_member* wm)
	:in(i),member(wm->member),of(wm->of) {}
	cpp_wrapped_objmember(const cpp_wrapped_objmember& c)
	:in(c.in),member(c.member),of(c.of) {}
	~cpp_wrapped_objmember(void) {}
};

class cpptcl_subcommand;

//@Section: Cpptcl library
///
DLL_IMPORT_EXPORT
class meta_object: public list<meta_object*> { 
	friend class cpptcl_metaobject;
  public:
	///
	const meta_members_base* members;
	///
	const char* type;
	///
	char* tcl_command;
	///
	mutable const meta_object* container_type;
	///
  	mutable list<meta_object*> parent_list;
	///
	mutable list<cpptcl_subcommand*> sub_commands;
	///
	virtual tcl_object* make_new(tcl_args&) const {return 0;}
	///
	virtual bool instantiable(void) const { return false;}	
	///
	int member_info_size(void) const {
		return (members ? members->member_info_size() : 0);
	}
	///
	const cpp_member_info* member_info(void) const {		
		return (members ? members->member_info() : 0);
	}
	///
	meta_object(const char* type, meta_object& parent, meta_members_base* m=0)    
	:members(m),type(type),tcl_command(0),container_type(0),
	parent_list(&parent),_has_members(false){
		((meta_object&)parent).append(this);
	}
	///
	meta_object(const char* type, meta_members_base* m=0)
	:members(m),type(type),tcl_command(0),container_type(0),_has_members(false) {
	}
	///
	meta_object(char* tcl_command, const char* type, meta_members_base* m)
    :members(m),type(type),tcl_command(tcl_command),
	container_type(0),_has_members(false){
	}
	///
	~meta_object(void) {}
	///
	int parse_meta_commands(tcl_obj&, tcl_args&) const;
	///
	bool is_a(const meta_object& t) const;
	///
	bool has_members(void) const {return _has_members;}
  protected:
	/// Called on registration to check whether I or my parents have members
	void check_for_members(void) const;
	///
	mutable bool _has_members;
	///
	bool attach_to_tcl_interp(tcl_obj&, bool attach=true) const;
	///
	const cpp_wrapped_member* string_configuration_option(tcl_args& arg,
			const char* member_type=0) const;
  public:
	///
    const meta_object& container(const meta_object& m) const { 
		container_type = &m; return *this;
    }
	///
	const meta_object* needs_container(void) const;
	///
	const cpp_mem* configuration_option(tcl_args& arg,
			const char* member_type=0) const;
	///
	const cpp_mem* find_member(const cpp_private& data, 
			const char* member_type) const;
	///
	static void register_tcl_types(void);
	///
	static int Cpptcl_setToType(Tcl_Interp* interp, Tcl_Obj* objPtr, 
													bool want_object);
	
};

#include "tcl_obj.h"

inline tcl_obj& operator<< (tcl_obj& o, const meta_object* m) {
	return o << m->type;
}

//@Section: Cpptcl library
///
template <class T> 
class meta_type : public meta_object {
  public:
	///
	meta_type(const char* type, meta_object& parent, meta_members_base* m)
	:meta_object(type, parent, m) {}
	
	///
	meta_type(const char* type, meta_members_base* m=0)
	:meta_object(type, m) {}
};

//@Section: Cpptcl library
///
template <class T> 
class meta_createable_type : public meta_type<T> {
  public:
	///
	tcl_object* make_new(tcl_args& arg) const {return new T(arg);}
	///
	bool instantiable(void) const { return true;}
	///
	meta_createable_type(const char* type, meta_members_base* m)
	:meta_type<T>(type,m) {
		tcl_command = (char*)type;
	}
	///
	meta_createable_type(const char* type, meta_object& parent, meta_members_base* m)
	:meta_type<T>(type,parent,m) {
		tcl_command = (char*)type;
	}
};

#endif
