/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_fn_members.cc"
 *                                    created: 22/10/97 {11:46:28 am} 
 *                                last update: 3/11/97 {1:48:16 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 *  See header file for further information
 * ###################################################################
 */

#include "cpptcl_fn_members.h"

Cpptcl_IBaseClass(cpp_fn_mem,"memberfunction",cpp_operator_mem);

void cpp_fn_mem::get_syntax(tcl_args& arg) const {
	arg(arguments(),"call this object method");
}

int cpp_fn_mem::parse_tcl_command (tcl_args& arg) {
	arg >> done;
	NO_EXCEPTIONS(arg);
	tcl_get((tcl_object*)arg.container,arg);
	return arg;			
}

int cpp_fn_mem::parse_meta_commands(tcl_obj& tcl_, tcl_args& arg) {
	if(arg("","return type of this method")=="returnType") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		tcl_ << return_type() << result;
		return tcl_;
	} else if(arg("","argument list of this method")=="argumentList") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		tcl_ << arguments() << result;
		return tcl_;
	} else {
		return cpp_operator_mem::parse_meta_commands(tcl_,arg);
	}
}

// Define a void object::foo(void) type
typedef void (tcl_object::*vv_mem_fptr)(void);
template class cpptcl_fn_member<vv_mem_fptr>;
void cpptcl_fn_member<vv_mem_fptr>::tcl_get(tcl_object* o, tcl_obj& tcl_) const {
	(o->*ptmf)();
	tcl_ << result;
}

