/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl	 
 * 
 *	FILE: "template.cc"
 *								   created:	19/7/96 {8:17:07 pm}
 *								   last update: 05/08/98 {09:49:44 AM}
 *	Author:	  Vince	Darley 
 *	 E-mail: darley@fas.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "cpptcl_metaobject.h"

#define DEFINE_TEMPLATES
#include "list.cpp"

#define MAKE_LIST(T) \
  template class list<T*>; \
  template class list_pos<T*>; \
  template class list_node<T*>
  
MAKE_LIST(meta_object);
MAKE_LIST(const char);
MAKE_LIST(cpptcl_subcommand);

#undef DEFINE_TEMPLATES

tcl_args& operator>> (tcl_args& arg, const meta_object*& into){
	// we pretend it's a type, since that's what we read
	// from the command line, although in fact we find an
	// 'meta_object' straightaway.
	arg.set_conversion_type("cpx_type");
	const char* t;
	arg.const_string_read(t);
	if(!t){
		(void)into;
	} else {
		into = tcl_base::metaobject->find_meta_info(t);
		if(into) {
			arg.parsed_so_far << t;
		} else {
			arg.signal_error(tcl_args::Conversion);
		}
	}
	arg.read_done();
	return arg;
}

tcl_args& operator>> (tcl_args& arg, cpx_type& into){
	arg.set_conversion_type("cpx_type");
	const char* t;
	arg.const_string_read(t);
	if(!t){
		into = 0;
	} else {
		into = tcl_base::metaobject->find_type(t);	
		if(into) {
			arg.parsed_so_far << t;
		} else {
			arg.signal_error(tcl_args::Conversion);
		}
	}
	arg.read_done();
	return arg;
}
