/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "tcl_args_template.cc"
 *									  created: 11/5/96 {8:47:00 pm}	
 *								  last update: 05/22/98 {16:04:05 PM}	
 *	Author:	Vince Darley
 *	E-mail:	<darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#define DEFINE_TEMPLATES

#include "tcl_args_t.cpp"

tcl_args_reader& operator>> (tcl_args_reader& a, bool& into) {
	if(a) {
		register int boolVal;
		if(Tcl_GetBooleanFromObj(NULL,(Tcl_Obj*)(const Tcl_Obj*)a,&boolVal) == TCL_ERROR) {
			a.state = tcl_args_reader::Fail;
		} else {
			into = (boolVal ? true : false);
		}
	}
	return a;
}
// This function needs to be written
tcl_args_reader& operator>> (tcl_args_reader& a, char& into) {
	if(a) {
		register int boolVal;
		if(Tcl_GetBooleanFromObj(NULL,(Tcl_Obj*)a,&boolVal) == TCL_ERROR) {
			a.state = tcl_args_reader::Fail;
		} else {
			into = 'a';
		}
	}
	return a;
}
tcl_args_reader& operator>> (tcl_args_reader& a, int& into) {
	if(a) {
		register int intVal;
		if(Tcl_GetIntFromObj(NULL,(Tcl_Obj*)a,&intVal) == TCL_ERROR) {
			a.state = tcl_args_reader::Fail;
		} else {
			into = (int)intVal;
		}
	}
	return a;
}
tcl_args_reader& operator>> (tcl_args_reader& a, long& into) {
	if(a) {
		register long intVal;
		if(Tcl_GetLongFromObj(NULL,(Tcl_Obj*)a,&intVal) == TCL_ERROR) {
			a.state = tcl_args_reader::Fail;
		} else {
			into = (long)intVal;
		}
	}
	return a;
}
tcl_args_reader& operator>> (tcl_args_reader& a, float& into) {
	if(a) {
		register double doubleVal;
		if(Tcl_GetDoubleFromObj(NULL,a,&doubleVal) == TCL_ERROR) {
			a.state = tcl_args_reader::Fail;
		} else {
			into = (float) doubleVal;
		}
	}
	return a;
}
tcl_args_reader& operator>> (tcl_args_reader& a, double& into) {
	if(a) {
		register double doubleVal;
		if(Tcl_GetDoubleFromObj(NULL,a,&doubleVal) == TCL_ERROR) {
			a.state = tcl_args_reader::Fail;
		} else {
			into = doubleVal;
		}
	}
	return a;
}
tcl_args_reader& operator>> (tcl_args_reader& a, const char*& into) {
	if(a) {
		int len;
		into = Tcl_GetStringFromObj(a,&len);
	}
	return a;
}

tcl_args_reader& operator>> (tcl_args_reader& a, Tcl_Obj*& into) {
	if(a) {
		into = (Tcl_Obj*)a;
	} else {
		into = 0;
	}
	return a;
}

#if defined(__MWERKS__) || defined(__GNUC__)

template tcl_args& operator >><int> (tcl_args& arg, int& t);
template tcl_args& operator >><long> (tcl_args& arg, long& t);
template tcl_args& operator >><float> (tcl_args& arg, float& t);
template tcl_args& operator >><double> (tcl_args& arg, double& t);
template tcl_args& operator >><char> (tcl_args& arg, char& t);
template tcl_args& operator >><Tcl_Obj*> (tcl_args& arg, Tcl_Obj*& t);

#else

template tcl_args& operator >> (tcl_args& arg, int& t);
template tcl_args& operator >> (tcl_args& arg, long& t);
template tcl_args& operator >> (tcl_args& arg, float& t);
template tcl_args& operator >> (tcl_args& arg, double& t);
template tcl_args& operator >> (tcl_args& arg, char& t);
template tcl_args& operator >> (tcl_args& arg, Tcl_Obj*& t);

#endif
