/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "sockets_events.h"
 *                                    created: 30/10/97 {8:35:20 pm} 
 *                                last update: 05/08/98 {10:21:01 AM} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that the copyright notice and warranty disclaimer appear in
 * supporting documentation.
 * 
 * Vince Darley disclaims all warranties with regard to this software,
 * including all implied warranties of merchantability and fitness.  In
 * no event shall Vince Darley be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortuous action, arising out of or in connection with the use or
 * performance of this software.
 * ========================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  30/10/97 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_sockets_events_
#define _Cpptcl_sockets_events_

#include "cpptcl.h"

class cpp_socket_t;
class cpp_event;
class cpp_trigger;
class cpp_socket_mem;
class cpp_event_mem;
class cpp_trigger_mem;


//@Section: Cpptclextra library
///
DLL_IMPORT_EXPORT
class cpp_trigger {
	friend class cpp_trigger_mem;
	friend class cpp_socket_mem;
    friend class cpp_socket_t;
  public:
	///
    bool has_requests(void) const {return (requests.isNonEmpty());}
	///
    void trigger(void);
	///
    void trigger(class tcl_object*);
	///
    void add_socket(cpp_socket_t*);
	///
    void remove_socket(cpp_socket_t*);
	///
    cpp_trigger(tcl_object* container);
	///
    ~cpp_trigger(void) {}
    
  protected:
	///
	tcl_object* container;
	///
    void register_socket(cpp_socket_t* e) {requests.append(e);}
	///
    void deregister_socket(cpp_socket_t* e) {requests.remove(e);}
	///
    list<cpp_socket_t*> requests;
};

//@Section: Cpptclextra library
///
DLL_IMPORT_EXPORT
class cpp_event: public cpp_trigger {
	///
	friend class cpp_socket_t;
  public:
	///
    cpp_event(tcl_object* container);
	///
    ~cpp_event(void) {}
    
};

//@Section: Cpptclextra library
///
DLL_IMPORT_EXPORT
class cpp_socket_t: public cpp_trigger {
  friend class cpp_trigger;
  friend class cpp_socket_mem;
  public:
	///
    cpp_socket_t(tcl_object* container);
	///
    virtual ~cpp_socket_t(void) {deregister_myself();}
	///
    virtual void call(tcl_object* container, tcl_object* with)=0;
	///
	bool ready(void) const {
		return (requestees.isNonEmpty() ? true : false);
	}
	///
    void add_event(cpp_trigger* o) {o->add_socket(this);}
	///
    void remove_event(cpp_trigger* o) {o->remove_socket(this);}

  protected:
	///
    void register_event(cpp_trigger* o) {requestees.append(o);}
	///
    void deregister_event(cpp_trigger* o) {requestees.remove(o);}

  private:
	///
    void deregister_myself(void);
	///
    list<cpp_trigger*> requestees;
};

///
typedef void (tcl_object::*cpp_socket_fn)(tcl_object*);
#ifdef __GNUC__
///
typedef cpp_socket_t (tcl_object::*cpp_socket_ptr);
///
typedef cpp_trigger (tcl_object::*cpp_event_ptr);
#else
///
typedef cpp_socket_t& (tcl_object::*cpp_socket_ptr);
///
typedef cpp_trigger& (tcl_object::*cpp_event_ptr);
#endif



#define NO_PTMF_TEMPLATES

#ifndef NO_PTMF_TEMPLATES
template <T, int>
#else
DLL_IMPORT_EXPORT
#endif
class cpp_socket: public cpp_socket_t {
#ifdef NO_PTMF_TEMPLATES
	void (tcl_object::*T)(tcl_object*);
  public:
	cpp_socket(tcl_object *c, void (tcl_object::*t)(tcl_object*))
	:cpp_socket_t(c),T(t) {}
#else
  public:
	cpp_socket(tcl_object *c):cpp_socket_t(c) {}	
#endif
	void call(tcl_object *container, tcl_object* with) {
		(container->*T)(with); trigger();
	}
};

#endif
