/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "cpptclextra_init.cc"
 *									  created: 11/5/96 {8:44:18 pm} 
 *								  last update: 16/12/97 {1:18:50 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<mailto:darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "cpptclextra_init.h"
#include "member_events.h"
#include "member_file_io.h"
#include "member_gatherer.h"

//class record_keeper* _cpx_record_keeper = 0;

int Cpptcl_InitFunction(Cpptclextra_Init) {
	Tcl_PkgRequire(interp, "Cpptcl", CPPTCL_VERSION, 0);
/*
	if(_cpx_record_keeper == 0) {
		char record_keep[] = "cpxRecording";
		tcl_args t(interp);
		t.setName(record_keep);
		_cpx_record_keeper = new record_keeper(t);
	}
*/	
	Cpptcl_Object(cpp_trigger_mem,cpp_mem);
	Cpptcl_Object(cpp_event_mem,cpp_trigger_mem);
	Cpptcl_Object(cpp_socket_mem,cpp_trigger_mem);

	Cpptcl_Object(member_file,cpp_config_mem);
	Cpptcl_Object(member_file_i,member_file);
	Cpptcl_Object(member_file_o,member_file);
	Cpptcl_Object(member_file_io,member_file);

	Cpptcl_Object(member_gatherer,cpp_config_mem);
		
	Tcl_PkgProvide(interp,"Cpptclextra",CPPTCL_VERSION);

	return TCL_OK;
}


