/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_member_base.h"
 *                                    created: 21/10/97 {2:20:03 pm} 
 *                                last update: 19/11/97 {1:58:19 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  21/10/97 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_cpptcl_member_base_
#define _Cpptcl_cpptcl_member_base_

#include "tcl_obj.h"
#include "tcl_interaction.h"
#include "tcl_args.h"
#include "cpptcl_private.h"

class cpp_mem;

//@Section: Cpptcl library
//@Man: member io
//@{
///
tcl_obj& operator << (tcl_obj& arg, const cpp_mem& mem);
///
tcl_args& operator>> (tcl_args& arg, const cpp_mem& into);
///
tcl_args_reader& operator >> (tcl_args_reader& arg, const cpp_mem& mem);
//@}
 
//@Section: Cpptcl library
//@Man: 
DLL_IMPORT_EXPORT
class cpp_mem : public tcl_interaction {
	friend class cpp_member_info;
	friend tcl_args_reader& operator >> (tcl_args_reader& arg, const cpp_mem& mem);
	friend tcl_obj& operator << (tcl_obj& arg, const cpp_mem& mem);
	
  protected:
    ///
    
	static DLL_IMPORT_EXPORT tcl_object* container;  
    ///
	virtual cpp_mem* copy(void) const=0;
    ///
	cpp_mem(const cpp_mem& c):tcl_interaction(c) {}
  public:
	Cpptcl_BaseClass(cpp_mem);
    ///
	virtual void tcl_get(tcl_object* o, tcl_obj& t) const=0;
    ///
	virtual void tcl_set(tcl_object*, tcl_args_reader&) const {}
    ///
	const cpp_mem& operator()(tcl_object* o) const { container = o; return *this;}
    ///
	cpp_mem(Tcl_Obj* n=0) {
		_name = n;
		if(_name) Tcl_IncrRefCount(_name);
	}
    ///
	cpp_mem(const char* n=0) {
		if(n) {
			_name = Tcl_NewStringObj((char*)n,-1);
			Tcl_IncrRefCount(_name);
		}
	}
	virtual ~cpp_mem(void) {
		Tcl_DecrRefCount(_name);
	}
    ///
    virtual void conversion_error(tcl_args&) const;
	///
	virtual void get_syntax(tcl_args& arg) const;
    ///
	/** 
	 * If this object requires a container to exist as an instantiated object,
	 * then this command will only ever be called when arg.container is set
	 * to that container.
	 */
	virtual int parse_tcl_command(tcl_args& arg)=0;
	/// usually configuration is the same as parse, but sometimes not
	virtual int configure_member(tcl_args& arg);
	/// most member types are not operators
	virtual bool ensemble_behaviour(void) const { return false;}
	///
	bool embedded(void) const { return true;}
	///
    virtual int parse_meta_commands(tcl_obj&, tcl_args& arg);
	/// get our tcl command (could be an ensemble command)
	inline tcl_obj& tcl_command(tcl_obj& o) const;
    /// get our tcl stream
    inline tcl_obj& get_tcl_obj(void) const;
	///
	tcl_object* objcontainer(void) const {return container;}
	///
	virtual bool private_data(const cpp_private& data) const=0;
    ///
	virtual const char* data_type(void) const {return "";}
};

//@Section: Cpptcl library
//@Man: 
DLL_IMPORT_EXPORT
class cpp_operator_mem : public cpp_mem {
  protected:
    ///
	cpp_operator_mem(const cpp_operator_mem& c):cpp_mem(c) {}
  public:
	Cpptcl_BaseClass(cpp_operator_mem);
	/// most descendant types are operators
	bool ensemble_behaviour(void) const { return true;}
    ///
	cpp_operator_mem(const char* n):cpp_mem(n) {}
    ///
	~cpp_operator_mem(void) {}
};


#endif
