/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_members.h"
 *                                    created: 15/10/97 {4:08:15 pm} 
 *                                last update: 19/11/97 {1:58:26 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  15/10/97 VMD 1.0 original
 * ###################################################################
 */
 
#ifndef _Cpptcl_cpptcl_members_
#define _Cpptcl_cpptcl_members_
 
#include "cpptcl_member_base.h"
class tcl_object;

//@Section: Cpptcl library
//@Man: 
DLL_IMPORT_EXPORT
class cpp_member_info {
  public:
    ///
	cpp_member_info(cpp_mem& _info):member_info(_info.copy()) {}
    ///
    Tcl_Obj* name(void) const {return member_info->name();}
    ///
    const cpp_mem* member_info;
    ///
	const cpp_mem& member(void) const { return *member_info;}
    ///
	const char* type(void) const { return member_info->type();}
    ///
	const cpp_mem& member(tcl_object* o) const { 
		return member_info->operator()(o);
	}
	///
	bool private_data(const cpp_private& data) const {
		return member_info->private_data(data);
	}
    ///
	bool ensemble_behaviour(void) const { return member_info->ensemble_behaviour();}
    //
	//const cpp_mem& member(tcl_base* o) const { return (*member_info)(o->the_object());}
};

#include "meta_type.h"

//@Section: Cpptcl library
///
template <class T>
class meta__members : public meta_members_base {
  public:
	///
	static const cpp_member_info _member_info[];
	///
	const cpp_member_info* member_info(void) const {
		return _member_info;
	}
	///
	int member_info_size(void) const {return _member_info_size;}
	///
	int _member_info_size;
	///
	meta__members(void):meta_members_base()  {
	}
	///
	~meta__members(void) {}
};
//@Section: Cpptcl library
///
template <class T>
class meta_members : public meta__members<T> {
  public:
	///
	meta_members(void):meta__members<T>()  {
		_member_info_size = (sizeof(_member_info)/sizeof(*_member_info));
	}
	///
	~meta_members(void) {}
};

#endif
