/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl	 
 * 
 *	FILE: "member_events.cc"
 *								   created:	21/5/96 {11:41:30 am}
 *								   last update: 18/12/97 {4:07:56 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: darley@fas.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "member_events.h"

Cpptcl_IBaseClass(cpp_trigger_mem,"datatrigger",cpp_mem);
Cpptcl_IBaseClass(cpp_event_mem,"dataevent",cpp_trigger_mem);
Cpptcl_IBaseClass(cpp_socket_mem,"datasocket",cpp_trigger_mem);

void cpp_trigger_mem::get_syntax(tcl_args& arg) const {
	arg.syntax("value");
}

cpp_socket_mem* cpp_trigger_mem::find_socket(cpp_socket_t* s, tcl_object* o) const {
	return (cpp_socket_mem*) o->find_member(cpp_private((void*)s),o->_type,cpp_socket_mem::_type.type);
}

cpp_trigger_mem* cpp_socket_mem::find_trigger(cpp_trigger* s, tcl_object* o) const {
	return (cpp_trigger_mem*) o->find_member(cpp_private((void*)s),o->_type,cpp_trigger_mem::_type.type);
}

int cpp_trigger_mem::parse_tcl_command(tcl_args& arg){	
	if (arg("","list all current sockets I trigger")=="getContents") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		// Note this could return nothing at all
		for(list_pos<cpp_socket_t*> s = trigger().requests;s;++s) {
			cpp_socket_mem* m = find_socket(s.item(),s.item()->container);	
			get_tcl_obj() << m->name() << lappend;
		}
		get_tcl_obj() << result;
		return TCL_OK;
    } else if (arg("socket","attach trigger to given socket")=="connect") {
		object<cpp_socket_mem> i;
		bool dont_do_it = false;
	    arg >> i >> optional >> dont_do_it >> done;
		NO_EXCEPTIONS(arg);
		// what we're connecting to
		cpp_socket_mem* member_just_read = i;
		get_tcl_obj() << member_just_read << endl;
		cpp_socket_t* t = &member_just_read->socket();
		container = (tcl_object*) arg.container;
		get_tcl_obj() << t->container << endl;
		// the above line blitzed our container (static member)
		container = (tcl_object*) arg.container;
		get_tcl_obj() << container << endl;
		get_tcl_obj() << result;
		if(!dont_do_it) {
			trigger(container).add_socket(t);
		}
		return TCL_OK;
    } else if (arg("socket","detach trigger from given socket")=="disconnect") {
		object<cpp_socket_mem> i;
		arg >> i >> done;
		NO_EXCEPTIONS(arg);
		// what we're connecting to
		cpp_socket_mem* member_just_read = i;
		cpp_socket_t* t = &member_just_read->socket();
		// the above line blitzed our container (static member)
		container = (tcl_object*) arg.container;
		trigger(container).remove_socket(t);
		return TCL_OK;
	} else  // if we don't recognize the command, see if base does
		return arg.no_match();
}

int cpp_socket_mem::parse_tcl_command(tcl_args& arg) {	
    if (arg("","list all connected triggering events")=="getContents") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		// Note this could return nothing at all
		for(list_pos<cpp_trigger*> s = socket().requestees;s;++s) {
			cpp_trigger_mem* m = find_trigger(s.item(),s.item()->container);	
			get_tcl_obj() <<  m->name() << lappend;
		}
		get_tcl_obj() << result;
		return TCL_OK;
    } else if (arg("event","form connection with a given event")=="connect") {
	    object<cpp_trigger_mem> i;
		bool dont_do_it = false;
	    arg >> i >> optional >> dont_do_it >> done;
		NO_EXCEPTIONS(arg);
		// what we're connecting to
		cpp_trigger_mem* member_just_read = i;
		get_tcl_obj() << member_just_read << endl;
		cpp_trigger* t = &member_just_read->trigger();
		container = (tcl_object*) arg.container;
		get_tcl_obj() << t->container << endl;
		// the above line blitzed our container (static member)
		container = (tcl_object*) arg.container;
		get_tcl_obj() << container << endl;
		get_tcl_obj() << result;
		if(!dont_do_it) {
			socket(container).add_event(t);
		}
		return TCL_OK;
    } else if (arg("event","remove connection with a given event")=="disconnect") {
	    object<cpp_trigger_mem> i;
	    arg >> i >> done;
		NO_EXCEPTIONS(arg);
		// what we're connecting to
		cpp_trigger_mem* member_just_read = i;
		cpp_trigger* t = &member_just_read->trigger();
		// the above line blitzed our container (static member)
		container = (tcl_object*) arg.container;
		socket(container).remove_event(t);
		return TCL_OK;
    } else  // if we don't recognize the command, see if base does
		return cpp_trigger_mem::parse_tcl_command(arg);
}

void cpp_socket_mem::get_syntax(tcl_args& arg) const {
	arg.syntax("value");
}



