/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "member_gatherer.cc"
 *                                    created: 1/11/97 {4:58:27 pm} 
 *                                last update: 16/12/97 {2:45:10 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 *  See header file for further information
 * ###################################################################
 */

#include "member_gatherer.h"
#include "meta_object.h"

Cpptcl_IBaseClass(member_gatherer,"datagatherer",cpp_config_mem);

int member_gatherer::parse_tcl_command(tcl_args& arg){	
	if (arg("","return the source to which I connect")=="connection") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		get_tcl_obj() << &(gatherer().connection()) << result;
		return TCL_OK;
    } else if (arg("source","attach to given source")=="connect") {
		object<cpp_mem> i;
		arg >> i >> done;
		NO_EXCEPTIONS(arg);
		connect(i);
		return TCL_OK;
    } else if (arg("","detach from the source I observe")=="disconnect") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		disconnect();
		return TCL_OK;
	} else  // if we don't recognize the command, see if base does
		return arg.no_match();
}

#define cppGatherType(T) const char* member_gatherer_t<T>::_data_type = #T
cppGatherType(int);
cppGatherType(bool);
cppGatherType(float);
cppGatherType(long);
cppGatherType(double);

template <class T>
void member_gatherer_t<T>::tcl_set(tcl_object* o, tcl_args_reader& istr) const {
	if(read_only()) {
		istr.setstate(tcl_args_reader::Fail);
		return;
	}
	object<cpp_data_mem> reader;
	tcl_obj to;
	Tcl_Obj* ob = istr;
	tcl_args arg(to,1,&ob);
	arg >> reader;	
	if(arg.haveErr) {
		istr.setstate(tcl_args_reader::Fail);			
	} else {
		container = o;
		cpp_data_mem* rmem = reader;
		gatherer().from_member = rmem;
		gatherer().from_obj = rmem->objcontainer();
	}
}


#define instantiate_some(T) \
template class member_gatherer_t<T>; \
template class cpp_data_gatherer_t<T>

 instantiate_some(bool);
 instantiate_some(int);
 instantiate_some(float);
 instantiate_some(long);
 instantiate_some(double);
