/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "Econobj.cc"
 *                                    created: 15/10/97 {11:12:21 am} 
 *                                last update: 07/18/98 {19:42:16 PM} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 *  See header file for further information
 * ###################################################################
 */

#include "Econobj.h"

#include "plcpp_args.h"
#define PLPLOT_MATRIX_CLASSES
#include "tclMatrix.h"
#include <math.h>

Cpptcl_Members(Econobj) = { 
    cppDatamember("lambda",Econobj::lambda,double),
    cppDatamember("sigma",Econobj::sigma,double),
    cppDatamember("rho",Econobj::rho,double),
    cppDatamember("b",Econobj::b,double),
    cppDatamember("B",Econobj::B,double),
    cppDatamember("beta",Econobj::beta,double),
    cppDatamember("C",Econobj::C,double),
    cppDatamember("T",Econobj::T,long),
    cppDatamember("predictor",Econobj::predictor,int).set_items("equil\0perfect\0complex\0complex2\0\0"),
};

Cpptcl_IClass(Econobj,"Econobj",tcl_object);


Econobj::Econobj(tcl_args& arg)
:tcl_object(arg)
{
    lambda = 0.55;
    sigma = 1.0;
    rho = 0.0;
    b = 1.35;
    B = 0.5;
    beta = 3.0;
    C = 1.0;
    T = 1000;
    predictor = 1;
}

int Econobj::parse_tcl_command(tcl_args& arg){
    if(arg("m p","fill matrices with map iterates")=="calculate") {
	TclMatFloat m, p;
	arg >> m >> p;
	DONE(arg);
	switch(predictor) {
	  case 1:
	    for(long i =0; i< T-1; i++) {
		register double d = (1.0+m(i))*rho + (1.0-m(i))*sigma;
		double tt = 0.5*beta*((sigma-rho)*((b/B)*d+ rho +sigma)*p(i)*p(i) - C);
		double th = tanh(tt);
		double mm = (1.0-lambda)*m(i) + lambda * th;
		m(i+1) = mm;
		
		double pp = -0.5*b*p(i)*d/B;
		p(i+1) = pp;
		
	    }
	    break;
	  case 2:
	    for(long i =0; i< T-1; i++) {
		double pp = -b*p(i)*(1.0-m(i))/(2*B+b*(1+m(i)));
		p(i+1) = pp;
		double tt = 0.5*beta*((pp-p(i))*(pp-p(i)) - C);
		double th = tanh(tt);
		double mm = (1.0-lambda)*m(i) + lambda * th;
		m(i+1) = mm;
	    }
	    break;
	  case 3:
	    for(long i =0; i< T-1; i++) {
		double pi = p(i);
		double mi = m(i);
		double pii = (i>0 ? p(i-1) : p(i));
		double mii = (i>0 ? m(i-1) : m(i));
		
		double pp = -b*(3*pi+pii+m(i)*(pi-pii))/(4*B);
		p(i+1) = pp;
		double tt = 0.5*beta*((pi-pii)*(2*pp-3*pi/2-pii/2)/2-C);
		double th = tanh(tt);
		double mm = (1.0-lambda)*m(i) + lambda * th;
		m(i+1) = mm;
	    }
	    break;
	  case 4:
	    for(long i =0; i< T-1; i++) {
		double pi = p(i);
		double mi = m(i);
		double pii = (i>0 ? p(i-1) : p(i));
		
		double pp = -b*(3*pi-pii+m(i)*(pi-pii))/(2*B);
		if(pp>5.0) {
		    pp = 5.0;
		} else if (pp < -5.0) {
		    pp = -5.0;
		}
		p(i+1) = pp;
		double tt = 0.5*beta*((pi-pii)*(2*pp-3*pi+pii)-C);
		double th = tanh(tt);
		double mm = (1.0-lambda)*m(i) + lambda * th;
		m(i+1) = mm;
	    }
	    break;
	}
	return tcl_;
    } else if(arg("m p mout pout","iterate coords from first pair of matrices into second pair")=="transform") {
	TclMatFloat m, p, mout, pout;
	arg >> m >> p >> mout >> pout;
	DONE(arg);
	int len = m.dim_size(0);
	switch(predictor) {
	  case 1:
	    for(long i =0; i< len; i++) {
		register double d = (1.0+m(i))*rho + (1.0-m(i))*sigma;
		double tt = 0.5*beta*((sigma-rho)*((b/B)*d+ rho +sigma)*p(i)*p(i) - C);
		double th = tanh(tt);
		double mm = (1.0-lambda)*m(i) + lambda * th;
		mout(i) = mm;
		
		double pp = -0.5*b*p(i)*d/B;
		pout(i) = pp;
	    }
	    break;
	  case 2:
	    for(long i =0; i< len; i++) {
		double pp = -b*p(i)*(1.0-m(i))/(2*B+b*(1+m(i)));
		pout(i) = pp;
		double tt = 0.5*beta*((pp-p(i))*(pp-p(i)) - C);
		double th = tanh(tt);
		double mm = (1.0-lambda)*m(i) + lambda * th;
		mout(i) = mm;
	    }
	    break;
	  default:
	    tcl_ << "Can't iterate this predictor" << tcl_error;
	    break;
	}
	return tcl_;
    } else {
	return tcl_object::parse_tcl_command(arg);
    }
}
  
  
int Cpptcl_InitFunction(Econobj_Init) {
    interp.PkgRequire("Cpptcl");
    Cpptcl_Object(Econobj, tcl_base);
    interp.PkgProvide("Econobj","0.1");	
    //const tcl_object * o = cpp_mem::container;
    return TCL_OK;
}

