## -*-Tcl-*-
 # ###################################################################
 #  Cpptcl - connecting C++ with Tcl
 # 
 #  FILE: "Mwerks_export.tcl"
 #                                    created: 19/2/98 {8:20:16 am} 
 #                                last update: 19/2/98 {8:29:31 am} 
 #  Author: Vince Darley
 #  E-mail: <darley@fas.harvard.edu>
 #    mail: Division of Engineering and Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.fas.harvard.edu/~darley/>
 #  
 # Copyright (c) 1998  Vince Darley
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # ###################################################################
 ##

package require Tk 8.0
set orig [tk_getOpenFile]
set fin [open $orig r]
set contents [read $fin]
close $fin
set out [tk_getSaveFile -initialfile "[file root $orig].exp"]
if {[file exists $out]} {
    button .b -text "Replace" -command "set replace 1"
    button .c -text "Append" -command "set replace 0" -default active \
	    -takefocus 1
    pack .b .c -side left
    focus .b 
    console show
    update
    global replace
    #vwait replace
    set replace 0
    if {$replace} {
	file delete $out
    }
}
regsub -all {Link Error   : Undefined symbol: } $contents "/EXPORT: " contents
regsub -all  "(\\(\[^)\]+\\) )?in file:\[\r\n\]+\[^\r\n\]+\[\r\n\]+" $contents "\n" contents
set contents [lsort -dictionary [split $contents "\n"]]
set fout [open $out a+]
set last ""
foreach c $contents {
    set c [string trimright $c]
    if {$c != $last} {
	if {[regexp {@@[AB]$} $c]} {
	    puts $fout "[set last $c] ,DATA"
	} else {
	    puts $fout [set last $c]
	}
    }
}
close $fout
file delete "[file root $orig].dll"
exit
