package require Cpptcl
package require Itcl

#INDEX\
proc cpp::ObjectControl

class cpp::ObjectControl {

    constructor {args} {
    	#eval configure $args
    }

    protected variable cpptclSimPeer
    public variable peer "local"
    
    public method call {args} 
    public method getObjectsFromSimulation { name } 
    public method getObjects {obj} 
    public method barObjectMenu { menuName menuTitle fromObject } 
    public method objectMenu { base fromObject } 
    public method hierarchialObjectMenu { submenu obj }

    proc findFileForType {dir ext args}
    proc bitmapForType {type {obj ""}}
    proc gifForType {type {obj ""}}

    private proc _findFileForType {dir ext type}

}

body cpp::ObjectControl::findFileForType {dir ext args} {
	foreach trytype $args {
		set try [_findFileForType $dir $ext $trytype]
		if {$try != ""} {
			return $try
		}
    }
	return ""
}


body cpp::ObjectControl::_findFileForType {dir ext type} {
	set try [file join $dir [eval join [subst $type] \"\"]${ext}]
	if { [file exists $try] } {
		return $try
	} else {
		foreach o [uplevel \#0 cppmeta listAncestry $type ] {
			set try [file join $dir [eval join \"$o\" \"\"]${ext}]
			if { [file exists $try] } {
				return $try
			}
		}
	}   
}

body cpp::ObjectControl::bitmapForType {type {obj ""}} {
	global ::cpp::options
	set types {}
	if { $type == "Info Source Bool" && $obj != ""} {
		set types "${type}[uplevel \#0 $obj getValue]"
	}
	lappend types $type
	return @[findFileForType $options(BITMAPDIR) ".xbm" $types]
}


body cpp::ObjectControl::gifForType {type {obj ""}} {
	global ::cpp::options
	set types {}
	if { $type == "Info Source Bool" && $obj != ""} {
		set types "${type}[uplevel \#0 $obj getValue]"
	}
	lappend types $type
	return [findFileForType $options(GIFDIR) ".gif" $types]
}

body cpp::ObjectControl::call {args} {
	switch [lindex $peer 0] {
	  "local" {
	  	eval $args
	  }
	  "remote" {
	  	eval dp_RPC [lindex $peer 1] $args
	  }
	  "interp" {
	  	[lindex $peer 1] eval $args
	  }
	  "default" {
	  	error "Unknown peer option"
	 }
	}
}	

body cpp::ObjectControl::getObjectsFromSimulation {name } {
	cpxStatus "Querying simulation for new object types."
	set peer $cpptclSimPeer($name)
	if { $peer != "local" } {
		foreach obj [call cppmeta listTypes] {
			getObjects "$obj"
			
		}
	}	
}

body cpp::ObjectControl::getObjects {obj} {
	set com [call cppmeta commandFor "$obj"]
	set parents [call cppmeta listParents "$obj" ]
	if { $com == "" } {
		cppmeta addObjectType $obj $parents
	} else {
		cppmeta addObjectType -command $com $obj $parents
	}
	
	foreach obj [call cppmeta listTypes "$obj"] {
		getObjects "$obj"
	}
}

body cpp::ObjectControl::barObjectMenu { menuName menuTitle fromObject } {
	if { ![winfo exists $menuName] } {
		menubutton $menuName -text "$menuTitle"  \
			-menu $menuName.menu
	}
	objectMenu $menuName "$fromObject"
	
	return $menuName

}

body cpp::ObjectControl::objectMenu { base fromObject } {
	if { ![winfo exists $base.menu] } {
		menu $base.menu
	}
	
	# loop through all object types in hierarchial fashion
	# note some will not be creatable, as they will be abstract classes
	
	hierarchialObjectMenu $base.menu $fromObject
	return $base.menu
}

body cpp::ObjectControl::hierarchialObjectMenu { submenu obj } {
	# if I can be created, despite having children, put in an item
	if { [cppmeta commandFor "$obj"] != "" } {
		if { [catch { $submenu index "create basic '$obj'" } ] } {
			$submenu add command -label "create basic '$obj'" \
				[code $this addObject \{$obj\}]
		}
	}
	# in any case:
	foreach s [cppmeta listTypes "$obj"] {
		if { [cppmeta commandFor "$s"] == "" \
			|| [cppmeta hasDescendants "$s"]} {
			set m ${submenu}.[evoxToTclLower $s]
			if { ![winfo exists ${m}m] } {
				menu ${m}m
			}
			if { [catch { $submenu index "$s" } ] } {
				$submenu add cascade -label "$s" -menu ${m}m
			}
			hierarchialObjectMenu ${m}m "$s"
		} else {
			if { [catch { $submenu index "$s" } ] } {
				${submenu} add command -label "$s" \
				-command [code $this addObject \{$s\}]
			}
		}
	}
	
}
