#  $Header: /Master/jWrap/frontend/cc/Build.mk,v 1.3.0.1 1999/03/11 12:49:29 phillf Exp $
#
#       Copyright(c) 96-97 FRIDU a Free Software Company (Philippe Le Foll)
#
# File      :   Build.mk
# Projet    :   Fridu Realtime Booster
# Module    :   Config/Ic
# Auteur    :   Philippe Le Foll (phillf@iu-vannes.fr)
#
# Last
#      Author      : $Author: phillf $
#      Date        : $Date: 1999/03/11 12:49:29 $
#      Revision    : $Revision: 1.3.0.1 $
#      Source      : $Source: /Master/jWrap/frontend/cc/Build.mk,v $
#      State       : $State: Exp $
#
#Modification History
#--------------------
#01b,18apr98,phillf,moved to new tree
#01a,06feb98,phillf,written from jIc 
#


# Do not install in production tree
# ---------------------------------
  NOT_INSTALL=1

# Define modules
# ------------------------
  LIB_SRCXXS  = yaccFrontendCc.cxx lexFrontendCc.cxx 
  LIB_OBJS  = $(LIB_SRCXXS:%.cxx=${OBJDIR}/%${OBJ_SFX})

  SRCXXS= $(LIB_SRCXXS)

# define meta rules
# ------------------
  LIBS = libFrontendCc

# define some extra option for TK
# --------------------------------
  MK_DEFINES  = 
  MK_INCLUDES =


# Use Makefile rules for lex & yacc 
# ----------------------------------
yaccFrontendCc.cxx:	yaccFrontendCc.y
	@echo yaccing yaccFrontendCc.y
	$(YACC) -p yycc_ yaccFrontendCc.y 
	mv y.tab.c yaccFrontendCc.cxx
	mv y.tab.h yaccFrontendCc.h

lexFrontendCc.cxx:	lexFrontendCc.lex
	@echo lexing lexFrontendCc.lex
	flex -Pyycc_ lexFrontendCc.lex 
	sed "s/lex.yycc_.c/lexFrontendCc.cxx/" <lex.yycc_.c >lexFrontendCc.cxx
	@rm -f lex.yycc_.c

# set Parser in libCt.h if any .i changed
# ----------------------------------------
${INCDIR}/libFrontendCc.i: $(LIB_SRCXXS:%.cxx=${DEPDIR}/%.i)
	${protoRule}

# Set library & subLib name and give source depending files
# ----------------------------------------------------------
${LIBDIR}/libFrontendCc${LIB_SFX}: ${LIB_OBJS}
	${libRule}
