/*
 * The following are flags returned by GetOpenMode.  They
 * are or'd together to determine how opening and handling
 * a device should occur.
 */

#define TCL_RDONLY		(1<<0)
#define TCL_WRONLY		(1<<1)
#define TCL_RDWR		(1<<2)
#define TCL_CREAT		(1<<3)
#define TCL_TRUNC		(1<<4)
#define TCL_APPEND		(1<<5)
#define TCL_ALWAYS_APPEND	(1<<6)
#define TCL_EXCL		(1<<7)
#define TCL_NOCTTY		(1<<8)
#define TCL_NONBLOCK		(1<<9)
#define TCL_RW_MODES 		(TCL_RDONLY|TCL_WRONLY|TCL_RDWR)

typedef Tcl_Channel (Tcl_OpenDeviceProc) _ANSI_ARGS_((Tcl_Interp *interp,int port, int *errorCodePtr));
typedef int (Tcl_CheckDeviceProc) _ANSI_ARGS_((struct PortState *state));
typedef void (Tcl_CloseDeviceProc) _ANSI_ARGS_((int port));

/*
 * This structure describes per-instance state of a 
 * macintosh device based channel.
 */

typedef struct PortState {   
    short inputRef;			// Macintosh file reference numbers. 
    short outputRef;		// Added because serial ports have both
    						// an input and output reference.
    						
    int		portID;			// Internal Hardware Reference Number 
    int		blocking;		// Enable/Disable Serial Blocking
		    
    Tcl_Channel devChan;	/* Pointer to the channel for this device. */
    
    int watchMask;		/* OR'ed set of flags indicating which events
    				 * are being watched. */
    int validMask;		/* OR'ed set of flags indicating which events
    				 * are able to be watched. */
    int pending;		/* 1 if message is pending on queue. */
    
    Tcl_CheckDeviceProc	*readyProc; /* Function to check device for events */
    
    struct PortState *nextPtr;	/* Pointer to next registered file. */
} PortState;

typedef struct PortDesc {
	char *name;			/* Human Readable Device Name */
	char *type;			/* Human Readable Port Type */
	char *desc;			/* Human Readable Device Description */
	int	portid;			/* Enumerated Port ID */
	Tcl_OpenDeviceProc	*openProc;	/* Function to open device */
	Tcl_CloseDeviceProc	*closeProc; /* Function to force closed device */
} PortDesc;

/*
 * The following structure is what is added to the Tcl event queue when
 * file events are generated.
 */

typedef struct PortEvent {
    Tcl_Event header;		/* Information that is standard for
				 * all events. */
    PortState *infoPtr;		/* Pointer to file info structure.  Note
				 * that we still have to verify that the
				 * file exists before dereferencing this
				 * pointer. */
} PortEvent;


/* Function Prototypes used by this module */

int Device_Init _ANSI_ARGS_((Tcl_Interp *interp));

int Tcl_DeviceObjCmd 	_ANSI_ARGS_((
	ClientData dummy,
	Tcl_Interp *tinterp,
	int objc,
	Tcl_Obj *CONST objv[]
));
	
Tcl_Channel	Tcl_OpenDeviceChannel _ANSI_ARGS_((Tcl_Interp *interp,char *devName));
int	Tcl_ResetDeviceChannel _ANSI_ARGS_((Tcl_Interp *interp,char *devName));

/* Hooks into the serial code */
Tcl_Channel	SerialOpen	_ANSI_ARGS_((Tcl_Interp *interp,int port, int *errorCodePtr));
void		SerialReset	_ANSI_ARGS_((int port));

void DeviceInsert _ANSI_ARGS_((PortState *fileState));
void DeviceRemove _ANSI_ARGS_((PortState *fileState));
