/*
 * odieLib.r --
 *
 *	This file creates resources used by the Odie package.
 *
 * Copyright (c) 1997 Sun Microsystems, Inc.
 * Copyright (C) 1999 Woods Design Services
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include <Types.r>
#include <SysTypes.r>

/*
 * The folowing include and defines help construct
 * the version string for Tcl.
 */

#define ODIE_MAJOR_VERSION 1		/* Major number */
#define ODIE_MINOR_VERSION  0		/* Minor number */
#define ODIE_RELEASE_SERIAL   	/* Really minor number! */
#define RELEASE_LEVEL beta		/* alpha, beta, or final */
#define ODIE_VERSION "1.0"
#define ODIE_PATCH_LEVEL "1.0b1"
#define FINAL 0				/* Change to 1 if final version. */

#if FINAL
#   define MINOR_VERSION (ODIE_MINOR_VERSION * 16) + ODIE_RELEASE_SERIAL
#else
#   define MINOR_VERSION ODIE_MINOR_VERSION * 16
#endif

#define RELEASE_CODE 0x00

resource 'vers' (1) {
	ODIE_MAJOR_VERSION, MINOR_VERSION,
	RELEASE_LEVEL, 0x00, verUS,
	ODIE_PATCH_LEVEL,
	ODIE_PATCH_LEVEL ", Sean Woods"
};

resource 'vers' (2) {
	ODIE_MAJOR_VERSION, MINOR_VERSION,
	RELEASE_LEVEL, 0x00, verUS,
	ODIE_PATCH_LEVEL,
	"Odie " ODIE_PATCH_LEVEL "  1999"
};

/*
 * The -16397 string will be displayed by Finder when a user
 * tries to open the shared library. The string should
 * give the user a little detail about the library's capabilities
 * and enough information to install the library in the correct location.  
 * A similar string should be placed in all shared libraries.
 */
resource 'STR ' (-16397, purgeable) {
	"Odie\n\n"
	"This library implements the Open Design and Integration"
	"Environment for Tcl/Tk programs.  To work properly, it "
	"should be placed in the Tool Command Language folder "
	"within the Extensions folder."
};


/* 
 * Set up the pkgIndex in the resource fork of the library.
 */

#if defined(__POWERPC__)
  #define TARGET
#else
  #define TARGET "CFM68K"
#endif

/* 
 * For some reason the tckPkgSetup doesn't load my library 
 * I call package setup, and then explicitly load the file
 */
 
data 'TEXT' (4000,"pkgIndex",purgeable, preload) {
	"# Tcl package index file, version 1.0\n"
	"package ifneeded Odie 1.0 [list tclPkgSetup $dir Odie 1.0 {{Odie" TARGET ".shlb load Odie}}]\n"
	"load [file join $dir Odie" TARGET ".shlb] Odie\n"
};
