/*
 * itkStaticApplication.r --
 *
 *	This file creates resources which bind in the static version of the
 *  pkgIndex tclIndex and itk's Tcl code files.
 *
 * Jim Ingham for Itcl 2.2
 * 
 * Copyright (c) 1996 Lucent Technologies
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * SCCS: @(#) itkStaticApplication.r 1.5 96/10/03 17:54:21
 */

#include <Types.r>
#include <SysTypes.r>
#include <AEUserTermTypes.r>

/*
 * The folowing include and defines help construct
 * the version string for Tcl.
 */

#define RESOURCE_INCLUDED
#include <tcl.h>
#include <tk.h>


#include <Types.r>
#include <SysTypes.r>
#include <AEUserTermTypes.r>

#define RELEASE_CODE 0x00

#define ITK_APP_RESOURCES 128
#define ITK_APP_CREATOR 'ODIE'

#include "odieMacApp.r"
//#include "OdieTclInit.r"
//#include "OdieTkInit.r"

/*
 * The folowing include and defines help construct
 * the version string for Tcl.
 */
#define ODIE_VERSION		"1.0"
#define	ODIE_MAJOR_VERSION	1
#define ODIE_MINOR_VERSION	0
#define	ODIE_PATCH_LEVEL	"1.0.0"


#if (TK_RELEASE_LEVEL == 0)
#   define RELEASE_LEVEL alpha
#elif (TK_RELEASE_LEVEL == 1)
#   define RELEASE_LEVEL beta
#elif (TK_RELEASE_LEVEL == 2)
#   define RELEASE_LEVEL final
#endif

#if (TK_RELEASE_LEVEL == 2)
#   define MINOR_VERSION (ODIE_MINOR_VERSION * 16) + TK_RELEASE_SERIAL
#else
#   define MINOR_VERSION ODIE_MINOR_VERSION * 16
#endif

resource 'vers' (1) {
	ODIE_MAJOR_VERSION, MINOR_VERSION,
	RELEASE_LEVEL, 0x00, verUS,
	ODIE_PATCH_LEVEL,
	ODIE_PATCH_LEVEL ", by Sean Woods  1998" "\n" "Etoyoc, Inc."
};

resource 'vers' (2) {
	ODIE_MAJOR_VERSION, MINOR_VERSION,
	RELEASE_LEVEL, 0x00, verUS,
	ODIE_PATCH_LEVEL,
	"Odie " ODIE_PATCH_LEVEL "  1998"
};

/*
 * tclshrc
 * Code Executed at startup
 */ 
read 'TEXT' (32, "tclshrc", purgeable,preload) 
	":::Odie" ODIE_VERSION ":library:odierc.tcl";

/*
 * The following resource is used when creating the 'env' variable in
 * the Macintosh environment.  The creation mechanisim looks for the
 * 'STR#' resource named "Tcl Environment Variables" rather than a
 * specific resource number.  (In other words, feel free to change the
 * resource id if it conflicts with your application.)  Each string in
 * the resource must be of the form "KEYWORD=SOME STRING".  See Tcl
 * documentation for futher information about the env variable.
 *
 * A good example of something you may want to set is: "TCL_LIBRARY=My
 * disk:etc."
 */
 
resource 'STR#' (128, "Tcl Environment Variables") {
	{	"DEVELOPMENT=1",
		"ERROR=0"
	};
};
