typedef int	(Odie_ProcessProc) (ClientData data);

typedef struct OdieTask {
	int		pid;				/* Process ID */
	char	state; 				/* Task State */
	
	Tcl_Interp *interp;			/* Interpreter to call */
	
	int				pending;
	
	unsigned long	period;		/* Milleseconds between calls */	
	unsigned long	nextcall;	/* Time stamp of next call */	
	unsigned long	maxtime;	/* Max time Used (Sec) */
	unsigned long	mintime;	/* Min time Used (Sec) */
	unsigned long	avgtime;	/* Average time Used (Sec) */

	char			desc[32];		/* Text Description of task */
	Odie_ProcessProc *cfunct; 	/* Proc to call for update */
	ClientData		 data;		/* data passed to proc */
	
	struct OdieTask *nextPtr;
} OdieTask;

/*
 * Spedial case:
 * A TCL script executed within a specified interpreter
 *
 */
 
typedef struct OdieTclTask {
	Tcl_Interp 	*interp;
	Tcl_Obj		*script;
} OdieTclTask;

typedef struct OdieTaskEvent {
    Tcl_Event header;		/* Information that is standard for
				 * all events. */
    OdieTask *infoPtr;		/* Pointer to file info structure.  Note
				 * that we still have to verify that the
				 * file exists before dereferencing this
				 * pointer. */
} OdieTaskEvent;


enum {
	taskStateActive,
	taskStateStopped,
	taskStateHalted,
	taskStateSleeping,
	taskStateKilled
};

int Tcl_ProcessConfigure(
	OdieTask *infoPtr,		/* Process Information */
    Tcl_Interp *interp,		/* Current interpreter. */
    int objc,			/* Number of arguments. */
    Tcl_Obj *CONST objv[]	/* Argument objects. */
);

int Tcl_ProcessCreate _ANSI_ARGS_((
	Tcl_Interp *interp,
	Tcl_Obj *script
));
	
int ProcessCreate _ANSI_ARGS_((
	Odie_ProcessProc *Task_Proc,
	ClientData data
));
	
void Odie_StartProcess _ANSI_ARGS_((int pid));
void Odie_StopProcess _ANSI_ARGS_((int pid));
void Odie_ResetProcess _ANSI_ARGS_((int pid));
void Odie_KillProcess _ANSI_ARGS_((int pid));
void Odie_SetProcessPeriod _ANSI_ARGS_((int pid,long period));
void Odie_Realtime _ANSI_ARGS_((int tf));
void Odie_Interp _ANSI_ARGS_((Tcl_Interp *tinterp));

OdieTask * Odie_GetState _ANSI_ARGS_((int pid));
OdieTask * Odie_GetStateFromName _ANSI_ARGS_((char *name));

void Odie_MainLoop _ANSI_ARGS_(());
