# Desktop Settings
global env tcl_pkgPath
cd
set env(LIBRARY) [file join [pwd] lib]
set tcl_pkgPath [file join [pwd] lib]

namespace eval ::odie {
# Load Library Data
proc libLoad {} {
	uplevel #0 {
		set path [file join $env(LIBRARY) odie]
		source [file join $path index.tcl]
	}
}
# Create Desktop Environment
proc desktop {} {
	uplevel #0 {
		wm title . {Desktop}
		set win .menu
		destroy $win
		frame $win -bg grey -borderwidth 1 -relief raised
		foreach path [glob [file join bin *]] {
			set icon 		[file join $path icon]
			set name 	[string tolower [file tail $path]]
			set tkpath $win.$name
			if [file exists $icon] {
				source $icon
			}
		}
		foreach item [lsort [winfo children $win]] { 
			$item configure -direction flush -indicatoron 1 -anchor w
			grid $item -sticky ew 
		}
		grid $win
		wm geometry . {}
	}
}
}

# Bootstrap Code
if [catch {::odie::libLoad} error] {
	bgerror $error 
}
if [file exists odierc] {
	if [catch [source odierc] error] { 
		bgerror $error 
	}
}
if [catch {::odie::desktop} error] {
	bgerror $error 
}

global bootstrap
if [info exists bootstrap] {
	foreach line $bootstrap { eval $line }
}
