/* 
 * tkMacApp.r --
 *
 *	This file creates resources for use in the Wish application.
 *
 * Copyright (c) 1996 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * SCCS: @(#) tkMacApplication.r 1.2 96/10/03 17:53:57
 */

/*
 * The following resources defines the Apple Events that Tk can be
 * sent from Apple Script.
 */

resource 'aete' (0, "Wish Suite") {
    0x01, 0x00, english, roman,
    {
	"Required Suite", 
	"Events that every application should support", 
	'reqd', 1, 1,
	{},
	{},
	{},
	{},

	"Odie Suite", "Events for the Odie application", 'ODIE', 1, 1,
	{
	    "do script", "Execute a Tcl script", 'misc', 'dosc',
	    'TEXT', "Result", replyOptional, singleItem,
	    notEnumerated, reserved, reserved, reserved, reserved,
	    reserved, reserved, reserved, reserved, reserved,
	    reserved, reserved, reserved, reserved, 
	    'TEXT', "Script to execute", directParamRequired,
	    singleItem, notEnumerated, changesState, reserved,
	    reserved, reserved, reserved, reserved, reserved,
	    reserved, reserved, reserved, reserved, reserved,
	    reserved, 
	    {},
	},
	{},
	{},
	{},
    }
};

/*
 * The following two resources define the default "About Box" for Mac Tk.
 * This dialog appears if the "About Tk..." menu item is selected from
 * the Apple menu.  This dialog may be overridden by defining a Tcl procedure
 * with the name of "tkAboutDialog".  If this procedure is defined the
 * default dialog will not be shown and the Tcl procedure is expected to
 * create and manage an About Dialog box.
 */
data 'DLOG' (128, "Default About Box", purgeable) {
	$"002B 000D 0130 0146 0010 0100 0000 0000"            
	$"0000 0081 00"                                       
};
 
 
resource 'DITL' (129, "About Box", purgeable) {
    {
	{223, 124, 245, 208}, Button	    {enabled, "Ok"},
	{131, 187, 150, 271}, Button	    {enabled, "More"},
	{ 11, 187, 45, 294}, StaticText    {disabled, "Odie \nRelease" },
	{ 58, 187, 127, 304}, StaticText    {disabled, 	 
	    "Sean Woods\n" 
	    "David Romig\n" 
	    "Ron Deloach\n" 
	     "Vy Ho" },
	{ 183, 20, 216, 306}, StaticText    {disabled, 	    
	    "The Organic Data and Instruction Environment\n\n"
	    "1998, Philadelphia Software Guild" },	    
	{ 5,  17, 172, 177}, Picture  {enabled, 128}
    }
};
/*
 * Here is the custom file open dialog. This dialog is used instead of
 * the default file dialog if the -filetypes flag is specified.
 */

resource 'DLOG' (130, purgeable) {
    {0, 0, 195, 344}, dBoxProc, invisible, noGoAway, 0,
     130, "", noAutoCenter
};

resource 'DITL' (130, "File Open Box", purgeable) {
    {
	{135, 252, 155, 332}, Button   {enabled, "Open"},
	{104, 252, 124, 332}, Button   {enabled, "Cancel"},	    
        {  0,   0,   0,   0}, HelpItem {disabled, HMScanhdlg {130}},
        {  8, 235,  24, 337}, UserItem {enabled},
        { 32, 252,  52, 332}, Button   {enabled, "Eject"},
        { 60, 252,  80, 332}, Button   {enabled, "Desktop"},    
        { 29,  12, 159, 230}, UserItem {enabled},
        {  6,  12,  25, 230}, UserItem {enabled},
        { 91, 251,  92, 333}, Picture  {disabled, 11},
        {168,  20, 187, 300}, Control  {enabled, 131} 
    }
};

resource 'CNTL' (131, "File Types menu", purgeable) {
    {168, 20, 187, 300},
    popupTitleLeftJust,
    visible,
    80,
    132,
    popupMenuCDEFProc,
    0,
    "File Type:"
};


resource 'MENU' (132, preload) {
    132,
    textMenuProc,
    0xFFFF, enabled, "", {}
};


