/*
 * odieMacInit.c
 *
 * Initializes the odie system on the macintosh platform
 *
 *  Questions, Bugs reports, and Creative direction can for now be sent to
 *  Sean Woods, yoda@drexel.edu
 *
 * Copyright (c) 1998 Woods Design Services
 *
 * See the file "odie.license" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include <Gestalt.h>
#include <ToolUtils.h>
#include <Fonts.h>
#include <Dialogs.h>
#include <SegLoad.h>
#include <Traps.h>
#include <Appearance.h>
#include <SpeechSynthesis.h>

#include "tk.h"
#include "tkInt.h"
#include "tkMacInt.h"
#include "tclMac.h"

#include "process.h"
#include "matrices.h"

#pragma export on
int Odie_Init	_ANSI_ARGS_(( Tcl_Interp *interp ));
int Odie_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));
#pragma export reset

int Device_Init(Tcl_Interp *interp);
int Matrix_Init(Tcl_Interp *tinterp);
int Process_Init(Tcl_Interp *tinterp);
int Tclapplescript_Init(Tcl_Interp *interp);

int Odie_Init( Tcl_Interp *interp ) {

	/*
	 * Mark off what sections of the code we can start
	 */
	
	if (Matrix_Init(interp) == TCL_ERROR) {
    	Tcl_SetVar2(interp, "odie", "MATRIX", "0", TCL_GLOBAL_ONLY); 
	} else {
    	Tcl_SetVar2(interp, "odie", "MATRIX", "1", TCL_GLOBAL_ONLY); 	
	}	

	if (Process_Init(interp) == TCL_ERROR) {
    	Tcl_SetVar2(interp, "odie", "PROCESS", "0", TCL_GLOBAL_ONLY); 
	} else {
    	Tcl_SetVar2(interp, "odie", "PROCESS", "1", TCL_GLOBAL_ONLY);
	}
	
	if (Device_Init(interp) == TCL_ERROR) {
    	Tcl_SetVar2(interp, "odie", "DEVICE", "0", TCL_GLOBAL_ONLY); 
	} else {
    	Tcl_SetVar2(interp, "odie", "DEVICE", "1", TCL_GLOBAL_ONLY);
	}

	Tcl_PkgProvide(interp, "Odie", "1.0");
	
	return TCL_OK;
}

/*
 *----------------------------------------------------------------------
 * Odie_SafeInit --
 *
 *      Initializes the devices package
 *
 * Results: 
 *      Nothing happens, since this is not a safe activity.
 *
 * Side Effects:
 *      None
 *
 *----------------------------------------------------------------------
 */

int 
Odie_SafeInit(interp)
    Tcl_Interp *interp;
{
 	if (Matrix_Init(interp) == TCL_ERROR) {
    	Tcl_SetVar2(interp, "odie", "MATRIX", "0", TCL_GLOBAL_ONLY); 
	} else {
    	Tcl_SetVar2(interp, "odie", "MATRIX", "1", TCL_GLOBAL_ONLY); 	
	}  
	Tcl_SetVar2(interp, "odie", "PROCESS", "0", TCL_GLOBAL_ONLY); 
	Tcl_SetVar2(interp, "odie", "DEVICE", "0", TCL_GLOBAL_ONLY);
    return TCL_OK;
}

