# -*- tcl -*-
#		Pool 2.2, as of February 20, 1999
#		Pool_Net @net:mFullVersion@
#
# CVS: $Id: spooler.cls,v 1.2 1998/06/04 18:06:50 aku Exp $
#
# @c SMTP based spooler of outbound mail (found in files in halfbaked SMTP
# @c format).
# @s SMTP based spooler.
# @i SMTP, spooler
# -----------------------------

class smtpSpooler {
    # @c Implements a file and directory based spooler for mails.
    # @c See <m start> for more. Uses <c smtpConnection> to do the real work.

    # @o host:    The name of the host the smtp demon is running on.
    # @o helo:    The initial string to send to the smtp demon
    # @o from:    The address of the sender.
    # @o n:       The number of simultaneously open connections to the smtp
    # @o n:       demon.
    # @o command: The script to evaluate after the last mail was sent down the
    # @o command: line.

    option host -d localhost         -t ::pool::getopt::nonempty
    option helo -d [::info hostname] -t ::pool::getopt::nonempty
    option from -d ""                -t ::pool::getopt::nonempty
    option n    -d 1                 -t ::pool::getopt::integer
    option command

    # @v active:   Boolean flag locking the object against multiple <m start>s.
    # @v msgFiles: Contains the list of files containing the mails to sent to
    # @v msgFiles: the smtp demon. Can be seens as a task queue as well, as it
    # @v msgFiles: will be shortened during the operation.

    var active   0
    var msgFiles {}



    method start {flist} {
	# @c All specified files are forwarded to the given site, using the
	# @c SMTP protocol. Files successfully transfered are deleted
	# @c afterward. A partial transfer is enough to do so.

	# @a flist: List of files to transfer.

	# @n This procedure assumes that the files are in HB-SMTP format
	# @n (half baked SMTP), as generated by the smail MTA. In such files
	# @n the message is prepended with MAIL FROM, RCPT TO, DATA commands,
	# @n and the standard EOM-indicator (. on a single line line) is
	# @n appended.

	if {$flist == {}} {
	    ::pool::syslog::syslog debug $this nothing to spool
	    return
	}

	if {$active} {
	    # A spooler is running, avoid sending out mail already in delivery
	    ::pool::syslog::syslog debug $this already active
	    return
	}
	if {$opt(-host) == {}} {
	    error "-host not defined"
	}
	if {$opt(-helo) == {}} {
	    error "-helo not defined"
	}
	if {$opt(-from) == {}} {
	    error "-from not defined"
	}
	if {$opt(-n) <= 0} {
	    set opt(-n) 1
	}

	set msgFiles $flist

	# a finite loop starts -n 'threads', thus
	# allowing for limited degree of parallelism.

	for {set j 0} {$j < $opt(-n)} {incr j} {
	    SpoolMessage
	}

	return
    }


    method SpoolMessage {} {
	# @c Initiates a SMTP session for the first message in the queue.

	# lock against multiple starts
	incr active

	if {$msgFiles == {}} {
	    # nothing more to be done
	    # release spooler lock held by this thread
	    incr active -1

	    ::pool::syslog::syslog debug $this done ($active)

	    if {($active == 0) && ([string length $opt(-command)] > 0)} {
		# last session completed, call out to user, if possible
		uplevel #0 $opt(-command)
	    }

	    return
	}

	set file [::pool::list::shift msgFiles]

	set    f  [open $file r]
	gets  $f		; # discard MAIL FROM, we are using our own.
	gets  $f  recipient	; # take    RCPT TO
	gets  $f		; # discard DATA
	set    text [read $f]	; # rest of message
	close $f

	# remove EOM indicator and all preceding empty lines.
	regsub -- "\n\n*\\.\n\$" $text "\n" text

	# remove heading to uncover recipient address.
	regsub -- {^RCPT TO:} $recipient {} recipient

	set conn ${this}_c[::pool::serial::new]

	smtpConnection $conn \
		-helo $opt(-helo) \
		-host $opt(-host)

	::pool::syslog::syslog \
		debug spooling $file for $recipient via smtp session $conn

	$conn put				\
	    -from	$opt(-from)		\
	    -to		$recipient		\
	    -message	$text			\
	    -string	1			\
	    -command	[list $this Done $file]
	return
    }


    method Done {file conn} {
	# @c Executed after SMTP transfer of <a file> is finished.
	# @c Removes the file in case of success. Always initiates
	# @c the transfer of the next file.
	# @a conn: Name of the used smtp descriptor array.
	# @a file: Name of the file transfered to the outside world.

	if {"[$conn state]" == "error"} {
	    # ignore errors, but do not delete the offending file.

	    ::pool::syslog::syslog error spooler $conn [$conn errorInfo]
	} else {
	    # remove the transfered file. The 'catch' is required
	    # as it might have been transfered and deleted
	    # successfully before, for a different receiver.

	    ::pool::syslog::syslog debug spooler removing $file
	    catch {file delete $file}
	}

	$conn close -command [list $this AllDone]

	# Always done. Release the lock held by this thread and schedule
	# spooling of the next message.

	incr active -1
	SpoolMessage
	return
    }


    method AllDone {conn} {
	# @c Called by <a conn> after the channel to the smtp demon was closed.
	# @c Simply destroys the connection

	# @a conn: The <c smtpConnection> in shutdown, to destroy.

	$conn delete
	return
    }
}

