# -*- tcl -*-
# Automatically generated from file '/home/aku/.mkd423/pool2.2/net/smtp/spooler.cls'.
# Date: Sat Feb 20 19:29:08 MET 1999
# -------------------------------
# ** Do NOT edit manually **
#
# ** Provided class       **     >> smtpSpooler <<
# -------------------------------

package require Pool_Base

# -------------------------------
# Namespace describing the class
namespace eval ::pool::oo::class::smtpSpooler {
    variable  _superclasses    {}
    variable  _scChainForward  smtpSpooler
    variable  _scChainBackward smtpSpooler
    variable  _classVariables  {}
    variable  _methods         {AllDone Done SpoolMessage start}

    variable  _variables
    array set _variables  {active {smtpSpooler {isArray 0 initialValue 0}} msgFiles {smtpSpooler {isArray 0 initialValue {}}}}

    variable  _options
    array set _options  {from {smtpSpooler {-default {} -type ::pool::getopt::nonempty -action {} -class From}} helo {smtpSpooler {-default bluepeak.westend.com -type ::pool::getopt::nonempty -action {} -class Helo}} n {smtpSpooler {-default 1 -type ::pool::getopt::integer -action {} -class N}} host {smtpSpooler {-default localhost -type ::pool::getopt::nonempty -action {} -class Host}} command {smtpSpooler {-default {} -type ::pool::getopt::notype -action {} -class Command}}}

    variable  _optionAliases
    array set _optionAliases {_ _}
    unset     _optionAliases(_)

    variable  _methodTable
    array set _methodTable  {start . SpoolMessage . Done . AllDone .}

    # Export every method
    namespace export -clear *
}

# -------------------------------


proc ::pool::oo::class::smtpSpooler::AllDone {conn} {
    ::pool::oo::support::SetupVars smtpSpooler
    # @c Called by <a conn> after the channel to the smtp demon was closed.
	# @c Simply destroys the connection

	# @a conn: The <c smtpConnection> in shutdown, to destroy.

	$conn delete
	return
}



proc ::pool::oo::class::smtpSpooler::Done {file conn} {
    ::pool::oo::support::SetupVars smtpSpooler
    # @c Executed after SMTP transfer of <a file> is finished.
	# @c Removes the file in case of success. Always initiates
	# @c the transfer of the next file.
	# @a conn: Name of the used smtp descriptor array.
	# @a file: Name of the file transfered to the outside world.

	if {"[$conn state]" == "error"} {
	    # ignore errors, but do not delete the offending file.

	    ::pool::syslog::syslog error spooler $conn [$conn errorInfo]
	} else {
	    # remove the transfered file. The 'catch' is required
	    # as it might have been transfered and deleted
	    # successfully before, for a different receiver.

	    ::pool::syslog::syslog debug spooler removing $file
	    catch {file delete $file}
	}

	$conn close -command [list $this AllDone]

	# Always done. Release the lock held by this thread and schedule
	# spooling of the next message.

	incr active -1
	SpoolMessage
	return
}



proc ::pool::oo::class::smtpSpooler::SpoolMessage {} {
    ::pool::oo::support::SetupVars smtpSpooler
    # @c Initiates a SMTP session for the first message in the queue.

	# lock against multiple starts
	incr active

	if {$msgFiles == {}} {
	    # nothing more to be done
	    # release spooler lock held by this thread
	    incr active -1

	    ::pool::syslog::syslog debug $this done ($active)

	    if {($active == 0) && ([string length $opt(-command)] > 0)} {
		# last session completed, call out to user, if possible
		uplevel #0 $opt(-command)
	    }

	    return
	}

	set file [::pool::list::shift msgFiles]

	set    f  [open $file r]
	gets  $f		; # discard MAIL FROM, we are using our own.
	gets  $f  recipient	; # take    RCPT TO
	gets  $f		; # discard DATA
	set    text [read $f]	; # rest of message
	close $f

	# remove EOM indicator and all preceding empty lines.
	regsub -- "\n\n*\\.\n\$" $text "\n" text

	# remove heading to uncover recipient address.
	regsub -- {^RCPT TO:} $recipient {} recipient

	set conn ${this}_c[::pool::serial::new]

	smtpConnection $conn  -helo $opt(-helo)  -host $opt(-host)

	::pool::syslog::syslog  debug spooling $file for $recipient via smtp session $conn

	$conn put				 -from	$opt(-from)		 -to		$recipient		 -message	$text			 -string	1			 -command	[list $this Done $file]
	return
}



proc ::pool::oo::class::smtpSpooler::start {flist} {
    ::pool::oo::support::SetupVars smtpSpooler
    # @c All specified files are forwarded to the given site, using the
	# @c SMTP protocol. Files successfully transfered are deleted
	# @c afterward. A partial transfer is enough to do so.

	# @a flist: List of files to transfer.

	# @n This procedure assumes that the files are in HB-SMTP format
	# @n (half baked SMTP), as generated by the smail MTA. In such files
	# @n the message is prepended with MAIL FROM, RCPT TO, DATA commands,
	# @n and the standard EOM-indicator (. on a single line line) is
	# @n appended.

	if {$flist == {}} {
	    ::pool::syslog::syslog debug $this nothing to spool
	    return
	}

	if {$active} {
	    # A spooler is running, avoid sending out mail already in delivery
	    ::pool::syslog::syslog debug $this already active
	    return
	}
	if {$opt(-host) == {}} {
	    error "-host not defined"
	}
	if {$opt(-helo) == {}} {
	    error "-helo not defined"
	}
	if {$opt(-from) == {}} {
	    error "-from not defined"
	}
	if {$opt(-n) <= 0} {
	    set opt(-n) 1
	}

	set msgFiles $flist

	# a finite loop starts -n 'threads', thus
	# allowing for limited degree of parallelism.

	for {set j 0} {$j < $opt(-n)} {incr j} {
	    SpoolMessage
	}

	return
}



# -------------------------------
# Entrypoint for autoloader
proc ::pool::oo::class::smtpSpooler::loadClass {} {}

# Import standard methods, fix option processor definition (shortcuts)
::pool::oo::support::FixMethods smtpSpooler
::pool::oo::support::FixOptions smtpSpooler

# Create object instantiation procedure
interp alias {} smtpSpooler {} ::pool::oo::support::New smtpSpooler

# -------------------------------

