set rcsId {$Id: bindings.tcl,v 1.4 1997/12/30 15:02:13 jfontain Exp $}

# provide a reliable non-intrusive binding mechanism: a new tag is created, inserted in the existing tags at a specified position
# and when deleted, all existing bndings for this tag are safely and completely removed

class bindings {
    proc bindings {this widget index} {
        ::set bindings::($this,widget) $widget
        bindtags $widget [linsert [bindtags $widget] $index bindings($this)]
    }
    proc ~bindings {this} {
        ::set tags [bindtags $bindings::($this,widget)]
        ::set index [lsearch -exact $tags bindings($this)]
        bindtags $bindings::($this,widget) [lreplace $tags $index $index]
        foreach tag [bind bindings($this)] {
            bind bindings($this) $tag {}
        }
    }
    proc set {this tag sequence} {                                                         ;# for exact behavior, see Tk bind manual
        bind bindings($this) $tag $sequence
    }
}
