set rcsId {$Id: stooop.tcl,v 3.63 1998/09/05 20:21:54 jfontain Exp $}

package provide stooop 3.6.1

catch {rename proc _proc}

namespace eval ::stooop {
    variable checkCode
    variable traceProcedureChannel
    variable traceProcedureFormat
    variable traceDataChannel
    variable traceDataFormat
    variable traceDataOperations

    set checkCode {}
    if {[info exists ::env(STOOOPCHECKALL)]} {
        array set ::env {STOOOPCHECKPROCEDURES {} STOOOPCHECKDATA {}}
    }
    if {[info exists ::env(STOOOPCHECKPROCEDURES)]} {
        append checkCode {::stooop::checkProcedure;}
    }
    if {[info exists ::env(STOOOPTRACEALL)]} {
        set ::env(STOOOPTRACEPROCEDURES) $::env(STOOOPTRACEALL)
        set ::env(STOOOPTRACEDATA) $::env(STOOOPTRACEALL)
    }
    if {[info exists ::env(STOOOPTRACEPROCEDURES)]} {
        set traceProcedureChannel $::env(STOOOPTRACEPROCEDURES)
        if {![regexp {^stdout|stderr$} $traceProcedureChannel]} {
            set traceProcedureChannel [open $::env(STOOOPTRACEPROCEDURES) w+]
        }
        set traceProcedureFormat {class: %C, procedure: %p, object: %O, arguments: %a}
        catch {set traceProcedureFormat $::env(STOOOPTRACEPROCEDURESFORMAT)}
        append checkCode {::stooop::traceProcedure;}
    }
    if {[info exists ::env(STOOOPTRACEDATA)]} {
        set traceDataChannel $::env(STOOOPTRACEDATA)
        if {![regexp {^stdout|stderr$} $traceDataChannel]} {
            set traceDataChannel [open $::env(STOOOPTRACEDATA) w+]
        }
        set traceDataFormat {class: %C, procedure: %p, array: %A, object: %O, member: %m, operation: %o, value: %v}
        catch {set traceDataFormat $::env(STOOOPTRACEDATAFORMAT)}
        set traceDataOperations rwu
        catch {set traceDataOperations $::env(STOOOPTRACEDATAOPERATIONS)}
    }

    namespace export class virtual new delete classof

    if {![info exists newId]} {
        variable newId 0
    }

    _proc new {classOrId args} {
        variable newId
        variable fullClass

        if {[scan $classOrId %u dummy]==0} {
            set constructor ${classOrId}::[namespace tail $classOrId]
            uplevel $constructor [set id [incr newId]] $args
            set fullClass($id) [namespace qualifiers [uplevel namespace which -command $constructor]]
        } else {
            if {[catch {set fullClass([set id [incr newId]]) $fullClass($classOrId)}]} {
                error "invalid object identifier $classOrId"
            }
            uplevel $fullClass($classOrId)::_copy $id $classOrId
        }
        return $id
    }

    _proc delete {args} {
        variable fullClass

        foreach id $args {
            uplevel ::stooop::deleteObject $fullClass($id) $id
            unset fullClass($id)
        }
    }

    _proc deleteObject {fullClass id} {
        uplevel ${fullClass}::~[namespace tail $fullClass] $id
        foreach name [array names ${fullClass}:: $id,*] {
            unset ${fullClass}::($name)
        }
    }

    _proc classof {id} {
        variable fullClass

        return $fullClass($id)
    }

    _proc copy {fullClass from to} {
        set index [string length $from]
        foreach name [array names ${fullClass}:: $from,*] {
            set ${fullClass}::($to[string range $name $index end]) [set ${fullClass}::($name)]
        }
    }
}

_proc ::stooop::class {args} {
    variable declared

    set class [lindex $args 0]
    set declared([uplevel namespace eval $class {namespace current}]) {}
    uplevel namespace eval $class [list "::variable {}\n[lindex $args end]"]
}

_proc ::stooop::parseProcedureName {namespace name fullClassVariable procedureVariable messageVariable} {
    variable declared
    upvar $fullClassVariable fullClass $procedureVariable procedure $messageVariable message

    if {[info exists declared($namespace)]&&([string length [namespace qualifiers $name]]==0)} {
        set fullClass $namespace
        set procedure $name
        return 1
    } else {
        if {![string match ::* $name]} {
            if {[string compare $namespace ::]==0} {
                set name ::$name
            } else {
                set name ${namespace}::$name
            }
        }
        set fullClass [namespace qualifiers $name]
        if {[info exists declared($fullClass)]} {
            set procedure [namespace tail $name]
            return 1
        } else {
            if {[string length $fullClass]==0} {
                set message "procedure $name class name is empty"
            } else {
                set message "procedure $name class $fullClass is unknown"
            }
            return 0
        }
    }
}

_proc ::stooop::virtual {keyword name arguments args} {
    variable pureVirtual

    if {[string compare [uplevel namespace which -command $keyword] ::proc]!=0} {
        error "virtual operator works only on proc, not $keyword"
    }
    if {![parseProcedureName [uplevel namespace current] $name fullClass procedure message]} {
        error $message
    }
    set class [namespace tail $fullClass]
    if {[string compare $class $procedure]==0} {
        error "cannot make class $fullClass constructor virtual"
    }
    if {[string compare ~$class $procedure]==0} {
        error "cannot make class $fullClass destructor virtual"
    }
    if {[string compare [lindex $arguments 0] this]!=0} {
        error "cannot make static procedure $procedure of class $fullClass virtual"
    }
    set pureVirtual [expr {[llength $args]==0}]
    uplevel ::proc [list $name $arguments [lindex $args 0]]
    unset pureVirtual
}

_proc proc {name arguments args} {
    if {![::stooop::parseProcedureName [uplevel namespace current] $name fullClass procedure message]} {
        uplevel _proc [list $name $arguments] $args
        return
    }
    if {[llength $args]==0} {
        error "missing body for ${fullClass}::$procedure"
    }
    set class [namespace tail $fullClass]
    if {[string compare $class $procedure]==0} {
        if {[string compare [lindex $arguments 0] this]!=0} {
            error "class $fullClass constructor first argument must be this"
        }
        if {[string compare [lindex $arguments 1] copy]==0} {
            if {[llength $arguments]!=2} {
                error "class $fullClass copy constructor must have 2 arguments exactly"
            }
            if {[catch {info body ::${fullClass}::$class}]} {
                error "class $fullClass copy constructor defined before constructor"
            }
            eval ::stooop::constructorDeclaration $fullClass $class 1 \{$arguments\} $args
        } else {
            eval ::stooop::constructorDeclaration $fullClass $class 0 \{$arguments\} $args
            ::stooop::generateDefaultCopyConstructor $fullClass
        }
    } elseif {[string compare ~$class $procedure]==0} {
        if {[llength $arguments]!=1} {
            error "class $fullClass destructor must have 1 argument exactly"
        }
        if {[string compare [lindex $arguments 0] this]!=0} {
            error "class $fullClass destructor argument must be this"
        }
        if {[catch {info body ::${fullClass}::$class}]} {
            error "class $fullClass destructor defined before constructor"
        }
        ::stooop::destructorDeclaration $fullClass $class $arguments [lindex $args 0]
    } else {
        if {[catch {info body ::${fullClass}::$class}]} {
            error "class $fullClass member procedure $procedure defined before constructor"
        }
        ::stooop::memberProcedureDeclaration $fullClass $class $procedure $arguments [lindex $args 0]
    }
}

_proc ::stooop::constructorDeclaration {fullClass class copy arguments args} {
    variable checkCode
    variable fullBases
    variable variable

    set number [llength $args]
    if {($number%2)==0} {
        error "bad class $fullClass constructor declaration, a base class, contructor arguments or body may be missing"
    }
    if {[string compare [lindex $arguments end] args]==0} {
        set variable($fullClass) {}
    }
    if {!$copy} {
        set fullBases($fullClass) {}
    }
    foreach {base baseArguments} [lrange $args 0 [expr {$number-2}]] {
        set constructor ${base}::[namespace tail $base]
        catch {$constructor}
        set fullBase [namespace qualifiers [uplevel 2 namespace which -command $constructor]]
        if {[string length $fullBase]==0} {
            if {[string match *$base $fullClass]} {
                error "class $fullClass cannot be derived from itself"
            } else {
                error "class $fullClass constructor defined before base class $base constructor"
            }
        }
        if {!$copy} {
            if {[lsearch -exact $fullBases($fullClass) $fullBase]>=0} {
                error "class $fullClass directly inherits from class $fullBase more than once"
            }
            lappend fullBases($fullClass) $fullBase
        }
        regsub -all \n $baseArguments {} constructorArguments($fullBase)
    }
    set constructorBody \
"::variable {}
$checkCode
"
    if {[llength $fullBases($fullClass)]>0} {
        if {[info exists variable($fullClass)]} {
            foreach fullBase $fullBases($fullClass) {
                if {![info exists constructorArguments($fullBase)]} {
                    error "missing base class $fullBase constructor arguments from class $fullClass constructor"
                }
                set baseConstructor ${fullBase}::[namespace tail $fullBase]
                if {[info exists variable($fullBase)]&&([string first {$args} $constructorArguments($fullBase)]>=0)} {
                    append constructorBody \
"::set _list \[::list $constructorArguments($fullBase)\]
::eval $baseConstructor \$this \[::lrange \$_list 0 \[::expr {\[::llength \$_list\]-2}\]\] \[::lindex \$_list end\]
::unset _list
::set ${fullBase}::(\$this,_derived) $fullClass
"
                } else {
                    append constructorBody \
"$baseConstructor \$this $constructorArguments($fullBase)
::set ${fullBase}::(\$this,_derived) $fullClass
"
                }
            }
        } else {
            foreach fullBase $fullBases($fullClass) {
                if {![info exists constructorArguments($fullBase)]} {
                    error "missing base class $fullBase constructor arguments from class $fullClass constructor"
                }
                set baseConstructor ${fullBase}::[namespace tail $fullBase]
                append constructorBody \
"$baseConstructor \$this $constructorArguments($fullBase)
::set ${fullBase}::(\$this,_derived) $fullClass
"
            }
        }
    }
    if {$copy} {
        append constructorBody \
"::catch {::set ${fullClass}::(\$this,_derived) \[::set ${fullClass}::(\$[::lindex $arguments 1],_derived)\]}
"
    }
    append constructorBody [lindex $args end]
    if {$copy} {
        _proc ${fullClass}::_copy $arguments $constructorBody
    } else {
        _proc ${fullClass}::$class $arguments $constructorBody
    }
}

_proc ::stooop::destructorDeclaration {fullClass class arguments body} {
    variable checkCode
    variable fullBases

    set body \
"::variable {}
$checkCode
$body
"
    for {set index [expr {[llength $fullBases($fullClass)]-1}]} {$index>=0} {incr index -1} {
        set fullBase [lindex $fullBases($fullClass) $index]
        append body \
"::stooop::deleteObject $fullBase \$this
"
    }
    _proc ${fullClass}::~$class $arguments $body
}

_proc ::stooop::memberProcedureDeclaration {fullClass class procedure arguments body} {
    variable checkCode
    variable pureVirtual

    if {[info exists pureVirtual]} {
        if {$pureVirtual} {
            _proc ${fullClass}::$procedure $arguments \
"::variable {}
$checkCode
::uplevel \$${fullClass}::(\$this,_derived)::$procedure \[::lrange \[::info level 0\] 1 end\]
"
        } else {
            _proc ${fullClass}::_$procedure $arguments \
"::variable {}
$checkCode
$body
"
            _proc ${fullClass}::$procedure $arguments \
"::variable {}
$checkCode
if {!\[::catch {::info body \$${fullClass}::(\$this,_derived)::$procedure}\]} {
::return \[::uplevel \$${fullClass}::(\$this,_derived)::$procedure \[::lrange \[::info level 0\] 1 end\]\]
}
::uplevel ${fullClass}::_$procedure \[::lrange \[::info level 0\] 1 end\]
"
        }
    } else {
        _proc ${fullClass}::$procedure $arguments \
"::variable {}
$checkCode
$body
"
    }
}

_proc ::stooop::generateDefaultCopyConstructor {fullClass} {
    variable fullBases

    foreach fullBase $fullBases($fullClass) {
        append body \
"${fullBase}::_copy \$this \$sibling
"
    }
    append body \
"::stooop::copy $fullClass \$sibling \$this
"
    _proc ${fullClass}::_copy {this sibling} $body
}


if {[llength [array names ::env STOOOP*]]>0} {

    catch {rename ::stooop::class ::stooop::_class}
    _proc ::stooop::class {args} {
        variable traceDataOperations

        set class [lindex $args 0]
        if {[info exists ::env(STOOOPCHECKDATA)]} {
            uplevel namespace eval $class [list {::trace variable {} wu ::stooop::checkData}]
        }
        if {[info exists ::env(STOOOPTRACEDATA)]} {
            uplevel namespace eval $class [list "::trace variable {} $traceDataOperations ::stooop::traceData"]
        }
        uplevel ::stooop::_class $args
    }

    if {[info exists ::env(STOOOPCHECKPROCEDURES)]} {
        catch {rename ::stooop::virtual ::stooop::_virtual}
        _proc ::stooop::virtual {keyword name arguments args} {
            variable interface

            uplevel ::stooop::_virtual [list $keyword $name $arguments] $args
            parseProcedureName [uplevel namespace current] $name fullClass procedure message
            if {[llength $args]==0} {
                set interface($fullClass) {}
            }
        }

        catch {rename ::stooop::new ::stooop::_new}
        _proc ::stooop::new {classOrId args} {
            variable newId
            variable fullClass
            variable interface

            if {[scan $classOrId %u dummy]==0} {
                set constructor ${classOrId}::[namespace tail $classOrId]
                catch {$constructor}
                set fullName [namespace qualifiers [uplevel namespace which -command $constructor]]
                set fullClass([expr {$newId+1}]) $fullName
            } else {
                set fullName $fullClass($classOrId)
            }
            if {[info exists interface($fullName)]} {
                error "class $fullName with pure virtual procedures should not be instanciated"
            }
            return [uplevel ::stooop::_new $classOrId $args]
        }
    }

    _proc ::stooop::ancestors {fullClass} {
        variable ancestors
        variable fullBases

        if {[info exists ancestors($fullClass)]} {
            return $ancestors($fullClass)
        }
        set list {}
        foreach class $fullBases($fullClass) {
            set list [concat $list [list $class] [ancestors $class]]
        }
        set ancestors($fullClass) $list
        return $list
    }

    _proc ::stooop::debugInformation {className fullClassName procedureName fullProcedureName thisParameterName} {
        upvar $className class $fullClassName fullClass $procedureName procedure $fullProcedureName fullProcedure\
            $thisParameterName thisParameter
        variable declared

        set namespace [uplevel 2 namespace current]
        if {[lsearch -exact [array names declared] $namespace]<0} return
        set fullClass [string trimleft $namespace :]
        set class [namespace tail $fullClass]
        set list [info level -2]
        if {[llength $list]==0} return
        set procedure [lindex $list 0]
        set fullProcedure [uplevel 3 namespace which -command $procedure]
        set procedure [namespace tail $procedure]
        if {[string compare $class $procedure]==0} {
            set procedure constructor
        } elseif {[string compare ~$class $procedure]==0} {
            set procedure destructor
        }
        if {[string compare [lindex [info args $fullProcedure] 0] this]==0} {
            set thisParameter [lindex $list 1]
        }
    }

    _proc ::stooop::checkProcedure {} {
        variable fullClass

        debugInformation class qualifiedClass procedure qualifiedProcedure this
        if {![info exists this]} return
        if {[string compare $procedure constructor]==0} return
        if {![info exists fullClass($this)]} {
            error "$this is not a valid object identifier"
        }
        set fullName [string trimleft $fullClass($this) :]
        if {[string compare $fullName $qualifiedClass]==0} return
        if {[lsearch -exact [ancestors ::$fullName] ::$qualifiedClass]<0} {
            error "class $qualifiedClass of $qualifiedProcedure procedure not an ancestor of object $this class $fullName"
        }
    }

    _proc ::stooop::traceProcedure {} {
        variable traceProcedureChannel
        variable traceProcedureFormat

        debugInformation class qualifiedClass procedure qualifiedProcedure this
        set text $traceProcedureFormat
        regsub -all %C $text $qualifiedClass text
        regsub -all %c $text $class text
        regsub -all %P $text $qualifiedProcedure text
        regsub -all %p $text $procedure text
        if {[info exists this]} {
            regsub -all %O $text $this text
            regsub -all %a $text [lrange [info level -1] 2 end] text
        } else {
            regsub -all %O $text {} text
            regsub -all %a $text [lrange [info level -1] 1 end] text
        }
        puts $traceProcedureChannel $text
    }

    _proc ::stooop::checkData {array name operation} {
        scan $name %u,%s identifier member
        if {[info exists member]&&([string compare $member _derived]==0)} return

        debugInformation class qualifiedClass procedure qualifiedProcedure this
        if {![info exists class]} return
        set array [uplevel [list namespace which -variable $array]]
        if {![info exists procedure]} {
            if {[string compare $array ::${qualifiedClass}::]!=0} {
                error "class access violation in class $qualifiedClass namespace"
            }
            return
        }
        if {[string compare $qualifiedProcedure ::stooop::copy]==0} return
        if {[string compare $array ::${qualifiedClass}::]!=0} {
            error "class access violation in procedure $qualifiedProcedure"
        }
        if {![info exists this]} return
        if {![info exists identifier]} return
        if {$this!=$identifier} {
            error "object $identifier access violation in procedure $qualifiedProcedure acting on object $this"
        }
    }

    _proc ::stooop::traceData {array name operation} {
        variable traceDataChannel
        variable traceDataFormat

        scan $name %u,%s identifier member
        if {[info exists member]&&([string compare $member _derived]==0)} return

        if {![catch {lindex [info level -1] 0} procedure]&&([string compare ::stooop::deleteObject $procedure]==0)} return
        set class {}
        set qualifiedClass {}
        set procedure {}
        set qualifiedProcedure {}

        debugInformation class qualifiedClass procedure qualifiedProcedure this
        set text $traceDataFormat
        regsub -all %C $text $qualifiedClass text
        regsub -all %c $text $class text
        if {[info exists member]} {
            regsub -all %m $text $member text
        } else {
            regsub -all %m $text $name text
        }
        regsub -all %P $text $qualifiedProcedure text
        regsub -all %p $text $procedure text
        regsub -all %A $text [string trimleft [uplevel [list namespace which -variable $array]] :] text
        if {[info exists this]} {
            regsub -all %O $text $this text
        } else {
            regsub -all %O $text {} text
        }
        array set string {r read w write u unset}
        regsub -all %o $text $string($operation) text
        if {[string compare $operation u]==0} {
            regsub -all %v $text {} text
        } else {
            regsub -all %v $text [uplevel set ${array}($name)] text
        }
        puts $traceDataChannel $text
    }
}
namespace import stooop::*
set rcsId {$Id: switched.tcl,v 1.4 1998/03/30 08:26:05 jfontain Exp $}

package provide switched [lindex {$Revision: 1.4 $} 1]

class switched {

    proc switched {this args} {
        if {([llength $args]%2)!=0} {
            error "value for \"[lindex $args end]\" missing"
        }
        set switched::($this,complete) 0
        set switched::($this,arguments) $args
    }

    proc ~switched {this} {}

    virtual proc options {this}

    proc complete {this} {
        foreach description [options $this] {
            set option [lindex $description 0]
            set switched::($this,$option) [set default [lindex $description 1]]
            if {[llength $description]<3} {
                set initialize($option) {}
            } elseif {[string compare $default [lindex $description 2]]!=0} {
                set switched::($this,$option) [lindex $description 2]
                set initialize($option) {}
            }
        }
        foreach {option value} $switched::($this,arguments) {
            if {[catch {string compare $switched::($this,$option) $value} different]} {
                error "$switched::($this,_derived): unknown option \"$option\""
            }
            if {$different} {
                set switched::($this,$option) $value
                set initialize($option) {}
            }
        }
        unset switched::($this,arguments)
        foreach option [array names initialize] {
            $switched::($this,_derived)::set$option $this $switched::($this,$option)
        }
        set switched::($this,complete) 1
    }

    proc configure {this args} {
        if {[llength $args]==0} {
            return [descriptions $this]
        }
        foreach {option value} $args {
            if {![info exists switched::($this,$option)]} {
                error "$switched::($this,_derived): unknown option \"$option\""
            }
        }
        if {[llength $args]==1} {
            return [description $this [lindex $args 0]]
        }
        if {([llength $args]%2)!=0} {
            error "value for \"[lindex $args end]\" missing"
        }
        foreach {option value} $args {
            if {[string compare $switched::($this,$option) $value]!=0} {
                $switched::($this,_derived)::set$option $this [set switched::($this,$option) $value]
            }
        }
    }

    proc cget {this option} {
        if {[catch {set value $switched::($this,$option)}]} {
            error "$switched::($this,_derived): unknown option \"$option\""
        }
        return $value
    }

    proc description {this option} {
        foreach description [options $this] {
            if {[string compare [lindex $description 0] $option]==0} {
                if {[llength $description]<3} {
                    lappend description $switched::($this,$option)
                    return $description
                } else {
                    return [lreplace $description 2 2 $switched::($this,$option)]
                }
            }
        }
    }

    proc descriptions {this} {
        set descriptions {}
        foreach description [options $this] {
            if {[llength $description]<3} {
                lappend description $switched::($this,[lindex $description 0])
                lappend descriptions $description
            } else {
                lappend descriptions [lreplace $description 2 2 $switched::($this,[lindex $description 0])]
            }
        }
        return $descriptions
    }

}
set rcsId {$Id: scwoop.tcl,v 2.18 1998/09/19 19:40:16 jfontain Exp $}

package provide scwoop 2.3

class widget {}

switch $tcl_platform(platform) {
    macintosh {
        array set widget:: {default,ButtonAnchor center default,ButtonActiveBackgroundColor systemButtonText default,ButtonActiveBackgroundMono Black default,ButtonActiveForegroundColor systemButtonFace default,ChkradActiveForegroundColor DEF_BUTTON_ACTIVE_FG_COLOR default,ButtonActiveForegroundMono White default,ButtonBackgroundColor systemButtonFace default,ButtonBackgroundMono White default,ButtonBitmap {} default,ButtonBorderWidth 2 default,ButtonCursor {} default,ButtonCommand {} default,ButtonDefault disabled default,ButtonDisabledForegroundColor #a3a3a3 default,ButtonDisabledForegroundMono {} default,ButtonForeground systemButtonText default,ChkradForeground DEF_BUTTON_FG default,ButtonFont system default,ButtonHeight 0 default,ButtonHighlightBackground systemWindowBody default,ButtonHighlight systemButtonFrame default,LabelHighlightWidth 0 default,ButtonHighlightWidth 4 default,ButtonImage {} default,ButtonIndicator 1 default,ButtonJustify center default,ButtonOffValue 0 default,ButtonOnValue 1 default,ButtonPadX 7 default,LabelCheckRadiusPadX 1 default,ButtonPadY 3 default,LabelCheckRadiusPadY 1 default,ButtonRelief flat default,LabelCheckRadiusRelief flat default,ButtonSelectColor #b03060 default,ButtonSelectMono Black default,ButtonSelectImage {} default,ButtonState normal default,LabelTakeFocus 0 default,ButtonTakeFocus {} default,ButtonText {} default,ButtonTextVariable {} default,ButtonUnderline -1 default,ButtonValue {} default,ButtonWidth 0 default,ButtonWrapLength 0 default,RadiobuttonVariable selectedButton default,CheckbuttonVariable {} default,CanvasBackgroundColor systemWindowBody default,CanvasBackgroundMono White default,CanvasBorderWidth 0 default,CanvasCloseEnough 1 default,CanvasConfine 1 default,CanvasCursor {} default,CanvasHeight 7c default,CanvasHighlightBackground systemWindowBody default,CanvasHighlight Black default,CanvasHighlightWidth 3 default,CanvasInsertBackground Black default,CanvasInsertBorderColor 0 default,CanvasInsertBorderMono 0 default,CanvasInsertOffTime 300 default,CanvasInsertOnTime 600 default,CanvasInsertWidth 2 default,CanvasRelief flat default,CanvasScrollRegion {} default,CanvasSelectColor systemHighlight default,CanvasSelectMono Black default,CanvasSelectBorderColor 1 default,CanvasSelectBorderMono 0 default,CanvasSelectForegroundColor Black default,CanvasSelectForegroundMono White default,CanvasTakeFocus {} default,CanvasWidth 10c default,CanvasXScrollCommand {} default,CanvasXScrollIncrement 0 default,CanvasYScrollCommand {} default,CanvasYScrollIncrement 0 default,EntryBackgroundColor systemWindowBody default,EntryBackgroundMono White default,EntryBorderWidth 1 default,EntryCursor xterm default,EntryExportSelection 1 default,EntryFont "Helvetica 12" default,EntryForeground Black default,EntryHighlightBackground systemWindowBody default,EntryHighlight Black default,EntryHighlightWidth 0 default,EntryInsertBackground Black default,EntryInsertBorderColor 0 default,EntryInsertBorderMono 0 default,EntryInsertOffTime 300 default,EntryInsertOnTime 600 default,EntryInsertWidth 1 default,EntryJustify left default,EntryRelief solid default,EntryScrollCommand {} default,EntrySelectColor systemHighlight default,EntrySelectMono Black default,EntrySelectBorderColor 1 default,EntrySelectBorderMono 0 default,EntrySelectForegroundColor systemHighlightText default,EntrySelectForegroundMono White default,EntryShow {} default,EntryState normal default,EntryTakeFocus {} default,EntryTextVariable {} default,EntryWidth 20 default,FrameBackgroundColor systemWindowBody default,FrameBackgroundMono White default,FrameBorderWidth 0 default,FrameClass Frame default,FrameColormap {} default,FrameContainer 0 default,FrameCursor {} default,FrameHeight 0 default,FrameHighlightBackground systemWindowBody default,FrameHighlight Black default,FrameHighlightWidth 0 default,FrameRelief flat default,FrameTakeFocus 0 default,FrameUse {} default,FrameVisual {} default,FrameWidth 0 default,ListboxBackgroundColor systemWindowBody default,ListboxBackgroundMono White default,ListboxBorderWidth 1 default,ListboxCursor {} default,ListboxExportSelection 1 default,ListboxFont application default,ListboxForeground Black default,ListboxHeight 10 default,ListboxHighlightBackground systemWindowBody default,ListboxHighlight Black default,ListboxHighlightWidth 0 default,ListboxRelief solid default,ListboxScrollCommand {} default,ListboxSelectColor systemHighlight default,ListboxSelectMono Black default,ListboxSelectBorder 0 default,ListboxSelectForegroundColor systemHighlightText default,ListboxSelectForegroundMono White default,ListboxSelectMode browse default,ListboxSetGrid 0 default,ListboxTakeFocus {} default,ListboxWidth 20 default,MenuEntryActiveBackground {} default,MenuEntryActiveForeground {} default,MenuEntryAccelerator {} default,MenuEntryBackground {} default,MenuEntryBitmap None default,MenuEntryColumnBreak 0 default,MenuEntryCommand {} default,MenuEntryForeground {} default,MenuEntryFont {} default,MenuEntryHideMargin 0 default,MenuEntryImage {} default,MenuEntryIndicator 1 default,MenuEntryLabel {} default,MenuEntryMenu {} default,MenuEntryOffValue 0 default,MenuEntryOnValue 1 default,MenuEntrySelectImage {} default,MenuEntryState normal default,MenuEntryValue {} default,MenuEntryCheckVariable {} default,MenuEntryRadioVariable selectedButton default,MenuEntrySelect {} default,MenuEntryUnderline -1 default,MenuActiveBackgroundColor SystemMenuActive default,MenuActiveBackgroundMono Black default,MenuActiveBorderWidth 0 default,MenuActiveForegroundColor SystemMenuActiveText default,MenuActiveForegroundMono White default,MenuBackgroundColor SystemMenu default,MenuBackgroundMono White default,MenuBorderWidth 0 default,MenuCursor arrow default,MenuDisabledForegroundColor SystemMenuDisabled default,MenuDisabledForegroundMono {} default,MenuFont system default,MenuForeground SystemMenuText default,MenuPostCommand {} default,MenuRelief flat default,MenuSelectColor SystemMenuActive default,MenuSelectMono Black default,MenuTakeFocus 0 default,MenuTearoff 1 default,MenuTearoffCommand {} default,MenuTitle {} default,MenuType normal default,MenubuttonAnchor center default,MenubuttonActiveBackgroundColor #ececec default,MenubuttonActiveBackgroundMono Black default,MenubuttonActiveForegroundColor Black default,MenubuttonActiveForegroundMono White default,MenubuttonBackgroundColor systemWindowBody default,MenubuttonBackgroundMono White default,MenubuttonBitmap {} default,MenubuttonBorderWidth 2 default,MenubuttonCursor {} default,MenubuttonDirection below default,MenubuttonDisabledForegroundColor #a3a3a3 default,MenubuttonDisabledForegroundMono {} default,MenubuttonFont system default,MenubuttonForeground Black default,MenubuttonHeight 0 default,MenubuttonHighlightBackground systemWindowBody default,MenubuttonHighlight Black default,MenubuttonHighlightWidth 0 default,MenubuttonImage {} default,MenubuttonIndicator 0 default,MenubuttonJustify left default,MenubuttonMenu {} default,MenubuttonPadX 4p default,MenubuttonPadY 3p default,MenubuttonRelief flat default,MenubuttonState normal default,MenubuttonTakeFocus 0 default,MenubuttonText {} default,MenubuttonTextVariable {} default,MenubuttonUnderline -1 default,MenubuttonWidth 0 default,MenubuttonWrapLength 0 default,MessageAnchor center default,MessageAspect 150 default,MessageBackgroundColor systemWindowBody default,MessageBackgroundMono White default,MessageBorderWidth 2 default,MessageCursor {} default,MessageForeground Black default,MessageFont system default,MessageHighlightBackground systemWindowBody default,MessageHighlight Black default,MessageHighlightWidth 0 default,MessageJustify left default,MessagePadX -1 default,MessagePadY -1 default,MessageRelief flat default,MessageTakeFocus 0 default,MessageText {} default,MessageTextVariable {} default,MessageWidth 0 default,ScaleActiveBackgroundColor #ececec default,ScaleActiveBackgroundMono Black default,ScaleBackgroundColor systemWindowBody default,ScaleBackgroundMono White default,ScaleBigIncrement 0 default,ScaleBorderWidth 2 default,ScaleCommand {} default,ScaleCursor {} default,ScaleDigits 0 default,ScaleFont system default,ScaleForegroundColor Black default,ScaleForegroundMono Black default,ScaleFrom 0 default,ScaleHighlightBackground systemWindowBody default,ScaleHighlight Black default,ScaleHighlightWidth 0 default,ScaleLabel {} default,ScaleLength 100 default,ScaleOrient vertical default,ScaleRelief flat default,ScaleRepeatDelay 300 default,ScaleRepeatInterval 100 default,ScaleResolution 1 default,ScaleTroughColor #c3c3c3 default,ScaleTroughMono White default,ScaleShowValue 1 default,ScaleSliderLength 30 default,ScaleSliderRelief raised default,ScaleState normal default,ScaleTakeFocus {} default,ScaleTickInterval 0 default,ScaleTo 100 default,ScaleVariable {} default,ScaleWidth 15 default,ScrollbarActiveBackgroundColor #ececec default,ScrollbarActiveBackgroundMono Black default,ScrollbarActiveRelief raised default,ScrollbarBackgroundColor systemWindowBody default,ScrollbarBackgroundMono White default,ScrollbarBorderWidth 0 default,ScrollbarCommand {} default,ScrollbarCursor {} default,ScrollbarElementBorderWidth -1 default,ScrollbarHighlightBackground systemWindowBody default,ScrollbarHighlight Black default,ScrollbarHighlightWidth 0 default,ScrollbarJump 0 default,ScrollbarOrient vertical default,ScrollbarRelief flat default,ScrollbarRepeatDelay 300 default,ScrollbarRepeatInterval 100 default,ScrollbarTakeFocus {} default,ScrollbarTroughColor #c3c3c3 default,ScrollbarTroughMono White default,ScrollbarWidth 16 default,TextBackgroundColor systemWindowBody default,TextBackgroundMono White default,TextBorderWidth 0 default,TextCursor xterm default,TextForeground Black default,TextExportSelection 1 default,TextFont "Courier 12" default,TextHeight 24 default,TextHighlightBackground systemWindowBody default,TextHighlight Black default,TextHighlightWidth 3 default,TextInsertBackground Black default,TextInsertBorderColor 0 default,TextInsertBorderMono 0 default,TextInsertOffTime 300 default,TextInsertOnTime 600 default,TextInsertWidth 1 default,TextPadX 1 default,TextPadY 1 default,TextRelief flat default,TextSelectColor systemHighlight default,TextSelectMono Black default,TextSelectBorderColor 1 default,TextSelectBorderMono 0 default,TextSelectForegroundColor systemHighlightText default,TextSelectForegroundMono White default,TextSelectRelief solid default,TextSetGrid 0 default,TextSpacing1 0 default,TextSpacing2 0 default,TextSpacing3 0 default,TextState normal default,TextTabs {} default,TextTakeFocus {} default,TextWidth 80 default,TextWrap char default,TextXScrollCommand {} default,TextYScrollCommand {} default,ToplevelClass Toplevel default,ToplevelMenu {} default,ToplevelScreen {}}
    }
    unix {
        array set widget:: {default,ButtonAnchor center default,ButtonActiveBackgroundColor #ececec default,ButtonActiveBackgroundMono Black default,ButtonActiveForegroundColor Black default,ChkradActiveForegroundColor DEF_BUTTON_ACTIVE_FG_COLOR default,ButtonActiveForegroundMono White default,ButtonBackgroundColor #d9d9d9 default,ButtonBackgroundMono White default,ButtonBitmap {} default,ButtonBorderWidth 2 default,ButtonCursor {} default,ButtonCommand {} default,ButtonDefault disabled default,ButtonDisabledForegroundColor #a3a3a3 default,ButtonDisabledForegroundMono {} default,ButtonForeground Black default,ChkradForeground DEF_BUTTON_FG default,ButtonFont "Helvetica -12 bold" default,ButtonHeight 0 default,ButtonHighlightBackground #d9d9d9 default,ButtonHighlight Black default,LabelHighlightWidth 0 default,ButtonHighlightWidth 1 default,ButtonImage {} default,ButtonIndicator 1 default,ButtonJustify center default,ButtonOffValue 0 default,ButtonOnValue 1 default,ButtonPadX 3m default,LabelCheckRadiusPadX 1 default,ButtonPadY 1m default,LabelCheckRadiusPadY 1 default,ButtonRelief raised default,LabelCheckRadiusRelief flat default,ButtonSelectColor #b03060 default,ButtonSelectMono Black default,ButtonSelectImage {} default,ButtonState normal default,LabelTakeFocus 0 default,ButtonTakeFocus {} default,ButtonText {} default,ButtonTextVariable {} default,ButtonUnderline -1 default,ButtonValue {} default,ButtonWidth 0 default,ButtonWrapLength 0 default,RadiobuttonVariable selectedButton default,CheckbuttonVariable {} default,CanvasBackgroundColor #d9d9d9 default,CanvasBackgroundMono White default,CanvasBorderWidth 0 default,CanvasCloseEnough 1 default,CanvasConfine 1 default,CanvasCursor {} default,CanvasHeight 7c default,CanvasHighlightBackground #d9d9d9 default,CanvasHighlight Black default,CanvasHighlightWidth 1 default,CanvasInsertBackground Black default,CanvasInsertBorderColor 0 default,CanvasInsertBorderMono 0 default,CanvasInsertOffTime 300 default,CanvasInsertOnTime 600 default,CanvasInsertWidth 2 default,CanvasRelief flat default,CanvasScrollRegion {} default,CanvasSelectColor #c3c3c3 default,CanvasSelectMono Black default,CanvasSelectBorderColor 1 default,CanvasSelectBorderMono 0 default,CanvasSelectForegroundColor Black default,CanvasSelectForegroundMono White default,CanvasTakeFocus {} default,CanvasWidth 10c default,CanvasXScrollCommand {} default,CanvasXScrollIncrement 0 default,CanvasYScrollCommand {} default,CanvasYScrollIncrement 0 default,EntryBackgroundColor #d9d9d9 default,EntryBackgroundMono White default,EntryBorderWidth 2 default,EntryCursor xterm default,EntryExportSelection 1 default,EntryFont "Helvetica -12" default,EntryForeground Black default,EntryHighlightBackground #d9d9d9 default,EntryHighlight Black default,EntryHighlightWidth 1 default,EntryInsertBackground Black default,EntryInsertBorderColor 0 default,EntryInsertBorderMono 0 default,EntryInsertOffTime 300 default,EntryInsertOnTime 600 default,EntryInsertWidth 2 default,EntryJustify left default,EntryRelief sunken default,EntryScrollCommand {} default,EntrySelectColor #c3c3c3 default,EntrySelectMono Black default,EntrySelectBorderColor 1 default,EntrySelectBorderMono 0 default,EntrySelectForegroundColor Black default,EntrySelectForegroundMono White default,EntryShow {} default,EntryState normal default,EntryTakeFocus {} default,EntryTextVariable {} default,EntryWidth 20 default,FrameBackgroundColor #d9d9d9 default,FrameBackgroundMono White default,FrameBorderWidth 0 default,FrameClass Frame default,FrameColormap {} default,FrameContainer 0 default,FrameCursor {} default,FrameHeight 0 default,FrameHighlightBackground #d9d9d9 default,FrameHighlight Black default,FrameHighlightWidth 0 default,FrameRelief flat default,FrameTakeFocus 0 default,FrameUse {} default,FrameVisual {} default,FrameWidth 0 default,ListboxBackgroundColor #d9d9d9 default,ListboxBackgroundMono White default,ListboxBorderWidth 2 default,ListboxCursor {} default,ListboxExportSelection 1 default,ListboxFont "Helvetica -12 bold" default,ListboxForeground Black default,ListboxHeight 10 default,ListboxHighlightBackground #d9d9d9 default,ListboxHighlight Black default,ListboxHighlightWidth 1 default,ListboxRelief sunken default,ListboxScrollCommand {} default,ListboxSelectColor #c3c3c3 default,ListboxSelectMono Black default,ListboxSelectBorder 1 default,ListboxSelectForegroundColor Black default,ListboxSelectForegroundMono White default,ListboxSelectMode browse default,ListboxSetGrid 0 default,ListboxTakeFocus {} default,ListboxWidth 20 default,MenuEntryActiveBackground {} default,MenuEntryActiveForeground {} default,MenuEntryAccelerator {} default,MenuEntryBackground {} default,MenuEntryBitmap None default,MenuEntryColumnBreak 0 default,MenuEntryCommand {} default,MenuEntryForeground {} default,MenuEntryFont {} default,MenuEntryHideMargin 0 default,MenuEntryImage {} default,MenuEntryIndicator 1 default,MenuEntryLabel {} default,MenuEntryMenu {} default,MenuEntryOffValue 0 default,MenuEntryOnValue 1 default,MenuEntrySelectImage {} default,MenuEntryState normal default,MenuEntryValue {} default,MenuEntryCheckVariable {} default,MenuEntryRadioVariable selectedButton default,MenuEntrySelect {} default,MenuEntryUnderline -1 default,MenuActiveBackgroundColor #ececec default,MenuActiveBackgroundMono Black default,MenuActiveBorderWidth 2 default,MenuActiveForegroundColor Black default,MenuActiveForegroundMono White default,MenuBackgroundColor #d9d9d9 default,MenuBackgroundMono White default,MenuBorderWidth 2 default,MenuCursor arrow default,MenuDisabledForegroundColor #a3a3a3 default,MenuDisabledForegroundMono {} default,MenuFont "Helvetica -12 bold" default,MenuForeground Black default,MenuPostCommand {} default,MenuRelief raised default,MenuSelectColor #b03060 default,MenuSelectMono Black default,MenuTakeFocus 0 default,MenuTearoff 1 default,MenuTearoffCommand {} default,MenuTitle {} default,MenuType normal default,MenubuttonAnchor center default,MenubuttonActiveBackgroundColor #ececec default,MenubuttonActiveBackgroundMono Black default,MenubuttonActiveForegroundColor Black default,MenubuttonActiveForegroundMono White default,MenubuttonBackgroundColor #d9d9d9 default,MenubuttonBackgroundMono White default,MenubuttonBitmap {} default,MenubuttonBorderWidth 2 default,MenubuttonCursor {} default,MenubuttonDirection below default,MenubuttonDisabledForegroundColor #a3a3a3 default,MenubuttonDisabledForegroundMono {} default,MenubuttonFont "Helvetica -12 bold" default,MenubuttonForeground Black default,MenubuttonHeight 0 default,MenubuttonHighlightBackground #d9d9d9 default,MenubuttonHighlight Black default,MenubuttonHighlightWidth 0 default,MenubuttonImage {} default,MenubuttonIndicator 0 default,MenubuttonJustify center default,MenubuttonMenu {} default,MenubuttonPadX 4p default,MenubuttonPadY 3p default,MenubuttonRelief flat default,MenubuttonState normal default,MenubuttonTakeFocus 0 default,MenubuttonText {} default,MenubuttonTextVariable {} default,MenubuttonUnderline -1 default,MenubuttonWidth 0 default,MenubuttonWrapLength 0 default,MessageAnchor center default,MessageAspect 150 default,MessageBackgroundColor #d9d9d9 default,MessageBackgroundMono White default,MessageBorderWidth 2 default,MessageCursor {} default,MessageForeground Black default,MessageFont "Helvetica -12 bold" default,MessageHighlightBackground #d9d9d9 default,MessageHighlight Black default,MessageHighlightWidth 0 default,MessageJustify left default,MessagePadX -1 default,MessagePadY -1 default,MessageRelief flat default,MessageTakeFocus 0 default,MessageText {} default,MessageTextVariable {} default,MessageWidth 0 default,ScaleActiveBackgroundColor #ececec default,ScaleActiveBackgroundMono Black default,ScaleBackgroundColor #d9d9d9 default,ScaleBackgroundMono White default,ScaleBigIncrement 0 default,ScaleBorderWidth 2 default,ScaleCommand {} default,ScaleCursor {} default,ScaleDigits 0 default,ScaleFont "Helvetica -12 bold" default,ScaleForegroundColor Black default,ScaleForegroundMono Black default,ScaleFrom 0 default,ScaleHighlightBackground #d9d9d9 default,ScaleHighlight Black default,ScaleHighlightWidth 1 default,ScaleLabel {} default,ScaleLength 100 default,ScaleOrient vertical default,ScaleRelief flat default,ScaleRepeatDelay 300 default,ScaleRepeatInterval 100 default,ScaleResolution 1 default,ScaleTroughColor #c3c3c3 default,ScaleTroughMono White default,ScaleShowValue 1 default,ScaleSliderLength 30 default,ScaleSliderRelief raised default,ScaleState normal default,ScaleTakeFocus {} default,ScaleTickInterval 0 default,ScaleTo 100 default,ScaleVariable {} default,ScaleWidth 15 default,ScrollbarActiveBackgroundColor #ececec default,ScrollbarActiveBackgroundMono Black default,ScrollbarActiveRelief raised default,ScrollbarBackgroundColor #d9d9d9 default,ScrollbarBackgroundMono White default,ScrollbarBorderWidth 2 default,ScrollbarCommand {} default,ScrollbarCursor {} default,ScrollbarElementBorderWidth -1 default,ScrollbarHighlightBackground #d9d9d9 default,ScrollbarHighlight Black default,ScrollbarHighlightWidth 1 default,ScrollbarJump 0 default,ScrollbarOrient vertical default,ScrollbarRelief sunken default,ScrollbarRepeatDelay 300 default,ScrollbarRepeatInterval 100 default,ScrollbarTakeFocus {} default,ScrollbarTroughColor #c3c3c3 default,ScrollbarTroughMono White default,ScrollbarWidth 15 default,TextBackgroundColor #d9d9d9 default,TextBackgroundMono White default,TextBorderWidth 2 default,TextCursor xterm default,TextForeground Black default,TextExportSelection 1 default,TextFont "Courier -12" default,TextHeight 24 default,TextHighlightBackground #d9d9d9 default,TextHighlight Black default,TextHighlightWidth 1 default,TextInsertBackground Black default,TextInsertBorderColor 0 default,TextInsertBorderMono 0 default,TextInsertOffTime 300 default,TextInsertOnTime 600 default,TextInsertWidth 2 default,TextPadX 1 default,TextPadY 1 default,TextRelief sunken default,TextSelectColor #c3c3c3 default,TextSelectMono Black default,TextSelectBorderColor 1 default,TextSelectBorderMono 0 default,TextSelectForegroundColor Black default,TextSelectForegroundMono White default,TextSelectRelief raised default,TextSetGrid 0 default,TextSpacing1 0 default,TextSpacing2 0 default,TextSpacing3 0 default,TextState normal default,TextTabs {} default,TextTakeFocus {} default,TextWidth 80 default,TextWrap char default,TextXScrollCommand {} default,TextYScrollCommand {} default,ToplevelClass Toplevel default,ToplevelMenu {} default,ToplevelScreen {}}
    }
    windows {
        array set widget:: {default,ButtonAnchor center default,ButtonActiveBackgroundColor SystemButtonFace default,ButtonActiveBackgroundMono Black default,ButtonActiveForegroundColor SystemButtonText default,ChkradActiveForegroundColor SystemWindowText default,ButtonActiveForegroundMono White default,ButtonBackgroundColor SystemButtonFace default,ButtonBackgroundMono White default,ButtonBitmap {} default,ButtonBorderWidth 2 default,ButtonCursor {} default,ButtonCommand {} default,ButtonDefault disabled default,ButtonDisabledForegroundColor SystemDisabledText default,ButtonDisabledForegroundMono {} default,ButtonForeground SystemButtonText default,ChkradForeground SystemWindowText default,ButtonFont "{MS Sans Serif} 8" default,ButtonHeight 0 default,ButtonHighlightBackground SystemButtonFace default,ButtonHighlight SystemWindowFrame default,LabelHighlightWidth 0 default,ButtonHighlightWidth 1 default,ButtonImage {} default,ButtonIndicator 1 default,ButtonJustify center default,ButtonOffValue 0 default,ButtonOnValue 1 default,ButtonPadX 1 default,LabelCheckRadiusPadX 1 default,ButtonPadY 1 default,LabelCheckRadiusPadY 1 default,ButtonRelief raised default,LabelCheckRadiusRelief flat default,ButtonSelectColor SystemWindow default,ButtonSelectMono Black default,ButtonSelectImage {} default,ButtonState normal default,LabelTakeFocus 0 default,ButtonTakeFocus {} default,ButtonText {} default,ButtonTextVariable {} default,ButtonUnderline -1 default,ButtonValue {} default,ButtonWidth 0 default,ButtonWrapLength 0 default,RadiobuttonVariable selectedButton default,CheckbuttonVariable {} default,CanvasBackgroundColor SystemButtonFace default,CanvasBackgroundMono White default,CanvasBorderWidth 0 default,CanvasCloseEnough 1 default,CanvasConfine 1 default,CanvasCursor {} default,CanvasHeight 7c default,CanvasHighlightBackground SystemButtonFace default,CanvasHighlight SystemWindowFrame default,CanvasHighlightWidth 2 default,CanvasInsertBackground SystemButtonText default,CanvasInsertBorderColor 0 default,CanvasInsertBorderMono 0 default,CanvasInsertOffTime 300 default,CanvasInsertOnTime 600 default,CanvasInsertWidth 2 default,CanvasRelief flat default,CanvasScrollRegion {} default,CanvasSelectColor SystemHighlight default,CanvasSelectMono Black default,CanvasSelectBorderColor 1 default,CanvasSelectBorderMono 0 default,CanvasSelectForegroundColor SystemHighlightText default,CanvasSelectForegroundMono White default,CanvasTakeFocus {} default,CanvasWidth 10c default,CanvasXScrollCommand {} default,CanvasXScrollIncrement 0 default,CanvasYScrollCommand {} default,CanvasYScrollIncrement 0 default,EntryBackgroundColor SystemWindow default,EntryBackgroundMono White default,EntryBorderWidth 2 default,EntryCursor xterm default,EntryExportSelection 1 default,EntryFont "{MS Sans Serif} 8" default,EntryForeground SystemWindowText default,EntryHighlightBackground SystemButtonFace default,EntryHighlight SystemWindowFrame default,EntryHighlightWidth 0 default,EntryInsertBackground SystemWindowText default,EntryInsertBorderColor 0 default,EntryInsertBorderMono 0 default,EntryInsertOffTime 300 default,EntryInsertOnTime 600 default,EntryInsertWidth 2 default,EntryJustify left default,EntryRelief sunken default,EntryScrollCommand {} default,EntrySelectColor SystemHighlight default,EntrySelectMono Black default,EntrySelectBorderColor 0 default,EntrySelectBorderMono 0 default,EntrySelectForegroundColor SystemHighlightText default,EntrySelectForegroundMono White default,EntryShow {} default,EntryState normal default,EntryTakeFocus {} default,EntryTextVariable {} default,EntryWidth 20 default,FrameBackgroundColor SystemButtonFace default,FrameBackgroundMono White default,FrameBorderWidth 0 default,FrameClass Frame default,FrameColormap {} default,FrameContainer 0 default,FrameCursor {} default,FrameHeight 0 default,FrameHighlightBackground SystemButtonFace default,FrameHighlight SystemWindowFrame default,FrameHighlightWidth 0 default,FrameRelief flat default,FrameTakeFocus 0 default,FrameUse {} default,FrameVisual {} default,FrameWidth 0 default,ListboxBackgroundColor SystemButtonFace default,ListboxBackgroundMono White default,ListboxBorderWidth 2 default,ListboxCursor {} default,ListboxExportSelection 1 default,ListboxFont "{MS Sans Serif} 8" default,ListboxForeground SystemButtonText default,ListboxHeight 10 default,ListboxHighlightBackground SystemButtonFace default,ListboxHighlight SystemWindowFrame default,ListboxHighlightWidth 1 default,ListboxRelief sunken default,ListboxScrollCommand {} default,ListboxSelectColor SystemHighlight default,ListboxSelectMono Black default,ListboxSelectBorder 1 default,ListboxSelectForegroundColor SystemHighlightText default,ListboxSelectForegroundMono White default,ListboxSelectMode browse default,ListboxSetGrid 0 default,ListboxTakeFocus {} default,ListboxWidth 20 default,MenuEntryActiveBackground {} default,MenuEntryActiveForeground {} default,MenuEntryAccelerator {} default,MenuEntryBackground {} default,MenuEntryBitmap None default,MenuEntryColumnBreak 0 default,MenuEntryCommand {} default,MenuEntryForeground {} default,MenuEntryFont {} default,MenuEntryHideMargin 0 default,MenuEntryImage {} default,MenuEntryIndicator 1 default,MenuEntryLabel {} default,MenuEntryMenu {} default,MenuEntryOffValue 0 default,MenuEntryOnValue 1 default,MenuEntrySelectImage {} default,MenuEntryState normal default,MenuEntryValue {} default,MenuEntryCheckVariable {} default,MenuEntryRadioVariable selectedButton default,MenuEntrySelect {} default,MenuEntryUnderline -1 default,MenuActiveBackgroundColor SystemHighlight default,MenuActiveBackgroundMono Black default,MenuActiveBorderWidth 0 default,MenuActiveForegroundColor SystemHighlightText default,MenuActiveForegroundMono White default,MenuBackgroundColor SystemMenu default,MenuBackgroundMono White default,MenuBorderWidth 0 default,MenuCursor arrow default,MenuDisabledForegroundColor SystemDisabledText default,MenuDisabledForegroundMono {} default,MenuFont "{MS Sans Serif} 8" default,MenuForeground SystemMenuText default,MenuPostCommand {} default,MenuRelief flat default,MenuSelectColor SystemMenuText default,MenuSelectMono Black default,MenuTakeFocus 0 default,MenuTearoff 1 default,MenuTearoffCommand {} default,MenuTitle {} default,MenuType normal default,MenubuttonAnchor center default,MenubuttonActiveBackgroundColor SystemButtonFace default,MenubuttonActiveBackgroundMono Black default,MenubuttonActiveForegroundColor SystemButtonText default,MenubuttonActiveForegroundMono White default,MenubuttonBackgroundColor SystemButtonFace default,MenubuttonBackgroundMono White default,MenubuttonBitmap {} default,MenubuttonBorderWidth 2 default,MenubuttonCursor {} default,MenubuttonDirection below default,MenubuttonDisabledForegroundColor SystemDisabledText default,MenubuttonDisabledForegroundMono {} default,MenubuttonFont "{MS Sans Serif} 8" default,MenubuttonForeground SystemButtonText default,MenubuttonHeight 0 default,MenubuttonHighlightBackground SystemButtonFace default,MenubuttonHighlight SystemWindowFrame default,MenubuttonHighlightWidth 0 default,MenubuttonImage {} default,MenubuttonIndicator 0 default,MenubuttonJustify center default,MenubuttonMenu {} default,MenubuttonPadX 4p default,MenubuttonPadY 3p default,MenubuttonRelief flat default,MenubuttonState normal default,MenubuttonTakeFocus 0 default,MenubuttonText {} default,MenubuttonTextVariable {} default,MenubuttonUnderline -1 default,MenubuttonWidth 0 default,MenubuttonWrapLength 0 default,MessageAnchor center default,MessageAspect 150 default,MessageBackgroundColor SystemButtonFace default,MessageBackgroundMono White default,MessageBorderWidth 2 default,MessageCursor {} default,MessageForeground SystemButtonText default,MessageFont "{MS Sans Serif} 8" default,MessageHighlightBackground SystemButtonFace default,MessageHighlight SystemWindowFrame default,MessageHighlightWidth 0 default,MessageJustify left default,MessagePadX -1 default,MessagePadY -1 default,MessageRelief flat default,MessageTakeFocus 0 default,MessageText {} default,MessageTextVariable {} default,MessageWidth 0 default,ScaleActiveBackgroundColor SystemButtonFace default,ScaleActiveBackgroundMono Black default,ScaleBackgroundColor SystemButtonFace default,ScaleBackgroundMono White default,ScaleBigIncrement 0 default,ScaleBorderWidth 2 default,ScaleCommand {} default,ScaleCursor {} default,ScaleDigits 0 default,ScaleFont "{MS Sans Serif} 8" default,ScaleForegroundColor SystemButtonText default,ScaleForegroundMono Black default,ScaleFrom 0 default,ScaleHighlightBackground SystemButtonFace default,ScaleHighlight SystemWindowFrame default,ScaleHighlightWidth 2 default,ScaleLabel {} default,ScaleLength 100 default,ScaleOrient vertical default,ScaleRelief flat default,ScaleRepeatDelay 300 default,ScaleRepeatInterval 100 default,ScaleResolution 1 default,ScaleTroughColor SystemScrollbar default,ScaleTroughMono White default,ScaleShowValue 1 default,ScaleSliderLength 30 default,ScaleSliderRelief raised default,ScaleState normal default,ScaleTakeFocus {} default,ScaleTickInterval 0 default,ScaleTo 100 default,ScaleVariable {} default,ScaleWidth 15 default,ScrollbarActiveBackgroundColor SystemButtonFace default,ScrollbarActiveBackgroundMono Black default,ScrollbarActiveRelief raised default,ScrollbarBackgroundColor SystemButtonFace default,ScrollbarBackgroundMono White default,ScrollbarBorderWidth 0 default,ScrollbarCommand {} default,ScrollbarCursor {} default,ScrollbarElementBorderWidth -1 default,ScrollbarHighlightBackground SystemButtonFace default,ScrollbarHighlight SystemWindowFrame default,ScrollbarHighlightWidth 0 default,ScrollbarJump 0 default,ScrollbarOrient vertical default,ScrollbarRelief sunken default,ScrollbarRepeatDelay 300 default,ScrollbarRepeatInterval 100 default,ScrollbarTakeFocus {} default,ScrollbarTroughColor SystemScrollbar default,ScrollbarTroughMono White default,ScrollbarWidth 10 default,TextBackgroundColor SystemWindow default,TextBackgroundMono White default,TextBorderWidth 2 default,TextCursor xterm default,TextForeground SystemWindowText default,TextExportSelection 1 default,TextFont "{MS Sans Serif} 8" default,TextHeight 24 default,TextHighlightBackground SystemButtonFace default,TextHighlight SystemWindowFrame default,TextHighlightWidth 0 default,TextInsertBackground SystemWindowText default,TextInsertBorderColor 0 default,TextInsertBorderMono 0 default,TextInsertOffTime 300 default,TextInsertOnTime 600 default,TextInsertWidth 2 default,TextPadX 1 default,TextPadY 1 default,TextRelief sunken default,TextSelectColor SystemHighlight default,TextSelectMono Black default,TextSelectBorderColor 0 default,TextSelectBorderMono 0 default,TextSelectForegroundColor SystemHighlightText default,TextSelectForegroundMono White default,TextSelectRelief flat default,TextSetGrid 0 default,TextSpacing1 0 default,TextSpacing2 0 default,TextSpacing3 0 default,TextState normal default,TextTabs {} default,TextTakeFocus {} default,TextWidth 80 default,TextWrap char default,TextXScrollCommand {} default,TextYScrollCommand {} default,ToplevelClass Toplevel default,ToplevelMenu {} default,ToplevelScreen {}}
    }
}

class widget {
    proc widget {this path} {
        set widget::($this,path) $path
    }

    proc ~widget {this} {}

    virtual proc configure {this args} {
        return [eval $widget::($this,path) configure $args]
    }

    virtual proc cget {this args} {
        return [$widget::($this,path) cget $args]
    }
}


foreach class {button canvas entry frame label listbox menu menubutton message radiobutton scale scrollbar text toplevel} {
    class $class {
        proc $class {this parentPath args} widget "\[eval ::$class \$parentPath.\$this \$args\]" {}
        proc ~$class {this} {
            destroy $widget::($this,path)
        }
    }
}

class table {
    proc table {this parentPath args} widget {[eval ::table $parentPath.$this $args]} {}
    proc ~table {this} {
        destroy $widget::($this,path)
    }
}

foreach class {barchart graph hierbox htext stripchart tabset} {
    class $class {
        proc $class {this parentPath args} widget "\[eval ::blt::$class .\[string trimleft \$parentPath.\$this .\] \$args\]" {}
        proc ~$class {this} {
            destroy $widget::($this,path)
        }
    }
}

class composite {}

proc composite::composite {this base args} widget {$widget::($base,path)} {
    if {([llength $args]%2)!=0} {
        error "value for \"[lindex $args end]\" missing"
    }
    set composite::($this,base) $base
    set composite::($this,base,path) $widget::($base,path)
    set composite::($this,_children) {}
    set composite::($this,complete) 0
    set composite::($this,initialArguments) $args
}

proc composite::~composite {this} {
    eval delete [lsort -integer -decreasing $composite::($this,_children)] $composite::($this,base)
}

virtual proc composite::options {this}

proc composite::configure {this args} {
    if {[llength $args]==0} {
        return [descriptions $this]
    }
    if {![string match -* $args]} {
        return [eval widget::configure $composite::($this,[lindex $args 0]) [lrange $args 1 end]]
    }
    foreach {option value} $args {
        if {![info exists composite::($this,$option)]} {
            error "$composite::($this,_derived): unknown option \"$option\""
        }
    }
    if {[llength $args]==1} {
        return [description $this [lindex $args 0]]
    }
    if {([llength $args]%2)!=0} {
        error "value for \"[lindex $args end]\" missing"
    }
    foreach {option value} $args {
        if {[string compare $composite::($this,$option) $value]!=0} {
            $composite::($this,_derived)::set$option $this [set composite::($this,$option) $value]
        }
    }
}

proc composite::manage {this args} {
    foreach {child name} $args {
        if {[string length $name]==0} {
            error "widget $child has no name"
        }
        if {[string match -* $name]} {
            error "widget $child name \"$name\" must not start with a dash character"
        }
        if {[info exists composite::($this,$name)]} {
            error "\"$name\" member name already exists in composite layer"
        }
        set composite::($this,$name) $child
        set composite::($this,$name,path) $widget::($child,path)
        lappend composite::($this,_children) $child
    }
}

proc composite::complete {this} {
    set path $widget::($this,path)
    foreach description [options $this] {
        set option [lindex $description 0]
        set composite::($this,$option) [set default [lindex $description 3]]
        if {[llength $description]<5} {
            set initialize($option) {}
        } elseif {[string compare $default [lindex $description 4]]!=0} {
            set composite::($this,$option) [lindex $description 4]
            set initialize($option) {}
        }
        set value [option get $path [lindex $description 1] [lindex $description 2]]
        if {([string length $value]>0)&&([string compare $value $default]!=0)} {
            set composite::($this,$option) $value
            set initialize($option) {}
        }
    }
    foreach {option value} $composite::($this,initialArguments) {
        if {[catch {string compare $composite::($this,$option) $value} different]} {
            error "$composite::($this,_derived): unknown option \"$option\""
        }
        if {$different} {
            set composite::($this,$option) $value
            set initialize($option) {}
        }
    }
    unset composite::($this,initialArguments)
    foreach option [array names initialize] {
        $composite::($this,_derived)::set$option $this $composite::($this,$option)
    }
    set composite::($this,complete) 1
}

proc composite::cget {this args} {
    switch [llength $args] {
        0 {
            error "wrong # args: should be \"cget $this ?child? ?child? ... option\""
        }
        1 {
            if {![string match -* $args]||![info exists composite::($this,$args)]} {
                error "$composite::($this,_derived): unknown option \"$args\""
            }
            return $composite::($this,$args)
        }
        default {
            return [eval widget::cget $composite::($this,[lindex $args 0]) [lrange $args 1 end]]
        }
    }
}

proc composite::try {this args} {
    if {([llength $args]%2)!=0} {
        error "value for \"[lindex $args end]\" missing"
    }
    foreach {option value} $args {
        catch {widget::configure $composite::($this,base) $option $value}
        foreach child $composite::($this,_children) {
            catch {widget::configure $child $option $value}
        }
    }
}

proc composite::description {this option} {
    foreach description [options $this] {
        if {[string compare [lindex $description 0] $option]==0} {
            if {[llength $description]<5} {
                lappend description $composite::($this,$option)
                return $description
            } else {
                return [lreplace $description 4 4 $composite::($this,$option)]
            }
        }
    }
}

proc composite::descriptions {this} {
    set descriptions {}
    foreach description [options $this] {
        if {[llength $description]<5} {
            lappend description $composite::($this,[lindex $description 0])
            lappend descriptions $description
        } else {
            lappend descriptions [lreplace $description 4 4 $composite::($this,[lindex $description 0])]
        }
    }
    return $descriptions
}

proc composite::managingOrder {this name1 name2} {
    return [expr {$composite::($this,$name1)-$composite::($this,$name2)}]
}

proc composite::componentNames {this} {
    set names {}
    foreach index [array names composite:: $this,*,path] {
        if {[regexp {,(.+),path} $index dummy name]} {
            lappend names $name
        }
    }
    return [lsort -command "managingOrder $this" $names]
}
set rcsId {$Id: scwoutil.tcl,v 1.1 1998/09/15 21:17:14 jfontain Exp $}

if {[string compare $::tcl_platform(platform) windows]==0} {
    proc showTopLevel {path geometry} {
        wm deiconify $path
        wm geometry $path $geometry
    }
} else {
    proc showTopLevel {path geometry} {
        wm geometry $path $geometry
        wm deiconify $path
    }
}
set rcsId {$Id: safeemul.tcl,v 1.11 1996/12/22 13:10:50 jfontain Exp $}

global embed_args
if {[info exists embed_args]} {


proc checkTopLevelDirectDescendant {path} {
    if {([string compare $path .]!=0)&&([string compare [winfo parent $path] [winfo toplevel $path]]!=0)} {
        error "window \"$path\" must be a direct descendant of toplevel \"[winfo toplevel $path]\""
    }
    return $path
}

proc toplevel {args} {
    return [checkTopLevelDirectDescendant [eval frame $args]]
}

proc wm {args} {
    set path [checkTopLevelDirectDescendant [lindex $args 1]]
    switch [lindex $args 0] {
        deiconify {
            if {[llength [place info $path]]==0} {
                place $path -width {} -height {}
            }
        }
        geometry {
            set geometry [string trimleft [lindex $args 2] =]
            if {[scan $geometry %dx%d width height]==2} {
                place $path -width $width -height $height
                regsub {^[0-9]+x[0-9]+} $geometry {} geometry
            }
            if {[scan $geometry %d%d x y]==2} {
                incr x -[winfo rootx [winfo parent $path]]
                incr y -[winfo rooty [winfo parent $path]]
                place $path -bordermode ignore -x $x -y $y
            }
        }
        withdraw {
            place forget $path
        }
    }
}

set grabWindow {}
set grabEvents {
    <ButtonPress> <ButtonPress-1> <ButtonPress-2> <ButtonPress-3> <ButtonRelease> <ButtonRelease-1> <ButtonRelease-2>
    <ButtonRelease-3> <KeyPress> <KeyRelease>
}

proc grab {args} {
    global grabWindow grabEvents

    switch -- [lindex $args 0] {
        current - status {}
        release {
            if {[string compare [lindex $args end] $grabWindow]==0} {
                foreach event $grabEvents {
                    bind all $event {}
                }
                set grabWindow {}
            }
        }
        default {
            set grabWindow [lindex $args end]
            foreach event $grabEvents {
                set sequence [bind $grabWindow $event]
                if {[string length $sequence]>0} {
                    bind all $event "if {\[string compare %W $grabWindow\]!=0} {eval $sequence}"
                }
            }
        }
    }
}

}
set rcsId {$Id: bindings.tcl,v 1.4 1997/12/30 15:02:13 jfontain Exp $}


class bindings {
    proc bindings {this widget index} {
        ::set bindings::($this,widget) $widget
        bindtags $widget [linsert [bindtags $widget] $index bindings($this)]
    }
    proc ~bindings {this} {
        ::set tags [bindtags $bindings::($this,widget)]
        ::set index [lsearch -exact $tags bindings($this)]
        bindtags $bindings::($this,widget) [lreplace $tags $index $index]
        foreach tag [bind bindings($this)] {
            bind bindings($this) $tag {}
        }
    }
    proc set {this tag sequence} {
        bind bindings($this) $tag $sequence
    }
}
set rcsId {$Id: widgetip.tcl,v 1.32 1998/09/19 19:38:46 jfontain Exp $}

class widgetTip {

    class topLabel {

        proc topLabel {this parentPath args} composite {
            [new toplevel $parentPath -highlightbackground black -highlightthickness 1] $args
        } {
            composite::manage $this [new label $widget::($this,path)] label
            composite::complete $this
            pack $composite::($this,label,path)
            wm overrideredirect $widget::($this,path) 1
        }

        proc ~topLabel {this} {}

        proc options {this} {
            return [list\
                [list -bordercolor borderColor BorderColor Black Black]\
                [list -borderwidth borderWidth BorderWidth 1 1]\
                [list\
                    -background background Background\
                    $widget::(default,ButtonBackgroundColor) $widget::(default,ButtonBackgroundColor)\
                ]\
                [list -font font Font $widget::(default,ButtonFont) $widget::(default,ButtonFont)]\
                [list -foreground foreground Foreground $widget::(default,ButtonForeground) $widget::(default,ButtonForeground)]\
                [list -text text Text {} {}]\
            ]
        }

        foreach option {-background -font -foreground -text} {
            proc set$option {this value} "\$composite::(\$this,label,path) configure $option \$value"
        }

        proc set-bordercolor {this value} {
            $widget::($this,path) configure -highlightbackground $value
        }

        proc set-borderwidth {this value} {
            $widget::($this,path) configure -highlightthickness $value
        }
    }

    if {![info exists widgetTip::(label)]} {
        set widgetTip::(label) [new topLabel . -font $widget::(default,EntryFont) -background #FFFFBF]
        set widgetTip::(path) $widget::($widgetTip::(label),path)
        wm withdraw $widgetTip::(path)
        bind all <ButtonPress> {widgetTip::globalEvent %W}
        bind all <KeyPress> {widgetTip::globalEvent %W}
        set widgetTip::(xLast) -1
        set widgetTip::(yLast) -1
    }

    proc widgetTip {this args} switched {$args} {
        switched::complete $this
    }

    proc ~widgetTip {this} {
        disable $this
        catch {delete $widgetTip::($this,bindings)}
    }

    proc options {this} {
        return [list\
            [list -font $widget::(default,EntryFont) $widget::(default,EntryFont)]\
            [list -path {} {}]\
            [list -text {} {}]\
        ]
    }

    proc set-path {this value} {
        if {$switched::($this,complete)} {
            error {option -path cannot be set dynamically}
        }
        if {![winfo exists $value]} {
            error "invalid widget: \"$value\""
        }
        set bindings [new bindings $value 0]
        bindings::set $bindings <Enter> "widgetTip::enable $this"
        bindings::set $bindings <Leave> "widgetTip::disable $this"
        bindings::set $bindings <Destroy> "delete $this"
        set widgetTip::($this,bindings) $bindings
    }

    proc set-font {this value} {}
    proc set-text {this value} {}

    proc globalEvent {widget} {
        if {![catch {string first $switched::($widgetTip::(active),-path) $widget} value]&&($value==0)} {
            disable $widgetTip::(active)
        }
    }

    proc show {this x y} {
        set path $widgetTip::(path)
        widget::configure $widgetTip::(label) -font $switched::($this,-font) -text $switched::($this,-text)
        showTopLevel $path +$x+$y
        update idletasks
        raise $path
    }

    proc enable {this} {
        set x [winfo pointerx $widgetTip::(path)]
        set y [winfo pointery $widgetTip::(path)]
        if {($x==$widgetTip::(xLast))&&($y==$widgetTip::(yLast))} {
            widgetTip::show $this [expr {$x+7}] [expr {$y+10}]
        } else {
            set widgetTip::(xLast) $x
            set widgetTip::(yLast) $y
            set widgetTip::(event) [after 300 "widgetTip::enable $this"]
        }
        set widgetTip::(active) $this
    }

    proc disable {this} {
        catch {after cancel $widgetTip::(event)}
        catch {unset widgetTip::(active)}
        wm withdraw $widgetTip::(path)
    }

}
set rcsId {$Id: scroll.tcl,v 1.7 1998/09/27 20:41:25 jfontain Exp $}


class scroll {

    proc scroll {this scrollableClass parentPath args} composite {[new frame $parentPath] $args} {
        set path $widget::($this,path)
        composite::manage $this [new $scrollableClass $path] scrolled\
            [new scrollbar $path -orient horizontal] horizontal [new scrollbar $path] vertical [new frame $path] filler

        widget::configure $composite::($this,scrolled)\
            -xscrollcommand "scroll::update $this 1 0" -yscrollcommand "scroll::update $this 0 1"
        widget::configure $composite::($this,horizontal) -command "$composite::($this,scrolled,path) xview"
        widget::configure $composite::($this,vertical) -command "$composite::($this,scrolled,path) yview"

        grid propagate $widget::($this,path) 0

        grid $composite::($this,scrolled,path) -sticky nsew
        grid rowconfigure $path 0 -weight 1
        grid columnconfigure $path 0 -weight 1

        set scroll::($this,0,1,path) $composite::($this,vertical,path)
        set scroll::($this,1,0,path) $composite::($this,horizontal,path)

        composite::complete $this
    }

    proc ~scroll {this} {}

    proc options {this} {
        return [list\
            [list -automatic automatic Automatic 1 1]\
            [list -height height Height $widget::(default,CanvasHeight)]\
            [list -horizontal horizontal Horizontal 1 1]\
            [list -vertical vertical Vertical 1 1]\
            [list -width width Width $widget::(default,CanvasWidth)]\
        ]
    }

    foreach option {-automatic -horizontal -vertical} {
        proc set$option {this value} "
            if {\$composite::(\$this,complete)} {
                error {option $option cannot be set dynamically}
            }
        "
    }

    proc set-height {this value} {
        $widget::($this,path) configure -height $value
    }

    proc set-width {this value} {
        $widget::($this,path) configure -width $value
    }

    proc update {this row column first last} {
        set path $scroll::($this,$row,$column,path)
        foreach {previousFirst previousLast} [$path get] {}
        if {($first!=$previousFirst)||($last!=$previousLast)} {
            $path set $first $last
        }
        set visible [llength [grid info $path]]
        if {!$composite::($this,-automatic)||(($last-$first)<1)} {
            if {!$visible} {
                if {$composite::($this,-vertical)} {
                    grid $composite::($this,vertical,path) -row 0 -column 1 -sticky nsew
                }
                if {$composite::($this,-horizontal)} {
                    grid $composite::($this,horizontal,path) -row 1 -column 0 -sticky nsew
                }
                grid $composite::($this,filler,path) -sticky nsew -column 1 -row 1
            }
        } else {
            foreach {first last} [$scroll::($this,$column,$row,path) get] {}
            if {$visible&&(($last-$first)>=1)} {
                grid remove $scroll::($this,0,1,path)
                grid remove $scroll::($this,1,0,path)
                grid remove $composite::($this,filler,path)
            }
        }
    }

}
set rcsId {$Id: scroller.tcl,v 1.20 1998/09/27 20:43:02 jfontain Exp $}

class scroller {

    proc scroller {this parentPath args} composite {[new scroll canvas $parentPath] $args} {
        set scroller::($this,canvasPath) $composite::($composite::($this,base),scrolled,path)
        composite::complete $this
    }

    proc ~scroller {this} {}

    proc options {this} {
        return [list\
            [list -height height Height 0 0]\
            [list -width width Width 0 0]\
            [list\
                -xscrollincrement xScrollIncrement ScrollIncrement\
                $widget::(default,CanvasXScrollIncrement) $widget::(default,CanvasXScrollIncrement)\
            ]\
            [list\
                -yscrollincrement yScrollIncrement ScrollIncrement\
                $widget::(default,CanvasYScrollIncrement) $widget::(default,CanvasYScrollIncrement)\
            ]\
        ]
    }

    proc display {this path} {
        if {[string length $path]==0} {
            $scroller::($this,canvasPath) delete all
            bind $scroller::($this,displayed) <Configure> {}
            catch {unset scroller::($this,displayed)}
            return
        }
        if {[info exists scroller::($this,displayed)]} {
            error "scroller \"$this\" already displays widget \"$scroller::($this,displayed)\""
        }
        if {[string compare $widget::($this,path) [winfo parent $path]]!=0} {
            error "displayed widget \"$path\" must be a child of scroller \"$this\" path"
        }
        set scroller::($this,displayed) $path
        set canvas $scroller::($this,canvasPath)
        raise $path $canvas
        $canvas create window 0 0 -window $path -anchor nw
        bind $path <Configure> "$canvas configure -width %w -height %h -scrollregion {0 0 %w %h}"
    }

    proc set-width {this value} {
        composite::configure $composite::($this,base) -width $value
    }

    proc set-height {this value} {
        composite::configure $composite::($this,base) -height $value
    }

    proc set-xscrollincrement {this value} {
        $scroller::($this,canvasPath) configure -xscrollincrement $value
    }

    proc set-yscrollincrement {this value} {
        $scroller::($this,canvasPath) configure -yscrollincrement $value
    }

}
set rcsId {$Id: confint.tcl,v 1.29 1998/09/27 20:45:52 jfontain Exp $}


class configurationInterface {}

proc configurationInterface::configurationInterface {this parentPath args} composite {[new frame $parentPath] $args} {
    composite::manage $this\
        [new frame $parentPath] top [new frame $parentPath -background black -height 1] separator [new frame $parentPath] bottom
    pack $composite::($this,top,path) -fill both -expand 1
    pack $composite::($this,separator,path) -fill x
    pack $composite::($this,bottom,path) -fill both
    new widgetTip -path $composite::($this,bottom,path) -text {enter component options}
    composite::manage $this\
        [new listbox $composite::($this,top,path) -font {Helvetica -11 bold} -height 0 -selectmode single] names\
        [new frame $composite::($this,top,path) -background white -highlightbackground black -highlightthickness 1] container
    new widgetTip -path $composite::($this,names,path) -text {select component(class)}
    pack $composite::($this,names,path) -side left -anchor nw
    pack $composite::($this,container,path) -padx 2 -pady 2 -fill both -expand 1
    composite::manage $this [new scroller $composite::($this,bottom,path) -height 100] scroller
    pack $composite::($this,scroller,path) -fill both

    composite::complete $this
}

proc configurationInterface::~configurationInterface {this} {}

proc configurationInterface::options {this} {}

proc configurationInterface::manage {this widget} {
    if {[info exists configurationInterface::($this,managed)]} {
        error "a widget \"$widget\" of class [classof $widget] is managed already"
    }
    set configurationInterface::($this,managed) $widget
    set list this([string trimleft [classof $widget] :])
    foreach name [composite::componentNames $widget] {
        lappend list $name\([string trimleft [classof $composite::($widget,$name)] :]\)
    }
    set path $composite::($this,names,path)
    eval $path insert 0 $list
    $path selection set 0
    bind $path <ButtonRelease-1> "configurationInterface::update $this"
    bind $path <KeyRelease-space> "configurationInterface::update $this"
    update $this
}

proc configurationInterface::update {this} {
    set selection [$composite::($this,names,path) curselection]
    if {[llength $selection]==0} {
        return
    }
    scan [lindex [$composite::($this,names,path) get $selection] 0] {%[^(]} name
    set managed $configurationInterface::($this,managed)
    if {[string compare $name this]==0} {
        updateOptionEntries $this $managed
    } else {
        updateOptionEntries $this $composite::($managed,$name)
        ::update idletasks
        flashHighlight $this $composite::($managed,$name,path)
    }
}

proc configurationInterface::updateOptionEntries {this widget {columns 2}} {
    if {[info exists configurationInterface::($this,entriesPath)]} {
        scroller::display $composite::($this,scroller) {}
        destroy $configurationInterface::($this,entriesPath)
    }
    set configurationInterface::($this,entriesPath) [set frame [frame $composite::($this,scroller,path).entries]]
    set columns [expr {2*$columns}]
    set column 0
    set row 0
    foreach description [widget::configure $widget] {
        if {[llength $description]<4} {
            continue
        }
        set option [string trimleft [lindex $description 0] -]
        set label [label $frame.${column}_$row -font {Helvetica -11} -text $option:]
        grid $label -column $column -row $row -sticky e
        incr column
        set entry [entry $frame.${column}_$row -width 12 -font {Helvetica -11 bold}]
        $entry insert 0 [widget::cget $widget -$option]
        bind $entry <Return> "
            $entry configure -background red
            ::update idletasks
            widget::configure $widget -$option \[$entry get\]
            $entry configure -background [$entry cget -background]
        "
        bind $entry <KP_Enter> [bind $entry <Return>]
        grid $entry -column $column -row $row -sticky ew
        if {[incr column]>=$columns} {
            set column 0
            incr row
        }
    }
    for {set column 1} {$column<$columns} {incr column 2} {
        grid columnconfigure $frame $column -weight 1
    }
    scroller::display $composite::($this,scroller) $frame
}

proc configurationInterface::flashHighlight {this path} {
    global highlightEvent

    if {[winfo exists .highlight]} {
        after cancel $highlightEvent
        destroy .highlight
    }
    toplevel .highlight -background {} -highlightthickness 1\
        -highlightbackground red -width [expr {[winfo width $path]+2}] -height [expr {[winfo height $path]+2}]
    wm overrideredirect .highlight 1
    wm geometry .highlight +[expr {[winfo rootx $path]-1}]+[expr {[winfo rooty $path]-1}]
    set highlightEvent [after 2000 {catch {destroy .highlight}}]
}

proc configurationInterface::container {this} {
    return $composite::($this,container,path)
}

. configure -background black -borderwidth 1
set options [new configurationInterface .]
set container [new scroller [configurationInterface::container $options] -width 200 -height 200]
pack $widget::($container,path) -fill both -expand 1
configurationInterface::manage $options $container

set tclLogoData {
    R0lGODlhYgEIAvf/AP//////zP//mf//Zv//M///AP/M///MzP/Mmf/MZv/MM//MAP+Z//+ZzP+Zmf+ZZv+ZM/+ZAP9m//9mzP9mmf9mZv9mM/9mAP8z//8z
    zP8zmf8zZv8zM/8zAP8A//8AzP8Amf8AZv8AM/8AAMz//8z/zMz/mcz/Zsz/M8z/AMzM/8zMzMzMmczMZszMM8zMAMyZ/8yZzMyZmcyZZsyZM8yZAMxm/8xm
    zMxmmcxmZsxmM8xmAMwz/8wzzMwzmcwzZswzM8wzAMwA/8wAzMwAmcwAZswAM8wAAJn//5n/zJn/mZn/Zpn/M5n/AJnM/5nMzJnMmZnMZpnMM5nMAJmZ/5mZ
    zJmZmZmZZpmZM5mZAJlm/5lmzJlmmZlmZplmM5lmAJkz/5kzzJkzmZkzZpkzM5kzAJkA/5kAzJkAmZkAZpkAM5kAAGb//2b/zGb/mWb/Zmb/M2b/AGbM/2bM
    zGbMmWbMZmbMM2bMAGaZ/2aZzGaZmWaZZmaZM2aZAGZm/2ZmzGZmmWZmZmZmM2ZmAGYz/2YzzGYzmWYzZmYzM2YzAGYA/2YAzGYAmWYAZmYAM2YAADP//zP/
    zDP/mTP/ZjP/MzP/ADPM/zPMzDPMmTPMZjPMMzPMADOZ/zOZzDOZmTOZZjOZMzOZADNm/zNmzDNmmTNmZjNmMzNmADMz/zMzzDMzmTMzZjMzMzMzADMA/zMA
    zDMAmTMAZjMAMzMAAAD//wD/zAD/mQD/ZgD/MwD/AADM/wDMzADMmQDMZgDMMwDMAACZ/wCZzACZmQCZZgCZMwCZAABm/wBmzABmmQBmZgBmMwBmAAAz/wAz
    zAAzmQAzZgAzMwAzAAAA/wAAzAAAmQAAZgAAM+4AAN0AALsAAKoAAIgAAHcAAFUAAEQAACIAABEAAADuAADdAAC7AACqAACIAAB3AABVAABEAAAiAAARAAAA
    7gAA3QAAuwAAqgAAiAAAdwAAVQAARAAAIgAAEe7u7t3d3bu7u6qqqoiIiHd3d1VVVURERCIiIhEREQAAACwAAAAAYgEIAgAI/wABCBxIsKDBgwgTKlzIsKHD
    hxAjSpxIsaLFixgzatzIsaPHjyAn1jtwwN4BBCgROFiJwF7IlzBjypxJs6bHejhPplzp4IHPBzqCCtUBJIjRo0Z1PDhgs6nTp1CjPiVJkmdPn0OBaC0ahCvS
    r2DDHtXhQKrZs2jTxsSZs2RKBD+BChVLt67du0iBLFXLt69fqCPtmaS682cFoVvxKl7MeLEOBPX+Sp5MGSHbkyetxh2KuLHnz6A9K2VaubRpmYR5bkacOLTr
    17BdA3l8urZtgmzrDdapcjXR2MCDCx9+VC/p28hrCt7NG+7PrFqJS59OXfrjAMmzR6wXYCSCzCvjHv/m7LW6+fPop4/WfnskSZXhfeaAHr18+vv481cny36y
    Ax36BSjggAQWt1d/fD1Q4IIMNkjdY5EheJaCDlZo4YWiHSghRt25995xCVGI4YgkllgcfxsaRNUBmvk0HnmJPcCQiCbWaKODernUF3fcBWBPAM359htwMi5E
    441IJilgBQhg91EAUHrY3FVYzUdUdAEWqZADSnbpZX7rKXRZavE9p4OVQdlXYlkLcfnlm3BSN1uZcsGIZZxhIcCQm3j26eefAurZJqCEFmrocECAiBAChzbq
    6KN4AeGkQgdAaumlkErKEKOYduqpnzo0hICan5ZqqomhMnQAqae26iqDqS7/VA+rr9Zq631aKhQArbf26utwuSY066/EFgtsQ8Maq+yyn7HJEIDMRittXYI+
    O+212BqlaELQZuvtstsi1O235P4aobXlptvrQxWo6+6rQDx05Lv0YhrrjPXm2+m9RurrL6TBKjTvvwT7GXBCfBascJ/O7rnww3hW6zDEFHsp8aAVZ4xkuItq
    7HGNHB9U6cckY3iuqiWnjOPJC42s8ssD6jApyjDXrB+/stqs8304L7Tzz+YdrBDQREsndEJFJx1cww0p7fRrF6P79NSMRb3QuFRnXVfI4j68QwQLhB3BDlpT
    x/VBWJ+6Qw1gLyDc1wXELXcBC5BdtnCJRpT2pzuE/y13BMH1Pffgdd8dnA46yutqBIQHx/jgkBduOGw6sIyvqYIPDnhsj0Me+eSUSzSwpZnP7TbnnqdewOag
    g9Zzv3wv4Lndr+2guuqth3Z0iKXK/jlspd+uee6f7d6xp50PTrtrvgs/O/GNGX8Qp5gGL/fpryUvvNgRdL889HcxLSryqX//me3O012D+eAvJv6mnqaOPfPO
    S95+aFYvRL2l2stdA2z9Ixz77seYvEXEZZZqnumAJzzWETA0BoQIAh9lvbg5EDQKhNwFH/gZmUlkgo4K4PxAE8C42Y+DoancBzGVQQvCpoUmHCAKGfO6hQSA
    hc9zTQlPOEPXiYRXf6rgCP89U8G4ybCHi5HeQZJFQc9tsDElfCISo/dD/kXuiHdBnwanCBslGoSJIfxdaETIRdjkT1Z7K1T/pKgYLZoOi2UMH0XSSKj+Zc+J
    cXzN2biVwMbRz495DM0euwapDLIRL/3jYSAbMzOItKuQyvvj3A65yLtUZHSEUuAQGZPISrrmkn38myT950kfUgSTgFIgHOniRhOW0pQTQeWfmqfIxbRwlSTa
    ChD15cWDJKxRtAxNK+n2pQc4YEXvecAu3dVLg+wPmKIkIeRw6aDr6I+O72pmQZ55qOZRsi4Z3CSJaOOQesgyXWeEHySNKM3h2YicEfllvdKpv1DWEi/hvNH7
    HiL/z3cN8niPepw4s7hFVP1zS/5K3AohJdB2Xq9G2hSYviz3EBAa6nHfFIshSwQEekYkANjMlgopYlE1upCI0xznQR/CzXJpiqSkO2lj8jmiClA0I+ecVg0b
    sipIoY+aSCnohSJqjxVUoQp60EMeqrCCbZXUWztliD1C2ifBAdUo2rtngZppjyoAghTOCKtYnbGKLqBoIDmNVkQJMtU+XjUIG73QPg9yD0AgY6x4FesYgqCD
    47TUW2sdSFsheVXrvfU8HhVIFcCa18aG9RBFcRZV1WoRkPbRM1m9UGJXwFjHelYVZAgCm9K6rMQqZLJ4YpxnaOogj9oDEJ6N7Vj3Wpae/6LzIqiNE9gaY9gK
    zXUgVbirbIfrDMgyJbfGWinaSDdQsWTWQcZ7LXGnS9YcmFNdyjUIcuHU3LDElUHGqwJ1x6uKKjxVWhGkyCMLOdNIgldMehivfJEBRpHeVHEJpGYru4srhdij
    s/KlbhWsENpvedAipNUtNbWX0fOM9CCLDXCASVEF0BoYIwmG0w6omcH/FeilEJawiPNQ3AtfJMNwavB+D4u3kJFYxBJGxiHIFViCoPhNHr7LcwmUv3rAFsYS
    3scyi1XjgfTTVd8VkNB8DGQJq2LIRMbIkVuVQRYDJwcI+W+TJVxgcv3WIVPGHCAD9GC2AnjL0+2yl6Xsqx3rJ/+9gj0zmoe7V3WZViF/PVWS82M1zs55vDNW
    F5wnYtta9TZLB1nBn8kLZWUNWiKjutV+BdQzLS86ze8qM0UibSs332fQlr40nemlaUI3+lF7To/4Qi3q2AY60xmxx6kdVWX9BIzJrZbtKmatrKg6xLKGHnN6
    EGeQH+c6tmp2l6+Rtd1GTZrPBnnxsT1b53oVeSD1aPahGJyfgIl32p7Vh7+uLZBsd3pwOUaPplcgXHDn9cldsvJ9vvwQbRtKk/L2zMXqIWd3hzXZNuqb2DaM
    IXo7xN6FEnbQiu3vxr5aSaUTm4XufLVgLzA9cP52w8cq5DcNcwENRk92Cbk4d6InWPf/2HheAV6dr7Vt4Dr0nFbxM/Llvorb6i4Iv1U+2/R8DYauDA0MZ56e
    jdy4UPhOj6KkzXPIngds6eMvK+W3IKPXSpPpQTnPxWrh82y4iCbHbOpCbh2rvwrr50nvzrfujGrfp4QPFbrM8+2aZTvk6IAKHtl1VxCmq/zh+AG63GLuuXSD
    aSNhvlQrDS+d9Cqa7V3XzzDdez4Y7l045B5InjFVA8pTJ1jG5rnb9SP4Asjb8gPKvEASb8W5pf1kGm86r4NTenkH8PJLQ/zNL16dhq2d55EXENwLULsW4h44
    FMcYlSdpHiDAnu1tX1Dncfca4w+o5iI7O/N7jxvoq4JBkw/6/yjZKSCFXuS8l1LlfhTq942zXPKqOz5SPJ2fRloE/aEk/3RyZY92/71B4bc6ABR2+QFiGIF/
    60RMcgIi7edv8AZ+qkN32kN3EGR/FYGAjhJx1VEBZsZ27xcg4Sd1OsZ7ZHZfE+EqGkgdEpMPbAd4BRJ+8jd/20dpHYGC3vQgbOV/DRd8CwKDqCN+SlaDreJG
    MWgXDRN7Gzd6CyJCFNg5FOgaqjcQKDg3TxgWJ9Nv4LYKF0JGseE7RRgbUSgQs+cnblSFX5ErSNhwHzggqNeFdGOGoJF8UlMqWiSCnyExWDhtLugZs6EUPeGG
    KcVAArggclhxahN3xPFgj6dyPOgYxv/0HedSD7Ehc8DBOHZoHoV4WkOIiMcyEKHXcEpoF0rxHRYoEAhnFJP3hUYRNnAoSB1xiniiRaqYJ9iWh7n2fYoRJuok
    TDn0Gp3Xiq7IEXhXVdE0HA+Whu62hkmhIQ6BgXTRSV04i7FBbMK4iXHDeGBIEJ/obntoIJlobnJHgKDxNRVyYGYnZm8oHdViD1v3fkDgACbYEMN4S5xjIaV2
    YkMoO0T3GfECXE0nFkBABmOgD6RACoAACEe1AvFIEJtnFx93KBzYEcMYi/pYdp7IiF4RkAJ5CMNlkExlgg1ZF2t0KGG4evmogMPhLPUgexu5DyJGYeY3EIUG
    RYFYKCUJACH/mYEVSRzHgYzTpgqqMGfIkAeWA46rpXB/cpM5SWuDiDcEYYvQN16rcA82x1up9icGFxFLCU3SeBRaUg86GJUidggycBDrxUkC1ChZCRFb2U1N
    GRzV4pNiKV9k0DMz8Bn0ByiZSClIZno8eZFz2WSzcRB3eZQzWCiPdhH2UHJwaEC/F5gSpoV2SUQZ5CiJaRGL2SqqZYwRwm6QCWMzhmUGUZiM0UpdeSH3qJg2
    SBxaIpefOWqiWRCkuRgT6CipaRGSmI/E4Szb+JqYFpsEMZuKgXaNYncfNYZ+cppBICiP6ZvThYsRKZu8JY6EYpwQUV98gyiksYjOSV2BdjAZljz7/xgn1vkQ
    2JkuI+Wa3dlYBfY+20WcjXKTALAr+RIrDbiensUVVrNdnkeSH2GUsCYQUImfYrUPR+FUyCWelrKWEZED+VIkK0mgxFVngzaTd6FAyokhe2mI9FIk7Cihw1Vg
    5qh57QWEjrKhmjhPigWisvWAB8N6SEGEl4J9HPougtKbLCpWrwaeaCk3wIghNCpR9UIaAyqh1WY1DmpLxfgo/fgRE+krQKAjYZmjYlVggwagDkmFl9KkHvGk
    vsIUH0ql78YVPeOMQdA5lxgnXCqR9dKPKSemebWjvsQYzfOjGFKeEOGlt9KP6gmi1fY+pFWH+xISbcks/XifVNpl4QJlTv/YKfIpEIW6LP2IozmKi3yVfUqK
    kpfyqDjZpgIKp3glpwYRqD7qKQyqlZ4KAEWKn122n7RpopaConjmqawGql5hORYKTjKFKbKaEGZqqABQq2JqoElxEKTVUJ8Skxvxq5IKAG8KqmH1p1V5ofrX
    KQt5gZ7apwSqqCoyZIKTpn9SihnBrI4GANq6ng84oiapGI9jpyVymweInFBqrtD6WF5pEMCGT5q6L9dKEfkqaPRar0fqTIvxU6YCnB7xr+nifOfanSJqOcf6
    lp7CqfMJi72SKPEFrS5qEJk5nOPpnyGhsC51AJQqoa8WNaSaoUhCsViKTiVLoBT6RVAWNq5yqhL/YbG9ggAvy6pGETAJtgDY2Cm9mqI2urMSVpDHZqmK0rLP
    CK6FMrR81KFGG2BfdWyB5nwFAaNHMTavEqRzqC4PMLXjRQp5sKpc1rM6l1vk2LUwoae2UgFiS10UNm36uU3Zcpka4ba1ogMZu2gIeWzEWmZMuyzwilP1ogNW
    IGpedWx1Fix6ay/imrdtmriLhgzC+mehpXbyerAx8bivwoJ+G6aiBm/84rmXEp0hobXTArp/VgXPKmqB1jC5Ki0Uu670kgNNtg9BKVZdxbhdcTKmu6kxobrS
    QgZNNgbGG1akgGutFlqoG6m9YrMSQbzRkrwwFlq7mweqeotFUS2DKy3S/4uq9UIGu+tkRTEGYUWVVstX5xK8vBoTs0su5AtjxAoEzkAK9hChrUZbMrm5rYK3
    GhG/3wIE5Rtg1XYIgBCwzRsEx4Gz/+u1quK/e1rAdHkUq6C9DStf3xed1EssADyu+uKSIlYczlAFABC3gLacAiHAOtWv9yfBt8KREvZqZIC/29u8I+XAroKn
    IqHDtiLDBnwUY0AKn9pqemG76CkT3/st6Hu2RnEIegAAzTlnQsYU5FosPCwRS+wtTazBXlFeAMCdizYGqeLDrlK75WbG8akY1pvCRkHALpHB40Ub7lsqaGyK
    0oIAk9XG1FVtNbyio2td0KssdwwAanwonYoXFP9MXF02BgkMAIgKZGRJnyoqE4dsKHh8F4vcol12CCZ8wqK2Cn2VpJUcE5dcKCu8S0A8XQ93CCtQxItGBjNQ
    x6cCwQ1xyoRiZHexysT1akCwD5ExxU0GWcrkL7Z8Oc2KVnbBx6NmFGTwyJcLY5b6Ly6Mj8xSunXBzLEVeWSQDwIhxlumjAtLE7QMKmlLF/ZLXdM8Bp8sx7IV
    iqkqE+XcJz0zOgTsnUjhyoCMZt14uOQcLa8zOrzsakihDxHizo71gAWTxRPRwaVSQzKAvHfSxSFaHIAQIZE8XuLMTDTh0J+yU/WQB6qwCoeAvAOdn8XhzQKB
    wo7Vzw/a0QDNEH6mwUj/QQafLMzy1XEPU8gA4NET6xArELcPRwZUKcVmm9AbbaM0Mcg/bZ4R1sxGMQY6IroiBs//ArU0syxKJBj3cA9VkNH/VtCCNcwZc8xZ
    TcgIUbYFudbyVR6P7KxAptAQU83nR1kH0WRyrdIK7MQVQ9f3Z9cFAc45nRefvNfy5dJhgcuXUrgckZtaHWKSXNNFDckiptNjAZBkccW9wtgcAdjaeLw1nTgs
    7QyN+B0o8RMoQRo+fSsMTRGePRBHzZ5IMQZPOcOJXaPfgroyEdM6F9srhxRdUNsipgolTQbRsVMwfCo8LRC8TRCeKc3lodcAMGeqsA8lXZaYmi7LbcjXbBAI
    /81x5YEPBNFqF20Qq30r4VsRik3P3k3WxTHZVI25D6BQ8wwpWH3L3V0QrFvVNf3KAhHfc8a+BLHesWoTzT0QfcvfR0EG5/K6f/Z9ubLF0mLWTZPfnw1katYF
    5/LdsjVjEsPUX2rgwIobvj1WwRfc/ihqY7Cm520rHyyEzNLbcR3dBAHWXIaw9f0onN3Z0VIQ0TxdxHoU0m3jAUYGTEPgkLLjASwtge3eR2EFF35pUUoQLNzC
    NaHZnuLjU4rPxSHesB3KZYblF0vhLTPhzu3kXTHZN7xohzADdusuL76sZj4QDh7ExeHfsPxnZFkQOQ4pZM6X0QIidV7BY5E4OA1kXf9wMUhuKX+eECDeKQ1z
    D6uA4UhhXbUoajmgKItu3zXR4pcS6ZMOY+WB4v9d4tuc6bhRyjLh6QtKEPhw0s/5FaQexlsOY6tg6TKp6sNLuwQhA7BOXNMcBLN+D7U+lgjL6rZy38r32APh
    66D5FdJN7Jd2CDheL+nd0NJyLxH97MUB5Sm+aPlw5NZWE30OJ9quzdPldkDg5fv8Z4leEMn9Kstd7m9y7jCm7mrO4Z7VBSBynjRG7uh1LjJwz3zdFXhu2Fum
    ChpO5fni5v8cLVMuEDIQBJvMyHlx8ESuzl5wMo/+K7rdttNyHBNf8cNVHhG/0pe2a1mbLx//EmdZWroswgH/Vh5kUBCjHVuBgM31grAwselx4iyM8uuyVR5j
    cDI3H27B4vNJ7tfqPS1aUikUrc6jbvOXNgZJX59MP0dOn+vo3qJTH+VzRgYRrvQ6nvUTQfZfEp2V0vUEDdwFYer56Xto3yhYOxNz3yWxUinpfNjQ/vZSLjFV
    7i1mvx13ryQjZVm2jRTe/uV/JmSAH++1MvjXWfhJYkCWRfKeBXiLn+dbBlkf7i+Sb56UnySkYW5C71ijx+5GPcYqrMv60uhfNPpIUi0AcvqNNXqFHaxwL9uf
    ry/Kbhmyr08DASBRP6GE3YGY2/qQ6i+/fxCydi1aoiBs71hqBgS5/+NnKzHInrMz/yHmnxKdCrL31KVmRI38aAZvEkPvBY4akG+bERL+RV7TKmD+W9ZxuaL+
    ANP97U/3qg0QQYCoclbQ4EGEBckEYRiEjD0AEQHYI5XQ4sWEhxg+kAjgQUOQIUWOJFnS5EmUKVWuNMmx40uYMWXGPACE5U2cOXXuZHggIgKGhzBeXNjwYUeK
    Q5UmHLOx40eeUaVOpSrS5UysWWHWrNrVq1cEEQ8EXYqwKMMxECXeK9vWWdMgOjo6+FrX7t0gV7XuxQoU71/AJB2ItTnGrTNVZ4Ok7cj2sNKiOupJ9BvY8uWT
    cvlulkkX82e7LuvpcPhY8ZiXjh9fTMwQSNifoGWD1szZtv9Ez7N1R61NmoxpkKgbr8aoyibDwbF3L79b+7bt3Mylr5Tom6Db06mJX9TY8CrX6eGlOn++Obp4
    9CJ9ehR4va1ifdq3ZwQpOeLo9PlvAil/G6p+AGH7CIh9DoNPvvkO6s619fAD8EGT+OuPs/8gRM8lz4TCDqT4hkvwILgYvI80C0sEScIJ+arQROk080vDslpr
    qMO1PjxIsSAaJJHFElFMUasVedxNs7EWc2uV4xiiMSLVPjQuJB2FNHG9H7MKUkrZgFCLod/a2ifJIJYEoMkEVQkJiCixhJDKKme6Us3PYLOJDPeU+hIkUhB0
    8sz1wINTPzbbjKmCP3dLjtCBvAT/M08PbVyQIfsAqKzQ9AIV9KUdKf1shogGrHOoOxtitEYb3wqpAtw0zQ+2S2PKVFXLXGSowLJCZWhUJkt1Bser3oRVN1Zb
    xfRXzNAEoEgY7VxUzwRxhM1BYqULVliJcoj2srDqIavWZRv9kE+xrp0uOWolglZcvAbDzzBu8WR2OzPrk8hXdC/Tq9wAXq33K5d8a0vGW98l7tG8Rtx3t3up
    zffg5iYbcENRBV6N4PUmZfizhIVd+OK6fKILCIgD9na+EOOqjmPZOC1Xoo1R7iosvz7FSDFcxyxVMdgsdjkw8hTWd2eeOOIq2aFolhg4SE8G+rKehS1y6ank
    wo/omd0d/5m4JxmC7Tyo8Wq61ae7jsphI8sy+urVQtUhgIl+Fvurry8N+22dwvqoy6XOJjXBBZOjl26q1l45XMB34ujj96zem2RIJ+O6cK8iXXluyFeSayyQ
    zVY81zKLCsvPyuGebHCdQ0cJiHrwk9kivTmfr7vLwTS9Ky0Hl3T2m8IijWrW8Rzd9e2Ksudc3KsylvTiV+LoI94TolmtiJLabhXkAHA7eZ6OX7l07EWSCyh2
    IcMT+okq2q4pya7vXifty+V+/YbQHAvvoUomhXzpiQPiNfV1UB/+kUxLWO8DYBAGU5qllEwf+DPfxOLyvwf8rYAgIVe5JLg+juiAfhhRIAODl/8SyVxwgkEQ
    YKtEiD0gBGAGiVKKAleAlAYe5hCyG4mxTljAEl7qhsk7AFBoNZRH6aMKMCQOjkaig/XsEH4VpJYScfcAewSheQfRB4eGaK4Y/ouGJ6qgE7uXMR2OkCSSAcIU
    DRLEK0oki2UhWH0c8LuI/E+MBRucF2d3AB2EDyP7CE4aI7JGpQDMNTp4gKXiOMeTgFFQcgSgA2SwQYtkbTF+BAAgQQWpCjzAAYbsCCNHqMg2eXJ9SNTB6g4i
    yTHk4SWWrFpcmDgTURYQVYOLJQoRkINVLCVJqVzlYeIVv0JmpZbwm+XKrIVIq+TAjAVJEhlU2RFAHKZkboSjuYa5vmL/luuaxdPBDJbpjGbWLJohq2EOHEA+
    4iGzPtW8VDqRqYMc6CNvRhGnW9ooEjJ0wQodcac648JOQQVgi++Up/i4VM/E1ZAM+lAFQXAFOn82RHLCqsdAEamDLszTNTXLg6JORIYx/NAgpPgdRCP6z5VV
    9KQgyWgL40fSjlShLU0BAkgPYUpn3I8yKwVXufqJTEgy5aUvkelSVDGGQ4gUIzqNyONOyskqaYunrlnKowBBvqLqqiBMZc9UGwLVH0XRq0HAaUGs+kKJZFWr
    XLVj98CaIrEC0KIhUWpCfhkmtDIJGVrdKvQINdYcrSyu6+NfSpZ510P48R575StMAfBTf+aw/0qDXd8B6vFXk+jxIklKbEdWwFitAmJ09tjm+iT7I8phD0Nz
    DapZGjIGP9aDldu5KuEAe9oUEXB2xcRjSVp7I6PEdrbEycdOAWvA7U1QcPdxwM8yV7Tg8nO4j1FFF1J1XFDmdoTTqocDZMdCDhoFEL1cq8q6CtjsTki3swMj
    AnQABKSqAhmkGKdFFkSG8XZkuocBxFVKi8HkKpdtM1nBPe5hj3uwckFAyK8a+dqFZ83Vn+ntj1Ox99aIqNUifHSNaDvSUa2SoU/HZUgOVtbWrmW3HvUtTvz0
    AUc9aNU41z1uNk0oRh/BpAr7lWQgsKrVQ5i4UyQOgo3DKMZX1iPBbv8B2BjyCgANN8u/RI7bj1DcNeesYMerOYuTY6or48AmAEQWCECrdOWusQrEqwkRGe7h
    WV3NcMDr9edEL/Xft9WGTG5psx/toasx1AbN2LPzIpHZIBbb0yj77EipjGNePMPPzD+KtNiuEmU2xq+4jXZUYI8l4ZNOOkWVFhuV9osQW23awR8aA+qaSmaG
    iHpCpMZyWlcjyRfr10lAKCatsSfr/oC6e6w6NXAZ0gU4Jno11IONSW9brojWZgVcNgoc13y+41nYq7jtz0mvcu2ytPnHCQKCkK0Ha61BO6LHk60M4/dmW78O
    ucdCd7qptdLaYBojj8IHnOdDBlefF9YUfg7/T799pCT1WyJ/hhcQaiPslRLcNqlFJrHdkiRVPxa0j2nKerQ9VolzhuKIDHj+DBoEcz+22GZBka8B7DSv6jmh
    DnmJsjOdnI+Ptcr9GTkyLx3u+CWbOB0/ZL2TBnOQSwTcFqniVz98azrSOebUkroYWWXzU4IkWPquX2Ahe9ydlyfnFb8P1gsiyQpyHSMOf7XR40etsZP9sWbf
    lXfQBkQSTsTtJ4I7mZ9l9hCl/LMG0ozLC5jjNsVdnaLB+oKcY3KlzDAsigds3wc+mRXbV6JwLDYZYrd3KAlr0OvLAUQyj5Bfto/uB0ESAr4Oawz7x+hdGOLp
    DSKj13QkxmXpgomP/wl6kMTeNqOH3yGeCe6zpD1GaCL+oUW/90OQ4oVqDZFe1G4QfUQQ+AF8PvSdkYd6ZHVBehk8ZAwv9zsDXyikqMKSZ1hiIuJ9+yTh9m3O
    X/yt5oEUSGqcrqE7f+5rlfvDP2Nrn9m6JwCko/SbPz06CzahOyNKQAU0NADEmxDZun2TwJEIOb4YwAKiE2fomy8jCg20ilZ5PXQrI/6bQIajjxIMibCzDRSs
    N4DrP4kgwReUl3bywHcasIjoAqQaAzIYwggswRjkjBkEPTbhwanbwRwMvqd4wswANpGDONCroKrTwEJTLyucIIfTJC/Si577E4cjJO/6lS3sDwToQtMhpP8I
    0iQEQIADsKzRyUIdtC01eUM4dAA5HB6DgZU0LI81RCYjiwk7fDtr+hMMS8IeET6+cDYA0oE4jEMH8MGOOMSG+B1GTI8HmMQ4jIlNhJD2+RFM5CFD3Ilgab7d
    QLzHYsJiccS9oLzKOkWd6CJYYcVQfJBRTBFZdCtazAm96EUAwUVXxIz6M4+pMqRSNBnj0hRiJJZj5AthNEWYWEbnGEMeecZficZYTMZfxAnt6S1nBMVivIxX
    mhBVfBtl5AlWycX80EZY4UAr8cZqDJpOUhV4VBV5xIp0LLVvxAm96EfQyEdN2Uc3yZL3Epd13AnnEMgaSsivIEhKMUiZcMiGkEP/OfydabSQhdQJJKKxjukh
    NklHiSyUQuwPi+yJmNjINflHnGCVQawLVhQ44yFHYjnJ8nBFQ2LJB+nIupEISJSKmSRJm/wVnHwOnVxJhXTJm9CL+xtKmSxKQKTCDgyMnVzKeuQJ53jKioxK
    mHBHAFmuKklKmOBJAPHJnAg4mqzJmCDKryzHWLHEUbNKpbwWtMwJKulHqIxIqVSVQJRBsnwJs2SJMnyACoDIjmHK3GlGr9jLxuxLTfnIyRrA/bGJq6zM/akL
    HTgnmmiur7hLgATKxrSJrxkQzJwKgiwkT1zN1QzK3YBFrCAtu3ijOeSkeqjNOayHmIwaKgkABHAAOPRB/3GkCtC8CefoCtwkH37CzQMIgCsjyHOcCTa0DNic
    CdmsC24EyumsoWBxLxgMxqooTsK8R6qQS2kUSsjUgQpYz/VsEMNkz0x6x+qUievkl0l8I5pgTTSTzLbbwEskTsW8ibysCj6cRJk4gAKdxOeEzJBIDrAEjeyc
    CdcMz7qMHDhqGRPsCMziCfFkCVYZTJFwTNph0IZwULiUigg9UOqsUOMJFAtLmGWEwqyMiquI0ZIQUbZ8iX5KjuE0kRSliRUty694JbdpmglNiQ61HNHky7b0
    Sh39mWY70an40a0IUsGMnJgYqHPsUZ1IUpWIlAclCRylCoLMvWOR0qmIztvARv8AFdKuSLKS2NLtDL0ZjQoqMbwxRc2+NFMuZRGKfAk2nYqrzNGOGDOSyBgb
    Vck65QlyUcU8Rc+3jJ8ohZM//U+6dFOqyJiRG8UwVdSXSFSnUI4RbVImfVJIoRIQnY1KZUy8GFSqKCEC2szR6dMuDVDjXNJRhQm3NFX+bEVKbRNQRVIWlQqA
    orPMpNBFZcg+cblHjQpcdDhLOVL9OEKtCFaUcNXxkAlrZQkvXQlWYdauLNVC7VVLlRJqzYptNQlspVFtlY1uVYlGfUxSldcnVdOUrIuj5IxUPYl1tUdbvYt3
    TYmr2FeBCFd65SebkKwNNZG/3Ix79bQrzdR2BY2ARYn/5ZLWlWjW7LHJFKJPNM0eqpzHS43YqTjJdFWJir3W+5hTMTXYXOUnEomb3eyRkOVHK52LqtjCkxXW
    ZGVHpSFTlyXURAzVYYWQhlWRmwVJYv1Xu0jZRJqXl41CcR3a6glaCKnZgxxZnK0KWDXOSHNak6iNbdXYnSBIqPrYnFDO8lhYgC1afwVUljgcqQBbk+iIqIXa
    qf3DzTtQlv0MtUXKpO1P1GQnqULZtcQJui2JbxVavD1YqrW7ibWQv7W/wAUAgk2YwrVYX7VTpm3KxoVUXXVSmPVPq82P+YSJYuxXQmJI8/QkmBHUzmUJsWXc
    IYNBPCvJvJMJtPXWsaxcrhmM/41MmAviiE6F2HIl0wGjrI2d14s83IwlUYGwzd1NCSp93Fb9R/v4LyZaL/sA0cRVXL1dWkx1CnvoW9xFKZroW8Co3pW1jBKC
    lo80ywrCUO+BCGv93kP9XM7diiSpALJZXh2dK0XaWQL9EZUKDDDyTTkkjKkQQ7dJjhitgNU0z8daTfUtMlZ9Wx2Nw4rJCUn0RG29zxKdRAr+iTicXtKdkAMO
    DG6bWd6gEnt4AP8pQ/ysBxTbx0iLFIw9nck9XtmduOOo2YeNWwO+4IzFT5p4ACMOiU40MwTN4d90ACmeYiquYik2Yir5vfFwvQO1IyCwYjCm4v/QpDAGYxTO
    UBVeYv/LyQEylmIZVuMjyiQxRkw4ideuUM82Bk46BqB83YtAlUKiHWIxOlcVBeQvHR1BHiFCBlJDNlzn1ULUamR4rV1AnkmRk2QQomRAjmRMPgkJSeQRIsVO
    VllQniBRHuWWeGQNxNqeRWWJOrdGPt0MduX4OQAtlkJZFlVaFgkHmAFJzmVVdmXta2T2LWWdO+PkUVOk3WVmnjeUbGZmVua9MGZo9rkUoeZqnqNKReZshp9t
    7mZU/mZw7uRFHpZxxuRyJs9zbuR0lgg4XmedSxF4luR2joh5ZmdWttt7BuSjxYp95ucS3gtD/ecc3MXN+GOCrjeDfsSELmhZRuiGhj2ei+j/F6RSiKZoEpNm
    rCBYjEYkjZ4Jju5oJKswkU5Aigzpki6gk07p+VtplgY+isTmlxabPs7amXa7dpbpm16anN5pnH5mn663fnaVoBbqgBamoka3oUbdpIY1HehhpG5qMjtdbpbq
    eqFqqyay+VzhrB6rrX7nrq6cFOXqsOapFBWosh6rsQbrtKabFN3htvbm5yDguE6xua5rg7trvPa254DrvS6emm5lL3S4ui5nlBaXwoRD1xue1KkHe3jsx+6h
    1QROPZRh/7lsts7BlENGuqnMy44gKZbDo7adx2LOHqriyo6gy15tzDxW4DNsjilD/3nDAm3OfCZtQWns1AkAyZ5E3QRF7dRebeHGbPjpWOj4lf2Z7Qjy7QPw
    Q9x+bujGituEbHsw7d6+z+Ae7tbO7OVQS87ORuWubca+7egub/OOKt1OHea0B9akbD0c7qouM9kLD8+GJ9DeJMs6b/3eb/4+b9OOYjGubPjebjCZK1ZO5NVm
    YzLm4NTpbwd/cAiPcK1Ib972xNMG7gc48Ij8bMWuTXsYbQkPcREfcRI/MpzgcA7+8HoA8RJvcRd/cRhf5hNJbjyGwzmMcRzPcR3f8c1AADmu7QbncSEfciIv
    ciM/ciRPciVfciZvcifnjIAAADs=
}

scroller::display $container [label $widget::($container,path).label -image [image create photo -data $tclLogoData]]

