set rcsId {$Id: scroller.tcl,v 1.20 1998/09/27 20:43:02 jfontain Exp $}

class scroller {

    proc scroller {this parentPath args} composite {[new scroll canvas $parentPath] $args} {
        set scroller::($this,canvasPath) $composite::($composite::($this,base),scrolled,path)
        composite::complete $this
    }

    # displayed widget must be destroyed by user as it may be the path of a scwoop widget, which could be deleted elsewhere
    proc ~scroller {this} {}

    proc options {this} {
        return [list\
            [list -height height Height 0 0]\
            [list -width width Width 0 0]\
            [list\
                -xscrollincrement xScrollIncrement ScrollIncrement\
                $widget::(default,CanvasXScrollIncrement) $widget::(default,CanvasXScrollIncrement)\
            ]\
            [list\
                -yscrollincrement yScrollIncrement ScrollIncrement\
                $widget::(default,CanvasYScrollIncrement) $widget::(default,CanvasYScrollIncrement)\
            ]\
        ]
    }

    proc display {this path} {
        if {[string length $path]==0} {                                                       ;# undisplay, remove related resources
            $scroller::($this,canvasPath) delete all
            bind $scroller::($this,displayed) <Configure> {}
            catch {unset scroller::($this,displayed)}
            return
        }
        if {[info exists scroller::($this,displayed)]} {
            error "scroller \"$this\" already displays widget \"$scroller::($this,displayed)\""
        }
        if {[string compare $widget::($this,path) [winfo parent $path]]!=0} {
            error "displayed widget \"$path\" must be a child of scroller \"$this\" path"
        }
        set scroller::($this,displayed) $path
        set canvas $scroller::($this,canvasPath)
        raise $path $canvas                                                                    ;# always make sure widget is visible
        $canvas create window 0 0 -window $path -anchor nw
        # handle displayed widget dynamic size changes
        bind $path <Configure> "$canvas configure -width %w -height %h -scrollregion {0 0 %w %h}"
    }

    proc set-width {this value} {
        composite::configure $composite::($this,base) -width $value
    }

    proc set-height {this value} {
        composite::configure $composite::($this,base) -height $value
    }

    proc set-xscrollincrement {this value} {
        $scroller::($this,canvasPath) configure -xscrollincrement $value
    }

    proc set-yscrollincrement {this value} {
        $scroller::($this,canvasPath) configure -yscrollincrement $value
    }

}
