if {[catch {package require stooop 3.7}]} {                                               ;# in case stooop package is not installed
    source stooop.tcl
}
namespace import stooop::*
if {[catch {package require switched 1.4}]} {                                           ;# in case switched package is not installed
    source switched.tcl
}
if {[catch {package require scwoop 2.6}]} {                                               ;# in case scwoop package is not installed
    source scwoop.tcl
    source scwoutil.tcl
    source arrowbut.tcl
    source combobut.tcl
    source comboent.tcl
    source scrolist.tcl
    source bindings.tcl
    source widgetip.tcl
    source notebook.tcl
    source scroll.tcl
    source scroller.tcl
    source labelfra.tcl
    source spinent.tcl
    source panner.tcl
    source optimenu.tcl
}

set book [new notebook . -columns 6]
pack $widget::($book,path) -fill both -expand 1

set frame [notebook::newPage $book arrowButton]
$frame configure -width 300 -height 300
set widget [new arrowButton $frame]
place $widget::($widget,path) -x 10 -y 10
set widget [new arrowButton $frame -width 20]
place $widget::($widget,path) -x 10 -y 100
set widget [new arrowButton $frame -width 50]
place $widget::($widget,path) -x 100 -y 10
set widget [new arrowButton $frame -width 30]
place $widget::($widget,path) -x 100 -y 100
set widget [new arrowButton $frame -width 40]
place $widget::($widget,path) -x 200 -y 200

set frame [notebook::newPage $book comboButton]
$frame configure -width 300 -height 300
set widget [new comboButton $frame -list {{first choice} {second choice} {third choice}}]
place $widget::($widget,path) -x 60 -y 10
set widget [new comboButton $frame -list {{fourth choice} {fifth choice} {sixth choice} {seventh choice}}]
place $widget::($widget,path) -x 160 -y 100
set widget [new comboButton $frame -list {{eighth choice} {ninth choice}}]
place $widget::($widget,path) -x 100 -y 140

set frame [notebook::newPage $book comboEntry]
$frame configure -width 300 -height 300
set widget [new comboEntry $frame -list {{first choice} {second choice} {third choice}}]
place $widget::($widget,path) -x 60 -y 10
set widget [new comboEntry $frame -list {{fourth choice} {fifth choice} {sixth choice} {seventh choice}}]
place $widget::($widget,path) -y 60
set widget [new comboEntry $frame -list {{eighth choice} {ninth choice}}]
place $widget::($widget,path) -x 100 -y 140

set frame [notebook::newPage $book scrollList]
$frame configure -width 300 -height 300
set list [new scrollList $frame -list {0 1 2 3 4 5 6 7 8 9}]
place $widget::($list,path) -x 10 -y 10 -width 80 -height 50
set list [new scrollList $frame -list {10 11 12 13}]
place $widget::($list,path) -x 100 -y 20
set list [new scrollList $frame -list {20 21 22 23 24 25 26 27 28 29}]
place $widget::($list,path) -x 140 -y 50 -width 100 -height 80

set frame [notebook::newPage $book scroller]
set scroll [new scroller $frame -width 300 -height 200]
pack $widget::($scroll,path) -fill both -expand 1
set tclLogoData {
    R0lGODlhYgEIAvf/AP//////zP//mf//Zv//M///AP/M///MzP/Mmf/MZv/MM//MAP+Z//+ZzP+Zmf+ZZv+ZM/+ZAP9m//9mzP9mmf9mZv9mM/9mAP8z//8z
    zP8zmf8zZv8zM/8zAP8A//8AzP8Amf8AZv8AM/8AAMz//8z/zMz/mcz/Zsz/M8z/AMzM/8zMzMzMmczMZszMM8zMAMyZ/8yZzMyZmcyZZsyZM8yZAMxm/8xm
    zMxmmcxmZsxmM8xmAMwz/8wzzMwzmcwzZswzM8wzAMwA/8wAzMwAmcwAZswAM8wAAJn//5n/zJn/mZn/Zpn/M5n/AJnM/5nMzJnMmZnMZpnMM5nMAJmZ/5mZ
    zJmZmZmZZpmZM5mZAJlm/5lmzJlmmZlmZplmM5lmAJkz/5kzzJkzmZkzZpkzM5kzAJkA/5kAzJkAmZkAZpkAM5kAAGb//2b/zGb/mWb/Zmb/M2b/AGbM/2bM
    zGbMmWbMZmbMM2bMAGaZ/2aZzGaZmWaZZmaZM2aZAGZm/2ZmzGZmmWZmZmZmM2ZmAGYz/2YzzGYzmWYzZmYzM2YzAGYA/2YAzGYAmWYAZmYAM2YAADP//zP/
    zDP/mTP/ZjP/MzP/ADPM/zPMzDPMmTPMZjPMMzPMADOZ/zOZzDOZmTOZZjOZMzOZADNm/zNmzDNmmTNmZjNmMzNmADMz/zMzzDMzmTMzZjMzMzMzADMA/zMA
    zDMAmTMAZjMAMzMAAAD//wD/zAD/mQD/ZgD/MwD/AADM/wDMzADMmQDMZgDMMwDMAACZ/wCZzACZmQCZZgCZMwCZAABm/wBmzABmmQBmZgBmMwBmAAAz/wAz
    zAAzmQAzZgAzMwAzAAAA/wAAzAAAmQAAZgAAM+4AAN0AALsAAKoAAIgAAHcAAFUAAEQAACIAABEAAADuAADdAAC7AACqAACIAAB3AABVAABEAAAiAAARAAAA
    7gAA3QAAuwAAqgAAiAAAdwAAVQAARAAAIgAAEe7u7t3d3bu7u6qqqoiIiHd3d1VVVURERCIiIhEREQAAACwAAAAAYgEIAgAI/wABCBxIsKDBgwgTKlzIsKHD
    hxAjSpxIsaLFixgzatzIsaPHjyAn1jtwwN4BBCgROFiJwF7IlzBjypxJs6bHejhPplzp4IHPBzqCCtUBJIjRo0Z1PDhgs6nTp1CjPiVJkmdPn0OBaC0ahCvS
    r2DDHtXhQKrZs2jTxsSZs2RKBD+BChVLt67du0iBLFXLt69fqCPtmaS682cFoVvxKl7MeLEOBPX+Sp5MGSHbkyetxh2KuLHnz6A9K2VaubRpmYR5bkacOLTr
    17BdA3l8urZtgmzrDdapcjXR2MCDCx9+VC/p28hrCt7NG+7PrFqJS59OXfrjAMmzR6wXYCSCzCvjHv/m7LW6+fPop4/WfnskSZXhfeaAHr18+vv481cny36y
    Ax36BSjggAQWt1d/fD1Q4IIMNkjdY5EheJaCDlZo4YWiHSghRt25995xCVGI4YgkllgcfxsaRNUBmvk0HnmJPcCQiCbWaKODernUF3fcBWBPAM359htwMi5E
    441IJilgBQhg91EAUHrY3FVYzUdUdAEWqZADSnbpZX7rKXRZavE9p4OVQdlXYlkLcfnlm3BSN1uZcsGIZZxhIcCQm3j26eefAurZJqCEFmrocECAiBAChzbq
    6KN4AeGkQgdAaumlkErKEKOYduqpnzo0hICan5ZqqomhMnQAqae26iqDqS7/VA+rr9Zq631aKhQArbf26utwuSY066/EFgtsQ8Maq+yyn7HJEIDMRittXYI+
    O+212BqlaELQZuvtstsi1O235P4aobXlptvrQxWo6+6rQDx05Lv0YhrrjPXm2+m9RurrL6TBKjTvvwT7GXBCfBascJ/O7rnww3hW6zDEFHsp8aAVZ4xkuItq
    7HGNHB9U6cckY3iuqiWnjOPJC42s8ssD6jApyjDXrB+/stqs8304L7Tzz+YdrBDQREsndEJFJx1cww0p7fRrF6P79NSMRb3QuFRnXVfI4j68QwQLhB3BDlpT
    x/VBWJ+6Qw1gLyDc1wXELXcBC5BdtnCJRpT2pzuE/y13BMH1Pffgdd8dnA46yutqBIQHx/jgkBduOGw6sIyvqYIPDnhsj0Me+eSUSzSwpZnP7TbnnqdewOag
    g9Zzv3wv4Lndr+2guuqth3Z0iKXK/jlspd+uee6f7d6xp50PTrtrvgs/O/GNGX8Qp5gGL/fpryUvvNgRdL889HcxLSryqX//me3O012D+eAvJv6mnqaOPfPO
    S95+aFYvRL2l2stdA2z9Ixz77seYvEXEZZZqnumAJzzWETA0BoQIAh9lvbg5EDQKhNwFH/gZmUlkgo4K4PxAE8C42Y+DoancBzGVQQvCpoUmHCAKGfO6hQSA
    hc9zTQlPOEPXiYRXf6rgCP89U8G4ybCHi5HeQZJFQc9tsDElfCISo/dD/kXuiHdBnwanCBslGoSJIfxdaETIRdjkT1Z7K1T/pKgYLZoOi2UMH0XSSKj+Zc+J
    cXzN2biVwMbRz495DM0euwapDLIRL/3jYSAbMzOItKuQyvvj3A65yLtUZHSEUuAQGZPISrrmkn38myT950kfUgSTgFIgHOniRhOW0pQTQeWfmqfIxbRwlSTa
    ChD15cWDJKxRtAxNK+n2pQc4YEXvecAu3dVLg+wPmKIkIeRw6aDr6I+O72pmQZ55qOZRsi4Z3CSJaOOQesgyXWeEHySNKM3h2YicEfllvdKpv1DWEi/hvNH7
    HiL/z3cN8niPepw4s7hFVP1zS/5K3AohJdB2Xq9G2hSYviz3EBAa6nHfFIshSwQEekYkANjMlgopYlE1upCI0xznQR/CzXJpiqSkO2lj8jmiClA0I+ecVg0b
    sipIoY+aSCnohSJqjxVUoQp60EMeqrCCbZXUWztliD1C2ifBAdUo2rtngZppjyoAghTOCKtYnbGKLqBoIDmNVkQJMtU+XjUIG73QPg9yD0AgY6x4FesYgqCD
    47TUW2sdSFsheVXrvfU8HhVIFcCa18aG9RBFcRZV1WoRkPbRM1m9UGJXwFjHelYVZAgCm9K6rMQqZLJ4YpxnaOogj9oDEJ6N7Vj3Wpae/6LzIqiNE9gaY9gK
    zXUgVbirbIfrDMgyJbfGWinaSDdQsWTWQcZ7LXGnS9YcmFNdyjUIcuHU3LDElUHGqwJ1x6uKKjxVWhGkyCMLOdNIgldMehivfJEBRpHeVHEJpGYru4srhdij
    s/KlbhWsENpvedAipNUtNbWX0fOM9CCLDXCASVEF0BoYIwmG0w6omcH/FeilEJawiPNQ3AtfJMNwavB+D4u3kJFYxBJGxiHIFViCoPhNHr7LcwmUv3rAFsYS
    3scyi1XjgfTTVd8VkNB8DGQJq2LIRMbIkVuVQRYDJwcI+W+TJVxgcv3WIVPGHCAD9GC2AnjL0+2yl6Xsqx3rJ/+9gj0zmoe7V3WZViF/PVWS82M1zs55vDNW
    F5wnYtta9TZLB1nBn8kLZWUNWiKjutV+BdQzLS86ze8qM0UibSs332fQlr40nemlaUI3+lF7To/4Qi3q2AY60xmxx6kdVWX9BIzJrZbtKmatrKg6xLKGHnN6
    EGeQH+c6tmp2l6+Rtd1GTZrPBnnxsT1b53oVeSD1aPahGJyfgIl32p7Vh7+uLZBsd3pwOUaPplcgXHDn9cldsvJ9vvwQbRtKk/L2zMXqIWd3hzXZNuqb2DaM
    IXo7xN6FEnbQiu3vxr5aSaUTm4XufLVgLzA9cP52w8cq5DcNcwENRk92Cbk4d6InWPf/2HheAV6dr7Vt4Dr0nFbxM/Llvorb6i4Iv1U+2/R8DYauDA0MZ56e
    jdy4UPhOj6KkzXPIngds6eMvK+W3IKPXSpPpQTnPxWrh82y4iCbHbOpCbh2rvwrr50nvzrfujGrfp4QPFbrM8+2aZTvk6IAKHtl1VxCmq/zh+AG63GLuuXSD
    aSNhvlQrDS+d9Cqa7V3XzzDdez4Y7l045B5InjFVA8pTJ1jG5rnb9SP4Asjb8gPKvEASb8W5pf1kGm86r4NTenkH8PJLQ/zNL16dhq2d55EXENwLULsW4h44
    FMcYlSdpHiDAnu1tX1Dncfca4w+o5iI7O/N7jxvoq4JBkw/6/yjZKSCFXuS8l1LlfhTq942zXPKqOz5SPJ2fRloE/aEk/3RyZY92/71B4bc6ABR2+QFiGIF/
    60RMcgIi7edv8AZ+qkN32kN3EGR/FYGAjhJx1VEBZsZ27xcg4Sd1OsZ7ZHZfE+EqGkgdEpMPbAd4BRJ+8jd/20dpHYGC3vQgbOV/DRd8CwKDqCN+SlaDreJG
    MWgXDRN7Gzd6CyJCFNg5FOgaqjcQKDg3TxgWJ9Nv4LYKF0JGseE7RRgbUSgQs+cnblSFX5ErSNhwHzggqNeFdGOGoJF8UlMqWiSCnyExWDhtLugZs6EUPeGG
    KcVAArggclhxahN3xPFgj6dyPOgYxv/0HedSD7Ehc8DBOHZoHoV4WkOIiMcyEKHXcEpoF0rxHRYoEAhnFJP3hUYRNnAoSB1xiniiRaqYJ9iWh7n2fYoRJuok
    TDn0Gp3Xiq7IEXhXVdE0HA+Whu62hkmhIQ6BgXTRSV04i7FBbMK4iXHDeGBIEJ/obntoIJlobnJHgKDxNRVyYGYnZm8oHdViD1v3fkDgACbYEMN4S5xjIaV2
    YkMoO0T3GfECXE0nFkBABmOgD6RACoAACEe1AvFIEJtnFx93KBzYEcMYi/pYdp7IiF4RkAJ5CMNlkExlgg1ZF2t0KGG4evmogMPhLPUgexu5DyJGYeY3EIUG
    RYFYKCUJACH/mYEVSRzHgYzTpgqqMGfIkAeWA46rpXB/cpM5SWuDiDcEYYvQN16rcA82x1up9icGFxFLCU3SeBRaUg86GJUidggycBDrxUkC1ChZCRFb2U1N
    GRzV4pNiKV9k0DMz8Bn0ByiZSClIZno8eZFz2WSzcRB3eZQzWCiPdhH2UHJwaEC/F5gSpoV2SUQZ5CiJaRGL2SqqZYwRwm6QCWMzhmUGUZiM0UpdeSH3qJg2
    SBxaIpefOWqiWRCkuRgT6CipaRGSmI/E4Szb+JqYFpsEMZuKgXaNYncfNYZ+cppBICiP6ZvThYsRKZu8JY6EYpwQUV98gyiksYjOSV2BdjAZljz7/xgn1vkQ
    2JkuI+Wa3dlYBfY+20WcjXKTALAr+RIrDbiensUVVrNdnkeSH2GUsCYQUImfYrUPR+FUyCWelrKWEZED+VIkK0mgxFVngzaTd6FAyokhe2mI9FIk7Cihw1Vg
    5qh57QWEjrKhmjhPigWisvWAB8N6SEGEl4J9HPougtKbLCpWrwaeaCk3wIghNCpR9UIaAyqh1WY1DmpLxfgo/fgRE+krQKAjYZmjYlVggwagDkmFl9KkHvGk
    vsIUH0ql78YVPeOMQdA5lxgnXCqR9dKPKSemebWjvsQYzfOjGFKeEOGlt9KP6gmi1fY+pFWH+xISbcks/XifVNpl4QJlTv/YKfIpEIW6LP2IozmKi3yVfUqK
    kpfyqDjZpgIKp3glpwYRqD7qKQyqlZ4KAEWKn122n7RpopaConjmqawGql5hORYKTjKFKbKaEGZqqABQq2JqoElxEKTVUJ8Skxvxq5IKAG8KqmH1p1V5ofrX
    KQt5gZ7apwSqqCoyZIKTpn9SihnBrI4GANq6ng84oiapGI9jpyVymweInFBqrtD6WF5pEMCGT5q6L9dKEfkqaPRar0fqTIvxU6YCnB7xr+nifOfanSJqOcf6
    lp7CqfMJi72SKPEFrS5qEJk5nOPpnyGhsC51AJQqoa8WNaSaoUhCsViKTiVLoBT6RVAWNq5yqhL/YbG9ggAvy6pGETAJtgDY2Cm9mqI2urMSVpDHZqmK0rLP
    CK6FMrR81KFGG2BfdWyB5nwFAaNHMTavEqRzqC4PMLXjRQp5sKpc1rM6l1vk2LUwoae2UgFiS10UNm36uU3Zcpka4ba1ogMZu2gIeWzEWmZMuyzwilP1ogNW
    IGpedWx1Fix6ay/imrdtmriLhgzC+mehpXbyerAx8bivwoJ+G6aiBm/84rmXEp0hobXTArp/VgXPKmqB1jC5Ki0Uu670kgNNtg9BKVZdxbhdcTKmu6kxobrS
    QgZNNgbGG1akgGutFlqoG6m9YrMSQbzRkrwwFlq7mweqeotFUS2DKy3S/4uq9UIGu+tkRTEGYUWVVstX5xK8vBoTs0su5AtjxAoEzkAK9hChrUZbMrm5rYK3
    GhG/3wIE5Rtg1XYIgBCwzRsEx4Gz/+u1quK/e1rAdHkUq6C9DStf3xed1EssADyu+uKSIlYczlAFABC3gLacAiHAOtWv9yfBt8KREvZqZIC/29u8I+XAroKn
    IqHDtiLDBnwUY0AKn9pqemG76CkT3/st6Hu2RnEIegAAzTlnQsYU5FosPCwRS+wtTazBXlFeAMCdizYGqeLDrlK75WbG8akY1pvCRkHALpHB40Ub7lsqaGyK
    0oIAk9XG1FVtNbyio2td0KssdwwAanwonYoXFP9MXF02BgkMAIgKZGRJnyoqE4dsKHh8F4vcol12CCZ8wqK2Cn2VpJUcE5dcKCu8S0A8XQ93CCtQxItGBjNQ
    x6cCwQ1xyoRiZHexysT1akCwD5ExxU0GWcrkL7Z8Oc2KVnbBx6NmFGTwyJcLY5b6Ly6Mj8xSunXBzLEVeWSQDwIhxlumjAtLE7QMKmlLF/ZLXdM8Bp8sx7IV
    iqkqE+XcJz0zOgTsnUjhyoCMZt14uOQcLa8zOrzsakihDxHizo71gAWTxRPRwaVSQzKAvHfSxSFaHIAQIZE8XuLMTDTh0J+yU/WQB6qwCoeAvAOdn8XhzQKB
    wo7Vzw/a0QDNEH6mwUj/QQafLMzy1XEPU8gA4NET6xArELcPRwZUKcVmm9AbbaM0Mcg/bZ4R1sxGMQY6IroiBs//ArU0syxKJBj3cA9VkNH/VtCCNcwZc8xZ
    TcgIUbYFudbyVR6P7KxAptAQU83nR1kH0WRyrdIK7MQVQ9f3Z9cFAc45nRefvNfy5dJhgcuXUrgckZtaHWKSXNNFDckiptNjAZBkccW9wtgcAdjaeLw1nTgs
    7QyN+B0o8RMoQRo+fSsMTRGePRBHzZ5IMQZPOcOJXaPfgroyEdM6F9srhxRdUNsipgolTQbRsVMwfCo8LRC8TRCeKc3lodcAMGeqsA8lXZaYmi7LbcjXbBAI
    /81x5YEPBNFqF20Qq30r4VsRik3P3k3WxTHZVI25D6BQ8wwpWH3L3V0QrFvVNf3KAhHfc8a+BLHesWoTzT0QfcvfR0EG5/K6f/Z9ubLF0mLWTZPfnw1katYF
    5/LdsjVjEsPUX2rgwIobvj1WwRfc/ihqY7Cm520rHyyEzNLbcR3dBAHWXIaw9f0onN3Z0VIQ0TxdxHoU0m3jAUYGTEPgkLLjASwtge3eR2EFF35pUUoQLNzC
    NaHZnuLjU4rPxSHesB3KZYblF0vhLTPhzu3kXTHZN7xohzADdusuL76sZj4QDh7ExeHfsPxnZFkQOQ4pZM6X0QIidV7BY5E4OA1kXf9wMUhuKX+eECDeKQ1z
    D6uA4UhhXbUoajmgKItu3zXR4pcS6ZMOY+WB4v9d4tuc6bhRyjLh6QtKEPhw0s/5FaQexlsOY6tg6TKp6sNLuwQhA7BOXNMcBLN+D7U+lgjL6rZy38r32APh
    66D5FdJN7Jd2CDheL+nd0NJyLxH97MUB5Sm+aPlw5NZWE30OJ9quzdPldkDg5fv8Z4leEMn9Kstd7m9y7jCm7mrO4Z7VBSBynjRG7uh1LjJwz3zdFXhu2Fum
    ChpO5fni5v8cLVMuEDIQBJvMyHlx8ESuzl5wMo/+K7rdttNyHBNf8cNVHhG/0pe2a1mbLx//EmdZWroswgH/Vh5kUBCjHVuBgM31grAwselx4iyM8uuyVR5j
    cDI3H27B4vNJ7tfqPS1aUikUrc6jbvOXNgZJX59MP0dOn+vo3qJTH+VzRgYRrvQ6nvUTQfZfEp2V0vUEDdwFYer56Xto3yhYOxNz3yWxUinpfNjQ/vZSLjFV
    7i1mvx13ryQjZVm2jRTe/uV/JmSAH++1MvjXWfhJYkCWRfKeBXiLn+dbBlkf7i+Sb56UnySkYW5C71ijx+5GPcYqrMv60uhfNPpIUi0AcvqNNXqFHaxwL9uf
    ry/Kbhmyr08DASBRP6GE3YGY2/qQ6i+/fxCydi1aoiBs71hqBgS5/+NnKzHInrMz/yHmnxKdCrL31KVmRI38aAZvEkPvBY4akG+bERL+RV7TKmD+W9ZxuaL+
    ANP97U/3qg0QQYCoclbQ4EGEBckEYRiEjD0AEQHYI5XQ4sWEhxg+kAjgQUOQIUWOJFnS5EmUKVWuNMmx40uYMWXGPACE5U2cOXXuZHggIgKGhzBeXNjwYUeK
    Q5UmHLOx40eeUaVOpSrS5UysWWHWrNrVq1cEEQ8EXYqwKMMxECXeK9vWWdMgOjo6+FrX7t0gV7XuxQoU71/AJB2ItTnGrTNVZ4Ok7cj2sNKiOupJ9BvY8uWT
    cvlulkkX82e7LuvpcPhY8ZiXjh9fTMwQSNifoGWD1szZtv9Ez7N1R61NmoxpkKgbr8aoyibDwbF3L79b+7bt3Mylr5Tom6Db06mJX9TY8CrX6eGlOn++Obp4
    9CJ9ehR4va1ifdq3ZwQpOeLo9PlvAil/G6p+AGH7CIh9DoNPvvkO6s619fAD8EGT+OuPs/8gRM8lz4TCDqT4hkvwILgYvI80C0sEScIJ+arQROk080vDslpr
    qMO1PjxIsSAaJJHFElFMUasVedxNs7EWc2uV4xiiMSLVPjQuJB2FNHG9H7MKUkrZgFCLod/a2ifJIJYEoMkEVQkJiCixhJDKKme6Us3PYLOJDPeU+hIkUhB0
    8sz1wINTPzbbjKmCP3dLjtCBvAT/M08PbVyQIfsAqKzQ9AIV9KUdKf1shogGrHOoOxtitEYb3wqpAtw0zQ+2S2PKVFXLXGSowLJCZWhUJkt1Bser3oRVN1Zb
    xfRXzNAEoEgY7VxUzwRxhM1BYqULVliJcoj2srDqIavWZRv9kE+xrp0uOWolglZcvAbDzzBu8WR2OzPrk8hXdC/Tq9wAXq33K5d8a0vGW98l7tG8Rtx3t3up
    zffg5iYbcENRBV6N4PUmZfizhIVd+OK6fKILCIgD9na+EOOqjmPZOC1Xoo1R7iosvz7FSDFcxyxVMdgsdjkw8hTWd2eeOOIq2aFolhg4SE8G+rKehS1y6ank
    wo/omd0d/5m4JxmC7Tyo8Wq61ae7jsphI8sy+urVQtUhgIl+Fvurry8N+22dwvqoy6XOJjXBBZOjl26q1l45XMB34ujj96zem2RIJ+O6cK8iXXluyFeSayyQ
    zVY81zKLCsvPyuGebHCdQ0cJiHrwk9kivTmfr7vLwTS9Ky0Hl3T2m8IijWrW8Rzd9e2Ksudc3KsylvTiV+LoI94TolmtiJLabhXkAHA7eZ6OX7l07EWSCyh2
    IcMT+okq2q4pya7vXifty+V+/YbQHAvvoUomhXzpiQPiNfV1UB/+kUxLWO8DYBAGU5qllEwf+DPfxOLyvwf8rYAgIVe5JLg+juiAfhhRIAODl/8SyVxwgkEQ
    YKtEiD0gBGAGiVKKAleAlAYe5hCyG4mxTljAEl7qhsk7AFBoNZRH6aMKMCQOjkaig/XsEH4VpJYScfcAewSheQfRB4eGaK4Y/ouGJ6qgE7uXMR2OkCSSAcIU
    DRLEK0oki2UhWH0c8LuI/E+MBRucF2d3AB2EDyP7CE4aI7JGpQDMNTp4gKXiOMeTgFFQcgSgA2SwQYtkbTF+BAAgQQWpCjzAAYbsCCNHqMg2eXJ9SNTB6g4i
    yTHk4SWWrFpcmDgTURYQVYOLJQoRkINVLCVJqVzlYeIVv0JmpZbwm+XKrIVIq+TAjAVJEhlU2RFAHKZkboSjuYa5vmL/luuaxdPBDJbpjGbWLJohq2EOHEA+
    4iGzPtW8VDqRqYMc6CNvRhGnW9ooEjJ0wQodcac648JOQQVgi++Up/i4VM/E1ZAM+lAFQXAFOn82RHLCqsdAEamDLszTNTXLg6JORIYx/NAgpPgdRCP6z5VV
    9KQgyWgL40fSjlShLU0BAkgPYUpn3I8yKwVXufqJTEgy5aUvkelSVDGGQ4gUIzqNyONOyskqaYunrlnKowBBvqLqqiBMZc9UGwLVH0XRq0HAaUGs+kKJZFWr
    XLVj98CaIrEC0KIhUWpCfhkmtDIJGVrdKvQINdYcrSyu6+NfSpZ510P48R575StMAfBTf+aw/0qDXd8B6vFXk+jxIklKbEdWwFitAmJ09tjm+iT7I8phD0Nz
    DapZGjIGP9aDldu5KuEAe9oUEXB2xcRjSVp7I6PEdrbEycdOAWvA7U1QcPdxwM8yV7Tg8nO4j1FFF1J1XFDmdoTTqocDZMdCDhoFEL1cq8q6CtjsTki3swMj
    AnQABKSqAhmkGKdFFkSG8XZkuocBxFVKi8HkKpdtM1nBPe5hj3uwckFAyK8a+dqFZ83Vn+ntj1Ox99aIqNUifHSNaDvSUa2SoU/HZUgOVtbWrmW3HvUtTvz0
    AUc9aNU41z1uNk0oRh/BpAr7lWQgsKrVQ5i4UyQOgo3DKMZX1iPBbv8B2BjyCgANN8u/RI7bj1DcNeesYMerOYuTY6or48AmAEQWCECrdOWusQrEqwkRGe7h
    WV3NcMDr9edEL/Xft9WGTG5psx/toasx1AbN2LPzIpHZIBbb0yj77EipjGNePMPPzD+KtNiuEmU2xq+4jXZUYI8l4ZNOOkWVFhuV9osQW23awR8aA+qaSmaG
    iHpCpMZyWlcjyRfr10lAKCatsSfr/oC6e6w6NXAZ0gU4Jno11IONSW9brojWZgVcNgoc13y+41nYq7jtz0mvcu2ytPnHCQKCkK0Ha61BO6LHk60M4/dmW78O
    ucdCd7qptdLaYBojj8IHnOdDBlefF9YUfg7/T799pCT1WyJ/hhcQaiPslRLcNqlFJrHdkiRVPxa0j2nKerQ9VolzhuKIDHj+DBoEcz+22GZBka8B7DSv6jmh
    DnmJsjOdnI+Ptcr9GTkyLx3u+CWbOB0/ZL2TBnOQSwTcFqniVz98azrSOebUkroYWWXzU4IkWPquX2Ahe9ydlyfnFb8P1gsiyQpyHSMOf7XR40etsZP9sWbf
    lXfQBkQSTsTtJ4I7mZ9l9hCl/LMG0ozLC5jjNsVdnaLB+oKcY3KlzDAsigds3wc+mRXbV6JwLDYZYrd3KAlr0OvLAUQyj5Bfto/uB0ESAr4Oawz7x+hdGOLp
    DSKj13QkxmXpgomP/wl6kMTeNqOH3yGeCe6zpD1GaCL+oUW/90OQ4oVqDZFe1G4QfUQQ+AF8PvSdkYd6ZHVBehk8ZAwv9zsDXyikqMKSZ1hiIuJ9+yTh9m3O
    X/yt5oEUSGqcrqE7f+5rlfvDP2Nrn9m6JwCko/SbPz06CzahOyNKQAU0NADEmxDZun2TwJEIOb4YwAKiE2fomy8jCg20ilZ5PXQrI/6bQIajjxIMibCzDRSs
    N4DrP4kgwReUl3bywHcasIjoAqQaAzIYwggswRjkjBkEPTbhwanbwRwMvqd4wswANpGDONCroKrTwEJTLyucIIfTJC/Si577E4cjJO/6lS3sDwToQtMhpP8I
    0iQEQIADsKzRyUIdtC01eUM4dAA5HB6DgZU0LI81RCYjiwk7fDtr+hMMS8IeET6+cDYA0oE4jEMH8MGOOMSG+B1GTI8HmMQ4jIlNhJD2+RFM5CFD3Ilgab7d
    QLzHYsJiccS9oLzKOkWd6CJYYcVQfJBRTBFZdCtazAm96EUAwUVXxIz6M4+pMqRSNBnj0hRiJJZj5AthNEWYWEbnGEMeecZficZYTMZfxAnt6S1nBMVivIxX
    mhBVfBtl5AlWycX80EZY4UAr8cZqDJpOUhV4VBV5xIp0LLVvxAm96EfQyEdN2Uc3yZL3Epd13AnnEMgaSsivIEhKMUiZcMiGkEP/OfydabSQhdQJJKKxjukh
    NklHiSyUQuwPi+yJmNjINflHnGCVQawLVhQ44yFHYjnJ8nBFQ2LJB+nIupEISJSKmSRJm/wVnHwOnVxJhXTJm9CL+xtKmSxKQKTCDgyMnVzKeuQJ53jKioxK
    mHBHAFmuKklKmOBJAPHJnAg4mqzJmCDKryzHWLHEUbNKpbwWtMwJKulHqIxIqVSVQJRBsnwJs2SJMnyACoDIjmHK3GlGr9jLxuxLTfnIyRrA/bGJq6zM/akL
    HTgnmmiur7hLgATKxrSJrxkQzJwKgiwkT1zN1QzK3YBFrCAtu3ijOeSkeqjNOayHmIwaKgkABHAAOPRB/3GkCtC8CefoCtwkH37CzQMIgCsjyHOcCTa0DNic
    CdmsC24EyumsoWBxLxgMxqooTsK8R6qQS2kUSsjUgQpYz/VsEMNkz0x6x+qUievkl0l8I5pgTTSTzLbbwEskTsW8ibysCj6cRJk4gAKdxOeEzJBIDrAEjeyc
    CdcMz7qMHDhqGRPsCMziCfFkCVYZTJFwTNph0IZwULiUigg9UOqsUOMJFAtLmGWEwqyMiquI0ZIQUbZ8iX5KjuE0kRSliRUty694JbdpmglNiQ61HNHky7b0
    Sh39mWY70an40a0IUsGMnJgYqHPsUZ1IUpWIlAclCRylCoLMvWOR0qmIztvARv8AFdKuSLKS2NLtDL0ZjQoqMbwxRc2+NFMuZRGKfAk2nYqrzNGOGDOSyBgb
    Vck65QlyUcU8Rc+3jJ8ohZM//U+6dFOqyJiRG8UwVdSXSFSnUI4RbVImfVJIoRIQnY1KZUy8GFSqKCEC2szR6dMuDVDjXNJRhQm3NFX+bEVKbRNQRVIWlQqA
    orPMpNBFZcg+cblHjQpcdDhLOVL9OEKtCFaUcNXxkAlrZQkvXQlWYdauLNVC7VVLlRJqzYptNQlspVFtlY1uVYlGfUxSldcnVdOUrIuj5IxUPYl1tUdbvYt3
    TYmr2FeBCFd65SebkKwNNZG/3Ix79bQrzdR2BY2ARYn/5ZLWlWjW7LHJFKJPNM0eqpzHS43YqTjJdFWJir3W+5hTMTXYXOUnEomb3eyRkOVHK52LqtjCkxXW
    ZGVHpSFTlyXURAzVYYWQhlWRmwVJYv1Xu0jZRJqXl41CcR3a6glaCKnZgxxZnK0KWDXOSHNak6iNbdXYnSBIqPrYnFDO8lhYgC1afwVUljgcqQBbk+iIqIXa
    qf3DzTtQlv0MtUXKpO1P1GQnqULZtcQJui2JbxVavD1YqrW7ibWQv7W/wAUAgk2YwrVYX7VTpm3KxoVUXXVSmPVPq82P+YSJYuxXQmJI8/QkmBHUzmUJsWXc
    IYNBPCvJvJMJtPXWsaxcrhmM/41MmAviiE6F2HIl0wGjrI2d14s83IwlUYGwzd1NCSp93Fb9R/v4LyZaL/sA0cRVXL1dWkx1CnvoW9xFKZroW8Co3pW1jBKC
    lo80ywrCUO+BCGv93kP9XM7diiSpALJZXh2dK0XaWQL9EZUKDDDyTTkkjKkQQ7dJjhitgNU0z8daTfUtMlZ9Wx2Nw4rJCUn0RG29zxKdRAr+iTicXtKdkAMO
    DG6bWd6gEnt4AP8pQ/ysBxTbx0iLFIw9nck9XtmduOOo2YeNWwO+4IzFT5p4ACMOiU40MwTN4d90ACmeYiquYik2Yir5vfFwvQO1IyCwYjCm4v/QpDAGYxTO
    UBVeYv/LyQEylmIZVuMjyiQxRkw4ideuUM82Bk46BqB83YtAlUKiHWIxOlcVBeQvHR1BHiFCBlJDNlzn1ULUamR4rV1AnkmRk2QQomRAjmRMPgkJSeQRIsVO
    VllQniBRHuWWeGQNxNqeRWWJOrdGPt0MduX4OQAtlkJZFlVaFgkHmAFJzmVVdmXta2T2LWWdO+PkUVOk3WVmnjeUbGZmVua9MGZo9rkUoeZqnqNKReZshp9t
    7mZU/mZw7uRFHpZxxuRyJs9zbuR0lgg4XmedSxF4luR2joh5ZmdWttt7BuSjxYp95ucS3gtD/ecc3MXN+GOCrjeDfsSELmhZRuiGhj2ei+j/F6RSiKZoEpNm
    rCBYjEYkjZ4Jju5oJKswkU5Aigzpki6gk07p+VtplgY+isTmlxabPs7amXa7dpbpm16anN5pnH5mn663fnaVoBbqgBamoka3oUbdpIY1HehhpG5qMjtdbpbq
    eqFqqyay+VzhrB6rrX7nrq6cFOXqsOapFBWosh6rsQbrtKabFN3htvbm5yDguE6xua5rg7trvPa254DrvS6emm5lL3S4ui5nlBaXwoRD1xue1KkHe3jsx+6h
    1QROPZRh/7lsts7BlENGuqnMy44gKZbDo7adx2LOHqriyo6gy15tzDxW4DNsjilD/3nDAm3OfCZtQWns1AkAyZ5E3QRF7dRebeHGbPjpWOj4lf2Z7Qjy7QPw
    Q9x+bujGituEbHsw7d6+z+Ae7tbO7OVQS87ORuWubca+7egub/OOKt1OHea0B9akbD0c7qouM9kLD8+GJ9DeJMs6b/3eb/4+b9OOYjGubPjebjCZK1ZO5NVm
    YzLm4NTpbwd/cAiPcK1Ib972xNMG7gc48Ij8bMWuTXsYbQkPcREfcRI/MpzgcA7+8HoA8RJvcRd/cRhf5hNJbjyGwzmMcRzPcR3f8c1AADmu7QbncSEfciIv
    ciM/ciRPciVfciZvcifnjIAAADs=
}
scroller::display $scroll [label $widget::($scroll,path).label -image [image create photo -data $tclLogoData]]

set frame [notebook::newPage $book widgetTip]
pack [label $frame.label -text {rest your mouse on top of this} -relief sunken -borderwidth 1 -padx 10 -pady 10]
new widgetTip -path $frame.label -text {some help}

set frame [notebook::newPage $book spinEntry]
$frame configure -width 300 -height 300
set widget [new spinEntry $frame -list {{first choice} {second choice} {third choice}}]
place $widget::($widget,path) -x 60 -y 50
set widget [new spinEntry $frame -range {0 1 .05}]
place $widget::($widget,path) -x 10 -y 100
set widget [new spinEntry $frame -range {0 100 1} -width 3 -justify center -editable 0]
place $widget::($widget,path) -x 100 -y 160

set frame [notebook::newPage $book labelledFrame]
$frame configure -width 300 -height 300
set widget [new labelledFrame $frame -text choices]
place $widget::($widget,path) -x 10 -y 10
set choice 1
pack [radiobutton $widget::($widget,path).1 -variable choice -value 1 -text {first choice}] -anchor nw
pack [radiobutton $widget::($widget,path).2 -variable choice -value 2 -text {second choice}] -anchor nw
pack [radiobutton $widget::($widget,path).3 -variable choice -value 3 -text {third choice}] -anchor nw
set widget [new labelledFrame $frame -text choices -anchor s]
place $widget::($widget,path) -x 150 -y 150
pack [checkbutton $widget::($widget,path).4 -text {fourth choice}] -anchor nw
pack [checkbutton $widget::($widget,path).5 -text {fifth choice}] -anchor nw
pack [checkbutton $widget::($widget,path).6 -text {sixth choice}] -anchor nw

set frame [notebook::newPage $book panner]
set widget [new panner $frame -panes 3]
pack $widget::($widget,path) -fill both -expand 1
pack [frame $panner::($widget,frame1).w -width 200 -height 70 -background cyan -relief raised -bd 1] -fill both -expand 1
pack [frame $panner::($widget,frame2).w -width 200 -height 70 -background yellow -relief raised -bd 1] -fill both -expand 1
pack [frame $panner::($widget,frame3).w -width 200 -height 70 -background magenta -relief raised -bd 1] -fill both -expand 1

set frame [notebook::newPage $book optionMenu]
$frame configure -width 300 -height 300
set widget [new optionMenu $frame -choices {{first choice} {second choice} {third choice}}]
place $widget::($widget,path) -x 60 -y 10
set widget [new optionMenu $frame -choices {{fourth choice} {fifth choice} {sixth choice} {seventh choice}}]
place $widget::($widget,path) -x 160 -y 100
set widget [new optionMenu $frame -choices {{eighth choice} {ninth choice}}]
place $widget::($widget,path) -x 100 -y 200

set frame [notebook::newPage $book notebook]
pack [label $frame.label -text {did you say recursion?}]
set widget [new notebook $frame]
pack $widget::($widget,path)
set frame [notebook::newPage $widget red]
pack [canvas $frame.canvas -background red -width 100 -height 100]
set frame [notebook::newPage $widget green]
pack [canvas $frame.canvas -background green -width 100 -height 100]
set frame [notebook::newPage $widget blue]
pack [canvas $frame.canvas -background blue -width 100 -height 100]

set frame [notebook::newPage $book scroll]
set scroll [new scroll text $frame -width 300 -height 200]
pack $widget::($scroll,path) -fill both -expand 1
set text $composite::($scroll,scrolled,path)
$text configure -wrap word
$text insert end {\
1.1 What is Linux?

Linux is the free Unix written from scratch by Linus Torvalds with assistance from a loosely-knit team of hackers from across the Internet. Linux aims towards POSIX compliance, and has all of the features you would expect of a modern, fully-fledged Unix: true multitasking, virtual memory, shared libraries, demand loading, shared, copy-on-write executables, proper memory management, and TCP/IP networking.

Linux runs mainly on 386/486/586-based PCs, using the hardware facilities of the 386 processor family (TSS segments, et al.) to implement these features. Ports to other architectures are underway. (See `` What ports to other processors are there?'')

See the Linux INFO-SHEET for more details. (See `` Where can I get the HOWTOs and other documentation?'')

The Linux kernel is distributed under the GNU General Public License. (See, `` Is Linux public domain? Copyrighted?'')
}
$text configure -state disabled
