set rcsId {$Id: scwoop.tcl,v 2.22 1998/11/14 20:07:12 jfontain Exp $}

package provide scwoop 2.6

class widget {}

switch $tcl_platform(platform) {
    macintosh {
        array set widget:: {default,ButtonAnchor center default,ButtonActiveBackgroundColor systemButtonText default,ButtonActiveBackgroundMono Black default,ButtonActiveForegroundColor systemButtonFace default,ChkradActiveForegroundColor DEF_BUTTON_ACTIVE_FG_COLOR default,ButtonActiveForegroundMono White default,ButtonBackgroundColor systemButtonFace default,ButtonBackgroundMono White default,ButtonBitmap {} default,ButtonBorderWidth 2 default,ButtonCursor {} default,ButtonCommand {} default,ButtonDefault disabled default,ButtonDisabledForegroundColor #a3a3a3 default,ButtonDisabledForegroundMono {} default,ButtonForeground systemButtonText default,ChkradForeground DEF_BUTTON_FG default,ButtonFont system default,ButtonHeight 0 default,ButtonHighlightBackground systemWindowBody default,ButtonHighlight systemButtonFrame default,LabelHighlightWidth 0 default,ButtonHighlightWidth 4 default,ButtonImage {} default,ButtonIndicator 1 default,ButtonJustify center default,ButtonOffValue 0 default,ButtonOnValue 1 default,ButtonPadX 7 default,LabelCheckRadiusPadX 1 default,ButtonPadY 3 default,LabelCheckRadiusPadY 1 default,ButtonRelief flat default,LabelCheckRadiusRelief flat default,ButtonSelectColor #b03060 default,ButtonSelectMono Black default,ButtonSelectImage {} default,ButtonState normal default,LabelTakeFocus 0 default,ButtonTakeFocus {} default,ButtonText {} default,ButtonTextVariable {} default,ButtonUnderline -1 default,ButtonValue {} default,ButtonWidth 0 default,ButtonWrapLength 0 default,RadiobuttonVariable selectedButton default,CheckbuttonVariable {} default,CanvasBackgroundColor systemWindowBody default,CanvasBackgroundMono White default,CanvasBorderWidth 0 default,CanvasCloseEnough 1 default,CanvasConfine 1 default,CanvasCursor {} default,CanvasHeight 7c default,CanvasHighlightBackground systemWindowBody default,CanvasHighlight Black default,CanvasHighlightWidth 3 default,CanvasInsertBackground Black default,CanvasInsertBorderColor 0 default,CanvasInsertBorderMono 0 default,CanvasInsertOffTime 300 default,CanvasInsertOnTime 600 default,CanvasInsertWidth 2 default,CanvasRelief flat default,CanvasScrollRegion {} default,CanvasSelectColor systemHighlight default,CanvasSelectMono Black default,CanvasSelectBorderColor 1 default,CanvasSelectBorderMono 0 default,CanvasSelectForegroundColor Black default,CanvasSelectForegroundMono White default,CanvasTakeFocus {} default,CanvasWidth 10c default,CanvasXScrollCommand {} default,CanvasXScrollIncrement 0 default,CanvasYScrollCommand {} default,CanvasYScrollIncrement 0 default,EntryBackgroundColor systemWindowBody default,EntryBackgroundMono White default,EntryBorderWidth 1 default,EntryCursor xterm default,EntryExportSelection 1 default,EntryFont "Helvetica 12" default,EntryForeground Black default,EntryHighlightBackground systemWindowBody default,EntryHighlight Black default,EntryHighlightWidth 0 default,EntryInsertBackground Black default,EntryInsertBorderColor 0 default,EntryInsertBorderMono 0 default,EntryInsertOffTime 300 default,EntryInsertOnTime 600 default,EntryInsertWidth 1 default,EntryJustify left default,EntryRelief solid default,EntryScrollCommand {} default,EntrySelectColor systemHighlight default,EntrySelectMono Black default,EntrySelectBorderColor 1 default,EntrySelectBorderMono 0 default,EntrySelectForegroundColor systemHighlightText default,EntrySelectForegroundMono White default,EntryShow {} default,EntryState normal default,EntryTakeFocus {} default,EntryTextVariable {} default,EntryWidth 20 default,FrameBackgroundColor systemWindowBody default,FrameBackgroundMono White default,FrameBorderWidth 0 default,FrameClass Frame default,FrameColormap {} default,FrameContainer 0 default,FrameCursor {} default,FrameHeight 0 default,FrameHighlightBackground systemWindowBody default,FrameHighlight Black default,FrameHighlightWidth 0 default,FrameRelief flat default,FrameTakeFocus 0 default,FrameUse {} default,FrameVisual {} default,FrameWidth 0 default,ListboxBackgroundColor systemWindowBody default,ListboxBackgroundMono White default,ListboxBorderWidth 1 default,ListboxCursor {} default,ListboxExportSelection 1 default,ListboxFont application default,ListboxForeground Black default,ListboxHeight 10 default,ListboxHighlightBackground systemWindowBody default,ListboxHighlight Black default,ListboxHighlightWidth 0 default,ListboxRelief solid default,ListboxScrollCommand {} default,ListboxSelectColor systemHighlight default,ListboxSelectMono Black default,ListboxSelectBorder 0 default,ListboxSelectForegroundColor systemHighlightText default,ListboxSelectForegroundMono White default,ListboxSelectMode browse default,ListboxSetGrid 0 default,ListboxTakeFocus {} default,ListboxWidth 20 default,MenuEntryActiveBackground {} default,MenuEntryActiveForeground {} default,MenuEntryAccelerator {} default,MenuEntryBackground {} default,MenuEntryBitmap None default,MenuEntryColumnBreak 0 default,MenuEntryCommand {} default,MenuEntryForeground {} default,MenuEntryFont {} default,MenuEntryHideMargin 0 default,MenuEntryImage {} default,MenuEntryIndicator 1 default,MenuEntryLabel {} default,MenuEntryMenu {} default,MenuEntryOffValue 0 default,MenuEntryOnValue 1 default,MenuEntrySelectImage {} default,MenuEntryState normal default,MenuEntryValue {} default,MenuEntryCheckVariable {} default,MenuEntryRadioVariable selectedButton default,MenuEntrySelect {} default,MenuEntryUnderline -1 default,MenuActiveBackgroundColor SystemMenuActive default,MenuActiveBackgroundMono Black default,MenuActiveBorderWidth 0 default,MenuActiveForegroundColor SystemMenuActiveText default,MenuActiveForegroundMono White default,MenuBackgroundColor SystemMenu default,MenuBackgroundMono White default,MenuBorderWidth 0 default,MenuCursor arrow default,MenuDisabledForegroundColor SystemMenuDisabled default,MenuDisabledForegroundMono {} default,MenuFont system default,MenuForeground SystemMenuText default,MenuPostCommand {} default,MenuRelief flat default,MenuSelectColor SystemMenuActive default,MenuSelectMono Black default,MenuTakeFocus 0 default,MenuTearoff 1 default,MenuTearoffCommand {} default,MenuTitle {} default,MenuType normal default,MenubuttonAnchor center default,MenubuttonActiveBackgroundColor #ececec default,MenubuttonActiveBackgroundMono Black default,MenubuttonActiveForegroundColor Black default,MenubuttonActiveForegroundMono White default,MenubuttonBackgroundColor systemWindowBody default,MenubuttonBackgroundMono White default,MenubuttonBitmap {} default,MenubuttonBorderWidth 2 default,MenubuttonCursor {} default,MenubuttonDirection below default,MenubuttonDisabledForegroundColor #a3a3a3 default,MenubuttonDisabledForegroundMono {} default,MenubuttonFont system default,MenubuttonForeground Black default,MenubuttonHeight 0 default,MenubuttonHighlightBackground systemWindowBody default,MenubuttonHighlight Black default,MenubuttonHighlightWidth 0 default,MenubuttonImage {} default,MenubuttonIndicator 0 default,MenubuttonJustify left default,MenubuttonMenu {} default,MenubuttonPadX 4p default,MenubuttonPadY 3p default,MenubuttonRelief flat default,MenubuttonState normal default,MenubuttonTakeFocus 0 default,MenubuttonText {} default,MenubuttonTextVariable {} default,MenubuttonUnderline -1 default,MenubuttonWidth 0 default,MenubuttonWrapLength 0 default,MessageAnchor center default,MessageAspect 150 default,MessageBackgroundColor systemWindowBody default,MessageBackgroundMono White default,MessageBorderWidth 2 default,MessageCursor {} default,MessageForeground Black default,MessageFont system default,MessageHighlightBackground systemWindowBody default,MessageHighlight Black default,MessageHighlightWidth 0 default,MessageJustify left default,MessagePadX -1 default,MessagePadY -1 default,MessageRelief flat default,MessageTakeFocus 0 default,MessageText {} default,MessageTextVariable {} default,MessageWidth 0 default,ScaleActiveBackgroundColor #ececec default,ScaleActiveBackgroundMono Black default,ScaleBackgroundColor systemWindowBody default,ScaleBackgroundMono White default,ScaleBigIncrement 0 default,ScaleBorderWidth 2 default,ScaleCommand {} default,ScaleCursor {} default,ScaleDigits 0 default,ScaleFont system default,ScaleForegroundColor Black default,ScaleForegroundMono Black default,ScaleFrom 0 default,ScaleHighlightBackground systemWindowBody default,ScaleHighlight Black default,ScaleHighlightWidth 0 default,ScaleLabel {} default,ScaleLength 100 default,ScaleOrient vertical default,ScaleRelief flat default,ScaleRepeatDelay 300 default,ScaleRepeatInterval 100 default,ScaleResolution 1 default,ScaleTroughColor #c3c3c3 default,ScaleTroughMono White default,ScaleShowValue 1 default,ScaleSliderLength 30 default,ScaleSliderRelief raised default,ScaleState normal default,ScaleTakeFocus {} default,ScaleTickInterval 0 default,ScaleTo 100 default,ScaleVariable {} default,ScaleWidth 15 default,ScrollbarActiveBackgroundColor #ececec default,ScrollbarActiveBackgroundMono Black default,ScrollbarActiveRelief raised default,ScrollbarBackgroundColor systemWindowBody default,ScrollbarBackgroundMono White default,ScrollbarBorderWidth 0 default,ScrollbarCommand {} default,ScrollbarCursor {} default,ScrollbarElementBorderWidth -1 default,ScrollbarHighlightBackground systemWindowBody default,ScrollbarHighlight Black default,ScrollbarHighlightWidth 0 default,ScrollbarJump 0 default,ScrollbarOrient vertical default,ScrollbarRelief flat default,ScrollbarRepeatDelay 300 default,ScrollbarRepeatInterval 100 default,ScrollbarTakeFocus {} default,ScrollbarTroughColor #c3c3c3 default,ScrollbarTroughMono White default,ScrollbarWidth 16 default,TextBackgroundColor systemWindowBody default,TextBackgroundMono White default,TextBorderWidth 0 default,TextCursor xterm default,TextForeground Black default,TextExportSelection 1 default,TextFont "Courier 12" default,TextHeight 24 default,TextHighlightBackground systemWindowBody default,TextHighlight Black default,TextHighlightWidth 3 default,TextInsertBackground Black default,TextInsertBorderColor 0 default,TextInsertBorderMono 0 default,TextInsertOffTime 300 default,TextInsertOnTime 600 default,TextInsertWidth 1 default,TextPadX 1 default,TextPadY 1 default,TextRelief flat default,TextSelectColor systemHighlight default,TextSelectMono Black default,TextSelectBorderColor 1 default,TextSelectBorderMono 0 default,TextSelectForegroundColor systemHighlightText default,TextSelectForegroundMono White default,TextSelectRelief solid default,TextSetGrid 0 default,TextSpacing1 0 default,TextSpacing2 0 default,TextSpacing3 0 default,TextState normal default,TextTabs {} default,TextTakeFocus {} default,TextWidth 80 default,TextWrap char default,TextXScrollCommand {} default,TextYScrollCommand {} default,ToplevelClass Toplevel default,ToplevelMenu {} default,ToplevelScreen {}}
    }
    unix {
        array set widget:: {default,ButtonAnchor center default,ButtonActiveBackgroundColor #ececec default,ButtonActiveBackgroundMono Black default,ButtonActiveForegroundColor Black default,ChkradActiveForegroundColor DEF_BUTTON_ACTIVE_FG_COLOR default,ButtonActiveForegroundMono White default,ButtonBackgroundColor #d9d9d9 default,ButtonBackgroundMono White default,ButtonBitmap {} default,ButtonBorderWidth 2 default,ButtonCursor {} default,ButtonCommand {} default,ButtonDefault disabled default,ButtonDisabledForegroundColor #a3a3a3 default,ButtonDisabledForegroundMono {} default,ButtonForeground Black default,ChkradForeground DEF_BUTTON_FG default,ButtonFont "Helvetica -12 bold" default,ButtonHeight 0 default,ButtonHighlightBackground #d9d9d9 default,ButtonHighlight Black default,LabelHighlightWidth 0 default,ButtonHighlightWidth 1 default,ButtonImage {} default,ButtonIndicator 1 default,ButtonJustify center default,ButtonOffValue 0 default,ButtonOnValue 1 default,ButtonPadX 3m default,LabelCheckRadiusPadX 1 default,ButtonPadY 1m default,LabelCheckRadiusPadY 1 default,ButtonRelief raised default,LabelCheckRadiusRelief flat default,ButtonSelectColor #b03060 default,ButtonSelectMono Black default,ButtonSelectImage {} default,ButtonState normal default,LabelTakeFocus 0 default,ButtonTakeFocus {} default,ButtonText {} default,ButtonTextVariable {} default,ButtonUnderline -1 default,ButtonValue {} default,ButtonWidth 0 default,ButtonWrapLength 0 default,RadiobuttonVariable selectedButton default,CheckbuttonVariable {} default,CanvasBackgroundColor #d9d9d9 default,CanvasBackgroundMono White default,CanvasBorderWidth 0 default,CanvasCloseEnough 1 default,CanvasConfine 1 default,CanvasCursor {} default,CanvasHeight 7c default,CanvasHighlightBackground #d9d9d9 default,CanvasHighlight Black default,CanvasHighlightWidth 1 default,CanvasInsertBackground Black default,CanvasInsertBorderColor 0 default,CanvasInsertBorderMono 0 default,CanvasInsertOffTime 300 default,CanvasInsertOnTime 600 default,CanvasInsertWidth 2 default,CanvasRelief flat default,CanvasScrollRegion {} default,CanvasSelectColor #c3c3c3 default,CanvasSelectMono Black default,CanvasSelectBorderColor 1 default,CanvasSelectBorderMono 0 default,CanvasSelectForegroundColor Black default,CanvasSelectForegroundMono White default,CanvasTakeFocus {} default,CanvasWidth 10c default,CanvasXScrollCommand {} default,CanvasXScrollIncrement 0 default,CanvasYScrollCommand {} default,CanvasYScrollIncrement 0 default,EntryBackgroundColor #d9d9d9 default,EntryBackgroundMono White default,EntryBorderWidth 2 default,EntryCursor xterm default,EntryExportSelection 1 default,EntryFont "Helvetica -12" default,EntryForeground Black default,EntryHighlightBackground #d9d9d9 default,EntryHighlight Black default,EntryHighlightWidth 1 default,EntryInsertBackground Black default,EntryInsertBorderColor 0 default,EntryInsertBorderMono 0 default,EntryInsertOffTime 300 default,EntryInsertOnTime 600 default,EntryInsertWidth 2 default,EntryJustify left default,EntryRelief sunken default,EntryScrollCommand {} default,EntrySelectColor #c3c3c3 default,EntrySelectMono Black default,EntrySelectBorderColor 1 default,EntrySelectBorderMono 0 default,EntrySelectForegroundColor Black default,EntrySelectForegroundMono White default,EntryShow {} default,EntryState normal default,EntryTakeFocus {} default,EntryTextVariable {} default,EntryWidth 20 default,FrameBackgroundColor #d9d9d9 default,FrameBackgroundMono White default,FrameBorderWidth 0 default,FrameClass Frame default,FrameColormap {} default,FrameContainer 0 default,FrameCursor {} default,FrameHeight 0 default,FrameHighlightBackground #d9d9d9 default,FrameHighlight Black default,FrameHighlightWidth 0 default,FrameRelief flat default,FrameTakeFocus 0 default,FrameUse {} default,FrameVisual {} default,FrameWidth 0 default,ListboxBackgroundColor #d9d9d9 default,ListboxBackgroundMono White default,ListboxBorderWidth 2 default,ListboxCursor {} default,ListboxExportSelection 1 default,ListboxFont "Helvetica -12 bold" default,ListboxForeground Black default,ListboxHeight 10 default,ListboxHighlightBackground #d9d9d9 default,ListboxHighlight Black default,ListboxHighlightWidth 1 default,ListboxRelief sunken default,ListboxScrollCommand {} default,ListboxSelectColor #c3c3c3 default,ListboxSelectMono Black default,ListboxSelectBorder 1 default,ListboxSelectForegroundColor Black default,ListboxSelectForegroundMono White default,ListboxSelectMode browse default,ListboxSetGrid 0 default,ListboxTakeFocus {} default,ListboxWidth 20 default,MenuEntryActiveBackground {} default,MenuEntryActiveForeground {} default,MenuEntryAccelerator {} default,MenuEntryBackground {} default,MenuEntryBitmap None default,MenuEntryColumnBreak 0 default,MenuEntryCommand {} default,MenuEntryForeground {} default,MenuEntryFont {} default,MenuEntryHideMargin 0 default,MenuEntryImage {} default,MenuEntryIndicator 1 default,MenuEntryLabel {} default,MenuEntryMenu {} default,MenuEntryOffValue 0 default,MenuEntryOnValue 1 default,MenuEntrySelectImage {} default,MenuEntryState normal default,MenuEntryValue {} default,MenuEntryCheckVariable {} default,MenuEntryRadioVariable selectedButton default,MenuEntrySelect {} default,MenuEntryUnderline -1 default,MenuActiveBackgroundColor #ececec default,MenuActiveBackgroundMono Black default,MenuActiveBorderWidth 2 default,MenuActiveForegroundColor Black default,MenuActiveForegroundMono White default,MenuBackgroundColor #d9d9d9 default,MenuBackgroundMono White default,MenuBorderWidth 2 default,MenuCursor arrow default,MenuDisabledForegroundColor #a3a3a3 default,MenuDisabledForegroundMono {} default,MenuFont "Helvetica -12 bold" default,MenuForeground Black default,MenuPostCommand {} default,MenuRelief raised default,MenuSelectColor #b03060 default,MenuSelectMono Black default,MenuTakeFocus 0 default,MenuTearoff 1 default,MenuTearoffCommand {} default,MenuTitle {} default,MenuType normal default,MenubuttonAnchor center default,MenubuttonActiveBackgroundColor #ececec default,MenubuttonActiveBackgroundMono Black default,MenubuttonActiveForegroundColor Black default,MenubuttonActiveForegroundMono White default,MenubuttonBackgroundColor #d9d9d9 default,MenubuttonBackgroundMono White default,MenubuttonBitmap {} default,MenubuttonBorderWidth 2 default,MenubuttonCursor {} default,MenubuttonDirection below default,MenubuttonDisabledForegroundColor #a3a3a3 default,MenubuttonDisabledForegroundMono {} default,MenubuttonFont "Helvetica -12 bold" default,MenubuttonForeground Black default,MenubuttonHeight 0 default,MenubuttonHighlightBackground #d9d9d9 default,MenubuttonHighlight Black default,MenubuttonHighlightWidth 0 default,MenubuttonImage {} default,MenubuttonIndicator 0 default,MenubuttonJustify center default,MenubuttonMenu {} default,MenubuttonPadX 4p default,MenubuttonPadY 3p default,MenubuttonRelief flat default,MenubuttonState normal default,MenubuttonTakeFocus 0 default,MenubuttonText {} default,MenubuttonTextVariable {} default,MenubuttonUnderline -1 default,MenubuttonWidth 0 default,MenubuttonWrapLength 0 default,MessageAnchor center default,MessageAspect 150 default,MessageBackgroundColor #d9d9d9 default,MessageBackgroundMono White default,MessageBorderWidth 2 default,MessageCursor {} default,MessageForeground Black default,MessageFont "Helvetica -12 bold" default,MessageHighlightBackground #d9d9d9 default,MessageHighlight Black default,MessageHighlightWidth 0 default,MessageJustify left default,MessagePadX -1 default,MessagePadY -1 default,MessageRelief flat default,MessageTakeFocus 0 default,MessageText {} default,MessageTextVariable {} default,MessageWidth 0 default,ScaleActiveBackgroundColor #ececec default,ScaleActiveBackgroundMono Black default,ScaleBackgroundColor #d9d9d9 default,ScaleBackgroundMono White default,ScaleBigIncrement 0 default,ScaleBorderWidth 2 default,ScaleCommand {} default,ScaleCursor {} default,ScaleDigits 0 default,ScaleFont "Helvetica -12 bold" default,ScaleForegroundColor Black default,ScaleForegroundMono Black default,ScaleFrom 0 default,ScaleHighlightBackground #d9d9d9 default,ScaleHighlight Black default,ScaleHighlightWidth 1 default,ScaleLabel {} default,ScaleLength 100 default,ScaleOrient vertical default,ScaleRelief flat default,ScaleRepeatDelay 300 default,ScaleRepeatInterval 100 default,ScaleResolution 1 default,ScaleTroughColor #c3c3c3 default,ScaleTroughMono White default,ScaleShowValue 1 default,ScaleSliderLength 30 default,ScaleSliderRelief raised default,ScaleState normal default,ScaleTakeFocus {} default,ScaleTickInterval 0 default,ScaleTo 100 default,ScaleVariable {} default,ScaleWidth 15 default,ScrollbarActiveBackgroundColor #ececec default,ScrollbarActiveBackgroundMono Black default,ScrollbarActiveRelief raised default,ScrollbarBackgroundColor #d9d9d9 default,ScrollbarBackgroundMono White default,ScrollbarBorderWidth 2 default,ScrollbarCommand {} default,ScrollbarCursor {} default,ScrollbarElementBorderWidth -1 default,ScrollbarHighlightBackground #d9d9d9 default,ScrollbarHighlight Black default,ScrollbarHighlightWidth 1 default,ScrollbarJump 0 default,ScrollbarOrient vertical default,ScrollbarRelief sunken default,ScrollbarRepeatDelay 300 default,ScrollbarRepeatInterval 100 default,ScrollbarTakeFocus {} default,ScrollbarTroughColor #c3c3c3 default,ScrollbarTroughMono White default,ScrollbarWidth 15 default,TextBackgroundColor #d9d9d9 default,TextBackgroundMono White default,TextBorderWidth 2 default,TextCursor xterm default,TextForeground Black default,TextExportSelection 1 default,TextFont "Courier -12" default,TextHeight 24 default,TextHighlightBackground #d9d9d9 default,TextHighlight Black default,TextHighlightWidth 1 default,TextInsertBackground Black default,TextInsertBorderColor 0 default,TextInsertBorderMono 0 default,TextInsertOffTime 300 default,TextInsertOnTime 600 default,TextInsertWidth 2 default,TextPadX 1 default,TextPadY 1 default,TextRelief sunken default,TextSelectColor #c3c3c3 default,TextSelectMono Black default,TextSelectBorderColor 1 default,TextSelectBorderMono 0 default,TextSelectForegroundColor Black default,TextSelectForegroundMono White default,TextSelectRelief raised default,TextSetGrid 0 default,TextSpacing1 0 default,TextSpacing2 0 default,TextSpacing3 0 default,TextState normal default,TextTabs {} default,TextTakeFocus {} default,TextWidth 80 default,TextWrap char default,TextXScrollCommand {} default,TextYScrollCommand {} default,ToplevelClass Toplevel default,ToplevelMenu {} default,ToplevelScreen {}}
    }
    windows {
        array set widget:: {default,ButtonAnchor center default,ButtonActiveBackgroundColor SystemButtonFace default,ButtonActiveBackgroundMono Black default,ButtonActiveForegroundColor SystemButtonText default,ChkradActiveForegroundColor SystemWindowText default,ButtonActiveForegroundMono White default,ButtonBackgroundColor SystemButtonFace default,ButtonBackgroundMono White default,ButtonBitmap {} default,ButtonBorderWidth 2 default,ButtonCursor {} default,ButtonCommand {} default,ButtonDefault disabled default,ButtonDisabledForegroundColor SystemDisabledText default,ButtonDisabledForegroundMono {} default,ButtonForeground SystemButtonText default,ChkradForeground SystemWindowText default,ButtonFont "{MS Sans Serif} 8" default,ButtonHeight 0 default,ButtonHighlightBackground SystemButtonFace default,ButtonHighlight SystemWindowFrame default,LabelHighlightWidth 0 default,ButtonHighlightWidth 1 default,ButtonImage {} default,ButtonIndicator 1 default,ButtonJustify center default,ButtonOffValue 0 default,ButtonOnValue 1 default,ButtonPadX 1 default,LabelCheckRadiusPadX 1 default,ButtonPadY 1 default,LabelCheckRadiusPadY 1 default,ButtonRelief raised default,LabelCheckRadiusRelief flat default,ButtonSelectColor SystemWindow default,ButtonSelectMono Black default,ButtonSelectImage {} default,ButtonState normal default,LabelTakeFocus 0 default,ButtonTakeFocus {} default,ButtonText {} default,ButtonTextVariable {} default,ButtonUnderline -1 default,ButtonValue {} default,ButtonWidth 0 default,ButtonWrapLength 0 default,RadiobuttonVariable selectedButton default,CheckbuttonVariable {} default,CanvasBackgroundColor SystemButtonFace default,CanvasBackgroundMono White default,CanvasBorderWidth 0 default,CanvasCloseEnough 1 default,CanvasConfine 1 default,CanvasCursor {} default,CanvasHeight 7c default,CanvasHighlightBackground SystemButtonFace default,CanvasHighlight SystemWindowFrame default,CanvasHighlightWidth 2 default,CanvasInsertBackground SystemButtonText default,CanvasInsertBorderColor 0 default,CanvasInsertBorderMono 0 default,CanvasInsertOffTime 300 default,CanvasInsertOnTime 600 default,CanvasInsertWidth 2 default,CanvasRelief flat default,CanvasScrollRegion {} default,CanvasSelectColor SystemHighlight default,CanvasSelectMono Black default,CanvasSelectBorderColor 1 default,CanvasSelectBorderMono 0 default,CanvasSelectForegroundColor SystemHighlightText default,CanvasSelectForegroundMono White default,CanvasTakeFocus {} default,CanvasWidth 10c default,CanvasXScrollCommand {} default,CanvasXScrollIncrement 0 default,CanvasYScrollCommand {} default,CanvasYScrollIncrement 0 default,EntryBackgroundColor SystemWindow default,EntryBackgroundMono White default,EntryBorderWidth 2 default,EntryCursor xterm default,EntryExportSelection 1 default,EntryFont "{MS Sans Serif} 8" default,EntryForeground SystemWindowText default,EntryHighlightBackground SystemButtonFace default,EntryHighlight SystemWindowFrame default,EntryHighlightWidth 0 default,EntryInsertBackground SystemWindowText default,EntryInsertBorderColor 0 default,EntryInsertBorderMono 0 default,EntryInsertOffTime 300 default,EntryInsertOnTime 600 default,EntryInsertWidth 2 default,EntryJustify left default,EntryRelief sunken default,EntryScrollCommand {} default,EntrySelectColor SystemHighlight default,EntrySelectMono Black default,EntrySelectBorderColor 0 default,EntrySelectBorderMono 0 default,EntrySelectForegroundColor SystemHighlightText default,EntrySelectForegroundMono White default,EntryShow {} default,EntryState normal default,EntryTakeFocus {} default,EntryTextVariable {} default,EntryWidth 20 default,FrameBackgroundColor SystemButtonFace default,FrameBackgroundMono White default,FrameBorderWidth 0 default,FrameClass Frame default,FrameColormap {} default,FrameContainer 0 default,FrameCursor {} default,FrameHeight 0 default,FrameHighlightBackground SystemButtonFace default,FrameHighlight SystemWindowFrame default,FrameHighlightWidth 0 default,FrameRelief flat default,FrameTakeFocus 0 default,FrameUse {} default,FrameVisual {} default,FrameWidth 0 default,ListboxBackgroundColor SystemButtonFace default,ListboxBackgroundMono White default,ListboxBorderWidth 2 default,ListboxCursor {} default,ListboxExportSelection 1 default,ListboxFont "{MS Sans Serif} 8" default,ListboxForeground SystemButtonText default,ListboxHeight 10 default,ListboxHighlightBackground SystemButtonFace default,ListboxHighlight SystemWindowFrame default,ListboxHighlightWidth 1 default,ListboxRelief sunken default,ListboxScrollCommand {} default,ListboxSelectColor SystemHighlight default,ListboxSelectMono Black default,ListboxSelectBorder 1 default,ListboxSelectForegroundColor SystemHighlightText default,ListboxSelectForegroundMono White default,ListboxSelectMode browse default,ListboxSetGrid 0 default,ListboxTakeFocus {} default,ListboxWidth 20 default,MenuEntryActiveBackground {} default,MenuEntryActiveForeground {} default,MenuEntryAccelerator {} default,MenuEntryBackground {} default,MenuEntryBitmap None default,MenuEntryColumnBreak 0 default,MenuEntryCommand {} default,MenuEntryForeground {} default,MenuEntryFont {} default,MenuEntryHideMargin 0 default,MenuEntryImage {} default,MenuEntryIndicator 1 default,MenuEntryLabel {} default,MenuEntryMenu {} default,MenuEntryOffValue 0 default,MenuEntryOnValue 1 default,MenuEntrySelectImage {} default,MenuEntryState normal default,MenuEntryValue {} default,MenuEntryCheckVariable {} default,MenuEntryRadioVariable selectedButton default,MenuEntrySelect {} default,MenuEntryUnderline -1 default,MenuActiveBackgroundColor SystemHighlight default,MenuActiveBackgroundMono Black default,MenuActiveBorderWidth 0 default,MenuActiveForegroundColor SystemHighlightText default,MenuActiveForegroundMono White default,MenuBackgroundColor SystemMenu default,MenuBackgroundMono White default,MenuBorderWidth 0 default,MenuCursor arrow default,MenuDisabledForegroundColor SystemDisabledText default,MenuDisabledForegroundMono {} default,MenuFont "{MS Sans Serif} 8" default,MenuForeground SystemMenuText default,MenuPostCommand {} default,MenuRelief flat default,MenuSelectColor SystemMenuText default,MenuSelectMono Black default,MenuTakeFocus 0 default,MenuTearoff 1 default,MenuTearoffCommand {} default,MenuTitle {} default,MenuType normal default,MenubuttonAnchor center default,MenubuttonActiveBackgroundColor SystemButtonFace default,MenubuttonActiveBackgroundMono Black default,MenubuttonActiveForegroundColor SystemButtonText default,MenubuttonActiveForegroundMono White default,MenubuttonBackgroundColor SystemButtonFace default,MenubuttonBackgroundMono White default,MenubuttonBitmap {} default,MenubuttonBorderWidth 2 default,MenubuttonCursor {} default,MenubuttonDirection below default,MenubuttonDisabledForegroundColor SystemDisabledText default,MenubuttonDisabledForegroundMono {} default,MenubuttonFont "{MS Sans Serif} 8" default,MenubuttonForeground SystemButtonText default,MenubuttonHeight 0 default,MenubuttonHighlightBackground SystemButtonFace default,MenubuttonHighlight SystemWindowFrame default,MenubuttonHighlightWidth 0 default,MenubuttonImage {} default,MenubuttonIndicator 0 default,MenubuttonJustify center default,MenubuttonMenu {} default,MenubuttonPadX 4p default,MenubuttonPadY 3p default,MenubuttonRelief flat default,MenubuttonState normal default,MenubuttonTakeFocus 0 default,MenubuttonText {} default,MenubuttonTextVariable {} default,MenubuttonUnderline -1 default,MenubuttonWidth 0 default,MenubuttonWrapLength 0 default,MessageAnchor center default,MessageAspect 150 default,MessageBackgroundColor SystemButtonFace default,MessageBackgroundMono White default,MessageBorderWidth 2 default,MessageCursor {} default,MessageForeground SystemButtonText default,MessageFont "{MS Sans Serif} 8" default,MessageHighlightBackground SystemButtonFace default,MessageHighlight SystemWindowFrame default,MessageHighlightWidth 0 default,MessageJustify left default,MessagePadX -1 default,MessagePadY -1 default,MessageRelief flat default,MessageTakeFocus 0 default,MessageText {} default,MessageTextVariable {} default,MessageWidth 0 default,ScaleActiveBackgroundColor SystemButtonFace default,ScaleActiveBackgroundMono Black default,ScaleBackgroundColor SystemButtonFace default,ScaleBackgroundMono White default,ScaleBigIncrement 0 default,ScaleBorderWidth 2 default,ScaleCommand {} default,ScaleCursor {} default,ScaleDigits 0 default,ScaleFont "{MS Sans Serif} 8" default,ScaleForegroundColor SystemButtonText default,ScaleForegroundMono Black default,ScaleFrom 0 default,ScaleHighlightBackground SystemButtonFace default,ScaleHighlight SystemWindowFrame default,ScaleHighlightWidth 2 default,ScaleLabel {} default,ScaleLength 100 default,ScaleOrient vertical default,ScaleRelief flat default,ScaleRepeatDelay 300 default,ScaleRepeatInterval 100 default,ScaleResolution 1 default,ScaleTroughColor SystemScrollbar default,ScaleTroughMono White default,ScaleShowValue 1 default,ScaleSliderLength 30 default,ScaleSliderRelief raised default,ScaleState normal default,ScaleTakeFocus {} default,ScaleTickInterval 0 default,ScaleTo 100 default,ScaleVariable {} default,ScaleWidth 15 default,ScrollbarActiveBackgroundColor SystemButtonFace default,ScrollbarActiveBackgroundMono Black default,ScrollbarActiveRelief raised default,ScrollbarBackgroundColor SystemButtonFace default,ScrollbarBackgroundMono White default,ScrollbarBorderWidth 0 default,ScrollbarCommand {} default,ScrollbarCursor {} default,ScrollbarElementBorderWidth -1 default,ScrollbarHighlightBackground SystemButtonFace default,ScrollbarHighlight SystemWindowFrame default,ScrollbarHighlightWidth 0 default,ScrollbarJump 0 default,ScrollbarOrient vertical default,ScrollbarRelief sunken default,ScrollbarRepeatDelay 300 default,ScrollbarRepeatInterval 100 default,ScrollbarTakeFocus {} default,ScrollbarTroughColor SystemScrollbar default,ScrollbarTroughMono White default,ScrollbarWidth 10 default,TextBackgroundColor SystemWindow default,TextBackgroundMono White default,TextBorderWidth 2 default,TextCursor xterm default,TextForeground SystemWindowText default,TextExportSelection 1 default,TextFont "{MS Sans Serif} 8" default,TextHeight 24 default,TextHighlightBackground SystemButtonFace default,TextHighlight SystemWindowFrame default,TextHighlightWidth 0 default,TextInsertBackground SystemWindowText default,TextInsertBorderColor 0 default,TextInsertBorderMono 0 default,TextInsertOffTime 300 default,TextInsertOnTime 600 default,TextInsertWidth 2 default,TextPadX 1 default,TextPadY 1 default,TextRelief sunken default,TextSelectColor SystemHighlight default,TextSelectMono Black default,TextSelectBorderColor 0 default,TextSelectBorderMono 0 default,TextSelectForegroundColor SystemHighlightText default,TextSelectForegroundMono White default,TextSelectRelief flat default,TextSetGrid 0 default,TextSpacing1 0 default,TextSpacing2 0 default,TextSpacing3 0 default,TextState normal default,TextTabs {} default,TextTakeFocus {} default,TextWidth 80 default,TextWrap char default,TextXScrollCommand {} default,TextYScrollCommand {} default,ToplevelClass Toplevel default,ToplevelMenu {} default,ToplevelScreen {}}
    }
}

class widget {
    proc widget {this path} {
        set widget::($this,path) $path
    }

    proc ~widget {this} {}

    virtual proc configure {this args} {
        return [eval $widget::($this,path) configure $args]
    }

    virtual proc cget {this args} {                                     ;# for native widgets, arguments sole element is option name
        return [$widget::($this,path) cget $args]
    }
}


foreach class {button canvas entry frame label listbox menu menubutton message radiobutton scale scrollbar text toplevel} {
    class $class {                                                        ;# create a widget wrapper class for each native Tk widget
        # use fully qualified widget command so it does not interfere with class constructor procedure in class namespace
        # if parent is ., Tcl widget command automatically strips off extra dot, that is ..path becomes .path
        proc $class {this parentPath args} widget "\[eval ::$class \$parentPath.\$this \$args\]" {}
        proc ~$class {this} {
            destroy $widget::($this,path)
        }
    }
}

# eventually comment out the following lines if you do not use the great tkTable widget:
class table {
    proc table {this parentPath args} widget {[eval ::table $parentPath.$this $args]} {}
    proc ~table {this} {
        destroy $widget::($this,path)
    }
}

# use the following wrappers for BLT (eventually comment out if you do not use the great BLT library):
# (which works around the following bug: [blt::graph ..g] returns .g but .g command does not exist, whereas ..g does)
foreach class {barchart graph hierbox htext stripchart tabset} {
    class $class {
        proc $class {this parentPath args} widget "\[eval ::blt::$class .\[string trimleft \$parentPath.\$this .\] \$args\]" {}
        proc ~$class {this} {
            destroy $widget::($this,path)
        }
    }
}

class composite {}

# arguments are option / value pairs as are arguments to Tk widgets configure command
proc composite::composite {this base args} widget {$widget::($base,path)} {
    if {([llength $args]%2)!=0} {
        error "value for \"[lindex $args end]\" missing"
    }
    set composite::($this,base) $base
    # base path is actually identical to widget path (in widget constructor) but is defined here for consistency
    set composite::($this,base,path) $widget::($base,path)
    set composite::($this,_children) {}
    set composite::($this,complete) 0
    # delay arguments processing till completion as pure virtual procedure invocations do not work from base class constructor
    set composite::($this,initialArguments) $args
}

# delete children in reverse order of creation because Tk native widgets when destroyed destroy their children as well
proc composite::~composite {this} {
    eval delete [lsort -integer -decreasing $composite::($this,_children)] $composite::($this,base)
}

# derived class implementation must return a list of {name dbname dbclass defaultValue currentValue} lists, as Tk widget configure
# options with current value optional
virtual proc composite::options {this}

proc composite::configure {this args} {
    if {[llength $args]==0} {
        return [descriptions $this]
    }
    if {![string match -* $args]} {
        # first argument is a child widget name (no leading -), so configure child with optional option / value pairs
        return [eval widget::configure $composite::($this,[lindex $args 0]) [lrange $args 1 end]]
    }
    foreach {option value} $args {                                          ;# check all options validity before doing anything else
        if {![info exists composite::($this,$option)]} {
            error "$composite::($this,_derived): unknown option \"$option\""
        }
    }
    if {[llength $args]==1} {
        return [description $this [lindex $args 0]]
    }
    if {([llength $args]%2)!=0} {
        error "value for \"[lindex $args end]\" missing"
    }
    # derived (dynamic virtual) procedure must either accept (or eventually adjust) the value or throw an error
    # option data member is set prior to calling the method in case other methods are called and expect the new value
    foreach {option value} $args {
        if {[string compare $composite::($this,$option) $value]!=0} {
            $composite::($this,_derived)::set$option $this [set composite::($this,$option) $value]
        }
    }
}

proc composite::manage {this args} {
    # arguments are one or more child widgets (widget class is composite base class) associated with a name which can later be
    # used to retrieve the widget object and the widget path, at the composite level
    foreach {child name} $args {
        if {[string length $name]==0} {
            error "widget $child has no name"
        }
        if {[string match -* $name]} {
            error "widget $child name \"$name\" must not start with a dash character"
        }
        if {[info exists composite::($this,$name)]} {
            error "\"$name\" member name already exists in composite layer"
        }
        set composite::($this,$name) $child
        set composite::($this,$name,path) $widget::($child,path)
        lappend composite::($this,_children) $child
    }
}

# must be invoked at the end of derived class constructor so that components are properly configured
proc composite::complete {this} {
    set path $widget::($this,path)
    foreach description [options $this] {
        set option [lindex $description 0]
        set composite::($this,$option) [set default [lindex $description 3]]        ;# by default always set option to default value
        if {[llength $description]<5} {
            set initialize($option) {}                                ;# no initial value so force initialization with default value
        } elseif {[string compare $default [lindex $description 4]]!=0} {
            set composite::($this,$option) [lindex $description 4]
            set initialize($option) {}                         ;# initial value different from default value so force initialization
        }
        set value [option get $path [lindex $description 1] [lindex $description 2]]
        if {([string length $value]>0)&&([string compare $value $default]!=0)} {
            set composite::($this,$option) $value               ;# options database values always take precedence for initialization
            set initialize($option) {}
        }
    }
    # check validity of constructor options, which always take precedence for initialization
    foreach {option value} $composite::($this,initialArguments) {
        if {[catch {string compare $composite::($this,$option) $value} different]} {
            error "$composite::($this,_derived): unknown option \"$option\""
        }
        if {$different} {
            set composite::($this,$option) $value
            set initialize($option) {}
        }
    }
    unset composite::($this,initialArguments)
    foreach option [array names initialize] {       ;# all option values are initialized before any of the set procedures are called
        $composite::($this,_derived)::set$option $this $composite::($this,$option)
    }
    set composite::($this,complete) 1
}

proc composite::cget {this args} {
    switch [llength $args] {
        0 {
            error "wrong # args: should be \"cget $this ?child? ?child? ... option\""
        }
        1 {                                                  ;# sole argument is option name, which must start with a dash character
            if {![string match -* $args]||![info exists composite::($this,$args)]} {
                error "$composite::($this,_derived): unknown option \"$args\""
            }
            return $composite::($this,$args)                                                ;# return specified option current value
        }
        default {                                                                    ;# leading arguments must be child widget names
            return [eval widget::cget $composite::($this,[lindex $args 0]) [lrange $args 1 end]]
        }
    }
}

# may be used by derived class for options that it does not implement, but no error checking here, not optimal for debugging
proc composite::try {this args} {
    if {([llength $args]%2)!=0} {
        error "value for \"[lindex $args end]\" missing"
    }
    foreach {option value} $args {                                      ;# for best results, try each option / value pair separately
        catch {widget::configure $composite::($this,base) $option $value}
        foreach child $composite::($this,_children) {
            catch {widget::configure $child $option $value}
        }
    }
}

proc composite::description {this option} {                                ;# build Tk widget like specified option description list
    foreach description [options $this] {
        if {[string compare [lindex $description 0] $option]==0} {
            if {[llength $description]<5} {                                                                      ;# no initial value
                lappend description $composite::($this,$option)                                              ;# append current value
                return $description
            } else {
                return [lreplace $description 4 4 $composite::($this,$option)]                                  ;# set current value
            }
        }
    }
}

proc composite::descriptions {this} {                     ;# build Tk widget like option descriptions list for all supported options
    set descriptions {}
    foreach description [options $this] {
        if {[llength $description]<5} {                                                                          ;# no initial value
            lappend description $composite::($this,[lindex $description 0])                                  ;# append current value
            lappend descriptions $description
        } else {
            lappend descriptions [lreplace $description 4 4 $composite::($this,[lindex $description 0])]        ;# set current value
        }
    }
    return $descriptions
}

proc composite::managingOrder {this name1 name2} {    ;# sort command: returns a negative value if first widget is older than second
    return [expr {$composite::($this,$name1)-$composite::($this,$name2)}]
}

proc composite::componentNames {this} {                                                  ;# return component names in managing order
    set names {}
    foreach index [array names composite:: $this,*,path] {
        if {[regexp {,(.+),path} $index dummy name]} {
            lappend names $name
        }
    }
    return [lsort -command "managingOrder $this" $names]
}
