set rcsId {$Id: widgetip.tcl,v 1.33 1998/10/30 20:48:10 jfontain Exp $}

class widgetTip {

    class topLabel {

        proc topLabel {this parentPath args} composite {
            [new toplevel $parentPath -highlightbackground black -highlightthickness 1] $args
        } {
            composite::manage $this [new label $widget::($this,path)] label
            composite::complete $this
            pack $composite::($this,label,path)
            wm overrideredirect $widget::($this,path) 1                                             ;# no window manager decorations
        }

        proc ~topLabel {this} {}

        proc options {this} {
            return [list\
                [list -bordercolor borderColor BorderColor Black Black]\
                [list -borderwidth borderWidth BorderWidth 1 1]\
                [list\
                    -background background Background\
                    $widget::(default,ButtonBackgroundColor) $widget::(default,ButtonBackgroundColor)\
                ]\
                [list -font font Font $widget::(default,ButtonFont) $widget::(default,ButtonFont)]\
                [list -foreground foreground Foreground $widget::(default,ButtonForeground) $widget::(default,ButtonForeground)]\
                [list -text text Text {} {}]\
            ]
        }

        foreach option {-background -font -foreground -text} {
            proc set$option {this value} "\$composite::(\$this,label,path) configure $option \$value"
        }

        proc set-bordercolor {this value} {
            $widget::($this,path) configure -highlightbackground $value
        }

        proc set-borderwidth {this value} {
            $widget::($this,path) configure -highlightthickness $value
        }
    }

    if {![info exists widgetTip::(label)]} {
        set widgetTip::(label) [new topLabel . -font $widget::(default,EntryFont) -background #FFFFBF]
        set widgetTip::(path) $widget::($widgetTip::(label),path)
        wm withdraw $widgetTip::(path)
        # handle button and key presses as global events for some child widgets (such as entries) do not pass them to their parent
        bind all <ButtonPress> {widgetTip::globalEvent %W}
        bind all <KeyPress> {widgetTip::globalEvent %W}
        set widgetTip::(xLast) -1
        set widgetTip::(yLast) -1
    }

    proc widgetTip {this args} switched {$args} {
        switched::complete $this
    }

    proc ~widgetTip {this} {
        disable $this
        if {[info exists widgetTip::($this,bindings)]} {                                               ;# eventually remove bindings
            delete $widgetTip::($this,bindings)
        }
    }

    proc options {this} {
        return [list\
            [list -font $widget::(default,EntryFont) $widget::(default,EntryFont)]\
            [list -path {} {}]\
            [list -text {} {}]\
        ]
    }

    proc set-path {this value} {
        if {$switched::($this,complete)} {
            error {option -path cannot be set dynamically}
        }
        if {![winfo exists $value]} {
            error "invalid widget: \"$value\""
        }
        set bindings [new bindings $value 0]
        bindings::set $bindings <Enter> "widgetTip::enable $this"
        bindings::set $bindings <Leave> "widgetTip::disable $this"
        set widgetTip::($this,bindings) $bindings
    }

    proc set-font {this value} {}                                                  ;# nothing to do, data is saved at switched level
    proc set-text {this value} {}

    proc globalEvent {widget} {
        if {![catch {string first $switched::($widgetTip::(active),-path) $widget} value]&&($value==0)} {
            disable $widgetTip::(active)             ;# hide if active widget exists and is a descendant of the active target widget
        }
    }

    proc show {this x y} {
        set path $widgetTip::(path)
        widget::configure $widgetTip::(label) -font $switched::($this,-font) -text $switched::($this,-text)      ;# update tip label
        showTopLevel $path +$x+$y
        update idletasks
        raise $path
    }

    proc enable {this} {
        set x [winfo pointerx $widgetTip::(path)]
        set y [winfo pointery $widgetTip::(path)]
        if {($x==$widgetTip::(xLast))&&($y==$widgetTip::(yLast))} {
            widgetTip::show $this [expr {$x+7}] [expr {$y+10}]
        } else {
            set widgetTip::(xLast) $x
            set widgetTip::(yLast) $y
            set widgetTip::(event) [after 300 "widgetTip::enable $this"]                                                     ;# poll
        }
        set widgetTip::(active) $this                                                                      ;# remember active object
    }

    proc disable {this} {
        # event and active tip may no longer exist when the pointer leaves after a click (for example)
        catch {after cancel $widgetTip::(event)}
        catch {unset widgetTip::(active)}
        wm withdraw $widgetTip::(path)
    }

}
