/* 
 * tclWinEntry.c --
 *
 *    This procedure provides the entry point for the dll
 *
 */

#include "tclWinInt.h"

/*
 * VC++ has an alternate entry point called DllMain, so we need to rename
 * our entry point.
 */

#if defined(_MSC_VER) || defined(__GNUC__)
#  define DllEntryPoint DllMain
#endif

static int		tclProcessesAttached = 0;


/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This routine is called by the VC++ C run time library init
 *	code, or the Borland initialization routine.  It is responsible
 *	for initializing various dynamically loaded libraries.
 *	With VC++ and GNUC, it is renamed to DllMain
 *
 * Results:
 *	TRUE on sucess, FALSE on failure.
 *
 * Side effects:
 *	Establishes 32-to-16 bit thunk and initializes sockets library.
 *
 *----------------------------------------------------------------------
 */

BOOL APIENTRY
DllEntryPoint(hInst, reason, reserved)
    HINSTANCE hInst;		/* Library instance handle. */
    DWORD reason;		/* Reason this function is being called. */
    LPVOID reserved;		/* Not used. */
{
    switch (reason) {
    case DLL_PROCESS_ATTACH:
	if (tclProcessesAttached++) {
	    return FALSE;         /* Not the first initialization. */
	}

	TclWinInit(hInst);
	return TRUE;

    case DLL_PROCESS_DETACH:

	tclProcessesAttached--;
	if (tclProcessesAttached == 0) {
            Tcl_Finalize();
	}
	break;
    }

    return TRUE; 
}
