/*
 *	tclWinEntry.c
 */

#include <tclWinInt.h>

#if defined(_MSC_VER) || defined(__GNUC__)
#define DllEntryPoint DllMain
#endif


/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This routine is called by Borland to invoke the
 *	initialization code for the library.
 *      VC++, gcc en egcs rename it to DllMain.
 *
 * Results:
 *	TRUE.
 *
 * Side effects:
 *	See DllMain.
 *
 *----------------------------------------------------------------------
 */

BOOL APIENTRY
DllEntryPoint(
    HINSTANCE hInst,		/* Library instance handle. */
    DWORD reason,		/* Reason this function is being called. */
    LPVOID reserved)		/* Not used. */
{
    switch (reason) {
    case DLL_PROCESS_ATTACH:
	if (TclWinGetTclInstance() != NULL) {
	    /*
	     * Prevents DLL from being loaded multiple times under Win32s,
	     * since all copies of the DLL share the same data segment and
	     * Tcl isn't set up to handle that.  Under NT or 95, each time 
	     * the DLL is loaded, it gets its own private copy of the data 
	     * segment.
	     */

	    return FALSE;
	}

	TclWinInit(hInst);
	return TRUE;

    case DLL_PROCESS_DETACH:
	if (hInst == TclWinGetTclInstance()) {
	    Tcl_Finalize();
	}
	break;
    }

    return TRUE; 
}
