/* 
 * tclLoadNone.c --
 *
 *	This procedure provides a version of the TclLoadFile for use
 *	in systems that don't support dynamic loading; it just returns
 *	an error.
 *
 * Copyright (c) 1995-1997 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tclLoadNone.c,v 1.4 1999/05/07 20:07:40 stanton Exp $
 */

#include "tclInt.h"
#include "../compat/dlfcn.h"


/*
 *----------------------------------------------------------------------
 *
 * dlopen  --
 * dlsym   --
 * dlerror --
 * dlclose --
 *
 *	Dummy functions, in case our system doesn't support
 *	dynamic loading.
 *
 * Results:
 *	NULL for dlopen() and dlsym(). Error for other functions.
 *
 * Side effects:
 *	None
 *
 *----------------------------------------------------------------------
 */

VOID *dlopen(path, mode)
    CONST char *path;
    int mode;
{
    return (VOID *) NULL;
}

VOID *dlsym(handle, symbol)
    VOID *handle;
    CONST char *symbol;
{
    return (VOID *) NULL;
}

char *dlerror() {
    return "dynamic loading is not currently available on this system";
}
  
! int dlclose(handle)
!     VOID *handle;
  {
!     return -1;
  }
