# $Id: tcltk.spec,v 1.12 2000/03/05 21:40:23 jfontain Exp $

%define version 8.3.0
%define directory /opt/tcltk

Summary: Tcl/Tk scripting language development environment
Name: tcltk
Version: %{version}
Release: 1
Copyright: BSD
Group: Development/Languages
Source0: ftp://ftp.scriptics.com/pub/tcl/tcl8_3/tcl%{version}.tar.gz
Source1: ftp://ftp.scriptics.com/pub/tcl/tcl8_3/tk%{version}.tar.gz
Patch: ftp://ftp.neosoft.com/pub/tcl/sorted/packages-8.0/devel/tcl8.3.0plus.patch.gz
URL: http://www.scriptics.com/
Packager: Jean-Luc Fontaine <jfontain@multimania.com>
Buildroot: /var/tmp/%{name}%{version}
BuildRequires: XFree86-libs >= 3.3.3, XFree86-devel >= 3.3.3

%description
The Tcl (Tool Command Language) provides a powerful platform for
creating integration applications that tie together diverse
applications, protocols, devices, and frameworks.  When paired with
the Tk toolkit, Tcl provides the fastest and most powerful way to
create GUI applications that run on PCs, Unix, and the Macintosh.  Tcl
can also be used for a variety of web-related tasks and for creating
powerful command languages for applications.

%package -n tcl
Summary: The Tcl embeddable scripting language.
Group: Development/Languages
%description -n tcl
The Tcl (Tool Command Language) provides a powerful platform for
creating integration applications that tie together diverse
applications, protocols, devices, and frameworks.  When paired with
the Tk toolkit, Tcl provides the fastest and most powerful way to
create GUI applications that run on PCs, Unix, and the Macintosh.  Tcl
can also be used for a variety of web-related tasks and for creating
powerful command languages for applications.

%package -n tk
Summary: The Tk GUI toolkit for Tcl.
Group: Development/Languages
Requires: tcl = %{version}, XFree86-libs >= 3.3
%description -n tk
The Tk (ToolKit) toolkit for the Tcl scripting language. Provides the
fastest and most powerful way to create GUI applications that run on
PCs, Unix, and the Macintosh.

%prep

%setup -q -c -a 1
cd tcl%{version}
%patch -p 0

%build
cd tcl%{version}/unix
sed -e 's/-Wall -Wconversion -Wno-implicit-int//;' configure > $$ && mv $$ configure && chmod 755 configure
./configure --prefix %{directory} --exec-prefix %{directory}
make CFLAGS=$RPM_OPT_FLAGS
cd ../..
cd tk%{version}/unix
sed -e 's/-Wall -Wconversion -Wno-implicit-int//;' configure > $$ && mv $$ configure && chmod 755 configure
./configure --prefix %{directory} --exec-prefix %{directory}
make CFLAGS=$RPM_OPT_FLAGS

%install
cd tcl%{version}/unix
make INSTALL_ROOT=$RPM_BUILD_ROOT install
cd ../..
cd tk%{version}/unix
make INSTALL_ROOT=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

# to create the files list for tcl, comment out tk in the install section above,
# then run "rpm -bi" then do a find from the build root directory,
# and remove the files in specific directories which suffice by themselves,
# then to create the files list for tk, uncomment tk, comment out tcl,
# then rm -rf $RPM_BUILD_ROOT then rpm --short-circuit -bi then redo a find,
# and remove the files in specific directories which suffice by themselves.
%files -n tcl
%defattr(-,root,root)
%{directory}/lib/tcl8.3
%{directory}/lib/libtcl8.3.so
%{directory}/lib/tclConfig.sh
%{directory}/lib/libtclstub8.3.a
%{directory}/bin/tclsh8.3
%{directory}/include/tcl.h
%{directory}/include/tclDecls.h
%{directory}/man/man1/tclsh.1
%{directory}/man/man3/Access.3
%{directory}/man/man3/AddErrInfo.3
%{directory}/man/man3/Alloc.3
%{directory}/man/man3/AllowExc.3
%{directory}/man/man3/AppInit.3
%{directory}/man/man3/AssocData.3
%{directory}/man/man3/Async.3
%{directory}/man/man3/BackgdErr.3
%{directory}/man/man3/Backslash.3
%{directory}/man/man3/BoolObj.3
%{directory}/man/man3/ByteArrObj.3
%{directory}/man/man3/CallDel.3
%{directory}/man/man3/ChnlStack.3
%{directory}/man/man3/CmdCmplt.3
%{directory}/man/man3/Concat.3
%{directory}/man/man3/CrtChannel.3
%{directory}/man/man3/CrtChnlHdlr.3
%{directory}/man/man3/CrtCloseHdlr.3
%{directory}/man/man3/CrtCommand.3
%{directory}/man/man3/CrtFileHdlr.3
%{directory}/man/man3/CrtInterp.3
%{directory}/man/man3/CrtMathFnc.3
%{directory}/man/man3/CrtObjCmd.3
%{directory}/man/man3/CrtSlave.3
%{directory}/man/man3/CrtTimerHdlr.3
%{directory}/man/man3/CrtTrace.3
%{directory}/man/man3/DString.3
%{directory}/man/man3/DetachPids.3
%{directory}/man/man3/DoOneEvent.3
%{directory}/man/man3/DoWhenIdle.3
%{directory}/man/man3/DoubleObj.3
%{directory}/man/man3/Encoding.3
%{directory}/man/man3/Eval.3
%{directory}/man/man3/Exit.3
%{directory}/man/man3/ExprLong.3
%{directory}/man/man3/ExprLongObj.3
%{directory}/man/man3/FindExec.3
%{directory}/man/man3/GetCwd.3
%{directory}/man/man3/GetHostName.3
%{directory}/man/man3/GetIndex.3
%{directory}/man/man3/GetInt.3
%{directory}/man/man3/GetOpnFl.3
%{directory}/man/man3/GetStdChan.3
%{directory}/man/man3/GetVersion.3
%{directory}/man/man3/Hash.3
%{directory}/man/man3/InitStubs.3
%{directory}/man/man3/IntObj.3
%{directory}/man/man3/Interp.3
%{directory}/man/man3/LinkVar.3
%{directory}/man/man3/ListObj.3
%{directory}/man/man3/Notifier.3
%{directory}/man/man3/Object.3
%{directory}/man/man3/ObjectType.3
%{directory}/man/man3/OpenFileChnl.3
%{directory}/man/man3/OpenTcp.3
%{directory}/man/man3/ParseCmd.3
%{directory}/man/man3/PkgRequire.3
%{directory}/man/man3/Preserve.3
%{directory}/man/man3/PrintDbl.3
%{directory}/man/man3/RecEvalObj.3
%{directory}/man/man3/RecordEval.3
%{directory}/man/man3/RegExp.3
%{directory}/man/man3/SaveResult.3
%{directory}/man/man3/SetErrno.3
%{directory}/man/man3/SetRecLmt.3
%{directory}/man/man3/SetResult.3
%{directory}/man/man3/SetVar.3
%{directory}/man/man3/Sleep.3
%{directory}/man/man3/SplitList.3
%{directory}/man/man3/SplitPath.3
%{directory}/man/man3/StaticPkg.3
%{directory}/man/man3/StrMatch.3
%{directory}/man/man3/StringObj.3
%{directory}/man/man3/Tcl_Main.3
%{directory}/man/man3/Thread.3
%{directory}/man/man3/ToUpper.3
%{directory}/man/man3/TraceVar.3
%{directory}/man/man3/Translate.3
%{directory}/man/man3/UpVar.3
%{directory}/man/man3/Utf.3
%{directory}/man/man3/WrongNumArgs.3
%{directory}/man/man3/Tcl_Access.3
%{directory}/man/man3/Tcl_Stat.3
%{directory}/man/man3/Tcl_AddObjErrorInfo.3
%{directory}/man/man3/Tcl_AddErrorInfo.3
%{directory}/man/man3/Tcl_SetErrorCode.3
%{directory}/man/man3/Tcl_SetErrorCodeVA.3
%{directory}/man/man3/Tcl_PosixError.3
%{directory}/man/man3/Tcl_Alloc.3
%{directory}/man/man3/Tcl_Free.3
%{directory}/man/man3/Tcl_Realloc.3
%{directory}/man/man3/Tcl_AllowExceptions.3
%{directory}/man/man3/Tcl_AppInit.3
%{directory}/man/man3/Tcl_GetAssocData.3
%{directory}/man/man3/Tcl_SetAssocData.3
%{directory}/man/man3/Tcl_DeleteAssocData.3
%{directory}/man/man3/Tcl_AsyncCreate.3
%{directory}/man/man3/Tcl_AsyncMark.3
%{directory}/man/man3/Tcl_AsyncInvoke.3
%{directory}/man/man3/Tcl_AsyncDelete.3
%{directory}/man/man3/Tcl_AsyncReady.3
%{directory}/man/man3/Tcl_BackgroundError.3
%{directory}/man/man3/Tcl_Backslash.3
%{directory}/man/man3/Tcl_NewBooleanObj.3
%{directory}/man/man3/Tcl_SetBooleanObj.3
%{directory}/man/man3/Tcl_GetBooleanFromObj.3
%{directory}/man/man3/Tcl_NewByteArrayObj.3
%{directory}/man/man3/Tcl_SetByteArrayObj.3
%{directory}/man/man3/Tcl_GetByteArrayFromObj.3
%{directory}/man/man3/Tcl_SetByteArrayLength.3
%{directory}/man/man3/Tcl_CallWhenDeleted.3
%{directory}/man/man3/Tcl_DontCallWhenDeleted.3
%{directory}/man/man3/Tcl_StackChannel.3
%{directory}/man/man3/Tcl_UnstackChannel.3
%{directory}/man/man3/Tcl_CommandComplete.3
%{directory}/man/man3/Tcl_Concat.3
%{directory}/man/man3/Tcl_CreateChannel.3
%{directory}/man/man3/Tcl_GetChannelInstanceData.3
%{directory}/man/man3/Tcl_GetChannelType.3
%{directory}/man/man3/Tcl_GetChannelName.3
%{directory}/man/man3/Tcl_GetChannelHandle.3
%{directory}/man/man3/Tcl_GetChannelMode.3
%{directory}/man/man3/Tcl_GetChannelBufferSize.3
%{directory}/man/man3/Tcl_SetChannelBufferSize.3
%{directory}/man/man3/Tcl_NotifyChannel.3
%{directory}/man/man3/Tcl_BadChannelOption.3
%{directory}/man/man3/Tcl_CreateChannelHandler.3
%{directory}/man/man3/Tcl_DeleteChannelHandler.3
%{directory}/man/man3/Tcl_CreateCloseHandler.3
%{directory}/man/man3/Tcl_DeleteCloseHandler.3
%{directory}/man/man3/Tcl_CreateCommand.3
%{directory}/man/man3/Tcl_CreateFileHandler.3
%{directory}/man/man3/Tcl_DeleteFileHandler.3
%{directory}/man/man3/Tcl_CreateInterp.3
%{directory}/man/man3/Tcl_DeleteInterp.3
%{directory}/man/man3/Tcl_InterpDeleted.3
%{directory}/man/man3/Tcl_CreateMathFunc.3
%{directory}/man/man3/Tcl_CreateObjCommand.3
%{directory}/man/man3/Tcl_DeleteCommand.3
%{directory}/man/man3/Tcl_DeleteCommandFromToken.3
%{directory}/man/man3/Tcl_GetCommandInfo.3
%{directory}/man/man3/Tcl_SetCommandInfo.3
%{directory}/man/man3/Tcl_GetCommandName.3
%{directory}/man/man3/Tcl_IsSafe.3
%{directory}/man/man3/Tcl_MakeSafe.3
%{directory}/man/man3/Tcl_CreateSlave.3
%{directory}/man/man3/Tcl_GetSlave.3
%{directory}/man/man3/Tcl_GetMaster.3
%{directory}/man/man3/Tcl_GetInterpPath.3
%{directory}/man/man3/Tcl_CreateAlias.3
%{directory}/man/man3/Tcl_CreateAliasObj.3
%{directory}/man/man3/Tcl_GetAlias.3
%{directory}/man/man3/Tcl_GetAliasObj.3
%{directory}/man/man3/Tcl_ExposeCommand.3
%{directory}/man/man3/Tcl_HideCommand.3
%{directory}/man/man3/Tcl_CreateTimerHandler.3
%{directory}/man/man3/Tcl_DeleteTimerHandler.3
%{directory}/man/man3/Tcl_CreateTrace.3
%{directory}/man/man3/Tcl_DeleteTrace.3
%{directory}/man/man3/Tcl_DStringInit.3
%{directory}/man/man3/Tcl_DStringAppend.3
%{directory}/man/man3/Tcl_DStringAppendElement.3
%{directory}/man/man3/Tcl_DStringStartSublist.3
%{directory}/man/man3/Tcl_DStringEndSublist.3
%{directory}/man/man3/Tcl_DStringLength.3
%{directory}/man/man3/Tcl_DStringValue.3
%{directory}/man/man3/Tcl_DStringSetLength.3
%{directory}/man/man3/Tcl_DStringFree.3
%{directory}/man/man3/Tcl_DStringResult.3
%{directory}/man/man3/Tcl_DStringGetResult.3
%{directory}/man/man3/Tcl_DetachPids.3
%{directory}/man/man3/Tcl_ReapDetachedProcs.3
%{directory}/man/man3/Tcl_DoOneEvent.3
%{directory}/man/man3/Tcl_DoWhenIdle.3
%{directory}/man/man3/Tcl_CancelIdleCall.3
%{directory}/man/man3/Tcl_NewDoubleObj.3
%{directory}/man/man3/Tcl_SetDoubleObj.3
%{directory}/man/man3/Tcl_GetDoubleFromObj.3
%{directory}/man/man3/Tcl_GetEncoding.3
%{directory}/man/man3/Tcl_FreeEncoding.3
%{directory}/man/man3/Tcl_ExternalToUtfDString.3
%{directory}/man/man3/Tcl_ExternalToUtf.3
%{directory}/man/man3/Tcl_UtfToExternalDString.3
%{directory}/man/man3/Tcl_UtfToExternal.3
%{directory}/man/man3/Tcl_WinTCharToUtf.3
%{directory}/man/man3/Tcl_WinUtfToTChar.3
%{directory}/man/man3/Tcl_GetEncodingName.3
%{directory}/man/man3/Tcl_SetSystemEncoding.3
%{directory}/man/man3/Tcl_GetEncodingNames.3
%{directory}/man/man3/Tcl_CreateEncoding.3
%{directory}/man/man3/Tcl_GetDefaultEncodingDir.3
%{directory}/man/man3/Tcl_SetDefaultEncodingDir.3
%{directory}/man/man3/Tcl_EvalObjEx.3
%{directory}/man/man3/Tcl_EvalFile.3
%{directory}/man/man3/Tcl_EvalObjv.3
%{directory}/man/man3/Tcl_Eval.3
%{directory}/man/man3/Tcl_EvalEx.3
%{directory}/man/man3/Tcl_GlobalEval.3
%{directory}/man/man3/Tcl_GlobalEvalObj.3
%{directory}/man/man3/Tcl_VarEval.3
%{directory}/man/man3/Tcl_VarEvalVA.3
%{directory}/man/man3/Tcl_Exit.3
%{directory}/man/man3/Tcl_Finalize.3
%{directory}/man/man3/Tcl_FinalizeThread.3
%{directory}/man/man3/Tcl_CreateExitHandler.3
%{directory}/man/man3/Tcl_DeleteExitHandler.3
%{directory}/man/man3/Tcl_CreateThreadExitHandler.3
%{directory}/man/man3/Tcl_DeleteThreadExitHandler.3
%{directory}/man/man3/Tcl_ExprLong.3
%{directory}/man/man3/Tcl_ExprDouble.3
%{directory}/man/man3/Tcl_ExprBoolean.3
%{directory}/man/man3/Tcl_ExprString.3
%{directory}/man/man3/Tcl_ExprLongObj.3
%{directory}/man/man3/Tcl_ExprDoubleObj.3
%{directory}/man/man3/Tcl_ExprBooleanObj.3
%{directory}/man/man3/Tcl_ExprObj.3
%{directory}/man/man3/Tcl_FindExecutable.3
%{directory}/man/man3/Tcl_GetNameOfExecutable.3
%{directory}/man/man3/Tcl_GetCwd.3
%{directory}/man/man3/Tcl_Chdir.3
%{directory}/man/man3/Tcl_GetHostName.3
%{directory}/man/man3/Tcl_GetIndexFromObj.3
%{directory}/man/man3/Tcl_GetInt.3
%{directory}/man/man3/Tcl_GetDouble.3
%{directory}/man/man3/Tcl_GetBoolean.3
%{directory}/man/man3/Tcl_GetOpenFile.3
%{directory}/man/man3/Tcl_GetStdChannel.3
%{directory}/man/man3/Tcl_SetStdChannel.3
%{directory}/man/man3/Tcl_GetVersion.3
%{directory}/man/man3/Tcl_InitHashTable.3
%{directory}/man/man3/Tcl_DeleteHashTable.3
%{directory}/man/man3/Tcl_CreateHashEntry.3
%{directory}/man/man3/Tcl_DeleteHashEntry.3
%{directory}/man/man3/Tcl_FindHashEntry.3
%{directory}/man/man3/Tcl_GetHashValue.3
%{directory}/man/man3/Tcl_SetHashValue.3
%{directory}/man/man3/Tcl_GetHashKey.3
%{directory}/man/man3/Tcl_FirstHashEntry.3
%{directory}/man/man3/Tcl_NextHashEntry.3
%{directory}/man/man3/Tcl_HashStats.3
%{directory}/man/man3/Tcl_InitStubs.3
%{directory}/man/man3/Tcl_NewIntObj.3
%{directory}/man/man3/Tcl_NewLongObj.3
%{directory}/man/man3/Tcl_SetIntObj.3
%{directory}/man/man3/Tcl_SetLongObj.3
%{directory}/man/man3/Tcl_GetIntFromObj.3
%{directory}/man/man3/Tcl_GetLongFromObj.3
%{directory}/man/man3/Tcl_Interp.3
%{directory}/man/man3/Tcl_LinkVar.3
%{directory}/man/man3/Tcl_UnlinkVar.3
%{directory}/man/man3/Tcl_UpdateLinkedVar.3
%{directory}/man/man3/Tcl_ListObjAppendList.3
%{directory}/man/man3/Tcl_ListObjAppendElement.3
%{directory}/man/man3/Tcl_NewListObj.3
%{directory}/man/man3/Tcl_SetListObj.3
%{directory}/man/man3/Tcl_ListObjGetElements.3
%{directory}/man/man3/Tcl_ListObjLength.3
%{directory}/man/man3/Tcl_ListObjIndex.3
%{directory}/man/man3/Tcl_ListObjReplace.3
%{directory}/man/man3/Tcl_CreateEventSource.3
%{directory}/man/man3/Tcl_DeleteEventSource.3
%{directory}/man/man3/Tcl_SetMaxBlockTime.3
%{directory}/man/man3/Tcl_QueueEvent.3
%{directory}/man/man3/Tcl_ThreadQueueEvent.3
%{directory}/man/man3/Tcl_ThreadAlert.3
%{directory}/man/man3/Tcl_GetCurrentThread.3
%{directory}/man/man3/Tcl_DeleteEvents.3
%{directory}/man/man3/Tcl_InitNotifier.3
%{directory}/man/man3/Tcl_FinalizeNotifier.3
%{directory}/man/man3/Tcl_WaitForEvent.3
%{directory}/man/man3/Tcl_AlertNotifier.3
%{directory}/man/man3/Tcl_SetTimer.3
%{directory}/man/man3/Tcl_ServiceAll.3
%{directory}/man/man3/Tcl_ServiceEvent.3
%{directory}/man/man3/Tcl_GetServiceMode.3
%{directory}/man/man3/Tcl_SetServiceMode.3
%{directory}/man/man3/Tcl_NewObj.3
%{directory}/man/man3/Tcl_DuplicateObj.3
%{directory}/man/man3/Tcl_IncrRefCount.3
%{directory}/man/man3/Tcl_DecrRefCount.3
%{directory}/man/man3/Tcl_IsShared.3
%{directory}/man/man3/Tcl_RegisterObjType.3
%{directory}/man/man3/Tcl_GetObjType.3
%{directory}/man/man3/Tcl_AppendAllObjTypes.3
%{directory}/man/man3/Tcl_ConvertToType.3
%{directory}/man/man3/Tcl_OpenFileChannel.3
%{directory}/man/man3/Tcl_OpenCommandChannel.3
%{directory}/man/man3/Tcl_MakeFileChannel.3
%{directory}/man/man3/Tcl_GetChannel.3
%{directory}/man/man3/Tcl_GetChannelNames.3
%{directory}/man/man3/Tcl_GetChannelNamesEx.3
%{directory}/man/man3/Tcl_RegisterChannel.3
%{directory}/man/man3/Tcl_UnregisterChannel.3
%{directory}/man/man3/Tcl_Close.3
%{directory}/man/man3/Tcl_ReadChars.3
%{directory}/man/man3/Tcl_Read.3
%{directory}/man/man3/Tcl_GetsObj.3
%{directory}/man/man3/Tcl_Gets.3
%{directory}/man/man3/Tcl_WriteObj.3
%{directory}/man/man3/Tcl_WriteChars.3
%{directory}/man/man3/Tcl_Write.3
%{directory}/man/man3/Tcl_Flush.3
%{directory}/man/man3/Tcl_Seek.3
%{directory}/man/man3/Tcl_Tell.3
%{directory}/man/man3/Tcl_GetChannelOption.3
%{directory}/man/man3/Tcl_SetChannelOption.3
%{directory}/man/man3/Tcl_Eof.3
%{directory}/man/man3/Tcl_InputBlocked.3
%{directory}/man/man3/Tcl_InputBuffered.3
%{directory}/man/man3/Tcl_OpenTcpClient.3
%{directory}/man/man3/Tcl_MakeTcpClientChannel.3
%{directory}/man/man3/Tcl_OpenTcpServer.3
%{directory}/man/man3/Tcl_ParseCommand.3
%{directory}/man/man3/Tcl_ParseExpr.3
%{directory}/man/man3/Tcl_ParseBraces.3
%{directory}/man/man3/Tcl_ParseVarName.3
%{directory}/man/man3/Tcl_ParseQuotedString.3
%{directory}/man/man3/Tcl_FreeParse.3
%{directory}/man/man3/Tcl_EvalTokens.3
%{directory}/man/man3/Tcl_PkgRequire.3
%{directory}/man/man3/Tcl_PkgRequireEx.3
%{directory}/man/man3/Tcl_PkgPresent.3
%{directory}/man/man3/Tcl_PkgPresentEx.3
%{directory}/man/man3/Tcl_PkgProvide.3
%{directory}/man/man3/Tcl_PkgProvideEx.3
%{directory}/man/man3/Tcl_Preserve.3
%{directory}/man/man3/Tcl_Release.3
%{directory}/man/man3/Tcl_EventuallyFree.3
%{directory}/man/man3/Tcl_PrintDouble.3
%{directory}/man/man3/Tcl_RecordAndEvalObj.3
%{directory}/man/man3/Tcl_RecordAndEval.3
%{directory}/man/man3/Tcl_RegExpMatch.3
%{directory}/man/man3/Tcl_RegExpCompile.3
%{directory}/man/man3/Tcl_RegExpExec.3
%{directory}/man/man3/Tcl_RegExpRange.3
%{directory}/man/man3/Tcl_GetRegExpFromObj.3
%{directory}/man/man3/Tcl_RegExpMatchObj.3
%{directory}/man/man3/Tcl_GetRegExpInfo.3
%{directory}/man/man3/Tcl_SaveResult.3
%{directory}/man/man3/Tcl_RestoreResult.3
%{directory}/man/man3/Tcl_DiscardResult.3
%{directory}/man/man3/Tcl_SetErrno.3
%{directory}/man/man3/Tcl_GetErrno.3
%{directory}/man/man3/Tcl_ErrnoId.3
%{directory}/man/man3/Tcl_ErrnoMsg.3
%{directory}/man/man3/Tcl_SetRecursionLimit.3
%{directory}/man/man3/Tcl_SetObjResult.3
%{directory}/man/man3/Tcl_GetObjResult.3
%{directory}/man/man3/Tcl_SetResult.3
%{directory}/man/man3/Tcl_GetStringResult.3
%{directory}/man/man3/Tcl_AppendResult.3
%{directory}/man/man3/Tcl_AppendResultVA.3
%{directory}/man/man3/Tcl_AppendElement.3
%{directory}/man/man3/Tcl_ResetResult.3
%{directory}/man/man3/Tcl_SetVar2Ex.3
%{directory}/man/man3/Tcl_SetVar.3
%{directory}/man/man3/Tcl_SetVar2.3
%{directory}/man/man3/Tcl_ObjSetVar2.3
%{directory}/man/man3/Tcl_GetVar2Ex.3
%{directory}/man/man3/Tcl_GetVar.3
%{directory}/man/man3/Tcl_GetVar2.3
%{directory}/man/man3/Tcl_ObjGetVar2.3
%{directory}/man/man3/Tcl_UnsetVar.3
%{directory}/man/man3/Tcl_UnsetVar2.3
%{directory}/man/man3/Tcl_Sleep.3
%{directory}/man/man3/Tcl_SplitList.3
%{directory}/man/man3/Tcl_Merge.3
%{directory}/man/man3/Tcl_ScanElement.3
%{directory}/man/man3/Tcl_ConvertElement.3
%{directory}/man/man3/Tcl_SplitPath.3
%{directory}/man/man3/Tcl_JoinPath.3
%{directory}/man/man3/Tcl_GetPathType.3
%{directory}/man/man3/Tcl_StaticPackage.3
%{directory}/man/man3/Tcl_StringMatch.3
%{directory}/man/man3/Tcl_StringCaseMatch.3
%{directory}/man/man3/Tcl_NewStringObj.3
%{directory}/man/man3/Tcl_NewUnicodeObj.3
%{directory}/man/man3/Tcl_SetStringObj.3
%{directory}/man/man3/Tcl_SetUnicodeObj.3
%{directory}/man/man3/Tcl_GetStringFromObj.3
%{directory}/man/man3/Tcl_GetString.3
%{directory}/man/man3/Tcl_GetUnicode.3
%{directory}/man/man3/Tcl_GetUniChar.3
%{directory}/man/man3/Tcl_GetCharLength.3
%{directory}/man/man3/Tcl_GetRange.3
%{directory}/man/man3/Tcl_AppendToObj.3
%{directory}/man/man3/Tcl_AppendUnicodeToObj.3
%{directory}/man/man3/Tcl_AppendStringsToObj.3
%{directory}/man/man3/Tcl_AppendStringsToObjVA.3
%{directory}/man/man3/Tcl_AppendObjToObj.3
%{directory}/man/man3/Tcl_SetObjLength.3
%{directory}/man/man3/Tcl_ConcatObj.3
%{directory}/man/man3/Tcl_ConditionNotify.3
%{directory}/man/man3/Tcl_ConditionWait.3
%{directory}/man/man3/Tcl_GetThreadData.3
%{directory}/man/man3/Tcl_MutexLock.3
%{directory}/man/man3/Tcl_MutexUnlock.3
%{directory}/man/man3/Tcl_UniCharToUpper.3
%{directory}/man/man3/Tcl_UniCharToLower.3
%{directory}/man/man3/Tcl_UniCharToTitle.3
%{directory}/man/man3/Tcl_UtfToUpper.3
%{directory}/man/man3/Tcl_UtfToLower.3
%{directory}/man/man3/Tcl_UtfToTitle.3
%{directory}/man/man3/Tcl_TraceVar.3
%{directory}/man/man3/Tcl_TraceVar2.3
%{directory}/man/man3/Tcl_UntraceVar.3
%{directory}/man/man3/Tcl_UntraceVar2.3
%{directory}/man/man3/Tcl_VarTraceInfo.3
%{directory}/man/man3/Tcl_VarTraceInfo2.3
%{directory}/man/man3/Tcl_TranslateFileName.3
%{directory}/man/man3/Tcl_UpVar.3
%{directory}/man/man3/Tcl_UpVar2.3
%{directory}/man/man3/Tcl_UniChar.3
%{directory}/man/man3/Tcl_UniCharToUtf.3
%{directory}/man/man3/Tcl_UtfToUniChar.3
%{directory}/man/man3/Tcl_UniCharToUtfDString.3
%{directory}/man/man3/Tcl_UtfToUniCharDString.3
%{directory}/man/man3/Tcl_UniCharLen.3
%{directory}/man/man3/Tcl_UniCharNcmp.3
%{directory}/man/man3/Tcl_UtfCharComplete.3
%{directory}/man/man3/Tcl_NumUtfChars.3
%{directory}/man/man3/Tcl_UtfFindFirst.3
%{directory}/man/man3/Tcl_UtfFindLast.3
%{directory}/man/man3/Tcl_UtfNext.3
%{directory}/man/man3/Tcl_UtfPrev.3
%{directory}/man/man3/Tcl_UniCharAtIndex.3
%{directory}/man/man3/Tcl_UtfAtIndex.3
%{directory}/man/man3/Tcl_UtfBackslash.3
%{directory}/man/man3/Tcl_WrongNumArgs.3
%{directory}/man/mann/Tcl.n
%{directory}/man/mann/after.n
%{directory}/man/mann/append.n
%{directory}/man/mann/array.n
%{directory}/man/mann/bgerror.n
%{directory}/man/mann/binary.n
%{directory}/man/mann/break.n
%{directory}/man/mann/case.n
%{directory}/man/mann/catch.n
%{directory}/man/mann/cd.n
%{directory}/man/mann/clock.n
%{directory}/man/mann/close.n
%{directory}/man/mann/concat.n
%{directory}/man/mann/continue.n
%{directory}/man/mann/dde.n
%{directory}/man/mann/encoding.n
%{directory}/man/mann/eof.n
%{directory}/man/mann/error.n
%{directory}/man/mann/eval.n
%{directory}/man/mann/exec.n
%{directory}/man/mann/exit.n
%{directory}/man/mann/expr.n
%{directory}/man/mann/fblocked.n
%{directory}/man/mann/fconfigure.n
%{directory}/man/mann/fcopy.n
%{directory}/man/mann/file.n
%{directory}/man/mann/fileevent.n
%{directory}/man/mann/filename.n
%{directory}/man/mann/flush.n
%{directory}/man/mann/for.n
%{directory}/man/mann/foreach.n
%{directory}/man/mann/format.n
%{directory}/man/mann/gets.n
%{directory}/man/mann/glob.n
%{directory}/man/mann/global.n
%{directory}/man/mann/history.n
%{directory}/man/mann/http.n
%{directory}/man/mann/if.n
%{directory}/man/mann/incr.n
%{directory}/man/mann/info.n
%{directory}/man/mann/interp.n
%{directory}/man/mann/join.n
%{directory}/man/mann/lappend.n
%{directory}/man/mann/library.n
%{directory}/man/mann/lindex.n
%{directory}/man/mann/linsert.n
%{directory}/man/mann/list.n
%{directory}/man/mann/llength.n
%{directory}/man/mann/load.n
%{directory}/man/mann/lrange.n
%{directory}/man/mann/lreplace.n
%{directory}/man/mann/lsearch.n
%{directory}/man/mann/lsort.n
%{directory}/man/mann/msgcat.n
%{directory}/man/mann/namespace.n
%{directory}/man/mann/open.n
%{directory}/man/mann/package.n
%{directory}/man/mann/packagens.n
%{directory}/man/mann/pid.n
%{directory}/man/mann/pkgMkIndex.n
%{directory}/man/mann/proc.n
%{directory}/man/mann/puts.n
%{directory}/man/mann/pwd.n
%{directory}/man/mann/re_syntax.n
%{directory}/man/mann/read.n
%{directory}/man/mann/regexp.n
%{directory}/man/mann/registry.n
%{directory}/man/mann/regsub.n
%{directory}/man/mann/rename.n
%{directory}/man/mann/resource.n
%{directory}/man/mann/return.n
%{directory}/man/mann/safe.n
%{directory}/man/mann/scan.n
%{directory}/man/mann/seek.n
%{directory}/man/mann/set.n
%{directory}/man/mann/socket.n
%{directory}/man/mann/source.n
%{directory}/man/mann/split.n
%{directory}/man/mann/string.n
%{directory}/man/mann/subst.n
%{directory}/man/mann/switch.n
%{directory}/man/mann/tcltest.n
%{directory}/man/mann/tclvars.n
%{directory}/man/mann/tell.n
%{directory}/man/mann/time.n
%{directory}/man/mann/trace.n
%{directory}/man/mann/unknown.n
%{directory}/man/mann/unset.n
%{directory}/man/mann/update.n
%{directory}/man/mann/uplevel.n
%{directory}/man/mann/upvar.n
%{directory}/man/mann/variable.n
%{directory}/man/mann/vwait.n
%{directory}/man/mann/while.n
%{directory}/man/mann/Http.n
%{directory}/man/mann/pkg::create.n
%{directory}/man/mann/pkg_mkIndex.n
%{directory}/man/mann/SafeBase.n
%{directory}/man/mann/Tcltest.n
%files -n tk
%defattr(-,root,root)
%{directory}/lib/tk8.3
%{directory}/lib/libtk8.3.so
%{directory}/lib/tkConfig.sh
%{directory}/lib/libtkstub8.3.a
%{directory}/bin/wish8.3
%{directory}/include/tk.h
%{directory}/include/tkDecls.h
%{directory}/man/man1/wish.1
%{directory}/man/man3/3DBorder.3
%{directory}/man/man3/BindTable.3
%{directory}/man/man3/CanvPsY.3
%{directory}/man/man3/CanvTkwin.3
%{directory}/man/man3/CanvTxtInfo.3
%{directory}/man/man3/Clipboard.3
%{directory}/man/man3/ClrSelect.3
%{directory}/man/man3/ConfigWidg.3
%{directory}/man/man3/ConfigWind.3
%{directory}/man/man3/CoordToWin.3
%{directory}/man/man3/CrtErrHdlr.3
%{directory}/man/man3/CrtGenHdlr.3
%{directory}/man/man3/CrtImgType.3
%{directory}/man/man3/CrtItemType.3
%{directory}/man/man3/CrtPhImgFmt.3
%{directory}/man/man3/CrtSelHdlr.3
%{directory}/man/man3/CrtWindow.3
%{directory}/man/man3/DeleteImg.3
%{directory}/man/man3/DrawFocHlt.3
%{directory}/man/man3/EventHndlr.3
%{directory}/man/man3/FindPhoto.3
%{directory}/man/man3/FontId.3
%{directory}/man/man3/FreeXId.3
%{directory}/man/man3/GeomReq.3
%{directory}/man/man3/GetAnchor.3
%{directory}/man/man3/GetBitmap.3
%{directory}/man/man3/GetCapStyl.3
%{directory}/man/man3/GetClrmap.3
%{directory}/man/man3/GetColor.3
%{directory}/man/man3/GetCursor.3
%{directory}/man/man3/GetDash.3
%{directory}/man/man3/GetFont.3
%{directory}/man/man3/GetGC.3
%{directory}/man/man3/GetImage.3
%{directory}/man/man3/GetJoinStl.3
%{directory}/man/man3/GetJustify.3
%{directory}/man/man3/GetOption.3
%{directory}/man/man3/GetPixels.3
%{directory}/man/man3/GetPixmap.3
%{directory}/man/man3/GetRelief.3
%{directory}/man/man3/GetRootCrd.3
%{directory}/man/man3/GetScroll.3
%{directory}/man/man3/GetSelect.3
%{directory}/man/man3/GetUid.3
%{directory}/man/man3/GetVRoot.3
%{directory}/man/man3/GetVisual.3
%{directory}/man/man3/HandleEvent.3
%{directory}/man/man3/IdToWindow.3
%{directory}/man/man3/ImgChanged.3
%{directory}/man/man3/InternAtom.3
%{directory}/man/man3/MainLoop.3
%{directory}/man/man3/MainWin.3
%{directory}/man/man3/MaintGeom.3
%{directory}/man/man3/ManageGeom.3
%{directory}/man/man3/MapWindow.3
%{directory}/man/man3/MeasureChar.3
%{directory}/man/man3/MoveToplev.3
%{directory}/man/man3/Name.3
%{directory}/man/man3/NameOfImg.3
%{directory}/man/man3/OwnSelect.3
%{directory}/man/man3/ParseArgv.3
%{directory}/man/man3/QWinEvent.3
%{directory}/man/man3/Restack.3
%{directory}/man/man3/RestrictEv.3
%{directory}/man/man3/SetAppName.3
%{directory}/man/man3/SetClass.3
%{directory}/man/man3/SetGrid.3
%{directory}/man/man3/SetOptions.3
%{directory}/man/man3/SetVisual.3
%{directory}/man/man3/StrictMotif.3
%{directory}/man/man3/TextLayout.3
%{directory}/man/man3/TkInitStubs.3
%{directory}/man/man3/Tk_Init.3
%{directory}/man/man3/Tk_Main.3
%{directory}/man/man3/WindowId.3
%{directory}/man/man3/Tk_Alloc3DBorderFromObj.3
%{directory}/man/man3/Tk_Get3DBorder.3
%{directory}/man/man3/Tk_Get3DBorderFromObj.3
%{directory}/man/man3/Tk_Draw3DRectangle.3
%{directory}/man/man3/Tk_Fill3DRectangle.3
%{directory}/man/man3/Tk_Draw3DPolygon.3
%{directory}/man/man3/Tk_Fill3DPolygon.3
%{directory}/man/man3/Tk_3DVerticalBevel.3
%{directory}/man/man3/Tk_3DHorizontalBevel.3
%{directory}/man/man3/Tk_SetBackgroundFromBorder.3
%{directory}/man/man3/Tk_NameOf3DBorder.3
%{directory}/man/man3/Tk_3DBorderColor.3
%{directory}/man/man3/Tk_3DBorderGC.3
%{directory}/man/man3/Tk_Free3DBorderFromObj.3
%{directory}/man/man3/Tk_Free3DBorder.3
%{directory}/man/man3/Tk_CreateBindingTable.3
%{directory}/man/man3/Tk_DeleteBindingTable.3
%{directory}/man/man3/Tk_CreateBinding.3
%{directory}/man/man3/Tk_DeleteBinding.3
%{directory}/man/man3/Tk_GetBinding.3
%{directory}/man/man3/Tk_GetAllBindings.3
%{directory}/man/man3/Tk_DeleteAllBindings.3
%{directory}/man/man3/Tk_BindEvent.3
%{directory}/man/man3/Tk_CanvasPsY.3
%{directory}/man/man3/Tk_CanvasPsBitmap.3
%{directory}/man/man3/Tk_CanvasPsColor.3
%{directory}/man/man3/Tk_CanvasPsFont.3
%{directory}/man/man3/Tk_CanvasPsPath.3
%{directory}/man/man3/Tk_CanvasPsStipple.3
%{directory}/man/man3/Tk_CanvasTkwin.3
%{directory}/man/man3/Tk_CanvasGetCoord.3
%{directory}/man/man3/Tk_CanvasDrawableCoords.3
%{directory}/man/man3/Tk_CanvasSetStippleOrigin.3
%{directory}/man/man3/Tk_CanvasWindowCoords.3
%{directory}/man/man3/Tk_CanvasEventuallyRedraw.3
%{directory}/man/man3/Tk_CanvasTagsOption.3
%{directory}/man/man3/Tk_CanvasTextInfo.3
%{directory}/man/man3/Tk_ClipboardClear.3
%{directory}/man/man3/Tk_ClipboardAppend.3
%{directory}/man/man3/Tk_ClearSelection.3
%{directory}/man/man3/Tk_ConfigureWidget.3
%{directory}/man/man3/Tk_Offset.3
%{directory}/man/man3/Tk_ConfigureInfo.3
%{directory}/man/man3/Tk_ConfigureValue.3
%{directory}/man/man3/Tk_FreeOptions.3
%{directory}/man/man3/Tk_ConfigureWindow.3
%{directory}/man/man3/Tk_MoveWindow.3
%{directory}/man/man3/Tk_ResizeWindow.3
%{directory}/man/man3/Tk_MoveResizeWindow.3
%{directory}/man/man3/Tk_SetWindowBorderWidth.3
%{directory}/man/man3/Tk_ChangeWindowAttributes.3
%{directory}/man/man3/Tk_SetWindowBackground.3
%{directory}/man/man3/Tk_SetWindowBackgroundPixmap.3
%{directory}/man/man3/Tk_SetWindowBorder.3
%{directory}/man/man3/Tk_SetWindowBorderPixmap.3
%{directory}/man/man3/Tk_SetWindowColormap.3
%{directory}/man/man3/Tk_DefineCursor.3
%{directory}/man/man3/Tk_UndefineCursor.3
%{directory}/man/man3/Tk_CoordsToWindow.3
%{directory}/man/man3/Tk_CreateErrorHandler.3
%{directory}/man/man3/Tk_DeleteErrorHandler.3
%{directory}/man/man3/Tk_CreateGenericHandler.3
%{directory}/man/man3/Tk_DeleteGenericHandler.3
%{directory}/man/man3/Tk_CreateImageType.3
%{directory}/man/man3/Tk_GetImageMasterData.3
%{directory}/man/man3/Tk_InitImageArgs.3
%{directory}/man/man3/Tk_CreateItemType.3
%{directory}/man/man3/Tk_GetItemTypes.3
%{directory}/man/man3/Tk_CreatePhotoImageFormat.3
%{directory}/man/man3/Tk_CreateSelHandler.3
%{directory}/man/man3/Tk_DeleteSelHandler.3
%{directory}/man/man3/Tk_CreateWindow.3
%{directory}/man/man3/Tk_CreateWindowFromPath.3
%{directory}/man/man3/Tk_DestroyWindow.3
%{directory}/man/man3/Tk_MakeWindowExist.3
%{directory}/man/man3/Tk_DeleteImage.3
%{directory}/man/man3/Tk_DrawFocusHighlight.3
%{directory}/man/man3/Tk_CreateEventHandler.3
%{directory}/man/man3/Tk_DeleteEventHandler.3
%{directory}/man/man3/Tk_FindPhoto.3
%{directory}/man/man3/Tk_PhotoPutBlock.3
%{directory}/man/man3/Tk_PhotoPutZoomedBlock.3
%{directory}/man/man3/Tk_PhotoGetImage.3
%{directory}/man/man3/Tk_PhotoBlank.3
%{directory}/man/man3/Tk_PhotoExpand.3
%{directory}/man/man3/Tk_PhotoGetSize.3
%{directory}/man/man3/Tk_FontId.3
%{directory}/man/man3/Tk_PhotoSetSize.3
%{directory}/man/man3/Tk_FontMetrics.3
%{directory}/man/man3/Tk_PostscriptFontName.3
%{directory}/man/man3/Tk_FreeXId.3
%{directory}/man/man3/Tk_GeometryRequest.3
%{directory}/man/man3/Tk_SetInternalBorder.3
%{directory}/man/man3/Tk_GetAnchorFromObj.3
%{directory}/man/man3/Tk_GetAnchor.3
%{directory}/man/man3/Tk_NameOfAnchor.3
%{directory}/man/man3/Tk_AllocBitmapFromObj.3
%{directory}/man/man3/Tk_GetBitmap.3
%{directory}/man/man3/Tk_GetBitmapFromObj.3
%{directory}/man/man3/Tk_DefineBitmap.3
%{directory}/man/man3/Tk_NameOfBitmap.3
%{directory}/man/man3/Tk_SizeOfBitmap.3
%{directory}/man/man3/Tk_FreeBitmapFromObj.3
%{directory}/man/man3/Tk_FreeBitmap.3
%{directory}/man/man3/Tk_GetBitmapFromData.3
%{directory}/man/man3/Tk_GetCapStyle.3
%{directory}/man/man3/Tk_NameOfCapStyle.3
%{directory}/man/man3/Tk_GetColormap.3
%{directory}/man/man3/Tk_FreeColormap.3
%{directory}/man/man3/Tk_AllocColorFromObj.3
%{directory}/man/man3/Tk_GetColor.3
%{directory}/man/man3/Tk_GetColorFromObj.3
%{directory}/man/man3/Tk_GetColorByValue.3
%{directory}/man/man3/Tk_NameOfColor.3
%{directory}/man/man3/Tk_FreeColorFromObj.3
%{directory}/man/man3/Tk_FreeColor.3
%{directory}/man/man3/Tk_AllocCursorFromObj.3
%{directory}/man/man3/Tk_GetCursor.3
%{directory}/man/man3/Tk_GetCursorFromObj.3
%{directory}/man/man3/Tk_GetCursorFromData.3
%{directory}/man/man3/Tk_NameOfCursor.3
%{directory}/man/man3/Tk_FreeCursorFromObj.3
%{directory}/man/man3/Tk_FreeCursor.3
%{directory}/man/man3/Tk_GetDash.3
%{directory}/man/man3/Tk_AllocFontFromObj.3
%{directory}/man/man3/Tk_GetFont.3
%{directory}/man/man3/Tk_GetFontFromObj.3
%{directory}/man/man3/Tk_NameOfFont.3
%{directory}/man/man3/Tk_FreeFontFromObj.3
%{directory}/man/man3/Tk_FreeFont.3
%{directory}/man/man3/Tk_GetGC.3
%{directory}/man/man3/Tk_FreeGC.3
%{directory}/man/man3/Tk_GetImage.3
%{directory}/man/man3/Tk_RedrawImage.3
%{directory}/man/man3/Tk_SizeOfImage.3
%{directory}/man/man3/Tk_FreeImage.3
%{directory}/man/man3/Tk_GetJoinStyle.3
%{directory}/man/man3/Tk_NameOfJoinStyle.3
%{directory}/man/man3/Tk_GetJustifyFromObj.3
%{directory}/man/man3/Tk_GetJustify.3
%{directory}/man/man3/Tk_NameOfJustify.3
%{directory}/man/man3/Tk_GetOption.3
%{directory}/man/man3/Tk_GetPixelsFromObj.3
%{directory}/man/man3/Tk_GetPixels.3
%{directory}/man/man3/Tk_GetMMFromObj.3
%{directory}/man/man3/Tk_GetScreenMM.3
%{directory}/man/man3/Tk_GetPixmap.3
%{directory}/man/man3/Tk_FreePixmap.3
%{directory}/man/man3/Tk_GetReliefFromObj.3
%{directory}/man/man3/Tk_GetRelief.3
%{directory}/man/man3/Tk_NameOfRelief.3
%{directory}/man/man3/Tk_GetRootCoords.3
%{directory}/man/man3/Tk_GetScrollInfo.3
%{directory}/man/man3/Tk_GetSelection.3
%{directory}/man/man3/Tk_GetUid.3
%{directory}/man/man3/Tk_Uid.3
%{directory}/man/man3/Tk_GetVRootGeometry.3
%{directory}/man/man3/Tk_GetVisual.3
%{directory}/man/man3/Tk_HandleEvent.3
%{directory}/man/man3/Tk_IdToWindow.3
%{directory}/man/man3/Tk_ImageChanged.3
%{directory}/man/man3/Tk_InternAtom.3
%{directory}/man/man3/Tk_GetAtomName.3
%{directory}/man/man3/Tk_MainLoop.3
%{directory}/man/man3/Tk_MainWindow.3
%{directory}/man/man3/Tk_MaintainGeometry.3
%{directory}/man/man3/Tk_UnmaintainGeometry.3
%{directory}/man/man3/Tk_ManageGeometry.3
%{directory}/man/man3/Tk_MapWindow.3
%{directory}/man/man3/Tk_UnmapWindow.3
%{directory}/man/man3/Tk_MeasureChars.3
%{directory}/man/man3/Tk_TextWidth.3
%{directory}/man/man3/Tk_DrawChars.3
%{directory}/man/man3/Tk_UnderlineChars.3
%{directory}/man/man3/Tk_MoveToplevelWindow.3
%{directory}/man/man3/Tk_Name.3
%{directory}/man/man3/Tk_PathName.3
%{directory}/man/man3/Tk_NameToWindow.3
%{directory}/man/man3/Tk_NameOfImage.3
%{directory}/man/man3/Tk_OwnSelection.3
%{directory}/man/man3/Tk_ParseArgv.3
%{directory}/man/man3/Tk_QueueWindowEvent.3
%{directory}/man/man3/Tk_RestackWindow.3
%{directory}/man/man3/Tk_RestrictEvents.3
%{directory}/man/man3/Tk_SetAppName.3
%{directory}/man/man3/Tk_SetClass.3
%{directory}/man/man3/Tk_Class.3
%{directory}/man/man3/Tk_SetGrid.3
%{directory}/man/man3/Tk_UnsetGrid.3
%{directory}/man/man3/Tk_CreateOptionTable.3
%{directory}/man/man3/Tk_DeleteOptionTable.3
%{directory}/man/man3/Tk_InitOptions.3
%{directory}/man/man3/Tk_SetOptions.3
%{directory}/man/man3/Tk_FreeSavedOptions.3
%{directory}/man/man3/Tk_RestoreSavedOptions.3
%{directory}/man/man3/Tk_GetOptionValue.3
%{directory}/man/man3/Tk_GetOptionInfo.3
%{directory}/man/man3/Tk_FreeConfigOptions.3
%{directory}/man/man3/Tk_SetWindowVisual.3
%{directory}/man/man3/Tk_StrictMotif.3
%{directory}/man/man3/Tk_ComputeTextLayout.3
%{directory}/man/man3/Tk_FreeTextLayout.3
%{directory}/man/man3/Tk_DrawTextLayout.3
%{directory}/man/man3/Tk_UnderlineTextLayout.3
%{directory}/man/man3/Tk_PointToChar.3
%{directory}/man/man3/Tk_CharBbox.3
%{directory}/man/man3/Tk_DistanceToTextLayout.3
%{directory}/man/man3/Tk_IntersectTextLayout.3
%{directory}/man/man3/Tk_TextLayoutToPostscript.3
%{directory}/man/man3/Tk_InitStubs.3
%{directory}/man/man3/Tk_WindowId.3
%{directory}/man/man3/Tk_Parent.3
%{directory}/man/man3/Tk_Display.3
%{directory}/man/man3/Tk_DisplayName.3
%{directory}/man/man3/Tk_ScreenNumber.3
%{directory}/man/man3/Tk_Screen.3
%{directory}/man/man3/Tk_X.3
%{directory}/man/man3/Tk_Y.3
%{directory}/man/man3/Tk_Width.3
%{directory}/man/man3/Tk_Height.3
%{directory}/man/man3/Tk_Changes.3
%{directory}/man/man3/Tk_Attributes.3
%{directory}/man/man3/Tk_IsContainer.3
%{directory}/man/man3/Tk_IsEmbedded.3
%{directory}/man/man3/Tk_IsMapped.3
%{directory}/man/man3/Tk_IsTopLevel.3
%{directory}/man/man3/Tk_ReqWidth.3
%{directory}/man/man3/Tk_ReqHeight.3
%{directory}/man/man3/Tk_InternalBorderWidth.3
%{directory}/man/man3/Tk_Visual.3
%{directory}/man/man3/Tk_Depth.3
%{directory}/man/man3/Tk_Colormap.3
%{directory}/man/mann/bell.n
%{directory}/man/mann/bind.n
%{directory}/man/mann/bindtags.n
%{directory}/man/mann/bitmap.n
%{directory}/man/mann/button.n
%{directory}/man/mann/canvas.n
%{directory}/man/mann/checkbutton.n
%{directory}/man/mann/chooseColor.n
%{directory}/man/mann/chooseDirectory.n
%{directory}/man/mann/clipboard.n
%{directory}/man/mann/destroy.n
%{directory}/man/mann/dialog.n
%{directory}/man/mann/entry.n
%{directory}/man/mann/event.n
%{directory}/man/mann/focus.n
%{directory}/man/mann/focusNext.n
%{directory}/man/mann/font.n
%{directory}/man/mann/frame.n
%{directory}/man/mann/getOpenFile.n
%{directory}/man/mann/grab.n
%{directory}/man/mann/grid.n
%{directory}/man/mann/image.n
%{directory}/man/mann/label.n
%{directory}/man/mann/listbox.n
%{directory}/man/mann/loadTk.n
%{directory}/man/mann/lower.n
%{directory}/man/mann/menu.n
%{directory}/man/mann/menubar.n
%{directory}/man/mann/menubutton.n
%{directory}/man/mann/message.n
%{directory}/man/mann/messageBox.n
%{directory}/man/mann/option.n
%{directory}/man/mann/optionMenu.n
%{directory}/man/mann/options.n
%{directory}/man/mann/pack-old.n
%{directory}/man/mann/pack.n
%{directory}/man/mann/palette.n
%{directory}/man/mann/photo.n
%{directory}/man/mann/place.n
%{directory}/man/mann/popup.n
%{directory}/man/mann/radiobutton.n
%{directory}/man/mann/raise.n
%{directory}/man/mann/scale.n
%{directory}/man/mann/scrollbar.n
%{directory}/man/mann/selection.n
%{directory}/man/mann/send.n
%{directory}/man/mann/text.n
%{directory}/man/mann/tk.n
%{directory}/man/mann/tkerror.n
%{directory}/man/mann/tkvars.n
%{directory}/man/mann/tkwait.n
%{directory}/man/mann/toplevel.n
%{directory}/man/mann/winfo.n
%{directory}/man/mann/wm.n
%{directory}/man/mann/tk_chooseColor.n
%{directory}/man/mann/tk_chooseDirectory.n
%{directory}/man/mann/tk_dialog.n
%{directory}/man/mann/tk_focusNext.n
%{directory}/man/mann/tk_focusPrev.n
%{directory}/man/mann/tk_focusFollowsMouse.n
%{directory}/man/mann/tk_getOpenFile.n
%{directory}/man/mann/tk_getSaveFile.n
%{directory}/man/mann/tk_menuBar.n
%{directory}/man/mann/tk_bindForTraversal.n
%{directory}/man/mann/tk_messageBox.n
%{directory}/man/mann/tk_optionMenu.n
%{directory}/man/mann/tk_setPalette.n
%{directory}/man/mann/tk_bisque.n
%{directory}/man/mann/tk_popup.n
