/*
 *	tclWinEntry.c
 */

#include <tclWinInt.h>

#ifndef STATIC_BUILD

#if defined(_MSC_VER) || defined(__GNUC__)
#define DllEntryPoint DllMain
#endif


/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This routine is called by Borland to invoke the
 *	initialization code for the library.
 *      VC++, gcc en egcs rename it to DllMain.
 *
 * Results:
 *	TRUE.
 *
 * Side effects:
 *	See DllMain.
 *
 *----------------------------------------------------------------------
 */

BOOL APIENTRY
DllEntryPoint(
    HINSTANCE hInst,		/* Library instance handle. */
    DWORD reason,		/* Reason this function is being called. */
    LPVOID reserved)		/* Not used. */
{
    switch (reason) {
    case DLL_PROCESS_ATTACH:
	TclWinInit(hInst);
	return TRUE;

    case DLL_PROCESS_DETACH:
	if (hInst == TclWinGetTclInstance()) {
	    Tcl_Finalize();
	}
	break;
    }

    return TRUE; 
}
#endif /* !STATIC_BUILD */

