/* 
 * tclStubLib.c --
 *
 *	Stub object that will be statically linked into extensions that wish
 *	to access Tcl.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 * Copyright (c) 1998 Paul Duffin.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tclStubLib.c,v 1.3 1999/03/10 05:52:50 stanton Exp $
 */

#include "tclInt.h"
#include "tclPort.h"

TclStubs *tclStubsPtr = (TclStubs *) NULL;
TclPlatStubs *tclPlatStubsPtr = (TclPlatStubs *) NULL;
TclIntStubs *tclIntStubsPtr = (TclIntStubs *) NULL;
TclIntPlatStubs *tclIntPlatStubsPtr = (TclIntPlatStubs *) NULL;


/*
 *----------------------------------------------------------------------
 *
 * Tcl_InitStubs --
 *
 *	Tries to initialise the stub table pointers and ensures that
 *	the correct version of Tcl is loaded.
 *
 * Results:
 *	The actual version of Tcl that satisfies the request, or
 *	NULL to indicate that an error occurred.
 *
 * Side effects:
 *	Sets the stub table pointers.
 *
 *----------------------------------------------------------------------
 */

#undef Tcl_InitStubs

char *
Tcl_InitStubs (interp, version, exact)
    Tcl_Interp *interp;
    char *version;
    int exact;
{
    Interp *iPtr = (Interp *) interp;
    char *actualVersion;

    if (!iPtr->stubTable || (iPtr->stubTable->magic != TCL_STUB_MAGIC)) {
	interp->result = "This interpreter does not support stubs-enabled extensions.";
	interp->freeProc = TCL_STATIC;
	return NULL;
    }
    tclStubsPtr = iPtr->stubTable;

    actualVersion = tclStubsPtr->tcl_PkgRequireEx(interp, "Tcl", version, exact,
	    (ClientData *) NULL);
    if (actualVersion == NULL) {
	tclStubsPtr = NULL;
	return NULL;
    }

    tclPlatStubsPtr = tclStubsPtr->hooks->tclPlatStubs;
    tclIntStubsPtr = tclStubsPtr->hooks->tclIntStubs;
    tclIntPlatStubsPtr = tclStubsPtr->hooks->tclIntPlatStubs;
    return actualVersion;
}
