/* 
 * tclWinIsatty.c --
 *
 *	Emulation of isatty() function. This code is derived from
 *      tkMain.c from the corresponding Tk distribution.
 *
 * Copyright (c) 1990-1994 The Regents of the University of California.
 * Copyright (c) 1994-1997 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */


#include <windows.h>
#include "tcl.h"

int isatty(fd)
    int fd;
{
    HANDLE handle;

    if (fd != 0) {
	/* This code is only designed to handle stdin. */
	return 0;
    }

    handle = GetStdHandle(STD_INPUT_HANDLE);

    if ((handle == INVALID_HANDLE_VALUE) || (handle == 0) 
	     || (GetFileType(handle) == FILE_TYPE_UNKNOWN)) {
	/*
	 * If it's a bad or closed handle, then we don't have a console.
	 */

	return 0;
    } else if (GetFileType(handle) == FILE_TYPE_CHAR) {
	/*
	 * A character file handle is a tty by definition.
	 */

	return 1;
    } else {
	return 0;
    }
}
