##############################################################################
#    TCL Developer Studio
#
#    Copyright (C) 1999  Alexey Kakunin
#    small@star.spb.ru
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

proc findDialog { {findStr ""}} {
    global findDialog
    global tclDevData
    
    set w [toplevel .findDialog -borderwidth 10]
    wm title $w "Find:"

    if [info exist tclDevData(positions,findDialog)] {
        wm geometry $w $tclDevData(positions,findDialog)
    } else {
        set x [expr ([winfo screenwidth .] - 100)/2]
        set y [expr ([winfo screenheight .] - 100)/2]

        wm geometry $w +$x+$y
    }
    wm protocol $w WM_DELETE_WINDOW "set tclDevData(positions,findDialog) [wm geometry $w];set findDialog(ok) 0"
    
    set findDialog(find) $findStr
    
    set f [frame $w.f]
    pack $f -side left -expand 1 -fill both -padx 3
    
    tixComboBox $f.findStr -editable 1 -label "Find what:" -options {
        entry.textVariable findDialog(find)
    }
    
    #fill listbox
    set lb [$f.findStr subwidget listbox]
    
    foreach s $tclDevData(find) {
        $lb insert end $s
    }
    pack $f.findStr -fill x -expand 1 -side top -pady 3
#        bind [$f.findStr subwidget entry] <Esc> {set findDialog(ok) 0}
    
    set findDialog(case) 1
    set findDialog(regexp) 0
    set findDialog(direction) "-forward"
    
    frame $f.options
    
    # create checkbuttons
    frame $f.options.check
    checkbutton $f.options.check.case -text "Match case" -variable findDialog(case)
    checkbutton $f.options.check.regexp -text "Regular Expression" -variable findDialog(regexp)
    
    pack $f.options.check.case $f.options.check.regexp -side top -expand 1 -anchor w
    
    # create direction radiobuttons
    tixLabelFrame $f.options.direction -label "direction" -padx 2 -pady 2
    set direction [$f.options.direction subwidget frame]
    
    radiobutton $direction.up -text "Up" -variable findDialog(direction) -value "-backward"
    radiobutton $direction.down -text "Down" -variable findDialog(direction) -value "-forward"
    
    pack $direction.up $direction.down -side top -expand 1 -anchor w
    
    pack $f.options.check $f.options.direction -side left -expand 1
    pack $f.options -side top -fill both -expand 1
    
    set buttons [tixButtonBox $w.buttons -orientation vertical -pady 2]
    
    $buttons add find -text Find -command {set findDialog(ok) 1}
    $buttons add cancel -text Cancel -command {set findDialog(ok) 0}
    pack $buttons -fill y -expand 1 -side right -padx 3
    
    # run dialog
    focus [$f.findStr subwidget entry]
    grab $w
    tkwait variable findDialog(ok)
    grab release $w
    
    # store position
    set tclDevData(positions,findDialog) [wm geometry $w]

    destroy $w
    
    if $findDialog(ok) {
        #create options string
        if {$findDialog(case) == 0} {
            append options "-nocase "
        }
        
        if $findDialog(regexp) {
            append options "-regexp "
        }
        
        append options $findDialog(direction)
            
        return [list $findDialog(find) $options]
    } else {
        return ""
    }
}

# find in files dialog
proc findInFilesDialog { {findStr ""}} {
    global findInFilesDialog
    global tclDevData
    
    set w [toplevel .findInFilesDialog -borderwidth 10]
    wm title $w "Find in files:"
    
    if [info exist tclDevData(positions,findInFilesDialog)] {
        wm geometry $w $tclDevData(positions,findInFilesDialog)
    } else {
        set x [expr ([winfo screenwidth .] - 100)/2]
        set y [expr ([winfo screenheight .] - 100)/2]

        wm geometry $w +$x+$y
    }
    wm protocol $w WM_DELETE_WINDOW "set tclDevData(positions,finInFilesDialog) [wm geometry $w];set findInFilesDialog(ok) 0"
    
    set findInFilesDialog(find) $findStr

    set f [frame $w.f]
    pack $f -side left -expand 1 -fill both
        
    tixComboBox $f.findStr -editable 1 -label "Find what:" -options {
        entry.textVariable findInFilesDialog(find)
        label.width 21
    }
    
    #fill listbox
    set lb [$f.findStr subwidget listbox]
    
    foreach s $tclDevData(find) {
        $lb insert end $s
    }
    pack $f.findStr -fill x -expand 1 -side top -pady 3
#    bind [$f.findStr subwidget entry] <Key-Escape> {set findDialog(ok) 0}
    
    #create file types entry
    set findInFilesDialog(fileTypes) "*.tcl"
    tixLabelEntry $f.fileTypes -label "In files/file types:" \
        -options {
            entry.textVariable findInFilesDialog(fileTypes)
            label.width 21
        }
    pack $f.fileTypes -fill x -expand 1 -side top -pady 3
    
    #create directory entry
    set findInFilesDialog(dir) [project::getDir]
    if {$findInFilesDialog(dir) == ""} {
        set findInFilesDialog(dir) [pwd]
    }
    tixLabelEntry $f.dir -label "In folder:" \
        -options {
            entry.textVariable findInFilesDialog(dir)
            label.width 21
        }
    pack $f.dir -fill x -expand 1 -side top -pady 3
    
    set findInFilesDialog(subFolders) 1
   
    frame $f.options
    
    # create checkbuttons
    checkbutton $f.options.subFolders -text "Look in subfolders" -variable findInFilesDialog(subFolders)
    
    pack $f.options.subFolders -side top -expand 1 -anchor w
    
    pack $f.options -side top -fill both -expand 1
    
    set buttons [tixButtonBox $w.buttons -orientation vertical -pady 2]
    
    $buttons add find -text Find -command {set findInFilesDialog(ok) 1}
    $buttons add cancel -text Cancel -command {set findInFilesDialog(ok) 0}
    pack $buttons -fill y -expand 1 -side right -padx 3
    
    # run dialog
    focus [$f.findStr subwidget entry]
    grab $w
    tkwait variable findInFilesDialog(ok)
    grab release $w

    # store position
    set tclDevData(positions,findInFilesDialog) [wm geometry $w]

    destroy $w
    
    if $findInFilesDialog(ok) {
        #create options string
        append options "-subfolders "
        append options $findInFilesDialog(subFolders)
        
        set fileMasks [split $findInFilesDialog(fileTypes) ";"]    
        return [list $findInFilesDialog(find) $findInFilesDialog(dir) $fileMasks $options]
    } else {
        return {}
    }
}


proc replaceDialog { {findStr ""}} {
    global replaceDialog
    global tclDevData
    
    set w [toplevel .replaceDialog -borderwidth 10]
    wm title $w "Find:"
    
    if [info exist tclDevData(positions,replaceDialog)] {
        wm geometry $w $tclDevData(positions,replaceDialog)
    } else {
        set x [expr ([winfo screenwidth .] - 100)/2]
        set y [expr ([winfo screenheight .] - 100)/2]

        wm geometry $w +$x+$y
    }
    wm protocol $w WM_DELETE_WINDOW "set tclDevData(positions,replaceDialog) [wm geometry $w];set replaceDialog(ok) 0"
    
    set replaceDialog(find) $findStr
    
    set f [frame $w.f]
    pack $f -side left -expand 1 -fill both

    tixComboBox $f.findStr -editable 1 -label "Find what:" -options {
        entry.textVariable replaceDialog(find)
        label.width 14
    }
    
    #fill listbox
    set lb [$f.findStr subwidget listbox]
    
    foreach s $tclDevData(find) {
        $lb insert end $s
    }
    pack $f.findStr -fill x -expand 1 -side top -pady 3
#    bind [$f.findStr subwidget entry] <Return> {set findDialog(ok) 1}

    tixComboBox $f.replaceStr -editable 1 -label "Replace with:" -options {
        entry.textVariable replaceDialog(replace)
        label.width 14
    }
    
    #fill listbox
    set lb [$f.replaceStr subwidget listbox]
    
    foreach s $tclDevData(replace) {
        $lb insert end $s
    }
    pack $f.replaceStr -fill x -expand 1 -side top -pady 3
    
    set replaceDialog(case) 1
    set replaceDialog(regexp) 0
    set replaceDialog(in) "file"
    
    frame $f.options
    
    # create checkbuttons
    frame $f.options.check
    checkbutton $f.options.check.case -text "Match case" -variable replaceDialog(case)
    checkbutton $f.options.check.regexp -text "Regular expression" -variable replaceDialog(regexp)
    
    pack $f.options.check.case $f.options.check.regexp -side top -expand 1 -anchor w
    
    # create Replace In radiobuttons
    tixLabelFrame $f.options.direction -label "Replace in" -padx 2 -pady 2
    set direction [$f.options.direction subwidget frame]
    
    radiobutton $direction.up -text "Selection" -variable replaceDialog(in) -value "selection"
    radiobutton $direction.down -text "Whole file" -variable replaceDialog(in) -value "file"
    
    pack $direction.up $direction.down -side top -expand 1 -anchor w
    
    pack $f.options.check $f.options.direction -side left -expand 1
    pack $f.options -side top -fill both -expand 1
    
    set buttons [tixButtonBox $w.buttons -orientation vertical -pady 2]
    
    $buttons add findNext -text "Find Next" -command {set replaceDialog(ok) find}
    $buttons add replace -text "Replace" -command {set replaceDialog(ok) replace}
    $buttons add replaceAll -text "Replace All" -command {set replaceDialog(ok) replaceAll}
    $buttons add cancel -text Cancel -command {set replaceDialog(ok) 0}
    pack $buttons -fill y -expand 1 -side right -padx 3
    
    # run dialog
    focus [$f.findStr subwidget entry]
    grab $w
    tkwait variable replaceDialog(ok)
    grab release $w

    # store position
    set tclDevData(positions,replaceDialog) [wm geometry $w]

    destroy $w
    
    if {$replaceDialog(ok) != 0} {
        
        set options ""
        
        #create options string
        if {$replaceDialog(case) == 0} {
            append options "-nocase "
        }
        
        if $replaceDialog(regexp) {
            append options "-regexp "
        }
        
        return [list $replaceDialog(ok) $replaceDialog(find) $replaceDialog(replace) $replaceDialog(in) $options]
    } else {
        return {}
    }
}

# this is my realisation of grep.
# stil very incomplete

proc grep {findStr path fileMasks {args {}}} {
    
    #parse args
    set subFolders 0
    
    set argLen [llength $args]
    
    for {set i 0} {$i < $argLen} {incr i} {
        set option [lindex $args $i]
        incr i
        
        set value [lindex $args $i]
        
        switch -- "$option" {
            "-subfolders" {
                set subFolders $value
            }
        }
    }

    if {[file tail $path] != ""} {
        append path "/"
    }
    
    set pattern ""
    foreach fileMask $fileMasks {
        append pattern $path
        append pattern "$fileMask "
    }
    
    set result {}
    set findStrLen [string length $findStr]
    
    set files [eval "glob -nocomplain -- $pattern"]
    
    foreach file $files {
        switch [file type $file] {
            "file" {
                #process file
                set fileID [open $file "r"]
                set lineNum 1
                
                while {[gets $fileID line] != -1} {
                    set startIndex 0
                    set lineStr $line
                    
                    while {[string first $findStr $line] != -1} {
                        set index [string first $findStr $line]
                        
                        # set string after founded string
                        set line [string range $line [expr $index + $findStrLen] end]
                        
                        
                        #append to result
                        lappend result [list $file $lineNum [expr {$startIndex + $index}] $lineStr]

                        # set string after founded string
                        set startIndex [expr {$startIndex + $index + $findStrLen}]
                        set line [string range $line [expr {$index + $findStrLen}] end]
                    }
                    
                    incr lineNum
                }
                
                close $fileID
            }
            
            "directory" {
                if $subFolders {
                    #process directory
                    set fileResult [grep $findStr $file $fileMasks $args]
                    #append into the list
                    foreach i $fileResult {
                        lappend result $l
                    }
                }
            }
            
            "link" {
                # nothing to do. Now, we skip links
            }
        }
    }
    
    return $result
}





























