##############################################################################
#    TCL Developer Studio
#
#    Copyright (C) 1999  Alexey Kakunin
#    small@star.spb.ru
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

namespace eval help {
    variable HelpTips
    namespace export getBalloon getStatus addBalloon addStatus add
    
    proc getBalloon {path} {
        variable HelpTips
        
        if [info exist HelpTips($path,balloon)] {
            return $HelpTips($path,balloon)
        } else {
            return ""
        }
    }
    
    proc getStatus {path} {
        variable HelpTips
        
        if [info exist HelpTips($path,status)] {
            return $HelpTips($path,status)
        } else {
            return ""
        }
    }
    
    proc addBalloon {path text} {
        variable HelpTips
        
        set HelpTips($path,balloon) $text
        return
    }
    
    proc addStatus {path text} {
        variable HelpTips
        
        set HelpTips($path,status) $text
        return
    }
    
    proc add {path text} {
        addBalloon $path $text
        addStatus $path $text
        
        return
    }
    
}










