##############################################################################
#    TCL Developer Studio
#
#    Copyright (C) 1999  Alexey Kakunin
#    small@star.spb.ru
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

namespace eval newDialog {
    namespace export run
    
    variable NewDialog ""
    variable NewDialogData
    
    proc run {} {
        variable NewDialog
        variable NewDialogData
        global newDialog
        global tclDevData
    
        set newDialog(current) ""
        
        CreateDialog
        
        grab $NewDialog
        tkwait variable newDialog(ok)
        grab release $NewDialog
        
        set tclDevData(positions,newDialog) [wm geometry $NewDialog]
        
        destroy $NewDialog

        if $newDialog(ok) {
            return [array get NewDialogData]
        } else {
            return {}
        }
    }
    
    # create options dialog
    proc CreateDialog {} {
        variable NewDialog
        variable NewDialogData
        global newDialog
        global tclDevData
        global image
        
        set NewDialog [toplevel .newDialog]
        wm title $NewDialog "New"

        if [info exist tclDevData(positions,newDialog)] {
            wm geometry $NewDialog $tclDevData(positions,newDialog)
        } else {
            set x [expr ([winfo screenwidth .] - 100)/2]
            set y [expr ([winfo screenheight .] - 100)/2]

            wm geometry $NewDialog +$x+$y
        }
        
        wm protocol $NewDialog WM_DELETE_WINDOW "set tclDevData(positions,newDialog) [wm geometry $NewDialog];set newDialog(ok) 0"

        # Create the canvas to display the icons
        #
        set c [canvas $NewDialog.c -relief sunken -bd 1]       
        pack $c -side left -expand yes -fill both -padx 4 -pady 4

        # create several compound images in the canvas
        #
        set file  [image create pixmap -data $image(largeFile)]
        set tcl [image create pixmap -data $image(largeTCLFile)]
        set project [image create pixmap -data $image(largeProjectFile)]

        set cmp_file [image create compound -window $c -bd 1]
        $cmp_file add image -image $file
        $cmp_file add line
        $cmp_file add text   -text " File "

        set cmp_tcl [image create compound -window $c -bd 1]
        $cmp_tcl add image -image $tcl
        $cmp_tcl add line
        $cmp_tcl add text   -text " TCL File "

        set cmp_project [image create compound -window $c -bd 1]
        $cmp_project add image -image $project
        $cmp_project add line
        $cmp_project add text   -text " Project "

        $c create image  50  50  -image $cmp_file -tag file
        $c create image 150  50  -image $cmp_tcl -tag tcl
        $c create image 250  50  -image $cmp_project -tag project
        
        set newDialog(canvas) $c
        bind $c <Double-1> "newDialog::OnDoubleClick"
        bind $c <1> "newDialog::OnClick"
        
        set buttons [tixButtonBox $NewDialog.buttons -orientation vertical -pady 2]
    
        $buttons add create -text Create -command newDialog::OnCreate
        $buttons add cancel -text Cancel -command {set newDialog(ok) 0}
        pack $buttons -fill y -expand 1 -side right -padx 3
        
        return
    }
    
    proc OnDoubleClick {} {
        variable NewDialogData
        global newDialog
        
        set tags [$newDialog(canvas) gettags current]
        
        if {[lsearch $tags file] != -1} {
            OnNewFile
        } elseif {[lsearch $tags tcl] != -1} {
            OnNewTcl
        } elseif {[lsearch $tags project] != -1} {
            OnNewProject
        }
    }
    
    proc OnNewFile {} {
        variable NewDialogData
        global newDialog
        
        set NewDialogData(what) file
        
        set newDialog(ok) 1
    }
    
    proc OnNewTcl {} {
        variable NewDialogData
        global newDialog
        
        set NewDialogData(what) tcl
        
        set newDialog(ok) 1
    }
    
    proc OnNewProject {} {
        variable NewDialogData
        global newDialog
        
        set NewDialogData(what) project
        
        set newDialog(ok) 1
    }
    
    proc OnClick {} {
        variable NewDialogData
        global newDialog
        
        set coords [$newDialog(canvas) bbox current]
        set tags [$newDialog(canvas) gettags current]
        
        if {$coords != {}} {
            #create rectangle
            catch {$newDialog(canvas) delete box}
            eval $newDialog(canvas) create rect $coords -tag box
            set newDialog(current) [lindex $tags 0]
        }
        
        return
    }
    
    proc OnCreate {} {
        global newDialog
        
        switch $newDialog(current) {
            "file" {
                OnNewFile
            }
            "tcl" {
                OnNewTcl
            }
            "project" {
                OnNewProject
            }
        }
        
        return
    }
        
    
}


















