#!/bin/sh
# Call wish\
exec wish "$0" "$@"

##############################################################################
#    TCL Developer Studio
#
#    Copyright (C) 1999  Alexey Kakunin
#    small@star.spb.ru
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

if { [file type $argv0] == "link" } {
  set TCLDEV_HOME [file dirname [file readlink $argv0]]
} else {
  set TCLDEV_HOME [file dirname $argv0]
}

# set keywords
set tclDevData(keywords) [info commands]

# init global variables
set version 0.17

set tclDevData(files) {}
set tclDevData(curFile) ""
set tclDevData(find) {}
set tclDevData(find,lastOptions) ""
set tclDevData(replace) {}
set tclDevData(projectFile) ""

# load tix library
package require -exact Tix 4.1.8.0

source "$TCLDEV_HOME/balloon.tcl"

# create titlepane
source "$TCLDEV_HOME/titlepan.tcl"

# load files
source "$TCLDEV_HOME/images.tcl"

source "$TCLDEV_HOME/mainfram.tcl"
source "$TCLDEV_HOME/projwin.tcl"
source "$TCLDEV_HOME/editwin.tcl"
source "$TCLDEV_HOME/outwin.tcl"
source "$TCLDEV_HOME/project.tcl"
source "$TCLDEV_HOME/help.tcl"
source "$TCLDEV_HOME/status.tcl"
source "$TCLDEV_HOME/find.tcl"
source "$TCLDEV_HOME/options.tcl"
source "$TCLDEV_HOME/new.tcl"

#read options
options::read

# start TCL Developer Studio
mainFrame::create

##TCLDevStudioProject
##TCLDevStudioProject Name TCL Developer Studio
##TCLDevStudioProject Name_unix 
##TCLDevStudioProject Name_windows 
##TCLDevStudioProject Dir 
##TCLDevStudioProject Dir_unix ~/work/tcldev
##TCLDevStudioProject Dir_windows w:/tcl/tcldev
##TCLDevStudioProject RunCmd 
##TCLDevStudioProject RunCmd_unix wish tcldev.tcl
##TCLDevStudioProject RunCmd_windows c:/tcl/bin/wish80.exe tcldev.tcl
##TCLDevStudioProject DebugCmd 
##TCLDevStudioProject DebugCmd_unix tuba -i wish tcldev.tcl
##TCLDevStudioProject DebugCmd_windows tuba -i wish tcldev.tcl
