##############################################################################
#    TCL Developer Studio
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################
#This is before tab    This is after Tab

# Tcl Library to provide balloon help.
# balloon help bindings are automatically added to all buttons and
# menus by init_balloon call.
# you have only to provide descriptions for buttons or menu items by
# setting elements of global HelpTips array, indexed by button path or
# menu path,item to something useful.
# if you want to have balloon helps for any other widget you can
# do so by enable_balloon widget_path_or_class
# or enable_balloon_selective widget_path_or_class Tcl_Script
#
# You can toggle balloon help globally on and off by setting variable
# use_balloons to true or false

namespace eval balloon {
    variable BalloonAfterID ""
    variable Delay 100
    
    proc Enable {name_to_bind {script {}}} {
        if ![llength $script] {
            bind $name_to_bind <Any-Enter> "+balloon::Schedule %W %X %Y"
            bind $name_to_bind <Any-Motion> "+balloon::Reset %W %X %Y"
        } else {
            bind $name_to_bind <Any-Enter> "+balloon::Schedule %W %X %Y \[$script\]"
            bind $name_to_bind <Any-Motion> "+balloon::Reset %W %X %Y \[$script\]"
        }
        bind $name_to_bind <Any-Leave> "+balloon::Cancel"
    }

    proc Schedule {window x y {item {}}} {
        variable Delay
        variable BalloonAfterID
        
        if [string length $item] {
            set index "$window,$item"
        } else {set index $window}
        
        set text [help::getBalloon $index]
        if {$text != ""} {
            set BalloonAfterID [after $Delay "balloon::Create \"$text\" $x $y"]
        }
    }
    
    proc Reset {window x y {item {}}} {
        balloon::Cancel
        balloon::Schedule $window $x $y $item
    }

    proc Cancel {} {
        variable BalloonAfterID

        if {$BalloonAfterID != ""} {
            after cancel $BalloonAfterID
            set BalloonAfterID ""
        } else { 
            if [winfo exists .balloon_help] {destroy .balloon_help}
        }
    }

    proc Create {text x y} {
        variable BalloonAfterID
        
        catch {destroy .balloon_help}
        catch {toplevel .balloon_help -relief flat}
        
        set BalloonAfterID ""
        
        wm overrideredirect .balloon_help true
        wm positionfrom .balloon_help program
        wm geometry .balloon_help "+[expr $x+5]+[expr $y+5]"
        
        label .balloon_help.tip -text $text -wraplength 150 -bg #ffff60
        pack .balloon_help.tip
    }
    balloon::Enable Button
    #enable_balloon Menubutton
    #enable_balloon Menu "%W index active" 
}









