##############################################################################
#    TCL Developer Studio
#
#    Copyright (C) 1999  Alexey Kakunin
#    small@star.spb.ru
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

namespace eval options {
    namespace export runDialog setDefault read
    namespace export onTixOptions onUseHL onTabSize onFont
    
    variable OptionsDialog
    variable OptionsDialogData
    
    # run options dialog
    proc runDialog {} {
        variable OptionsDialog
        global optionsDialog
        global tclDevData
        
        SetData
        
        CreateDialog
        
        grab $OptionsDialog
        tkwait variable optionsDialog(ok)
        grab release $OptionsDialog
        
        set tclDevData(positions,optionsDialog) [wm geometry $OptionsDialog]
        
        destroy $OptionsDialog
        
        if $optionsDialog(ok) {
            # apply changes
            Apply
        }
        
        return
    }
    
    # create options dialog
    proc CreateDialog {} {
        variable OptionsDialog
        variable OptionsDialogData
        global optionsDialog
        global tclDevData
        
        set OptionsDialog [toplevel .optionsDialog]
        wm title $OptionsDialog "Options"

        if [info exist tclDevData(positions,optionsDialog)] {
            wm geometry $OptionsDialog $tclDevData(positions,optionsDialog)
        } else {
            set x [expr ([winfo screenwidth .] - 100)/2]
            set y [expr ([winfo screenheight .] - 100)/2]

            wm geometry $OptionsDialog +$x+$y
        }
        
        wm protocol $OptionsDialog WM_DELETE_WINDOW "set tclDevData(positions,optionsDialog) [wm geometry $OptionsDialog];set optionsDialog(ok) 0"

        # create notebook
        set nb [tixNoteBook $OptionsDialog.nb]
        $nb subwidget nbframe config -font nbFrameFont -tabpadx 0 -tabpady 0
        pack $nb -side left -fill both -expand 1
    
        # add tabs
        set common [$nb add common -label "Common" -underline 0]
        set editor [$nb add editor -label "Editor" -underline 0]
        set font [$nb add font -label "Font" -underline 0]
        
        # create common tab:
        tixLabelFrame $common.tix -label "Tix Options" -padx 2 -pady 2
        set tixFrame [$common.tix subwidget frame]
        pack $common.tix -fill both -expand 1 -side top
        
        tixComboBox $tixFrame.scheme -label "Tix Scheme:" -editable false -options {
            entry.textVariable options::OptionsDialogData(tixScheme)
        }
        
        set lb [$tixFrame.scheme subwidget listbox]
        
        foreach name {TK Gray Blue Bisque SGIGray TixGray} {
            $lb insert end $name
        }
        pack $tixFrame.scheme -side top -expand 1

        tixComboBox $tixFrame.fontSet -label "Tix FontSet:" -editable false -options {
            entry.textVariable options::OptionsDialogData(tixFontSet)
        }
        
        set lb [$tixFrame.fontSet subwidget listbox]
        
        foreach name {TK 12Point 14Point} {
            $lb insert end $name
        }
        pack $tixFrame.fontSet -side top -expand 1
        
        message $tixFrame.w -aspect 500 -text "Warning: this options will applied only for new windows"
        pack $tixFrame.w -side top -expand 1
        
        #create editor tab
        set f [frame $editor.f]
        pack $f -side top -expand 1 -fill both
        
        #insent options
        tixLabelFrame $f.indent -label "Indent" -padx 2 -pady 2
        pack $f.indent -side left -fill both -expand 1
        set indentFrame [$f.indent subwidget frame]
        checkbutton $indentFrame.useIndent -text "Use Indent" \
            -variable options::OptionsDialogData(useIndent)
        checkbutton $indentFrame.useSintaxIndent -text "Use Sintax Indent" \
            -variable options::OptionsDialogData(useSintaxIndent)
        tixControl $indentFrame.indentSize -label "Indent Size: " \
            -integer true -variable options::OptionsDialogData(indentSize) -min 1 -max 10 -options {
                entry.width 5
            }
        
        pack $indentFrame.useIndent $indentFrame.useSintaxIndent \
            -side top -expand 1 -anchor w
         
        pack $indentFrame.indentSize -side bottom -expand 1 -anchor w
        
        #tabs options
        tixLabelFrame $f.tabs -label "Tabs" -padx 2 -pady 2
        pack $f.tabs -side left -fill both -expand 1
        set tabsFrame [$f.tabs subwidget frame]
        checkbutton $tabsFrame.changeTabs -text "Change tabs by spaces" \
            -variable options::OptionsDialogData(changeTabs)
        tixControl $tabsFrame.tabSize -label "Tab Size: " \
            -integer true -variable options::OptionsDialogData(tabSize) -min 1 -max 10 -options {
                entry.width 5
            }
        
        pack $tabsFrame.changeTabs -side top -expand 1 -anchor w
        pack $tabsFrame.tabSize -side bottom -expand 1 -anchor w
        
        # highlighting options
        tixLabelFrame $editor.hl -label "HIghlighting" -padx 2 -pady 2
        pack $editor.hl -side top -fill both -expand 1
        set hlFrame [$editor.hl subwidget frame]
        checkbutton $hlFrame.useHL -text "Use highlighting" \
            -variable options::OptionsDialogData(useHL)
        pack $hlFrame.useHL -side top -expand 1 -anchor w

        # create font tabs
        tixControl $font.size -label "Size: " \
            -integer 0 -variable options::OptionsDialogData(fontSize) -min 6 -max 40 -options {
                label.width 10
                entry.width 5
            }
        tixLabelEntry $font.encoding -label "Encoding:" -options {
            label.width 10
            entry.textVariable options::OptionsDialogData(fontEncoding)
        }
        
        pack $font.size $font.encoding -side top -anchor w
            
        
        set buttons [tixButtonBox $OptionsDialog.buttons -orientation vertical -pady 2]
    
        $buttons add ok -text "OK" -command {set optionsDialog(ok) 1}
        $buttons add apply -text "Apply" -command {options::Apply}
        $buttons add cancel -text Cancel -command {set optionsDialog(ok) 0}
        pack $buttons -fill y -expand 1 -side right -padx 3
        
        return
    }
    
    
    # set data from global array to the local dialog's array
    proc SetData {} {
        variable OptionsDialogData
        global tclDevData
    
        foreach name {tixScheme tixFontSet 
                       useIndent useSintaxIndent indentSize 
                       changeTabs tabSize useHL
                       fontSize fontEncoding} {
            set OptionsDialogData($name) $tclDevData(options,$name) 
        }
        
        return
    }
    
    # set data from local dialog's array into the global array
    proc Apply {} {
        variable OptionsDialogData
        global tclDevData
        
        foreach name {tixScheme tixFontSet 
                       useIndent useSintaxIndent indentSize 
                       changeTabs tabSize useHL
                       fontSize fontEncoding} {
            if {$tclDevData(options,$name) != $OptionsDialogData($name)} {
                set tclDevData(options,$name) $OptionsDialogData($name)
            }
        }
        
        return
    }
    
    # set default values into the global options array
    proc setDefault {} {
        global tcl_platform
        global tclDevData
        
        if {$tcl_platform(platform) == "windows"} {
            set tclDevData(options,fontSize) 14
            set tclDevData(options,fontEncoding) ""
        } else {
            set tclDevData(options,fontSize) 10
            set tclDevData(options,fontEncoding) "koi8-r"
        }
        
        font create nbFrameFont -size 8
        
        set tclDevData(options,tixScheme) TixGray
        set tclDevData(options,tixFontSet) 14Point
        
        set tclDevData(options,useIndent) 1
        set tclDevData(options,useSintaxIndent) 1
        set tclDevData(options,indentSize) 4
        
        set tclDevData(options,changeTabs) 1
        set tclDevData(options,tabSize) 4
        
        set tclDevData(options,useHL) 1
        
        return
    }

    proc CreateFonts {} {
        global tclDevData
        
        # set editor font
        set font "-*-courier-medium-r-*-*-"
        if {$tclDevData(options,fontSize) != ""} {
            append font $tclDevData(options,fontSize)
        } else {
            append font *
        }
        
        append font "-*-*-*-*-*-"
        
        if {$tclDevData(options,fontEncoding) != ""} {
            append font $tclDevData(options,fontEncoding)
        } else {
            append font *-*
        }
        
        set tclDevData(options,fonts,editorFont) $font
        
        # set comment font
        set font "-*-courier-medium-i-*-*-"
        if {$tclDevData(options,fontSize) != ""} {
            append font $tclDevData(options,fontSize)
        } else {
            append font *
        }
        
        append font "-*-*-*-*-*-"
        
        if {$tclDevData(options,fontEncoding) != ""} {
            append font $tclDevData(options,fontEncoding)
        } else {
            append font *-*
        }
        
        set tclDevData(options,fonts,commentFont) $font
        
        # set keyword font
        set font "-*-courier-bold-r-*-*-"
        if {$tclDevData(options,fontSize) != ""} {
            append font $tclDevData(options,fontSize)
        } else {
            append font *
        }
        
        append font "-*-*-*-*-*-"
        
        if {$tclDevData(options,fontEncoding) != ""} {
            append font $tclDevData(options,fontEncoding)
        } else {
            append font *-*
        }
        
        set tclDevData(options,fonts,keywordFont) $font
        
        return
    }
        
    proc read {} {
        global tclDevData
        global tcl_platform
        global TCLDEV_HOME
        
        set tclDevData(rcVersion) 1
        setDefault
        
        if {$tcl_platform(platform) =="windows"} {
            set rcName "$TCLDEV_HOME/tcldev.cfg"
        } else {
            set rcName "~/.tcldevrc"
        }
        
        # check file
        if [file exist $rcName] {
            # load file
            catch {source $rcName}
        }
        
        return
    }
    
    proc save {} {
        global tclDevData
        global tcl_platform
        global TCLDEV_HOME
        
        if {$tcl_platform(platform) =="windows"} {
            set rcName "$TCLDEV_HOME/tcldev.cfg"
        } else {
            set rcName "~/.tcldevrc"
        }
        
        if [catch {set fileID [open $rcName "w"]}] {
            # can not open rc file
            return
        }
        
        
        puts $fileID "#This is TCL Developer Studio resource file"
        puts $fileID "set tclDevData(rcVersion) $tclDevData(rcVersion)"
        puts $fileID "# options"
        puts $fileID "set tclDevData(options,fontSize) $tclDevData(options,fontSize)"
        puts $fileID "set tclDevData(options,fontEncoding) $tclDevData(options,fontEncoding)"
        puts $fileID "set tclDevData(options,tixScheme) $tclDevData(options,tixScheme)"
        puts $fileID "set tclDevData(options,tixFontSet) $tclDevData(options,tixFontSet)"
        puts $fileID "set tclDevData(options,useIndent) $tclDevData(options,useIndent)"
        puts $fileID "set tclDevData(options,useSintaxIndent) $tclDevData(options,useSintaxIndent)"
        puts $fileID "set tclDevData(options,indentSize) $tclDevData(options,indentSize)"
        puts $fileID "set tclDevData(options,changeTabs) $tclDevData(options,changeTabs)"
        puts $fileID "set tclDevData(options,tabSize) $tclDevData(options,tabSize)"
        puts $fileID "set tclDevData(options,useHL) $tclDevData(options,useHL)"

        puts $fileID "# Window positions"
        puts $fileID "set tclDevData(positions,mainFrame) [mainFrame::getGeometry]"
        puts $fileID "set tclDevData(positions,projectWinSize) [mainFrame::getProjectWinSize]"
        puts $fileID "set tclDevData(positions,outputWinSize) [mainFrame::getOutputWinSize]"
        
        if [info exist tclDevData(positions,findDialog)] {
            puts $fileID "set tclDevData(positions,findDialog) $tclDevData(positions,findDialog)"
        }
        if [info exist tclDevData(positions,findInFilesDialog)] {
            puts $fileID "set tclDevData(positions,findInFilesDialog) $tclDevData(positions,findInFilesDialog)"
        }
        if [info exist tclDevData(positions,replaceDialog)] {
            puts $fileID "set tclDevData(positions,replaceDialog) $tclDevData(positions,replaceDialog)"
        }
        if [info exist tclDevData(positions,optionsDialog)] {
            puts $fileID "set tclDevData(positions,optionsDialog) $tclDevData(positions,optionsDialog)"
        }
        if [info exist tclDevData(positions,goToDialog)] {
            puts $fileID "set tclDevData(positions,goToDialog) $tclDevData(positions,goToDialog)"
        }
        if [info exist tclDevData(positions,projectDialog)] {
            puts $fileID "set tclDevData(positions,projectDialog) $tclDevData(positions,projectDialog)"
        }
        if [info exist tclDevData(positions,newDialog)] {
            puts $fileID "set tclDevData(positions,newDialog) $tclDevData(positions,newDialog)"
        }
        
        puts $fileID "# files information"
        
        if [info exist tclDevData(recentFiles)] {
            puts $fileID "set tclDevData(recentFiles) $tclDevData(recentFiles)"
        }
        if [info exist tclDevData(recentProjects)] {        
            puts $fileID "set tclDevData(recentProjects) $tclDevData(recentProjects)"
        }
        
        foreach name [array names tclDevData "files,*,cursor"] {
            if {$tclDevData($name) != ""} {
                puts $fileID "set tclDevData($name) $tclDevData($name)"
            }
        }
        foreach name [array names tclDevData "files,*,selFirst"] {
            if {$tclDevData($name) != ""} {
                puts $fileID "set tclDevData($name) $tclDevData($name)"
            }
        }
        foreach name [array names tclDevData "files,*,selLast"] {
            if {$tclDevData($name) != ""} {
                puts $fileID "set tclDevData($name) $tclDevData($name)"
            }
        }
        
        
        close $fileID
    }
    
    #------------------------------------------------------
    # reactions on change options
    proc onTixOptions {name1 name2 op} {
        global tclDevData
        
        if [info exist tclDevData(options,tixScheme)] {
            set scheme $tclDevData(options,tixScheme)
        } else {
            set scheme "TixGray"
        }

        if [info exist tclDevData(options,tixFontSet)] {
            set fontSet $tclDevData(options,tixFontSet)
        } else {
            set fontSet "14Point"
        }
        
        tix resetoptions $scheme $fontSet
    }
    
    proc onUseHL {name1 name2 op} {
        global tclDevData
        
        if $tclDevData(options,useHL) {
            editorWindows::enableHL
        } else {
            editorWindows::disableHL
        }
    }
    
    proc onTabSize {name1 name2 op} {
        editorWindows::onTabSize
        return
    }
    
    proc onFont {name1 name2 op} {
        global tclDevData
        
        if {![info exist tclDevData(options,fontSize)] ||
            ![info exist tclDevData(options,fontEncoding)]} {
            return
        }
        
        CreateFonts
        
        editorWindows::onFontChange
    }
    
    #------------------------------------------------------    
    # create reactions on change options
    trace variable tclDevData(options,tixScheme) w options::onTixOptions
    trace variable tclDevData(options,tixFontSet) w options::onTixOptions
    trace variable tclDevData(options,useHL) w options::onUseHL
    trace variable tclDevData(options,tabSize) w options::onTabSize
    trace variable tclDevData(options,fontSize) w options::onFont
    trace variable tclDevData(options,fontEncoding) w options::onFont
}
































