##############################################################################
#    TCL Developer Studio
#
#    Copyright (C) 1999  Alexey Kakunin
#    small@star.spb.ru
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

namespace eval outputWindow {

namespace export create addTextToDebug onDebugOutput clearDebug
namespace export clearFind addFind

variable This
variable TxtWidget
variable FindListBox

# editorWindows::create --
#
#        Create output window of TCL DevStudio
#
#        Arguments:
#            this        frame for storing output window
#
#        Results: (no results)
proc create {this} {
    variable This
    variable DebugWindow
    variable FindListBox
    
    set This $this

    # create notebook
    tixNoteBook $This.nb
    $This.nb subwidget nbframe config -font nbFrameFont -tabpadx 0 -tabpady 0
    pack $This.nb -side top -fill both -expand 1
    
    # add tabs
    set debug [$This.nb add debug -label "Debug" -underline 0]
    set find [$This.nb add find -label "Find" -underline 0]
    
    # create debug text
    tixScrolledText $debug.text -scrollbar "auto +x"
    
    set DebugWindow [$debug.text subwidget text]
    
    pack $debug.text -expand 1 -fill both
    
    # create find listbox
    tixScrolledListBox $find.listBox -command {outputWindow::OnFindSelect}
    set FindListBox [$find.listBox subwidget listbox]
    pack $find.listBox -expand 1 -fill both
    
    # Set Debug as activ tab    
    $This.nb raise debug

    return
}

proc addTextToDebug {text} {
    variable DebugWindow
    variable This

    # Set Debug as activ tab    
    $This.nb raise debug
    
    #append text
    $DebugWindow insert insert $text

    #set insert point to the end of the text
    $DebugWindow mark set insert end
    
    # see insetr point
    $DebugWindow see insert
}

proc onDebugOutput {stream} {
    #is file empty
    if [eof $stream] {
        set result ""
        #close it
        if [catch {close $stream} result] {
            # add error stream into the output window
            addTextToDebug $result
        }

        mainFrame::enable Run
        mainFrame::enable Debug
                
        return
    }
    
    # read text from file
    set text [read $stream]
    
    # add to the window
    addTextToDebug $text
    
    return
}

proc clearDebug {} {
    variable DebugWindow
    
    $DebugWindow delete 0.0 end
}

# Find Window methods
proc OnFindSelect {} {
    variable FindListBox
    global tclDevData
    
    set index [$FindListBox curselection]
    
    set entry [lindex $tclDevData(findInFiles) $index]
    
    mainFrame::openTextFile [lindex $entry 0]
    editorWindows::setCursor [lindex $entry 1] [lindex $entry 2]
    
    return
}


proc clearFind {} {
    variable FindListBox
    
    $FindListBox delete 0 end
    
    return
}

proc addFind {fileName lineNum pos line} {
    variable FindListBox
    variable This

    # Set Find as activ tab    
    $This.nb raise find
    
    $FindListBox insert end "$fileName:$lineNum:$pos $line"
    
    return
}

}





