##############################################################################
#    TCL Developer Studio
#
#    Copyright (C) 1999  Alexey Kakunin
#    small@star.spb.ru
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################


namespace eval project {

    variable vars {Name Dir RunCmd DebugCmd}
    
    foreach varName $vars {
        variable $varName ""

        foreach platform {unix windows} {
            set pVarName $varName
            append pVarName "_"
            append pVarName $platform

            variable $pVarName ""
        }
    }

    namespace export loadFile save resetProject
    namespace export runDialog

    variable OptionsDialog
    variable OptionsDialogData

    # Reset all project variables
    proc resetProject {} {
        global tcl_platform
        variable vars
        
        foreach varName $vars {
            variable $varName
            set $varName ""

            foreach platform {unix windows} {
                set pVarName $varName
                append pVarName "_"
                append pVarName $platform

                variable $pVarName
                set $pVarName ""
            }
        }

        return
    }

    # load project file
    proc loadFile { fileName } {
        global tcl_platform
        variable vars

        foreach varName $vars {
            variable $varName

            foreach platform {unix windows} {
                set pVarName $varName
                append pVarName "_"
                append pVarName $platform

                variable $pVarName
            }
        }

        resetProject

        if [catch {set fileID [open $fileName "r"]}] {
            error "Can not load project $fileName"
        }

        set line ""
        while {[gets $fileID line] != -1} {
            set firstChars [string range $line 0 21]
            if {$firstChars == "##TCLDevStudioProject "} {
                # this is TCLDevStudio variable
                # split string
                set l [split $line " "]

                # there are should be 3 elements or more
                if {[llength $l] >= 3} {
                    set varName [lindex $l 1]
                    set l [lreplace $l 0 1]
                    set value [join $l " "]

                    # set variable
                    set $varName $value
                }
            }
        }

        close $fileID

        if {$Name == ""} {
            error "$fileName is not TCL Developer Studio project file!"
        }

        # change current directory to the Project Directory
        if {$Dir != ""} {
            cd $Dir
        }

        return
    }

    # save project settings
    proc save {fileID} {
        variable vars

        foreach varName $vars {
            variable $varName

            foreach platform {unix windows} {
                set pVarName $varName
                append pVarName "_"
                append pVarName $platform

                variable $pVarName
            }
        }
        
        #save TCLDev Comment
        puts $fileID "##TCLDevStudioProject"
        
        # for each variable
        foreach varName $vars {
            #save variable
            if [info exist project::$varName] {
                eval "puts $fileID \"##TCLDevStudioProject $varName $$varName\""
            }
            
            #for each platfrom
            foreach platform {unix windows} {
                set pVarName $varName
                append pVarName "_"
                append pVarName $platform
                
                #save platform variable
                if [info exist project::$varName] {
                    eval "puts $fileID \"##TCLDevStudioProject $pVarName $$pVarName\""
                }
            }
        }
        
        
    }
    
    # create accessors
    foreach varName $vars {
        global tcl_platform

        set procName get
        append procName $varName

        set pVarName $varName
        append pVarName "_"
        append pVarName $tcl_platform(platform)

        proc $procName {} "global tcl_platform;                              \
                            variable $varName;                              \
                            variable $pVarName;                             \
                            if {[info exist $pVarName] && $$pVarName != \"\"} \
                                { return $$pVarName; };                       \
                            if [info exist $varName]                          \
                                {return $$varName;};                           \
                            return \"\" ; "

        namespace export $procName    
    }

    # set reaction on change project settings
    trace variable Name w mainFrame::setProjectName
    foreach platform {unix windows} {
        set pVarName Name_
        append pVarName $platform
                
        trace variable $pVarName w mainFrame::setProjectName
    }
        
    #------------------------------------------------------
    # project dialog implementation
    proc runDialog {} {
        variable ProjectDialog
        global projectDialog
        global tclDevData
        
        SetData
        
        CreateDialog
        
        grab $ProjectDialog
        tkwait variable projectDialog(ok)
        grab release $ProjectDialog
        
        set tclDevData(positions,projectDialog) [wm geometry $ProjectDialog]
        
        destroy $ProjectDialog
        
        if $projectDialog(ok) {
            # apply changes
            Apply
        }
        
        return
    }

    # set data from project into the local project dialog data    
    proc SetData {} {
        variable vars
        
        foreach varName $vars {
            variable $varName

            foreach platform {unix windows} {
                set pVarName $varName
                append pVarName "_"
                append pVarName $platform

                variable $pVarName
            }
        }
        variable ProjectDialogData
        
        #for each variable
        foreach name $vars {
            if [info exist project::$name] {
                eval "set ProjectDialogData(both,$name) $$name"
            } else {
                set ProjectDialogData(both,$name) ""
            }

            #for each platform
            foreach platform {unix windows} {
                set pVarName $name
                append pVarName "_"
                append pVarName $platform

                if [info exist project::$pVarName] {
                    eval "set ProjectDialogData($platform,$name) $$pVarName" 
                } else {
                    set ProjectDialogData($platform,$name) ""
                }
            }
        }
        
        return
    }
    
    proc Apply {} {
        variable vars
        
        foreach varName $vars {
            variable $varName

            foreach platform {unix windows} {
                set pVarName $varName
                append pVarName "_"
                append pVarName $platform

                variable $pVarName
            }
        }
        variable ProjectDialogData
        
        #for each variable
        foreach name $vars {
            set $name $ProjectDialogData(both,$name)

            #for each platform
            foreach platform {unix windows} {
                set pVarName $name
                append pVarName "_"
                append pVarName $platform

                set $pVarName $ProjectDialogData($platform,$name)
            }
        }
        
        return
    }
    
    proc CreateDialog {} {
        variable ProjectDialog
        variable ProjectDialogData
        global projectDialog
        global tclDevData
        
        set ProjectDialog [toplevel .optionsDialog]
        wm title $ProjectDialog "Project Settings"

        if [info exist tclDevData(positions,projectDialog)] {
            wm geometry $ProjectDialog $tclDevData(positions,projectDialog)
        } else {
            set x [expr ([winfo screenwidth .] - 100)/2]
            set y [expr ([winfo screenheight .] - 100)/2]

            wm geometry $ProjectDialog +$x+$y
        }
        
        wm protocol $ProjectDialog WM_DELETE_WINDOW "set tclDevData(positions,projectDialog) [wm geometry $ProjectDialog];set projectDialog(ok) 0"

        #create listbook
        set lnb [tixListNoteBook $ProjectDialog.lnb -dynamicgeometry 0]
        pack $lnb -fill both -expand 1 -padx 1 -pady 1 -side left
        
        $lnb subwidget hlist add both -itemtype text -text "Both" -under 0
        $lnb subwidget hlist add unix -itemtype text -text "Unix" -under 0
        $lnb subwidget hlist add windows -itemtype text -text "Windows" -under 0
    
        set both [$lnb add both]
        set unix [$lnb add unix]
        set windows [$lnb add windows]
        
        #fill list tabs
        foreach name {both unix windows} {
            eval "set this $$name"
            
            # create notebooks
            set nb [tixNoteBook $this.nb]
            $nb subwidget nbframe config -font nbFrameFont -tabpadx 0 -tabpady 0
            pack $nb -side left -fill both -expand 1
    
            # add tabs
            set general [$nb add common -label "General" -underline 0]
            set commands [$nb add editor -label "Commands" -underline 0]
            
            #create general tab
            eval "tixLabelEntry $general.name -label \"Name:\" -options {label.width 14 entry.textVariable project::ProjectDialogData($name,Name)}"
            eval "tixLabelEntry $general.dir -label \"Working Dir:\" -options {label.width 14 entry.textVariable project::ProjectDialogData($name,Dir)}"
            
            pack $general.name $general.dir -side top -padx 3 -pady 3 -anchor w
            
            #create commands tab
            eval "tixLabelEntry $commands.run -label \"Run:\" -options {label.width 14 entry.textVariable project::ProjectDialogData($name,RunCmd) }"
            eval "tixLabelEntry $commands.debug -label \"Debug:\" -options {label.width 14 entry.textVariable project::ProjectDialogData($name,DebugCmd) }"
            
            pack $commands.run $commands.debug -side top -padx 3 -pady 3 -anchor w
        }
        
        set buttons [tixButtonBox $ProjectDialog.buttons -orientation vertical -pady 2]
    
        $buttons add ok -text "OK" -command {set projectDialog(ok) 1}
        $buttons add apply -text "Apply" -command {project::Apply}
        $buttons add cancel -text Cancel -command {set projectDialog(ok) 0}
        pack $buttons -fill y -expand 1 -side right -padx 3
        
        return
    }
}





























