##############################################################################
#    TCL Developer Studio
#
#    Copyright (C) 1999  Alexey Kakunin
#    small@star.spb.ru
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

# Implementation of status text
# Read all information from global variable HelpTips(StatusText)
#
# Methods:
# Init - init status text
# Enable - enable status text for widget
# create - create status text window
# Schedule - set status test
# Cancel - delete status text
# setText - set text into the status line

namespace eval statusText {
    namespace export create setText
    variable StatusText
    
    #------------------------------------------------------
    proc Enable { widgetName {script {}}} {
        if ![llength $script] {
            bind $widgetName <Any-Enter> "+statusText::Schedule %W"
            
            if {$widgetName == "Menu"} {
                bind $widgetName <Any-Motion> "+statusText::Schedule %W"
            }
    } else {
            bind $widgetName <Any-Enter> "+statusText::Schedule %W \[$script\]"
            
            if {$widgetName == "Menu"} {
                bind $widgetName <Any-Motion> "+statusText::Schedule %W \[$script\]"
            }
        }
    
        bind $widgetName <Any-Leave> "+statusText::Cancel"
    }


    #------------------------------------------------------
    proc Schedule { window {item {}}} {
        variable StatusText

        if [string length $item] {
            set index "$window,$item"
        } else {
            set index $window
        }

        set text [help::getStatus $index]
        if {$text != ""} {
            set StatusText $text
        }
    }


    #------------------------------------------------------
    proc Cancel {} {
        variable StatusText
        set StatusText ""
        
        return
    }

    #------------------------------------------------------
    proc create { parent } {
        variable StatusText
    
        frame $parent.statusLine
        label $parent.statusLine.statusText -textvariable statusText::StatusText -width 40
        pack $parent.statusLine.statusText -side left -anchor w
        pack $parent.statusLine -side bottom -fill x -anchor sw
        
        return $parent.statusLine
    }

    #------------------------------------------------------
    proc setText {text} {
        variable StatusText
        
        set StatusText $text
        return
    }
    
    Enable Button
    Enable Menubutton
    Enable Menu "%W index active" 
}










