##############################################################################
#    TCL Developer Studio
#
#    Copyright (C) 1999  Alexey Kakunin
#    small@star.spb.ru
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

global text

global titlepane
set titlepane ".t"
set titleback blue4
set titlefor white

wm withdraw .
toplevel $titlepane -bd 4 -relief ridge -background $titleback
wm overrideredirect $titlepane 1
frame $titlepane.l1 -background $titleback
label $titlepane.l1.toler -text "TCL" -background $titleback -foreground $titlefor
label $titlepane.l1.ver -text "V. $version" -background $titleback -foreground $titlefor
pack $titlepane.l1.toler -side left -padx 5 -pady 5
pack $titlepane.l1.ver -side right -padx 5 -pady 5
label $titlepane.l2 -text "Developer Studio" -background $titleback -foreground $titlefor
label $titlepane.l3 -text "Copyright (c) 1998 Alexey Kakunin" -background $titleback -foreground $titlefor
label $titlepane.l4 -text "small@star.spb.ru" -background $titleback -foreground $titlefor
pack $titlepane.l1 -anchor w -side top -expand 1 -fill x -padx 5 -pady 5
pack $titlepane.l2 $titlepane.l3 $titlepane.l4 -side top -expand 1 -fill x -padx 5 -pady 5

if {$tcl_platform(platform) == "unix"} {
    set w 288
    set h 146
} else {
    set w 288
    set h 146
}

set x [expr ([winfo screenwidth .] - $w)/2]
set y [expr ([winfo screenheight .] - $h)/2]

wm geometry $titlepane +$x+$y

wm deiconify $titlepane
update idletasks

after 3000 {catch {destroy $titlepane}}





