# This TCL/TK script is used to produce the freewrap program.
#
# Freewrap allows creation of stand-alone TCL/TK executables without using a
# compiler. Renaming freewrap.exe to some other file name causes freewrap to
# behave as a a stand-alone, single-file WISH that can be used to run any 
# TCL/TK script. 
#
# Freewrap.exe is built using a modified makefile.vc in the tk/win directory for
# Jan Nijtmans' Plus patch.
#
# The following limitations have been noted while producing stand-alone programs
# using the Plus patch's TCL2C program under Windows NT.
# 
#         1) Console command not available
#            - A primative console command replacement is contained in this file.
#              This console provides a stdout location for puts. It does not
#              accept keyboard commands.
#
#         2) Cannot use command puts to stdout. Using this command crashes the
#            stand-alone program.
#		 - A puts replacement command is contained in this file. Stdout is
#              now sent to the replacement console noted in 1) above.
#
#         3) Exec command not available
#            - sorry no fix for this problem, yet.
#
# Revision history:
#
# Revison  Date           Author             Description
# -------  -------------  -----------------  ------------------------------------
#     0    Aug. 21, 1998  Dennis R. LaBelle  Original work
#   1.0    Sep. 19, 1998  Dennis R. LaBelle  Public issue
#

# List of all packages used in this file
package require Tcl 8.0
package require Tk 8.0

# The Load_Program stub starts here
global argv0
global argv
global _xx_contents
set _xx_contents ""

proc _xx_console {state args} {
# This procedure implements the console command when a program has been
# compiled with tcl2c.
global _xx_contents
	switch $state {
		 show		{
				  if {[winfo exists .console]} {return}
				  toplevel .console
				  text .console.text1
				  pack .console.text1 -side top -fill both -expand 1
				  .console.text1 insert end $_xx_contents
				}
		 hide		{
				  if {[winfo exists .console]} {destroy .console}
				}
		 title	{
                             if {[winfo exists .console]} {
					wm title .console $args
				     }
				}
		}
}

proc _xx_puts {args} {
# This procedure is used to replace the puts command when a program has been
# compiled with tcl2c.
global _xx_contents
global errorInfo

# check syntax
set newargs ""
set newline "\n"
set local 1
foreach item $args {
        switch -- $item {
               stderr -
               stdout       {}
               "-nonewline" { set newline "" }
               default      { lappend newargs $item }
             }
      }

set totargs [llength $newargs]

# check whether output is to something other than stdout
if {$totargs > 1} {
	if {[catch {uplevel #1 _xx_oldputs $args} errMsg]} {
          set savedInfo $errorInfo
          error $errMsg $errorInfo
         } { return "" }
   }

# output is to stdout or stderr. redirect it to the replacement console.
set newargs [lindex $newargs 0]
if {[winfo exists .console.text1]} {
      .console.text1 insert end $newargs
	.console.text1 insert end $newline
   }
append _xx_contents "$newargs$newline"
return ""
}


proc _xx_wrapit {} {
global argv0
global argv


set argctr 0
set argstr ""
foreach arg $argv {
        if {$arg != ""} {
            lappend argstr $arg
            incr argctr
           }
      }
if {$argctr == 1} {
    set filename [lindex $argstr 0]
    set fname [file root $filename]
    set execname ${fname}[file extension [info nameofexecutable]]
    set srcname  $filename
    set stub $argv0
    if {[catch {open $srcname r} srcfile]} {
        wm withdraw .
        tk_messageBox -parent . -icon warning -type ok -title "FreeWrap" -message "File to wrap not found. >$argstr<"
       } {
          file copy -force $stub $execname
          if {[catch {open $execname a} execfile]} {
              file delete $execname
             } {
                fconfigure $execfile -translation binary
                fconfigure $srcfile -translation binary
                set size [fcopy $srcfile $execfile]
                puts $execfile ""
                puts -nonewline $execfile [format "#%12d" $size]
                puts -nonewline $execfile "@-sign-@"
                close $execfile
               }
         }
   } {
       wm withdraw .
       tk_messageBox -parent . -icon warning -type ok -title "FreeWrap" -message "File to wrap not specified."
     }
exit 
}


# replace a couple of commands if the script has been compiled with tcl2c 
if {[info command console] == ""} {
	rename _xx_console console
	rename puts "_xx_oldputs"
	rename _xx_puts puts
   }


# Read the last 8 bytes of the file to find the special "signature"
set _xx_filein [open $argv0 r]
fconfigure $_xx_filein -translation binary
seek $_xx_filein -8 end
set _xx_signature [read $_xx_filein]
if {$_xx_signature == "@-sign-@"} {
    # Read another 12 bytes at the end of the file to find the length of
    # the appended TCL/TK script.
    seek $_xx_filein -20 end
    set _xx_progsize [read $_xx_filein 12]

    # Read in the appended program source code
    seek $_xx_filein [expr -1 * ($_xx_progsize + 22)] end
    fconfigure $_xx_filein -translation auto
    set _xx_progsrc [read $_xx_filein]
    close $_xx_filein

    # Remove unneeded procedures
    rename _xx_wrapit ""

    # Run the program
    eval "$_xx_progsrc"
   } elseif {[string tolower [file root [file tail $argv0]]] == "freewrap"} {
		    close $_xx_filein
                _xx_wrapit
		} {
                close $_xx_filein
		    set _xx_argv0 [file tail $argv0]
                set argv0 [lindex $argv 0]
                set argv [lrange $argv 1 end]

                if {![catch {open $argv0 r} _xx_filein]} {
                    # Read in the program source code
                    set _xx_progsrc [read $_xx_filein]
                    close $_xx_filein

                    # Run the program
                    eval "$_xx_progsrc"
                   } {
                      if {$argv0 == ""} {
                          set msg "No script file specified.\n"
                         } {set msg "Unable to open\n$argv0"}
                      wm withdraw .
                      tk_messageBox -parent . -title $_xx_argv0 -icon warning -type ok -message $msg
                      exit
                     }
		  }
