######################################################################
######################################################################

proc inspect-mark {port x y gvar} {

  upvar #0 $gvar var;

  set var(VRP) [$port cget -vrp];
  set var(VPN) [$port cget -vpn];
  set var(VUP) [$port cget -vup];

  set width [winfo width $port];
  set height [winfo height $port];

  set leftmargin [expr $width * 0.1];
  set rightmargin [expr $width * 0.9];

  set topmargin [expr $height * 0.1];
  set bottommargin [expr $height * 0.9];

  if {($x < $leftmargin) || ($x > $rightmargin) || ($y < $topmargin) || ($y > $bottommargin)} {
    set var(DIR) vup;
    set var(ANGLE) [compute_angle_2D $port $x $y];
    set var(AXIS) [normalize_vector [$port cget -vpn]];
  } else {

    set dx [expr $x - $width * 0.5];
    set dy [expr $height * 0.5 - $y];

    set var(DIR) axis;
    set var(MAXX) [expr $width * 0.4];
    set var(MAXY) [expr $height * 0.4];
    set var(AXIS) [compute_vector_3D $port $dx $dy $var(MAXX) $var(MAXY)];
  }
}


######################################################################
######################################################################

proc inspect-drag {port x y gvar} {

  upvar #0 $gvar var;

  if ![string compare $var(DIR) "axis"] {
    inspect-axis $port $x $y $gvar;
  } elseif ![string compare $var(DIR) "vup"] {
    inspect-vup $port $x $y $gvar;
  }
}


######################################################################
######################################################################

proc inspect-vup {port x y gvar} {

  upvar #0 $gvar var;

  set width [winfo width $port];
  set height [winfo height $port];

  set angle [compute_angle_2D $port $x $y];

  set matrix [rotation_axis $var(AXIS) [expr $angle - $var(ANGLE)]];
  set vup [rotate $var(VUP) $matrix];

  $port configure -vup $vup;
}


######################################################################
######################################################################

proc inspect-axis {port x y gvar} {

  upvar #0 $gvar var;

  set width [winfo width $port];
  set height [winfo height $port];

  set dx [expr $x - $width * 0.5];
  set dy [expr $height * 0.5 - $y];

  set vector [compute_vector_3D $port $dx $dy $var(MAXX) $var(MAXY)];

  set matrix [rotation_vectors $vector $var(AXIS)];

  if {$matrix == {}} {
    set vrp $var(VRP);
    set vpn $var(VPN);
    set vup $var(VUP);
  } else {
    set vrp [rotate $var(VRP) $matrix];
    set vpn [rotate $var(VPN) $matrix];
    set vup [rotate $var(VUP) $matrix];
  }

  $port configure -vrp $vrp -vpn $vpn -vup $vup;
}


######################################################################
######################################################################
