######################################################################
######################################################################

proc manipulate-mark {port cell model x y gvar} {

  upvar #0 $gvar var;

  if {$model == {}} {
    return;
  }

  set var(POS) [$cell modelcget $model -position];
  set var(FWD) [$cell modelcget $model -fwd];
  set var(UP) [$cell modelcget $model -up];

  set width [winfo width $port];
  set height [winfo height $port];

  set leftmargin [expr $width * 0.1];
  set rightmargin [expr $width * 0.9];

  set topmargin [expr $height * 0.1];
  set bottommargin [expr $height * 0.9];

  if {($x < $leftmargin) || ($x > $rightmargin) || ($y < $topmargin) || ($y > $bottommargin)} {
    set var(DIR) vpn;
    set var(ANGLE) [compute_angle_2D $port $x $y];
    set var(AXIS) [normalize_vector [$port cget -vpn]];
  } else {

    set dx [expr $x - $width * 0.5];
    set dy [expr $height * 0.5 - $y];

    set var(DIR) axis;
    set var(MAXX) [expr $width * 0.4];
    set var(MAXY) [expr $height * 0.4];
    set var(AXIS) [compute_vector_3D $port $dx $dy $var(MAXX) $var(MAXY)];
  }
}


######################################################################
######################################################################

proc manipulate-drag {port cell model x y gvar} {

  upvar #0 $gvar var;

  if {$model == {}} {
    return;
  }

  if ![string compare $var(DIR) "axis"] {
    manipulate-axis $port $cell $model $x $y $gvar;
  } elseif ![string compare $var(DIR) "vpn"] {
    manipulate-vpn $port $cell $model $x $y $gvar;
  }
}


######################################################################
######################################################################

proc manipulate-vpn {port cell model x y gvar} {

  upvar #0 $gvar var;

  set width [winfo width $port];
  set height [winfo height $port];

  set angle [compute_angle_2D $port $x $y];

  set matrix [rotation_axis $var(AXIS) [expr $var(ANGLE) - $angle]];
  set fwd [rotate $var(FWD) $matrix];
  set up [rotate $var(UP) $matrix];

  $cell modelconfigure $model -fwd $fwd -up $up;
}


######################################################################
######################################################################

proc manipulate-axis {port cell model x y gvar} {

  upvar #0 $gvar var;

  if {$model == {}} {
    return;
  }

  set width [winfo width $port];
  set height [winfo height $port];

  set dx [expr $x - $width * 0.5];
  set dy [expr $height * 0.5 - $y];

  set vector [compute_vector_3D $port $dx $dy $var(MAXX) $var(MAXY)];

  set matrix [rotation_vectors $var(AXIS) $vector];

  if {$matrix == {}} {
    set fwd $var(FWD);
    set up $var(UP);
  } else {
    set fwd [rotate $var(FWD) $matrix];
    set up [rotate $var(UP) $matrix];
  }

  $cell modelconfigure $model -fwd $fwd -up $up;
}


######################################################################
######################################################################
